#include "wapi.h"

#define SERV_PORT 3810

void revMsg(int sockfd, struct sockaddr *pcliaddr, socklen_t clilen)
{
	int n, ret, sendSize, msgLen, tmpLen;
	socklen_t len;
	
	char * mesg=NULL;
	WAPI_PKT_Tp pWaiPktReq=NULL;
	WAPI_PKT_Tp pWaiPktRes=NULL;
	
	WAPI_CERT_VERIFY_REQ_Tp pCertVerifyReq;
	WAPI_CERT_VERIFY_RES_Tp pCertVerifyRes;

	mesg=(char *)malloc(WAI_PKT_DATA_MAX_LEN+WAI_PKT_HEADER_MAX_LEN);
	if(mesg==NULL)
	{
		ERR_PRINT("%s(%d),iAS Serverj malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}

	pWaiPktReq=(WAPI_PKT_Tp)malloc(sizeof(WAPI_PKT_T));
	if(pWaiPktReq==NULL)
	{
		ERR_PRINT("%s(%d),iAS Serverj malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}

	pWaiPktRes=(WAPI_PKT_Tp)malloc(sizeof(WAPI_PKT_T));
	if(pWaiPktRes==NULL)
	{
		ERR_PRINT("%s(%d),iAS Serverj malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}

	for(;;)
	{
		len = clilen;
		DEBUG("iAS Serverj\n");
		/* waiting for receive data */
		n = recvfrom(sockfd, mesg, (WAI_PKT_DATA_MAX_LEN+WAI_PKT_HEADER_MAX_LEN), 0, pcliaddr, &len);
		DEBUG("iAS Serverj n=%d\n", n);//Added for test
		if(n>0)
		{
			ret=buf2CertVerifyReqPkt(pWaiPktReq, (unsigned char *)mesg, n);
			if(ret==FAILED)
			{
				ERR_PRINT("%s(%d), buf2CertVerifyReqPkt failed.\n",__FUNCTION__,__LINE__);//Added for test
				//goto err;
				continue;
			}

			
			DEBUG(" ver=%d, type=%d, subType=%d, length=%d, pktSeqNo=%d, segSegNo=%d,segFlag=%d.\n",\
												pWaiPktReq->ver,pWaiPktReq->type, pWaiPktReq->subType,\
												pWaiPktReq->length, pWaiPktReq->pktSeqNo, pWaiPktReq->segSegNo, \
												pWaiPktReq->segFlag);//Added for test

			if(pWaiPktReq->ver!=1)
			{
				ERR_PRINT("%s(%d), wai pkt version error.\n",__FUNCTION__,__LINE__);//Added for test
				continue;	//To drop this pkt
			}

			if( pWaiPktReq->type!=1)
			{
				ERR_PRINT("%s(%d), wai pkt type unknown.\n",__FUNCTION__,__LINE__);//Added for test
				continue;	//To drop this pkt
			}

			if(pWaiPktReq->subType==TYPE_CERT_VERIFY_REQ)
			{
				pCertVerifyReq=(WAPI_CERT_VERIFY_REQ_Tp)(pWaiPktReq->data);
				DEBUG(" asueCert.certFlag=%d, asueCert.certLen=%d\n", pCertVerifyReq->asueCert.certFlag, pCertVerifyReq->asueCert.certLen);//Added for test
				DEBUG(" aeCert.certFlag=%d, aeCert.certLen=%d\n", pCertVerifyReq->aeCert.certFlag, pCertVerifyReq->aeCert.certLen);//Added for test

				/*To generate wapi cert verify response packet*/
				pCertVerifyRes=(WAPI_CERT_VERIFY_RES_Tp)(pWaiPktRes->data);

				//To generate wapi cert verify response
				ret=processCertVerifyReq(pCertVerifyReq, pCertVerifyRes, &tmpLen);
				if(ret==FAILED)
				{
					ERR_PRINT("%s(%d), processCertVerifyReq failed.\n",__FUNCTION__,__LINE__);//Added for test
					continue;	//To drop this pkt
				}

				//To generate wapi cert verify response packet header
				pWaiPktRes->ver=pWaiPktReq->ver;
				pWaiPktRes->type=pWaiPktReq->type;
				pWaiPktRes->subType=TYPE_CERT_VERIFY_RES;
				pWaiPktRes->length=(unsigned short)(tmpLen+12);
				pWaiPktRes->pktSeqNo=pWaiPktReq->pktSeqNo;
				pWaiPktRes->segSegNo=pWaiPktReq->segSegNo;
				pWaiPktRes->segFlag=pWaiPktReq->segFlag;

				//To change structure certVerifyResPkt into buffer
				ret=certVerifyResPkt2Buf((unsigned char *)mesg, &msgLen, pWaiPktRes);
				DEBUG(" ret=%d, msgLen=%d\n", ret, msgLen);//Added for test
				if(ret==FAILED)
				{
					ERR_PRINT("%s(%d), certVerifyResPkt2Buf failed.\n",__FUNCTION__,__LINE__);//Added for test
					continue;	//To drop this pkt
				}

				//DEBUG("%s(%d),msgLen=%d--------------------------\n",__FUNCTION__,__LINE__, msgLen);//Added for test
				//dumpHex((unsigned char *)mesg, 64);
				//DEBUG("%s(%d),--------------------------\n",__FUNCTION__,__LINE__);//Added for test

				//To send wapi cert verify reponse pkt
				//sendSize=sendto(sockfd, mesg2, sizeof(WAPI_PKT_T), 0, pcliaddr, len);
				sendSize=sendto(sockfd, mesg, msgLen, 0, pcliaddr, len);
				DEBUG(" sendSize=%d, msgLen=%d\n", sendSize, msgLen);//Added for test
			}
			else
			{
				DEBUG(" wai pkt sub type is not TYPE_CERT_VERIFY_REQ.\n");//Added for test
				continue;	//To drop this pkt
			}
		}
	}
err:
	if(mesg!=NULL)
		free(mesg);

	if(pWaiPktReq!=NULL)
		free(pWaiPktReq);

	if(pWaiPktRes!=NULL)
		free(pWaiPktRes);
}

int main(void)
{
	int sockfd;
	int ret, toRet;
	struct sockaddr_in servaddr, cliaddr;

	sockfd = socket(AF_INET, SOCK_DGRAM, 0); /* create a socket */

	/* init servaddr */
	bzero(&servaddr, sizeof(servaddr));
	servaddr.sin_family = AF_INET;
	servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
	servaddr.sin_port = htons(SERV_PORT);

	/* bind address and port to socket */
	if(bind(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) == -1)
	{
		perror("bind error");
		toRet=FAILED;
		goto err;
	}
	revMsg(sockfd, (struct sockaddr *)&cliaddr, sizeof(cliaddr));
	toRet=SUCCESS;

err:
	return toRet;
}

