#include "wapiFiles.h"

/*
*  function description: To check file wether exist
*  parameters:
*  filename (input): file name
*  return 1: filename exist; return 0: filename doesn't exist
*/
int isFileExist(const char * filename)
{
	struct stat status;

	if(filename==NULL)
		return 0;

	if ( stat(filename, &status) < 0)
		return 0;

	return 1;
}

/*
*   function description: To get all files at dir(name)
*
*   parameters:
*   name(input): directory to parse
*   outFile(output): all file names at input directory
*   outFileNum(output): number of files at input directory
*
*   return: all files size at input directory
*   return: -1 if failed
*/
off_t list(const char *name, char ** outFile, int * outFileNum)
{
        char pn[255];
        DIR *dp;
        off_t f_size,d_size;
        int i, index;
        struct stat sbuf;
        struct direct *dir;
 
        f_size=0;
        index=0;
 
//        DEBUG("Current directory is %s\n",name);
        for (i=0;i<=1;i++)
        {
                if ((dp=opendir(name))==NULL)
                {
                        perror(name);
                        return -1;
                }
                while ((dir=readdir(dp))!=NULL)
                {
                        if(dir->d_ino==0)
                                continue;
                        strcpy(pn,name);
                        strcat(pn,"/");
                        strcat(pn,dir->d_name);
                        if (lstat(pn,&sbuf)<0)
                        {
                                perror(pn);
                                return -1;
                        }
                        if(((sbuf.st_mode&S_IFMT)!=S_IFLNK)&&((sbuf.st_mode&S_IFMT)==S_IFDIR)&&(strcmp(dir->d_name,".")!=0)&&(strcmp(dir->d_name,"..")!=0))
                        {
                                if (i==1)
                                {
                                        //d_size=list(pn);
                                        //f_size=f_size+d_size;
                                        DEBUG("%s(%d),not iterate here.\n",__FUNCTION__,__LINE__);//Added for test
                                }
                        }
                        else if((strcmp(dir->d_name,".")!=0)&&(strcmp(dir->d_name,"..")!=0))	// not include files: . and ..
                        {
                                if (i==0)
                                {
                                        f_size=f_size+sbuf.st_size;

					     /*
                                        if (strlen(dir->d_name)>=2*TABSPACES)
                                                DEBUG("%s\t%i\n",dir->d_name,sbuf.st_size);
                                        else if (strlen(dir->d_name)>=TABSPACES)
                                                DEBUG("%s\t\t%i\n",dir->d_name,sbuf.st_size);
                                        else
                                                DEBUG("%s\t\t\t%i\n",dir->d_name,sbuf.st_size);
                                         */
 
                                        if(strlen(dir->d_name)>FILE_NAME_MAX_LEN)
                                        {
                                                DEBUG("Warning: %s(%d),%s length > %d, not store this file name.\n",__FUNCTION__,__LINE__,dir->d_name,FILE_NAME_MAX_LEN);//Added for test
                                        }
                                        else
                                        {
                                                if(index>=FILE_MAX_NUM)
                                                {
                                                        DEBUG("Warning: %s(%d),file number already reach %d\n",__FUNCTION__,__LINE__,FILE_MAX_NUM);//Added for test
                                                }
                                                else
                                                {
//                                                        DEBUG("%s(%d),save %s at %d.\n",__FUNCTION__,__LINE__,dir->d_name,index);//Added for test
                                                        strcpy(outFile[index],dir->d_name);
                                                        index++;
                                                }
                                        }
                                }
                        }
                }
                closedir(dp);
        }
 
        *outFileNum=index;
        return f_size;
}

/*
*   function description: change string into hex
*   
*   parameters:
*   str (input): string which will be changed into hex
*   hexVal (output): value which is hex of str
*
*   return 0: success; return -1: failed
*/
static int str2hex(const char *str, unsigned long* hexVal)
{
        unsigned long retVal;
        int i, len;
 
        if(str==NULL)
        {
                ERR_PRINT("%s(%d), str input is null.\n",__FUNCTION__,__LINE__);//Added for test
                return -1;
        }
 
        retVal=0;
        len=strlen(str);
 
//      DEBUG("%s(%d), str=%s, len=%d.\n",__FUNCTION__,__LINE__, str, len);//Added for test
        for(i=0; i<len; i++)
        {
                if((str[i]>='0')&&(str[i]<='9'))
                {
                        retVal*=16;
                        retVal+=(unsigned long)(str[i]-'0');
                }
                else if((str[i]>='a')&&(str[i]<='f'))
                {
                        retVal*=16;
                        retVal+=(unsigned long)(str[i]-'a'+10);
                }
                else if((str[i]>='A')&&(str[i]<='F'))
                {
                        retVal*=16;
                        retVal+=(unsigned long)(str[i]-'A'+10);
                }
                else
                {
                        ERR_PRINT("%s(%d), invalid str input.\n",__FUNCTION__,__LINE__);//Added for test
                        return -1;
                }
        }
        *hexVal=retVal;
 
        return 0;
}


/*
*   function description: 
*	change filename into hex integer
*	steps: first remove path and suffix of filename, second change it into hex integer
*
*   parameters:
*   filename (input): string of filename which will be changed into hex integer
*   serial (output): hex integer from the string of filename (after remove path and sufffix of filename)
*
*   return 0: success; return -1: failed
*/
int filename2serial(const char * filename, unsigned long* serial)
{
        char tmpBuf[USER_CERT_DIR_MAX_LEN+FILE_NAME_MAX_LEN];
	 char tmpBuf2[FILE_NAME_MAX_LEN];
        char *ptr0, *ptr1, *ptr2;
        int ret,len;
        unsigned long retVal;
 
        if(filename==NULL)
        {
                ERR_PRINT("%s(%d), filename input is null.\n",__FUNCTION__,__LINE__);//Added for test
                return -1;
        }
 
        memset(tmpBuf, 0, sizeof(tmpBuf));
        strcpy(tmpBuf, filename);
//      DEBUG("%s(%d),filename=%s, tmpBuf=%s\n",__FUNCTION__,__LINE__,filename, tmpBuf);//Added for test


//////////////////////////////////////////////////////////////////////////////??????????????
	ptr0=NULL;
	ptr1=NULL;
	ptr2=NULL;

//	ptr0=tmpBuf;
	ptr1=tmpBuf;
	while(ptr1!=NULL)
	{
		ptr0=ptr1;
		if(ptr0[0]=='/')
                        ptr0++;//Not point to '/'
                ptr1=strstr(ptr0, "/");
	}
	
        ptr2=strstr(tmpBuf, ".");
        if(ptr2==NULL)
        {
                ERR_PRINT("%s(%d), invalid filename.\n",__FUNCTION__,__LINE__);//Added for test
                return -1;
        }
 
        len=ptr2-ptr0;
	memset(tmpBuf2, 0, sizeof(tmpBuf2));
	 strncpy(tmpBuf2, ptr0, len);
        //tmpBuf[len]=0;
 
//      DEBUG("%s(%d), tmpBuf2=%s\n",__FUNCTION__,__LINE__, tmpBuf2);//Added for test
        ret=str2hex(tmpBuf2, &retVal);
        //retVal=atoi(tmpBuf);
//      DEBUG("%s(%d), ret=%d, retVal=0x%x\n",__FUNCTION__,__LINE__, ret, retVal);//Added for test
      if(ret==-1)
      	{
      		 ERR_PRINT("%s(%d), str2hex failed.\n",__FUNCTION__,__LINE__);//Added for test
               return -1;
      	}
 ///////////////////////////////////////////////////////////////?????????????????????
        *serial=retVal;
        return 0;
}

/*
*   function description: change the string from source file into hex integer
*
*   parameters:
*   srcFile (input): source file
*   outHex (output): hex integer
*
*  return 0: success; return -1: failed
*/
int getHexFromFile(const char *srcFile, unsigned long *outHex)
{
        int fh, ret, readSize;
        int toRet;
        char tmpBuf[SERIAL_MAX_LEN];
        unsigned long outVal;
 
        if(srcFile==NULL)
        {
                ERR_PRINT("%s(%d), filename input is null.\n",__FUNCTION__,__LINE__);//Added for test
                return -1;
        }
 
        //Initial
        memset(tmpBuf, 0, sizeof(tmpBuf));
        outVal=0;
        
        fh = open(srcFile, O_RDONLY);
        if( fh == -1 ) 
        {
                ERR_PRINT("open %s error.\n", srcFile);//Added for test
                toRet=-1;
                goto err;
        }
 
        readSize=read(fh,(void *)&tmpBuf,sizeof(tmpBuf));
        if(tmpBuf[readSize-1]='\n')
        {
                tmpBuf[readSize-1]=0;//To remove '\n'
        }
       // DEBUG("%s(%d),readSize=%d, tmpBuf=%s, now_len=%d\n",__FUNCTION__,__LINE__,readSize, tmpBuf, strlen(tmpBuf));//Added for test
        if(( readSize == -1 ) || ( readSize==0 ) || (readSize > sizeof(tmpBuf)))
        {
                ERR_PRINT("read %s error.\n", srcFile);//Added for test
                toRet=-1;
                goto err;
        }
		
        ret=str2hex(tmpBuf, &outVal);
        if(ret==-1)
        {
                ERR_PRINT("%s(%d), str2hex failed.\n",__FUNCTION__,__LINE__);//Added for test
                return -1;
        }
 
 
        *outHex=outVal;
        //DEBUG("%s(%d), outVal=0x%x.\n",__FUNCTION__,__LINE__,outVal);//Added for test
 
        toRet=0;
err:
        if(fh!=-1)
                close(fh);
        return toRet;
}

/*
*   function description: get user cert number from wap area header at flash
*
*   parameters: 
*   userCertNum(output): the number of user certs if success
*
*   return 0 if success
*   return -1 if failed
*/
unsigned long getUserCertNum(unsigned long * userCertNum)
{
	int fh;
	int ret, toRet;
	unsigned long offset;
	WAPI_AREA_HEADER_T wapiAreaHeader;

	fh = open(FLASH_DEVICE_NAME1, O_RDONLY); 

	if ( fh == -1 ) 
	{
		ERR_PRINT("%s %d open %s error.\n",__FUNCTION__ , __LINE__, FLASH_DEVICE_NAME1);//Added for test
		toRet=FAILED;
		goto err;
	}

	//Initial
	memset(&wapiAreaHeader, 0, sizeof(wapiAreaHeader));

	offset=WAPI_AREA_BASE;
	lseek(fh,offset,SEEK_SET);
	ret=read(fh,(void *)&wapiAreaHeader,sizeof(wapiAreaHeader));
//	DEBUG("%s(%d),ret=%d,wapiAreaHeader.fileNum=0x%x\n",__FUNCTION__,__LINE__,ret,wapiAreaHeader.fileNum);//Added for test

	if ( memcmp(wapiAreaHeader.signature, WAPI_SIGNATURE, SIG_LEN)) {
		ERR_PRINT("WAPI_SIGNATURE error\n");
		toRet=FAILED;
		goto err;
	}

	* userCertNum=wapiAreaHeader.fileNum;
	toRet=SUCCESS;

err:
	if(fh!=-1)
		close(fh);

	return toRet;
}

/*
*   function description: get user cert infomation into certsInfo from CERTS_DATABASE
*
*   parameters:
*   certsInfo (output): to store user cert information get from from CERTS_DATABASE
*   count (input): number of entries in CERTS_DATABASE
*
*   return 0: success; return -1: failed
*/
int getCertsDb(CERTS_DB_ENTRY_Tp certsInfo, int count)
{
        FILE *fp;
        time_t  now, expired_tm;
        struct tm *tnow;
        struct tm tm_time;
 
        struct stat status;
        int readSize;
        int ret, toRet;
        int i,intVal;
        long longVal;
        char *p1, *p2, *ptr;
 
        char buffer[100];
        char tmpBuf[100];//Added for test
        char tmpBuf2[3];//Added for test
 
        if ( stat(CERTS_DATABASE, &status) < 0)
        {
                ERR_PRINT("%s(%d): %s not exist.\n",__FUNCTION__,__LINE__, CERTS_DATABASE);//Added for test
                toRet=FAILED;
                goto err;
        }
//        DEBUG("%s(%d)\n",__FUNCTION__,__LINE__);//Added for tes
        fp = fopen(CERTS_DATABASE, "r");
        if (!fp) {
                ERR_PRINT("open %s error.\n", CERTS_DATABASE);//Added for test
                toRet=FAILED;
                goto err;
        }
 
        p1=NULL;
        p2=NULL;
        for(i=0;i<count;i++)
        {
                if(!fgets(buffer, sizeof(buffer), fp))
                {
                        ERR_PRINT("%s(%d): fgets error.\n",__FUNCTION__,__LINE__);//Added for test
                        toRet=FAILED;
                        goto err;
                }
//                DEBUG("%s(%d),i=%d,buffer=%s, len=%d\n",__FUNCTION__,__LINE__,i,buffer, strlen(buffer));//Added for test
 
                //To set cert type, 0: X.509 (only at preset)
                certsInfo[i].certType=0;
 
                //dumpHex(buffer, strlen(buffer)+1);
                if(buffer[0]=='E')
                {
                        //Expired
                        certsInfo[i].certStatus=1;
                }
                else if(buffer[0]=='R')
                {
                        //Revoked
                        certsInfo[i].certStatus=2;
                }
                else
                {
                        //Valid
                        certsInfo[i].certStatus=0;
                }
                //DEBUG("%s(%d): certsInfo[i].certStatus=%d.\n",__FUNCTION__,__LINE__, certsInfo[i].certStatus);//Added for test
 
                //To parse exipred time
                p1=strchr(buffer,'\t');
                if(p1==NULL)
                {
                        ERR_PRINT("%s(%d): strchr failed.\n",__FUNCTION__,__LINE__);//Added for test
                        toRet=FAILED;
                        goto err;
                }
                p1++;
                p2=strchr(p1,'\t');
                if(p2==NULL)
                {
                        ERR_PRINT("%s(%d): strchr failed.\n",__FUNCTION__,__LINE__);//Added for test
                        toRet=FAILED;
                        goto err;
                }
                if(p2>p1)
                {
                        memset(tmpBuf, 0, sizeof(tmpBuf));
                        //memset(tmpBuf2, 0, sizeof(tmpBuf2));
                        strncpy(tmpBuf, p1, p2-p1);
                        //DEBUG("%s(%d): tmpBuf=%s.\n",__FUNCTION__,__LINE__, tmpBuf);//Added for test
                        memset(&tm_time, 0 , sizeof(tm_time));
 
                        //?????
                        //tm_time.tm_isdst=-1;
 
                        //To get year value
                        memset(tmpBuf2, 0, sizeof(tmpBuf2));
                        strncpy(tmpBuf2, tmpBuf, 2);
                        intVal=atoi(tmpBuf2);
                        if(intVal>=70)
                        {
                                //year: 1970 ~ 1999
                                //year - 1900
                                tm_time.tm_year=(intVal+1900)-1900;
                        }
                        else
                        {
                                //year: 2000 ~ 2069
                                //year - 1900
                                tm_time.tm_year=(intVal+2000)-1900;
                        }
 
                        //To get month value
                        memset(tmpBuf2, 0, sizeof(tmpBuf2));
                        strncpy(tmpBuf2, &tmpBuf[2], 2);
                        tm_time.tm_mon=atoi(tmpBuf2)-1;
 
                        //To get day value
                        memset(tmpBuf2, 0, sizeof(tmpBuf2));
                        strncpy(tmpBuf2, &tmpBuf[4], 2);
                        tm_time.tm_mday=atoi(tmpBuf2);
 
                        //To get hour value
                        memset(tmpBuf2, 0, sizeof(tmpBuf2));
                        strncpy(tmpBuf2, &tmpBuf[6], 2);
                        tm_time.tm_hour=atoi(tmpBuf2);
 
                        //To get minute value
                        memset(tmpBuf2, 0, sizeof(tmpBuf2));
                        strncpy(tmpBuf2, &tmpBuf[8], 2);
                        tm_time.tm_min=atoi(tmpBuf2);
 
                        //To get second value
                        memset(tmpBuf2, 0, sizeof(tmpBuf2));
                        strncpy(tmpBuf2, &tmpBuf[10], 2);
                        tm_time.tm_sec=atoi(tmpBuf2);
 
                //      DEBUG("(0): %d %d %d %d %d %d, tm_isdst=%d\n", 1900+tm_time.tm_year,tm_time.tm_mon+1,tm_time.tm_mday,tm_time.tm_hour,tm_time.tm_min,tm_time.tm_sec, tm_time.tm_isdst);//Added for test
 
                        expired_tm = mktime(&tm_time);
                        if(expired_tm < 0){
                                ERR_PRINT("Error:set Time Error for tm!\n");//Added for test
                                toRet=FAILED;
                                goto err;
                        }
                //      DEBUG("%s(%d): expired_tm=%ld.\n",__FUNCTION__,__LINE__,expired_tm);//Added for test
 
 
                        now=time(0);
                        tnow=localtime(&now);
                //      DEBUG("now=%ld, %d %d %d %d %d %d, tm_isdst=%d\n",now, 1900+tnow->tm_year,tnow->tm_mon+1,tnow->tm_mday,tnow->tm_hour,tnow->tm_min,tnow->tm_sec, tnow->tm_isdst);//Added for test
 
                        longVal=difftime(expired_tm,now);
//                        DEBUG("The difference is: %ld seconds\n",longVal);
                        if(longVal<=0)
                                certsInfo[i].validDaysLeft=0;
                        else
                                certsInfo[i].validDaysLeft=(unsigned short)(longVal/ONE_DAY_SECONDS)+1;
 
                //      DEBUG("%s(%d): certsInfo[%d].validDaysLeft=%d.\n",__FUNCTION__,__LINE__,i, certsInfo[i].validDaysLeft);//Added for test
 
//                      DEBUG("%s(%d): tmpBuf2=%s.\n",__FUNCTION__,__LINE__, tmpBuf2);//Added for test
                }
 
                //To parse revoked time(Not used now)
                p1=p2;
                p1++;
                p2=strchr(p1,'\t');
                if(p2==NULL)
                {
                        ERR_PRINT("%s(%d): strchr failed.\n",__FUNCTION__,__LINE__);//Added for test
                        toRet=FAILED;
                        goto err;
                }
                if(p2>p1)
                {
                        memset(tmpBuf, 0, sizeof(tmpBuf));
                        strncpy(tmpBuf, p1, p2-p1);
//                        DEBUG("%s(%d): tmpBuf=%s.\n",__FUNCTION__,__LINE__, tmpBuf);//Added for test
                }
 
                //To parse serial
                p1=p2;
                p1++;
                p2=strchr(p1,'\t');
                if(p2==NULL)
                {
                        ERR_PRINT("%s(%d): strchr failed.\n",__FUNCTION__,__LINE__);//Added for test
                        toRet=FAILED;
                        goto err;
                }
                if(p2>p1)
                {
                        memset(tmpBuf, 0, sizeof(tmpBuf));
                        strncpy(tmpBuf, p1, p2-p1);
//                      DEBUG("%s(%d):serial tmpBuf=%s.\n",__FUNCTION__,__LINE__, tmpBuf);//Added for test
                        ret=str2hex(tmpBuf, &certsInfo[i].serial);
//                      DEBUG("%s(%d), ret=%d, certsInfo[%d].serial=0x%x\n",__FUNCTION__,__LINE__, ret, i,certsInfo[i].serial);//Added for test
                        if(ret==FAILED)
                        {
                                ERR_PRINT("%s(%d), str2hex failed.\n",__FUNCTION__,__LINE__);//Added for test
                                toRet=FAILED;
                                goto err;
                        }
                }
                //To parse total valid days
                p1=p2;
                p1++;
                p2=strchr(p1,'\t');
                if(p2==NULL)
                {
                        ERR_PRINT("%s(%d): strchr failed.\n",__FUNCTION__,__LINE__);//Added for test
                        toRet=FAILED;
                        goto err;
                }
                if(p2>p1)
                {
                        memset(tmpBuf, 0, sizeof(tmpBuf));
                        strncpy(tmpBuf, p1, p2-p1);
                        //DEBUG("%s(%d):total valid days tmpBuf=%s.\n",__FUNCTION__,__LINE__, tmpBuf);//Added for test
                        certsInfo[i].validDays=(unsigned short)atoi(tmpBuf);
                        //DEBUG("%s(%d):certsInfo[%d].validDays=%d.\n",__FUNCTION__,__LINE__, i, certsInfo[i].validDays);//Added for test
                }
 
                //To parse user name
                p1=p2;
                p1++;
                p2=strchr(p1,'\n');
                if(p2==NULL)
                {
                        ERR_PRINT("%s(%d): strchr failed.\n",__FUNCTION__,__LINE__);//Added for test
                        toRet=FAILED;
                        goto err;
                }
                if(p2>p1)
                {
                        memset(tmpBuf, 0, sizeof(tmpBuf));
                        strncpy(tmpBuf, p1, p2-p1);
                        //DEBUG("%s(%d):user name tmpBuf=%s.\n",__FUNCTION__,__LINE__, tmpBuf);//Added for test
                        ptr=NULL;
                        ptr=strstr(p1, "CN=");
                        if(p2==NULL)
                        {
                                ERR_PRINT("%s(%d): strstr failed.\n",__FUNCTION__,__LINE__);//Added for test
                                toRet=FAILED;
                                goto err;
                        }
                        ptr+=3;//Point to user name
                        memset(certsInfo[i].userName, 0, sizeof(certsInfo[i].userName));
                        strncpy(certsInfo[i].userName, ptr, p2-ptr);
                        //DEBUG("%s(%d):certsInfo[%d].userName=%s.\n",__FUNCTION__,__LINE__, i, certsInfo[i].userName);//Added for test
                }
 
//              p1=buffer;
//              p2=strstr(p1,"\t");
//              DEBUG("%s(%d),i=%d,p2=%s, len=%d\n",__FUNCTION__,__LINE__,i,buffer, strlen(p2));//Added for test
        }
 
        toRet=SUCCESS;
 
err:
        if(fp!=NULL)
                fclose(fp);
//        DEBUG("%s(%d), toRet=%d\n",__FUNCTION__,__LINE__,toRet);//Added for tes
        return toRet;
}

