#ifndef INCLUDE_WAPIFILES_H
#define INCLUDE_WAPIFILES_H

#include <stdio.h>
#include <sys/types.h> 
#include <sys/stat.h> 
#include <fcntl.h>
#include <sys/dir.h>
#include <string.h>
#include "rtk_arch.h"

////////////////////////////////////
//For parse certs database: index.txt
#include <time.h>
//////////////////////////////////////////

//For test
//#define	FL_TRACE(__FLG__)				printf("[%s][%d]:-[%d]\n", __FUNCTION__, __LINE__, __FLG__);
//#define DEBUG(args) (printf("DEBUG: "), printf(args))
#define TRACE(x...) x
#if 0
#define DEBUG(x...) TRACE(printf("%s(%d)",__FILE__,__LINE__);printf(x))
#else
#define DEBUG(x...)
#endif
#define ERR_PRINT(x...) TRACE(printf(x))

//#define WAPI_8196

//#define FLASH_DEVICE_NAME		("/dev/mtd")

#if defined(WAPI_8196)
#define FLASH_DEVICE_NAME1		("/dev/mtdblock1")
#else
#define FLASH_DEVICE_NAME1		(WIFI_WAPI_CERT_DIR"/wapi_cert_database")
#endif

#define AS_CERT	"/web/as.cer"	//This file is for download from webpage

#define CA_CERT		(WIFI_WAPI_CERT_DIR "/CA.cert")		//filetype: TYPE_CA_CERT
#define CA_PUB_KEY	(WIFI_WAPI_CERT_DIR "/CA_pub.key")	//not stored in flash, it can be get from CA_CERT
#define CA_PRIV_KEY	(WIFI_WAPI_CERT_DIR "/CA.key")		//filetype: TYPE_CA_PRIV_KEY
#define CA_CRL		(WIFI_WAPI_CERT_DIR "/CA.crl")		//filetype: TYPE_CA_CRL
#define USER_CERT	(WIFI_WAPI_CERT_DIR "/user.cert")	//filetype: TYPE_USER_CERT
#define CERTS_DATABASE	(WIFI_WAPI_CERT_DIR "/index.txt")	//filetype: TYPE_CERTS_DATABASE
#define AP_CERT		(WIFI_WAPI_CERT_DIR "/ap.cert")		//filetype: TYPE_AP_CERT
#define CA4AP_CERT	(WIFI_WAPI_CERT_DIR "/ca4ap.cert")	//filetype: TYPE_CA4AP_CERT

#define NEW_USER_CERT	(WIFI_WAPI_CERT_DIR "/user.cert")
#define NEW_USER_CERT_SERIAL	(WIFI_WAPI_CERT_DIR "/serial.old")

#define NEXT_SERIAL	(WIFI_WAPI_CERT_DIR "/serial")
#define NEXT_CRLNUMBER	(WIFI_WAPI_CERT_DIR "/crlnumber")

#define USER_CERT_DIR	(WIFI_WAPI_CERT_DIR "/certs")		//This is used by me
#define NEW_CERTS_DIR	(WIFI_WAPI_CERT_DIR "/newcerts")	//This is used by only openssl

#define TYPE_CA_CERT 			0x80000001
#define TYPE_CA_PRIV_KEY 		0x80000002
#define TYPE_CA_CRL 			0x80000003
#define TYPE_USER_CERT 			0x80000004
#define TYPE_CERTS_DATABASE 	0x80000005
#define TYPE_AP_CERT		 	0x80000006
#define TYPE_CA4AP_CERT		0x80000007

//Pay attention!!!!
//Be same with skylark/AP/openssl-0.9.8b/apps/demoCA/serial at coding PC
#define SERIAL_INIT_VAL			0x40000000
//Be same with skylark/AP/openssl-0.9.8b/apps/demoCA/crlnumber at coding PC
#define CRLNUMBER_INIT_VAL		0x60000000

#define SIZE_OF_SQFS_SUPER_BLOCK 640
#define SIZE_OF_CHECKSUM 2
#define OFFSET_OF_LEN 2

#define ROOTFS_HEADER_SIZE 16
#define WAPI_AREA_HEADER_SIZE 16	//According to size of struct  _wapiAreaHeader_
#define WAPI_FILE_HEADER_SIZE 12	//According to size of struct _wapiFileHeader_

//fixed max wapi file size
#define CA_CERT_MAXSIZE 1100
#define CA_PRIV_KEY_MAXSIZE 300
#define CA_CRL_MAXSIZE 7000	//???
#define USER_CERT_MAXSIZE 1200
#define USER_CERT_MAXNUM 40
#define USER_CERT_DATABASE_MAXSIZE 6820//??
#define AP_CERT_MAXSIZE 1200
#define CA4AP_CERT_MAXSIZE CA_CERT_MAXSIZE

#define SIG_LEN			4
#define SQSH_SIGNATURE		((char *)"sqsh")
#define WAPI_SIGNATURE		((char *)"wapi")

//#if defined(WAPI_8196)
#if 1
//#define FLASH_SIZE 0x400000	//Address space: 4M
//#define MTD1_START 0xf0000	//Address space: 0xf0000
//#define MTD1_SIZE 0x310000	//Address space: 0x310000
#define MTD1_SIZE 0x2d0000	//Address space: 0x2d0000
#define WAPI_SIZE 0x10000	//Address space: 64K
#endif

#if defined(WAPI_8196)
//Wapi area layout
#define WAPI_AREA_BASE (MTD1_SIZE-WAPI_SIZE)
#else
#define WAPI_AREA_BASE 4
#endif


#define CA_CERT_BASE (WAPI_AREA_BASE+WAPI_AREA_HEADER_SIZE)
#define CA_PRIV_KEY_BASE (CA_CERT_BASE+CA_CERT_MAXSIZE)
#define CA_CRL_BASE (CA_PRIV_KEY_BASE+CA_PRIV_KEY_MAXSIZE)
#define USER_CERT_BASE (CA_CRL_BASE+CA_CRL_MAXSIZE)
#define USER_CERT_DATABASE_BASE (USER_CERT_BASE+USER_CERT_MAXSIZE*USER_CERT_MAXNUM)
#define AP_CERT_BASE (USER_CERT_DATABASE_BASE+USER_CERT_DATABASE_MAXSIZE) // ap cert is for our ap,  and ap cert is also user cert at user cert area, which need to be uploaded from webpage
#define CA4AP_CERT_BASE (AP_CERT_BASE+AP_CERT_MAXSIZE)	//ca cert for out ap which need to be uploaded from webpage
#define WAPI_AREA_END (CA4AP_CERT_BASE+CA4AP_CERT_MAXSIZE)

#define SUCCESS 0
#define FAILED -1

//For user certs now
#define FILE_NAME_MAX_LEN       	20
#define FILE_MAX_NUM            	40
#define USER_CERT_DIR_MAX_LEN	20
#define SERIAL_MAX_LEN          10	//used for serial max length and ca crlNumber max length

///////////////////////////////
//For parse certs database: index.txt
//#define CERTS_DB "/var/index.txt"
#define USER_NAME_LEN 30
#define ONE_DAY_SECONDS 86400
 
typedef struct _CertsDbEntry_ {
        unsigned char userName[USER_NAME_LEN];  //user name of this user cert
        unsigned long serial;                   //serial of this cert
        unsigned short validDays;               //total valid days of this cert
        unsigned short validDaysLeft;           //the left valid days of this cert
        unsigned char certType;                 //0(default): X.509; others: reserved
        unsigned char certStatus;               //0(default): valid; 1: expired; 2: revoked
} CERTS_DB_ENTRY_T, *CERTS_DB_ENTRY_Tp;
/////////////////////////////////////////

/* Flash store format: wapi area header */
typedef struct _wapiAreaHeader_ {
	unsigned char signature[SIG_LEN];
	unsigned long fileNum;			//Number of user certs at wapi area
	unsigned long nextSerial;		//reserve serial for next user cert
	unsigned long nextCrlNumber;	//reserve crl number for next ca crl
} WAPI_AREA_HEADER_T, *WAPI_AREA_HEADER_Tp;

/* Flash store format: wapi file header */
typedef struct _wapiFileHeader_ {
	unsigned long fileType;	// 1: CA cert (not include CA private key), 2: CA private key, 3: CA crl
							// 4: user cert (include user private key), 5: index.txt (database for crl)
	unsigned long fileSerial;	//serial of certificate, only used for user certificates
	unsigned long fileLen;		//lenght of this wapi file
} WAPI_FILE_HEADER_T, *WAPI_FILE_HEADER_Tp;

int isFileExist(const char * filename);
off_t list(const char *name, char ** outFile, int * outFileNum);
int getHexFromFile(const char *srcFile, unsigned long *outHex);
unsigned long getUserCertNum(unsigned long * userCertNum);

///////////////////////////////
//For parse certs database: index.txt
int getCertsDb(CERTS_DB_ENTRY_Tp certsInfo, int count);
/////////////////////////////////////
#endif //INCLUDE_WAPIFILES_H

