#include "wapiFiles.h"

/*
//For debug
void dumpHex(const unsigned char * buf, int bufLen)
{
	int i;

	for(i=0;i<bufLen;i++)
	{
		DEBUG("%2x  ",buf[i]);
		if(((i+1)>=16)&&((i+1)%16==0))
		{
			DEBUG("\n");
		}
	}
	DEBUG("\n");

}

//For debug
void dumpStr(const char * buf, int bufLen)
{
	int i;

	for(i=0;i<bufLen;i++)
	{
		DEBUG("%c",buf[i]);
		if(((i+1)>=16)&&((i+1)%16==0))
		{
			DEBUG("\n");
		}
	}
	DEBUG("\n");
}*/

static const char *cmd[]={
"usage: storeWapiFiles args\n",
"\n",
" -reset          - reset all wapi files at running system and reset flash space for wapi area (include wapi area header, wapi file header of ca cert, ca priv_key, ca crl, user cert database, ap cert and ca cert for ap)\n",
" -caCert        - store ca cert\n",
" -caKey         - store ca private key\n",
" -caCrl          - store ca crl\n",
" -oneUser      - store one new user cert at the end of original user certs\n",
" -allUser	        - re-store all user certs at the start of user certs area\n",
" -certDb         - store user cert database\n",
" -apCert	         - store ap cert file (fixed file: AP_CERT)\n",
" -ca4apCert	  - store ca cert file (fixed file: CA4AP_CERT) for ap\n",
" -allFile          - store all wapi files (not include ap cert file and ca4ap cert file)\n",
"-debug cnt     - only for test parsing cnt entries at index.txt\n",
NULL
};

/*
*  check rootfs size whether larger than size
*  return 1: rootfs size >= size(input)
*  return 0: rootfs size < size(input)
*  return -1: check failed 
*/
static int rootfsOverSize(const unsigned long size)
{
	int fh;
	int ret, toRet;
	unsigned long offset,length;
	unsigned char tmpBuf[16];

//	DEBUG("%s(%d),size=0x%x\n",__FUNCTION__,__LINE__,size);//Added for test
	fh = open(FLASH_DEVICE_NAME1, O_RDONLY); 

	if ( fh == -1 ) 
	{
		ERR_PRINT("%s %d open %s error.\n",__FUNCTION__ , __LINE__, FLASH_DEVICE_NAME1);//Added for test
		toRet=FAILED;
		goto err;
	}

	//To read flash
	offset=0;
	lseek(fh,offset,SEEK_SET);//Point to the (head + offset) of file
	
	memset(tmpBuf,0, sizeof(tmpBuf));//To initial
	ret=read(fh,(void *)tmpBuf,sizeof(tmpBuf));
//	DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
//	dumpHex(tmpBuf, ret);

	if ( memcmp(tmpBuf, SQSH_SIGNATURE, SIG_LEN)) {
		ERR_PRINT("SQSH_SIGNATURE error\n");
		toRet=FAILED;
		goto err;
	}

	length = *(((unsigned long *)tmpBuf) + OFFSET_OF_LEN) + SIZE_OF_SQFS_SUPER_BLOCK + SIZE_OF_CHECKSUM;
//	DEBUG("rootfs length=0x%x\n",length);//Added for test

	length+=ROOTFS_HEADER_SIZE;// Added 16B rootfs header
//	DEBUG("rootfs total length=0x%x\n",length);//Added for test

	//offset=MTD1_SIZE-WAPI_SIZE;
	//if(length>=offset)
	if(length>=size)
	{
		ERR_PRINT("root fs size >= 0x%x.\n",size);
		toRet=1;
		goto err;
	}

	toRet=0;
	
err:
	if(fh!=-1)
		close(fh);
	
	return toRet;
}

/*
*  function description: To store wapi file to /dev/mtdblock1
*
*  parameters: 
*  dstAddr (input): destination to store source file
*  srcFile (input): source file name
*  initFlag (input): 0 -- normal mode (store wapi file header and body); 1 -- initial mode (only initial wapi file header and store it)
*
* return 0: success, -1: failed
*/
static int storeFile(const unsigned long dstAddr, const char * srcFile, const char initFlag)
{
	int fh, fd;		// fh: /dev/mtdblock1 handler; fd: srcfile handler
	struct stat fileStat;
	unsigned long offset, totalLen, storeSize;
	WAPI_FILE_HEADER_T wapiFileHeader;
	unsigned char buffer[1300];
	int ret, readSize, lenLeft;
	int toRet;
	char rwFlag;// 0: indicate first time; 1: indicate not first time


	//To initial
	fh=-1;
	fd=-1;
	DEBUG("%s(%d) srcFile=%s\n",__FUNCTION__,__LINE__,srcFile);
	offset=dstAddr;
//	DEBUG("%s(%d), offset=0x%x\n",__FUNCTION__,__LINE__,offset);//Added for test

	//timmy_modify
	//if((offset >= MTD1_SIZE)||(offset< MTD1_SIZE -WAPI_SIZE))
	if(offset >= MTD1_SIZE)
	{
		ERR_PRINT("Error: dstAddr is out of wapi area %s - %s\n",(MTD1_SIZE -WAPI_SIZE), MTD1_SIZE);//Added for test
		toRet=FAILED;
		goto err;
	}

	//To check srcFile store area
	if(strcmp(srcFile, CA_CERT)==0)
	{
		if(dstAddr!=CA_CERT_BASE)
		{
			ERR_PRINT("Error: %s should store at 0x%x\n",CA_CERT, CA_CERT_BASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}
	else if(strcmp(srcFile, CA_PRIV_KEY)==0)
	{
		if(dstAddr!=CA_PRIV_KEY_BASE)
		{
			ERR_PRINT("Error: %s should store at 0x%x\n",CA_PRIV_KEY, CA_PRIV_KEY_BASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}
	else if(strcmp(srcFile, CA_CRL)==0)
	{
		if(dstAddr!=CA_CRL_BASE)
		{
			ERR_PRINT("Error: %s should store at 0x%x\n",CA_CRL, CA_CRL_BASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}
	else if(strcmp(srcFile, CERTS_DATABASE)==0)
	{
		if(dstAddr!=USER_CERT_DATABASE_BASE)
		{
			ERR_PRINT("Error: %s should store at 0x%x\n",CERTS_DATABASE, USER_CERT_DATABASE_BASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}
	else if(strcmp(srcFile, AP_CERT)==0)
	{
		if(dstAddr!=AP_CERT_BASE)
		{
			ERR_PRINT("Error: %s should store at 0x%x\n",AP_CERT, AP_CERT_BASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}
	else if(strcmp(srcFile, CA4AP_CERT)==0)
	{
		if(dstAddr!=CA4AP_CERT_BASE)
		{
			ERR_PRINT("Error: %s should store at 0x%x\n",CA4AP_CERT, CA4AP_CERT_BASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}
	else
	{
		//default: user cert
		if((dstAddr<USER_CERT_BASE)||(dstAddr>USER_CERT_BASE+USER_CERT_MAXSIZE*(USER_CERT_MAXNUM-1)))
		{
			ERR_PRINT("Error: user certs should store at [0x%x, 0x%x)\n",USER_CERT_BASE, USER_CERT_DATABASE_BASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}
	
	if(initFlag==0)
	{
		//Normal mode
		fd=open(srcFile, O_RDONLY);
		if ( fd == -1 ) 
		{
			ERR_PRINT("open %s error.\n", srcFile);//Added for test
			toRet=FAILED;
			goto err;
		}

	       if((fstat(fd,&fileStat) ==0) && (fileStat.st_size > 0))
	       {
	       	wapiFileHeader.fileLen=fileStat.st_size;
	       }
		else
		{
			wapiFileHeader.fileLen=0;
			ERR_PRINT("fstat %s error.\n", srcFile);//Added for test
			toRet=FAILED;
			goto err;
		}
//		DEBUG("%s(%d),wapiFileHeader.fileLen=%d\n",__FUNCTION__,__LINE__,wapiFileHeader.fileLen);//Added for test

		//To store srcfile into flash at dstAddr
		storeSize=wapiFileHeader.fileLen+WAPI_FILE_HEADER_SIZE;
		totalLen=offset+storeSize;
		if(totalLen >= MTD1_SIZE)
		{
			ERR_PRINT("Error: totalLen >= %s\n", MTD1_SIZE);//Added for test
			toRet=FAILED;
			goto err;
		}

		//To check srcFile whether over size
		if(strcmp(srcFile, CA_CERT)==0)
		{
			if(storeSize>CA_CERT_MAXSIZE)
			{
				ERR_PRINT("Error: %s size > 0x%x\n",CA_CERT, CA_CERT_MAXSIZE);//Added for test
				toRet=FAILED;
				goto err;
			}
		}
		else if(strcmp(srcFile, CA_PRIV_KEY)==0)
		{
			if(storeSize>CA_PRIV_KEY_MAXSIZE)
			{
				ERR_PRINT("Error: %s size > 0x%x\n",CA_PRIV_KEY, CA_PRIV_KEY_MAXSIZE);//Added for test
				toRet=FAILED;
				goto err;
			}
		}
		else if(strcmp(srcFile, CA_CRL)==0)
		{
			if(storeSize>CA_CRL_MAXSIZE)
			{
				ERR_PRINT("Error: %s size > 0x%x\n",CA_CRL, CA_CRL_MAXSIZE);//Added for test
				toRet=FAILED;
				goto err;
			}
		}
		else if(strcmp(srcFile, CERTS_DATABASE)==0)
		{
			if(storeSize>USER_CERT_DATABASE_MAXSIZE)
			{
				ERR_PRINT("Error: %s size > 0x%x\n",CERTS_DATABASE, USER_CERT_DATABASE_MAXSIZE);//Added for test
				toRet=FAILED;
				goto err;
			}
		}
		else if(strcmp(srcFile, AP_CERT)==0)
		{
			if(storeSize>AP_CERT_MAXSIZE)
			{
				ERR_PRINT("Error: %s size > 0x%x\n",AP_CERT, AP_CERT_MAXSIZE);//Added for test
				toRet=FAILED;
				goto err;
			}
		}
		else if(strcmp(srcFile, CA4AP_CERT)==0)
		{
			if(storeSize>CA4AP_CERT_MAXSIZE)
			{
				ERR_PRINT("Error: %s size > 0x%x\n",CA4AP_CERT, CA4AP_CERT_MAXSIZE);//Added for test
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			//default: user cert
			if(storeSize>USER_CERT_MAXSIZE)
			{
				ERR_PRINT("Error: user cert size > 0x%x\n", USER_CERT_MAXSIZE);//Added for test
				toRet=FAILED;
				goto err;
			}
		}

		rwFlag=0;
		lenLeft=(int)wapiFileHeader.fileLen;
		while(lenLeft>0)
		{
			//To read srcfile into buffer
			readSize=read(fd, (void *)buffer, sizeof(buffer));
//			DEBUG("%s(%d),readSize=%d\n",__FUNCTION__,__LINE__,readSize);//Added for test
			if(readSize==-1)
			{
				ERR_PRINT("%s(%d),read file failed.\n",__FUNCTION__,__LINE__);//Added for test
				toRet=FAILED;
				goto err;
			}
			//close(fd);

			if(rwFlag==0)
			{
				//To set wapiFileHeader
				if(!strcmp(srcFile,CA_CERT))
				{
					wapiFileHeader.fileType=TYPE_CA_CERT;
				}
				else if(!strcmp(srcFile,CA_PRIV_KEY))
				{
					wapiFileHeader.fileType=TYPE_CA_PRIV_KEY;
				}
				else if(!strcmp(srcFile,CA_CRL))
				{
					wapiFileHeader.fileType=TYPE_CA_CRL;
				}
				else if(!strcmp(srcFile,CERTS_DATABASE))
				{
					wapiFileHeader.fileType=TYPE_CERTS_DATABASE;
				}
				else if(!strcmp(srcFile,AP_CERT))
				{
					wapiFileHeader.fileType=TYPE_AP_CERT;
				}
				else if(!strcmp(srcFile,CA4AP_CERT))
				{
					wapiFileHeader.fileType=TYPE_CA4AP_CERT;
				}
				else//if(!strcmp(srcFile,USER_CERT))
				{
					//Default: user certs
					wapiFileHeader.fileType=TYPE_USER_CERT;
				}

				if(wapiFileHeader.fileType==TYPE_USER_CERT)
				{
					//User certs, we need wapiFileHeader.fileSerial
					ret=filename2serial(srcFile, &wapiFileHeader.fileSerial);
					 if(ret==-1)
				      	{
				      		 ERR_PRINT("%s(%d), filename2serial failed.\n",__FUNCTION__,__LINE__);//Added for test
				               toRet=FAILED;
						goto err;
				      	}
					//wapiFileHeader.fileSerial=1;	// 0: not used, this entry is used only for user certs (for test)
				}
				else
				{
					//other wapi files, we needn't wapiFileHeader.fileSerial
					wapiFileHeader.fileSerial=0;	// 0: not used, this entry is used only for user certs
				}
				
//				DEBUG("%s(%d),wapiFileHeader.fileLen=%d, offset=0x%x, wapiFileHeader.fileSerial=0x%x\n",__FUNCTION__,__LINE__,wapiFileHeader.fileLen,offset, wapiFileHeader.fileSerial);//Added for test

				//To write srcfile (include wapi file header) into flash
				fh = open(FLASH_DEVICE_NAME1, O_RDWR | O_SYNC); 

				if ( fh == -1 ) 
				{
					ERR_PRINT("%s %d open %s error.\n",__FUNCTION__ , __LINE__, FLASH_DEVICE_NAME1);//Added for test
					toRet=FAILED;
					goto err;
				}
				
				lseek(fh,offset,SEEK_SET);//Point to the start of first wapi file
				ret=write(fh,(void *)&wapiFileHeader,sizeof(wapiFileHeader));
//				DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
				if((ret==-1)||(ret < sizeof(wapiFileHeader)))
				{
					ERR_PRINT("%s(%d),error: write flash failed.\n",__FUNCTION__,__LINE__);//Added for test
					toRet=FAILED;
					goto err;
				}
			}

			ret=write(fh,(void *)&buffer,readSize);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if((ret==-1)||(ret < readSize))
			{
				ERR_PRINT("%s(%d),error: write flash failed.\n",__FUNCTION__,__LINE__);//Added for test
				toRet=FAILED;
				goto err;
			}

			lenLeft-=readSize;
			
			rwFlag=1;
		}
	}
	else
	{
		//initial mode
		//To set wapiFileHeader
		if(!strcmp(srcFile,CA_CERT))
		{
			wapiFileHeader.fileType=TYPE_CA_CERT;
		}
		else if(!strcmp(srcFile,CA_PRIV_KEY))
		{
			wapiFileHeader.fileType=TYPE_CA_PRIV_KEY;
		}
		else if(!strcmp(srcFile,CA_CRL))
		{
			wapiFileHeader.fileType=TYPE_CA_CRL;
		}
		else if(!strcmp(srcFile,CERTS_DATABASE))
		{
			wapiFileHeader.fileType=TYPE_CERTS_DATABASE;
		}
		else if(!strcmp(srcFile,AP_CERT))
		{
			wapiFileHeader.fileType=TYPE_AP_CERT;
		}
		else if(!strcmp(srcFile,CA4AP_CERT))
		{
			wapiFileHeader.fileType=TYPE_CA4AP_CERT;
		}
		else//if(!strcmp(srcFile,USER_CERT))
		{
			//Default: user certs
			wapiFileHeader.fileType=TYPE_USER_CERT;
		}
		wapiFileHeader.fileSerial=0;
		wapiFileHeader.fileLen=0;
				
//		DEBUG("%s(%d),offset=0x%x, wapiFileHeader.fileType=0x%x\n",__FUNCTION__,__LINE__,offset, wapiFileHeader.fileType);//Added for test

		//To write srcfile (include wapi file header) into flash
		fh = open(FLASH_DEVICE_NAME1, O_RDWR | O_SYNC); 

		if ( fh == -1 ) 
		{
			ERR_PRINT("%s %d open %s error.\n",__FUNCTION__ , __LINE__, FLASH_DEVICE_NAME1);//Added for test
			toRet=FAILED;
			goto err;
		}
		DEBUG("%s(%d) offset=%08x\n",__FUNCTION__,__LINE__,offset);
		lseek(fh,offset,SEEK_SET);//Point to the start of first wapi file
		ret=write(fh,(void *)&wapiFileHeader,sizeof(wapiFileHeader));
		DEBUG("%s(%d),ret=%d, sizeof(wapiFileHeader)=%d\n",__FUNCTION__,__LINE__,ret, sizeof(wapiFileHeader));//Added for test
		if((ret==-1)||(ret < sizeof(wapiFileHeader)))
		{
			ERR_PRINT("%s(%d),error: write flash failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
	}
	toRet=SUCCESS;

err:
	if(fd!=-1)
		close(fd);
	
	if(fh!=-1)
		close(fh);
	
//	DEBUG("%s(%d)\n",__FUNCTION__,__LINE__);//Added for test
	
	return toRet;
}

/*
*  function description: update wapi area header at flash
*  parameters:
*  fileNumber(input): number of user certs
*  serial (input): serial for next user cert
*  crlNumber (input): crl number for next ca crl
*  return 0: success; -1: failed
*/
static int updateWapiAreaHeader(const unsigned long fileNumber, const unsigned long serial, const unsigned long crlNumber)
{
	int fh;
	int ret, toRet;
	unsigned long offset;
	WAPI_AREA_HEADER_T wapiAreaHeader;

	//To open FLASH_DEVICE_NAME1
	fh = open(FLASH_DEVICE_NAME1, O_RDWR | O_SYNC); 

	if ( fh == -1 ) 
	{
		ERR_PRINT("%s %d open %s error.\n",__FUNCTION__ , __LINE__, FLASH_DEVICE_NAME1);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	//To set wapiAreaHeader
	memset(&wapiAreaHeader, 0, sizeof(wapiAreaHeader));
	strncpy(wapiAreaHeader.signature, "wapi", SIG_LEN);
	wapiAreaHeader.fileNum=fileNumber;
	wapiAreaHeader.nextSerial=serial;
	wapiAreaHeader.nextCrlNumber=crlNumber;
//	DEBUG("%s(%d),wapiAreaHeader.fileNum=0x%x, nextSerial=0x%x, nextCrlNumber=0x%x\n",__FUNCTION__,__LINE__,wapiAreaHeader.fileNum,wapiAreaHeader.nextSerial,wapiAreaHeader.nextCrlNumber);//Added for test
	//wapiAreaHeader.length=0;
	
	//To write flash
	offset=WAPI_AREA_BASE;
	lseek(fh,offset,SEEK_SET);//Point to the (MTD1_SIZE-WAPI_SIZE) of file
	ret=write(fh,(void *)&wapiAreaHeader,sizeof(wapiAreaHeader));
	DEBUG("%s %d ret=%d\n",__FUNCTION__ , __LINE__,ret);
	if((ret==-1)||(ret < sizeof(wapiAreaHeader)))
	{
		ERR_PRINT("%s(%d),error: write flash failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	toRet=SUCCESS;

err:
	if(fh!=-1)
		close(fh);
	
	return toRet;
}

//extern int isFileExist(const char * filename);
//extern off_t list(const char *name, char ** outFile, int * outFileNum);

//#define dump_cmd  {int iii; DEBUG("%s cmd=",__FILE__);	for( iii=0 ; iii<argc ;iii++ ) 		DEBUG("%s ",argv[iii]);	DEBUG("\n");}
//return 0: success
//return -1: failed
int main(int argc, char **argv)
{
	//struct stat fileStat;
	//IMG_HEADER_T imgHeader;
	//unsigned char tmpBuf[16];
	unsigned long offset, tmpVal;//, fileLength;
	int i, ret;//, readSize;
	int toRet;
	//unsigned long length=0;
	unsigned long curFileNo;//Current wapi file number
	unsigned long nxtSerial;//serial for next user cert
	unsigned long nxtCrlnumber;//crl number for next ca crl
	unsigned long userCertNumber;//number of current user certs at flash

	//WAPI_AREA_HEADER_T wapiAreaHeader;
	//WAPI_FILE_HEADER_T wapiFileHeader;

	//char tmpFile[USER_CERT_DIR_MAX_LEN+FILE_NAME_MAX_LEN];
	char tmpFile[50];

	char ** allUserCert=NULL;
	int userCertNum;
	off_t dir_size;

	char badops;
	char storeReset,storeCaCert, storeCaKey, storeCaCrl, storeOneUser,storeAllUser, storeCertDb, storeApCert,storeCa4apCert,storeAllFile;
	char forTest;//Added for test
	int cnt;//Added for test
	CERTS_DB_ENTRY_T certsInfo[50];//Added for test
	//char *apCertFile;
	char **pp;
	FILE *fp;
	
	//FILE *       fp;

//	DEBUG("%s(%d)\n",__FUNCTION__,__LINE__);//Added for test
	/*
	DEBUG("%s(%d), WAPI_AREA_BASE=0x%x\n",__FUNCTION__,__LINE__,WAPI_AREA_BASE);//Added for test
	DEBUG("%s(%d), CA_CERT_BASE=0x%x\n",__FUNCTION__,__LINE__,CA_CERT_BASE);//Added for test
	DEBUG("%s(%d), CA_PRIV_KEY_BASE=0x%x\n",__FUNCTION__,__LINE__,CA_PRIV_KEY_BASE);//Added for test
	DEBUG("%s(%d), CA_CRL_BASE=0x%x\n",__FUNCTION__,__LINE__,CA_CRL_BASE);//Added for test
	DEBUG("%s(%d), USER_CERT_BASE=0x%x\n",__FUNCTION__,__LINE__,USER_CERT_BASE);//Added for test
	DEBUG("%s(%d), USER_CERT_DATABASE_BASE=0x%x\n",__FUNCTION__,__LINE__,USER_CERT_DATABASE_BASE);//Added for test
	DEBUG("%s(%d), AP_CERT_BASE=0x%x\n",__FUNCTION__,__LINE__,AP_CERT_BASE);//Added for test
	DEBUG("%s(%d), WAPI_AREA_END=0x%x\n",__FUNCTION__,__LINE__,WAPI_AREA_END);//Added for test
	*/

	dump_cmd;

	//Initial flags
	badops=0;//0: options ok; 1: options error.
	storeReset=0;
	storeCaCert=0;
	storeCaKey=0;
	storeCaCrl=0;
	storeOneUser=0;
	storeAllUser=0;
	storeCertDb=0;
	storeApCert=0;
	storeCa4apCert=0;
	storeAllFile=0;

	forTest=0;
	cnt=0;

	argc--;
	argv++;

	if(argc==0)
	{
		badops=1;
	}
	
	while (argc >= 1)
	{
		if(strcmp(*argv,"-reset") == 0)
		{
			storeReset=1;
		}
		else if(strcmp(*argv,"-caCert") == 0)
		{
			storeCaCert=1;
		}
		else if(strcmp(*argv,"-caKey") == 0)
		{
			storeCaKey=1;
		} 
		else if(strcmp(*argv,"-caCrl") == 0)
		{
			storeCaCrl=1;
		} 
		else if(strcmp(*argv,"-oneUser") == 0)
		{
			storeOneUser=1;
		} 
		else if(strcmp(*argv,"-allUser") == 0)
		{
			storeAllUser=1;
		} 
		else if(strcmp(*argv,"-certDb") == 0)
		{
			storeCertDb=1;
		} 
		else if(strcmp(*argv,"-apCert") == 0)
		{
			/*
			if (--argc < 1)
				goto bad;
			apCertFile= *(++argv);
			*/
			storeApCert=1;
		} 
		else if(strcmp(*argv,"-ca4apCert") == 0)
		{
			storeCa4apCert=1;
		}
		else if(strcmp(*argv,"-allFile") == 0)
		{
			storeAllFile=1;
		}
		//Added for test: -debug cnt
		else if(strcmp(*argv,"-debug") == 0)
		{
			if (--argc < 1)
				goto bad;
			cnt=atoi(*(++argv));
//			DEBUG("%s(%d),cnt=%d\n",__FUNCTION__,__LINE__,cnt);//Added for test
			forTest=1;
		}
		//End for test
		else
		{
bad:
			ERR_PRINT("unknown option %s\n",*argv);
			badops=1;
			break;
		}
		argc--;
		argv++;	
	}

	if(badops==1)
	{
		for (pp=cmd; (*pp != NULL); pp++)
			DEBUG("%s",*pp);
		toRet=FAILED;
		goto err;
	} 

	//////////////
	//Added for test
	if(forTest==1)
	{
		ret=getCertsDb(certsInfo, cnt);
//	        DEBUG("%s(%d), ret=%d\n",__FUNCTION__,__LINE__, ret);//Added for tes
	        if(ret==FAILED)
	        {
	                ERR_PRINT("%s(%d), getCertsDb failed.\n",__FUNCTION__,__LINE__);//Added for tes
	                toRet=FAILED;
	                goto err;
	        }
	 
	        //Added for tes
	        for(i=0;i<cnt;i++)
	        {
	                DEBUG("%d: userName=%s, serial=%8X, validDays=%d, validDaysLeft=%d, certType=%d, certStatus=%d\n",i, certsInfo[i].userName, certsInfo[i].serial, certsInfo[i].validDays, certsInfo[i].validDaysLeft, certsInfo[i].certType, certsInfo[i].certStatus);//Added for test
	        }
	 
	        toRet=SUCCESS;
		 return toRet;
	}
	//End for test
	////////////////////////////////////
		
	////////////////////////////
	//To check root fs whether ovelap wapi area at flash
	offset=MTD1_SIZE-WAPI_SIZE;
	ret=rootfsOverSize(offset);
//	DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
	if((ret==FAILED)||(ret==1))
	{
		ERR_PRINT("error: can't use wapi area!\n");
		toRet=FAILED;
		goto err;
	}

	///////////////////////////
	//To initial wapi area at flash
	if(storeReset==1)
	{
		curFileNo=0;
		nxtSerial=SERIAL_INIT_VAL;
		nxtCrlnumber=CRLNUMBER_INIT_VAL;

		//To initial all wapi files at system first
		sprintf(tmpFile, "rm -f %s 2>/dev/null", AS_CERT);
		system(tmpFile);
		
		sprintf(tmpFile, "rm -f %s 2>/dev/null", CA_CERT);
		system(tmpFile);
		
		sprintf(tmpFile, "rm -f %s 2>/dev/null", CA_PRIV_KEY);
		system(tmpFile);

		sprintf(tmpFile, "rm -f %s 2>/dev/null", CA_CRL);
		system(tmpFile);

		sprintf(tmpFile, "rm -f %s 2>/dev/null", USER_CERT);
		system(tmpFile);

		sprintf(tmpFile, "rm -f %s/* 2>/dev/null", USER_CERT_DIR);
		system(tmpFile);

		sprintf(tmpFile, "rm -f %s/* 2>/dev/null", NEW_CERTS_DIR);
		system(tmpFile);

		//sprintf(tmpFile, "echo -n \"\" > %s", CERTS_DATABASE); // This line will cause some question in Marvell platform. the size of CERTS_DATABASE file are don'tequal zero.
		//system(tmpFile);
		fp = fopen(CERTS_DATABASE, "w+"); //This size of CERTS_DATABASE file must be zero.
		if (!fp) {
                ERR_PRINT("open %s error.\n", CERTS_DATABASE);//Added for test
                toRet=FAILED;
                goto err;
    }
		lseek(fp,0,SEEK_SET);
		fwrite( "" , 0 , 0 , fp );
		fclose(fp);



		sprintf(tmpFile, "rm -f %s 2>/dev/null", AP_CERT);
		system(tmpFile);

		sprintf(tmpFile, "rm -f %s 2>/dev/null", CA4AP_CERT);
		system(tmpFile);

		sprintf(tmpFile, "echo \"%8X\" >  %s", nxtSerial, NEXT_SERIAL);
		system(tmpFile);

		sprintf(tmpFile, "echo \"%8X\" >  %s", nxtCrlnumber, NEXT_CRLNUMBER);
		system(tmpFile);

		//Initial WapiAreaHeader
		ret=updateWapiAreaHeader(curFileNo, nxtSerial, nxtCrlnumber);
		
		if(ret==FAILED)
		{
			toRet=FAILED;
			goto err;
		}

		//To initial wapi file header of ca cert
		offset=CA_CERT_BASE;
		ret=storeFile(offset, CA_CERT, 1);
		
		if(ret==FAILED)
		{
			toRet=FAILED;
			goto err;
		}

		//To initial wapi file header of ca private key
		offset=CA_PRIV_KEY_BASE;
		ret=storeFile(offset, CA_PRIV_KEY, 1);
		
		if(ret==FAILED)
		{
			toRet=FAILED;
			goto err;
		}

		//To initial wapi file header of ca crl
		offset=CA_CRL_BASE;
		ret=storeFile(offset, CA_CRL, 1);
		
		if(ret==FAILED)
		{
			toRet=FAILED;
			goto err;
		}

		//To initial wapi file header of user certs database
		offset=USER_CERT_DATABASE_BASE;
		ret=storeFile(offset, CERTS_DATABASE, 1);
		
		if(ret==FAILED)
		{
			toRet=FAILED;
			goto err;
		}

		//To initial wapi file header of ap cert
		offset=AP_CERT_BASE;
		ret=storeFile(offset, AP_CERT, 1);
		
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),%s\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}	

		//To initial wapi file header of ca cert for ap
		offset=CA4AP_CERT_BASE;
		ret=storeFile(offset, CA4AP_CERT, 1);
		
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),%s\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
	}

	///////////////////////////
	//To store ca cert at flash
	if(storeCaCert==1)
	{
		//To store ca cert
		offset=CA_CERT_BASE;
		if(isFileExist(CA_CERT))
		{
			ret=storeFile(offset, CA_CERT, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				ERR_PRINT("%s(%d),%s\n",__FUNCTION__,__LINE__);//Added for test
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CA_CERT);//Added for test
			toRet=FAILED;
			goto err;
		}
	}

	///////////////////////////
	//To store ca private key at flash
	if(storeCaKey==1)
	{
		//To store ca private key
		offset=CA_PRIV_KEY_BASE;
		if(isFileExist(CA_PRIV_KEY))
		{
			ret=storeFile(offset, CA_PRIV_KEY, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CA_PRIV_KEY);//Added for test
			toRet=FAILED;
			goto err;
		}
	}

	///////////////////////////
	//To store ca crl at flash
	if(storeCaCrl==1)
	{
		//Initial
		userCertNumber=0;
		nxtSerial=0;
		nxtCrlnumber=0;
		
		//To store ca crl
		offset=CA_CRL_BASE;
		if(isFileExist(CA_CRL))
		{
			ret=storeFile(offset, CA_CRL, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CA_CRL);//Added for test
			toRet=FAILED;
			goto err;
		}

		//To update ca crl number at flash
		ret=getUserCertNum(&userCertNumber);
//		DEBUG("%s(%d),ret=%d, userCertNumber=%d\n",__FUNCTION__,__LINE__,ret, userCertNumber);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),getUserCertNum failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		ret=getHexFromFile(NEXT_SERIAL, &nxtSerial);
//		DEBUG("%s(%d),ret=%d, nxtSerial=0x%x\n",__FUNCTION__,__LINE__,ret, nxtSerial);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		ret=getHexFromFile(NEXT_CRLNUMBER, &nxtCrlnumber);
//		DEBUG("%s(%d),ret=%d, nxtCrlnumber=0x%x\n",__FUNCTION__,__LINE__,ret, nxtCrlnumber);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

//		DEBUG("%s(%d),userCertNumber=0x%x, nxtSerial=0x%x, nxtCrlnumber=0x%x\n",__FUNCTION__,__LINE__,userCertNumber,nxtSerial,nxtCrlnumber);//Added for test
		ret=updateWapiAreaHeader(userCertNumber, nxtSerial, nxtCrlnumber);
//		DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
		if(ret==FAILED)
		{
			toRet=FAILED;
			goto err;
		}
	}

	///////////////////////////
	//To store one user cert at flash
	//we assume the lastest user cert is /var/myca/certs/<serial.old>.cert and it's serial is at /var/myca/serial.old
	if(storeOneUser==1)
	{
		ret=getUserCertNum(&userCertNumber);
//		DEBUG("%s(%d),ret=%d, userCertNumber=%d\n",__FUNCTION__,__LINE__,ret, userCertNumber);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),getUserCertNum failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		if(userCertNumber>=USER_CERT_MAXNUM)
		{
			ERR_PRINT("%s(%d) Warning: number of current user certs at flash already >= %d.\n",__FUNCTION__,__LINE__, USER_CERT_MAXNUM);//Added for test
			toRet=FAILED;
			goto err;
		}
		offset=USER_CERT_BASE;
		offset+=userCertNumber*USER_CERT_MAXSIZE;

		ret=getHexFromFile(NEW_USER_CERT_SERIAL, &tmpVal);
//		DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		sprintf(tmpFile, "%s/%8X.cert",USER_CERT_DIR, tmpVal);
//		DEBUG("%s(%d),tmpFile=%s\n",__FUNCTION__,__LINE__,tmpFile);//Added for test
		if(isFileExist(tmpFile))
		{
			ret=storeFile(offset, tmpFile, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				ERR_PRINT("Warning: %s(%d), store user certs failed from 0x%x.\n",__FUNCTION__,__LINE__, offset);//Added for test
				goto err;
				//break;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, tmpFile);//Added for test
			toRet=FAILED;
			goto err;
		}

		userCertNumber++;//Add one new user cert

		nxtSerial=0;
		nxtCrlnumber=0;
		ret=getHexFromFile(NEXT_SERIAL, &nxtSerial);
//		DEBUG("%s(%d),ret=%d, nxtSerial=0x%x\n",__FUNCTION__,__LINE__,ret, nxtSerial);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		ret=getHexFromFile(NEXT_CRLNUMBER, &nxtCrlnumber);
//		DEBUG("%s(%d),ret=%d, nxtCrlnumber=0x%x\n",__FUNCTION__,__LINE__,ret, nxtCrlnumber);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

//		DEBUG("%s(%d),userCertNumber=0x%x, nxtSerial=0x%x, nxtCrlnumber=0x%x\n",__FUNCTION__,__LINE__,userCertNumber,nxtSerial,nxtCrlnumber);//Added for test
		ret=updateWapiAreaHeader(userCertNumber, nxtSerial, nxtCrlnumber);
//		DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
		if(ret==FAILED)
		{
			toRet=FAILED;
			goto err;
		}

		//To update user cert database at flash
		if(isFileExist(CERTS_DATABASE))
		{
			offset=USER_CERT_DATABASE_BASE;
			ret=storeFile(offset, CERTS_DATABASE, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CERTS_DATABASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}

	///////////////////////////
	//To re-store all user certs at flash
	if(storeAllUser==1)
	{
		//Initial
		curFileNo=0;
		
		//To initial memory related to user certs
		allUserCert = (char **) malloc(sizeof(char *) * FILE_MAX_NUM);
		if(allUserCert==NULL)
		{
			ERR_PRINT("%s(%d),malloc error.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
	       for (i=0;i<FILE_MAX_NUM;i++)
	       {
	       	allUserCert[i] = (char *) malloc(sizeof(char) * FILE_NAME_MAX_LEN);
			if(allUserCert[i]==NULL)
			{
				ERR_PRINT("%s(%d),malloc error.\n",__FUNCTION__,__LINE__);//Added for test
				toRet=FAILED;
				goto err;
			}
	       }
	       userCertNum=0;

//		DEBUG("%s(%d)\n",__FUNCTION__,__LINE__);//Added for test
		if(isFileExist(USER_CERT_DIR))
		{
			dir_size=list(USER_CERT_DIR, allUserCert, &userCertNum);
//			DEBUG(" This directory %s size is %i bytes.\n", USER_CERT_DIR, dir_size);
//			DEBUG("%s(%d), userCertNum=%d\n",__FUNCTION__,__LINE__, userCertNum);//Added for test
			
		 	offset=USER_CERT_BASE;
		        for(i=0;i<userCertNum;i++)
		        {
				//To store user cert
				if(i!=0)
					offset+=USER_CERT_MAXSIZE;
				sprintf(tmpFile, "%s/%s",USER_CERT_DIR, allUserCert[i]);
//				DEBUG("%s(%d), allUserCert[%d]=%s, tmpFile=%s\n",__FUNCTION__,__LINE__, i, allUserCert[i], tmpFile);//Added for test
				ret=storeFile(offset, tmpFile, 0);
//				DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
				if(ret==FAILED)
				{
					toRet=FAILED;
					ERR_PRINT("Warning: %s(%d), store user certs failed from 0x%x.\n",__FUNCTION__,__LINE__, offset);//Added for test
					goto err;
					//break;
				}
				curFileNo++;
		        }
//			DEBUG("%s(%d), curFileNo=%d\n",__FUNCTION__,__LINE__, curFileNo);//Added for test

			if(curFileNo>0)
			{
//				DEBUG("%s(%d), userCertNum=%d, curFileNo=%d\n",__FUNCTION__,__LINE__,userCertNum, curFileNo);//Added for test
				nxtSerial=0;
				nxtCrlnumber=0;
				ret=getHexFromFile(NEXT_SERIAL, &nxtSerial);
//				DEBUG("%s(%d),ret=%d, nxtSerial=0x%x\n",__FUNCTION__,__LINE__,ret, nxtSerial);//Added for test
				if(ret==FAILED)
				{
					ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
					toRet=FAILED;
					goto err;
				}

				ret=getHexFromFile(NEXT_CRLNUMBER, &nxtCrlnumber);
//				DEBUG("%s(%d),ret=%d, nxtCrlnumber=0x%x\n",__FUNCTION__,__LINE__,ret, nxtCrlnumber);//Added for test
				if(ret==FAILED)
				{
					ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
					toRet=FAILED;
					goto err;
				}
		
				ret=updateWapiAreaHeader(curFileNo, nxtSerial, nxtCrlnumber);
//				DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
				if(ret==FAILED)
				{
					toRet=FAILED;
					goto err;
				}
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, USER_CERT_DIR);//Added for test
			toRet=FAILED;
			goto err;
		}

		//To update user cert database at flash
		if(isFileExist(CERTS_DATABASE))
		{
			offset=USER_CERT_DATABASE_BASE;
			ret=storeFile(offset, CERTS_DATABASE, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CERTS_DATABASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}

	///////////////////////////
	//To store user cert database at flash
	if(storeCertDb==1)
	{
		if(isFileExist(CERTS_DATABASE))
		{
			offset=USER_CERT_DATABASE_BASE;
			ret=storeFile(offset, CERTS_DATABASE, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CERTS_DATABASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}

	///////////////////////////
	//To store ap cert at flash
	if(storeApCert==1)
	{
		if(isFileExist(AP_CERT))
		{
			offset=AP_CERT_BASE;
//			DEBUG("%s(%d),AP_CERT=%s, offset=0x%x\n",__FUNCTION__,__LINE__,AP_CERT, offset);//Added for test
			ret=storeFile(offset, AP_CERT, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, AP_CERT);//Added for test
			toRet=FAILED;
			goto err;
		}
	}

	///////////////////////////
	//To store ap cert at flash
	if(storeCa4apCert==1)
	{
		if(isFileExist(CA4AP_CERT))
		{
			offset=CA4AP_CERT_BASE;
//			DEBUG("%s(%d),CA4AP_CERT=%s, offset=0x%x\n",__FUNCTION__,__LINE__,CA4AP_CERT, offset);//Added for test
			ret=storeFile(offset, CA4AP_CERT, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CA4AP_CERT);//Added for test
			toRet=FAILED;
			goto err;
		}
	}
	///////////////////////////////
	
	///////////////////////////
	//To store all wapi files at flash
	if(storeAllFile==1)
	{
		//Initial WapiAreaHeader
		curFileNo=0;
		nxtSerial=0;
		nxtCrlnumber=0;
		ret=getHexFromFile(NEXT_SERIAL, &nxtSerial);
//		DEBUG("%s(%d),ret=%d, nxtSerial=0x%x\n",__FUNCTION__,__LINE__,ret, nxtSerial);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		ret=getHexFromFile(NEXT_CRLNUMBER, &nxtCrlnumber);
//		DEBUG("%s(%d),ret=%d, nxtCrlnumber=0x%x\n",__FUNCTION__,__LINE__,ret, nxtCrlnumber);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		
		ret=updateWapiAreaHeader(curFileNo, nxtSerial, nxtCrlnumber);
//		DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
		if(ret==FAILED)
		{
			toRet=FAILED;
			goto err;
		}

		//To store ca cert
		offset=CA_CERT_BASE;
		if(isFileExist(CA_CERT))
		{
			ret=storeFile(offset, CA_CERT, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CA_CERT);//Added for test
			toRet=FAILED;
			goto err;
		}

		//To store ca private key
		offset=CA_PRIV_KEY_BASE;
		if(isFileExist(CA_PRIV_KEY))
		{
			ret=storeFile(offset, CA_PRIV_KEY, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CA_PRIV_KEY);//Added for test
			toRet=FAILED;
			goto err;
		}

		//To store ca crl
		offset=CA_CRL_BASE;
		if(isFileExist(CA_CRL))
		{
			ret=storeFile(offset, CA_CRL, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CA_CRL);//Added for test
			toRet=FAILED;
			goto err;
		}

		
		//////////////////////////////////
		//To store user certs here
		//To initial memory related to user certs
		allUserCert = (char **) malloc(sizeof(char *) * FILE_MAX_NUM);
		if(allUserCert==NULL)
		{
			ERR_PRINT("%s(%d),malloc error.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
	       for (i=0;i<FILE_MAX_NUM;i++)
	       {
	       	allUserCert[i] = (char *) malloc(sizeof(char) * FILE_NAME_MAX_LEN);
			if(allUserCert[i]==NULL)
			{
				ERR_PRINT("%s(%d),malloc error.\n",__FUNCTION__,__LINE__);//Added for test
				toRet=FAILED;
				goto err;
			}
	       }
	       userCertNum=0;

		

		if(isFileExist(USER_CERT_DIR))
		{
			dir_size=list(USER_CERT_DIR, allUserCert, &userCertNum);

//			DEBUG(" This directory %s size is %i bytes.\n", USER_CERT_DIR, dir_size);

//			DEBUG("%s(%d), userCertNum=%d\n",__FUNCTION__,__LINE__, userCertNum);//Added for test

		 	offset=USER_CERT_BASE;
		        for(i=0;i<userCertNum;i++)
		        {
				//To store user cert
				if(i!=0)
					offset+=USER_CERT_MAXSIZE;
				sprintf(tmpFile, "%s/%s",USER_CERT_DIR, allUserCert[i]);
//				DEBUG("%s(%d), allUserCert[%d]=%s, tmpFile=%s\n",__FUNCTION__,__LINE__, i, allUserCert[i], tmpFile);//Added for test
				ret=storeFile(offset, tmpFile, 0);
//				DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
				if(ret==FAILED)
				{
					toRet=FAILED;
					ERR_PRINT("Warning: %s(%d), store user certs failed from 0x%x.\n",__FUNCTION__,__LINE__, offset);//Added for test
					goto err;
					//break;
				}
				curFileNo++;
		        }
			DEBUG("%s(%d), curFileNo=%d\n",__FUNCTION__,__LINE__, curFileNo);//Added for test

			if(curFileNo>0)
			{
//				DEBUG("%s(%d), userCertNum=%d, curFileNo=%d\n",__FUNCTION__,__LINE__,userCertNum, curFileNo);//Added for test
				nxtSerial=0;
				nxtCrlnumber=0;
				ret=getHexFromFile(NEXT_SERIAL, &nxtSerial);
//				DEBUG("%s(%d),ret=%d, nxtSerial=0x%x\n",__FUNCTION__,__LINE__,ret, nxtSerial);//Added for test
				if(ret==FAILED)
				{
					ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
					toRet=FAILED;
					goto err;
				}

				ret=getHexFromFile(NEXT_CRLNUMBER, &nxtCrlnumber);
//				DEBUG("%s(%d),ret=%d, nxtCrlnumber=0x%x\n",__FUNCTION__,__LINE__,ret, nxtCrlnumber);//Added for test
				if(ret==FAILED)
				{
					ERR_PRINT("%s(%d),getHexFromFile failed.\n",__FUNCTION__,__LINE__);//Added for test
					toRet=FAILED;
					goto err;
				}
		
				ret=updateWapiAreaHeader(curFileNo, nxtSerial, nxtCrlnumber);
//				DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
				if(ret==FAILED)
				{
					toRet=FAILED;
					goto err;
				}
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, USER_CERT_DIR);//Added for test
			toRet=FAILED;
			goto err;
		}
		//End of store user certs

		if(isFileExist(CERTS_DATABASE))
		{
			offset=USER_CERT_DATABASE_BASE;
			ret=storeFile(offset, CERTS_DATABASE, 0);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			ERR_PRINT("%s(%d),%s not exist.\n",__FUNCTION__,__LINE__, CERTS_DATABASE);//Added for test
			toRet=FAILED;
			goto err;
		}
	}
	
	toRet=SUCCESS;
	DEBUG("%s(%d): store wapi files OK!\n",__FUNCTION__,__LINE__);//Added for test

err:
	//To free memory  related to user certs
	if(allUserCert!=NULL)
	{
	       for (i=0;i<FILE_MAX_NUM;i++)
	       {
	        	   if(allUserCert[i]!=NULL)
		                 free(allUserCert[i]);
	       }
	}
	if(allUserCert!=NULL)
		free(allUserCert);

	DEBUG("%s(%d), toRet=%d\n",__FUNCTION__,__LINE__, toRet);//Added for test
	return toRet;
}

