#include "readFileSize.h"

static const char *cmd[]={
"usage: readFileSize args\n",
"\n",
" -in arg          - input file\n",
" -out arg        - output file which store input file size\n",
NULL
};

//return 0: success
////return -1: failed
int main(int argc, char **argv)
{
	char badops=0;
	char **pp;
	char *infile=NULL;
	char *outfile=NULL;
	int toRet=-1;
	struct stat status;
	char tmpBuf[50];

//	printf("%s(%d)\n",__FUNCTION__,__LINE__);//Added for test

	argc--;
	argv++;

	if(argc==0)
	{
		badops=1;
	}
	
	while (argc >= 1)
	{
		if(strcmp(*argv,"-in") == 0)
		{
			if (--argc < 1) goto bad;
				infile= *(++argv);
		}
		else if(strcmp(*argv,"-out") == 0)
		{
			if (--argc < 1) goto bad;
				outfile= *(++argv);
		}
		else
		{
bad:
			printf("unknown option %s\n",*argv);
			badops=1;
			break;
		}
		argc--;
		argv++;	
	}

	if(badops==1)
	{
		for (pp=cmd; (*pp != NULL); pp++)
			printf("%s",*pp);
		toRet=-1;
		goto err;
	} 

//	printf("%s(%d),infile=%s,outfile=%s\n",__FUNCTION__,__LINE__,infile,outfile);//Added for test
	if(stat(infile,&status)==0)
	{
//		printf("%s(%d),stat success: status.st_size=%d\n",__FUNCTION__,__LINE__,status.st_size);//Added for test
		sprintf(tmpBuf,"echo \"%d\" > %s", status.st_size, outfile);
//		printf("%s(%d),tmpBuf=%s\n",__FUNCTION__,__LINE__,tmpBuf);//Added for test
		system(tmpBuf);
	}
	else
	{
//		printf("%s(%d),stat err: status.st_size=%d\n",__FUNCTION__,__LINE__,status.st_size);//Added for test
		sprintf(tmpBuf,"echo \"0\" > %s", outfile);
//		printf("%s(%d),tmpBuf=%s\n",__FUNCTION__,__LINE__,tmpBuf);//Added for test
		system(tmpBuf);
	}

	toRet=0;

err:
	return toRet;
}

