#!/bin/sh

source ./header.sh

mkdir -p $CONFIG_ROOT_DIR

##################### check interface name , This is invalid in VAP interface ################
if_name=$1
len=`echo ${#if_name}`
EXT=`echo $1 | cut -b 7-9`
if [ "$EXT" = "vxd" ] || [ $len -eq 5 ]; then
	echo EXT=$EXT
else
	echo "Error : Interface name error , The script only be used in Root device or vxd device"
fi


############# check iwpriv exist  ##########################

if [ -f $IWPRIV_PATH/iwpriv ]; then
        echo "iwpriv path is" $IWPRIV_PATH/iwpriv
else
        echo $0 " ERROR : Can't find iwpriv path. Path=" $IWPRIV_PATH/iwpriv
        exit 1
fi

############# check Parameter number is vaild ##############

if [ $# -lt 3 ]; then
echo "ERROR : incomplete command."
echo "Example:" $0 "<interface name> <ssid> <MAC address>"
exit 1
fi


############################################################



CONFIG_DIR=$CONFIG_ROOT_DIR/$1
mkdir -p $CONFIG_DIR
SET_WLAN="$IWPRIV_PATH/iwpriv $1"
SET_WLAN_PARAM="$SET_WLAN set_mib"
IFCONFIG=ifconfig







################ wifi MIB initial value ###################
channel=0

#opmode=8 : Infrastructure
#opmode=32: Ad-hoc
opmode=8


ssid=$2
band=11

#phyBandSelect=1 : 2G
#phyBandSelect=2 : 5G
phyBandSelect=1



$IFCONFIG $1 down

################ write initial value to wifi device ###################
$SET_WLAN_PARAM channel=$channel
$SET_WLAN_PARAM opmode=$opmode
$SET_WLAN_PARAM ssid=$ssid
$SET_WLAN_PARAM band=$band
$SET_WLAN_PARAM phyBandSelect=$phyBandSelect


################ Save initial value into files ###################
echo $channel > $CONFIG_DIR/channel
echo $opmode > $CONFIG_DIR/opmode
echo $ssid > $CONFIG_DIR/ssid
echo $band > $CONFIG_DIR/band
echo $phyBandSelect > $CONFIG_DIR/phyBandSelect



################ Set Tx Rate ###################
#echo "auto : auto select "
#echo "CCK  : cck_1M , cck_2M , cck_5.5M , cck_11M"
#echo "OFDM : cck_1M , cck_2M , OFDM_12M , OFDM_18M , OFDM_24M , OFDM_36M , OFDM_48M , OFDM_54M"
#echo "MCS  : mcs0~mcs15"
################################################
./web_tx_rate.sh $1 auto
if [ $? -eq 1 ]; then
	echo "execute set_tx_rate.sh failue"
	exit 1
fi

ifconfig $1 hw ether $3
$IFCONFIG $1 up
