#!/bin/sh

source ./header.sh

CANAME=asu
WAPIDIR=$WAPIDIR_DATA_DIR
OPENSSL_CONF=$WAPI_BIN_DIR/openssl.cnf
WIFI_CERT_DATABASE=$WAPIDIR_DATA_DIR/wapi_cert_database

StoreWapi_Path=$WAPI_BIN_DIR/storeWapiFiles
Openssl_Path=$WAPI_BIN_DIR/openssl
ReadFile_Path=$WAPI_BIN_DIR/readFileSize

if [ -f $StoreWapi_Path ] ; then
	echo "StoreWapi_Path Path=$StoreWapi_Path"
else
	echo "Can't find Program-$StoreWapi_Path"
	exit 1
fi

if [ -f $Openssl_Path ] ; then
	echo "Openssl_Path Path=$Openssl_Path"
else
	echo "Can't find Program-$Openssl_Path"
	exit 1
fi

if [ -d $CONFIG_ROOT_DIR ]; then
	echo "WAPIDIR folder path is" $CONFIG_ROOT_DIR
else
	mkdir $CONFIG_ROOT_DIR
fi
echo $WAPI_BIN_DIR > $CONFIG_ROOT_DIR/wifi_bin_dir


if [ -f $ReadFile_Path ] ; then
	echo "ReadFile_Path Path=$ReadFile_Path"
else
	echo "Can't find Program-$ReadFile_Path"
	exit 1
fi

if [ -f $OPENSSL_CONF ] ; then
	echo "OPENSSL_CONF Path=$OPENSSL_CONF"
else
	echo "Can't find configure file-$OPENSSL_CONF"
	exit 1
fi

if [ -d $WAPIDIR ]; then
	echo "WAPIDIR folder path is" $WAPIDIR
else
	mkdir $WAPIDIR
fi

#re-build the WAPI CERT DATABASE
echo sqsh > $WIFI_CERT_DATABASE



#patch for wapi
#because "openssl ecparam -genkey ... " may generate wrong private key sometimes
NORM_PRIV_KEY_SIZE=195
#Retry times is $MAX_TRY_NUM-1
MAX_TRY_NUM=2
#end patch

#echo "Initial wapi area flash"
$StoreWapi_Path -reset

if [ $? -ne 0 ]; then
	echo "$0 : Execute $StoreWapi_Path -reset failure"
	exit 1
fi


#echo "Begin to generate ca files ... "
#generate ca private key
$Openssl_Path ecparam -genkey -name prime192v1 -out $WAPIDIR/priv.key -noout

if [ $? -ne 0 ]; then
	echo "$0 : Execute $Openssl_Path ecparam -genkey -name prime192v1 -out $WAPIDIR/priv.key -noout failure"
	exit 1
fi


#patch for wapi
#because "openssl ecparam -genkey ... " may generate wrong private key sometimes
num=1
while [ $num -lt $MAX_TRY_NUM ];
do
#    echo "num=$num"
    $ReadFile_Path -in $WAPIDIR/priv.key -out $WAPIDIR/privKeySize
    if [ $? -ne 0 ]; then
			echo "$0 : Execute $ReadFile_Path -in $WAPIDIR/priv.key -out $WAPIDIR/privKeySize failure"
			exit 1
		fi
    
    PRIV_KEY_SIZE=`cat $WAPIDIR/privKeySize`
#    echo "priv_key_size=$PRIV_KEY_SIZE"
 
    if [ "$PRIV_KEY_SIZE" != "$NORM_PRIV_KEY_SIZE" ]; then
        echo "Warning: generate wrong private key. Try again!"
        #Retry to generate user private key
        $Openssl_Path ecparam -genkey -name prime192v1 -out $WAPIDIR/priv.key -noout

				if [ $? -ne 0 ]; then
					echo "$0 : Execute $Openssl_Path ecparam -genkey -name prime192v1 -out $WAPIDIR/priv.key -noout failure"
					exit 1
				fi


        num=`expr $num + 1`

				if [ $num -eq $MAX_TRY_NUM ] ; then
					echo "generate wrong private key"
					exit 1
				else
					echo "retry $num"
				fi

    else
        echo "Size of private key file generated is ok."
        num=$MAX_TRY_NUM
    fi
done
#end patch



cp $WAPIDIR/priv.key $WAPIDIR/CA.key

#generate CA self-signed cert
$Openssl_Path req -new -x509 -days 3650 -key $WAPIDIR/CA.key -subj "/OU=realsil/CN=$CANAME" -out $WAPIDIR/CA.cert
if [ $? -ne 0 ]; then
					echo "$0 : Execute $Openssl_Path req -new -x509 -days 3650 -key $WAPIDIR/CA.key -subj "/OU=realsil/CN=$CANAME" -out $WAPIDIR/CA.cert failure"
					exit 1
fi


#patch for wapi web UI
#cp -f $WAPIDIR/CA.cert /web/as.cer

#To generate ca public key from ca cert
$Openssl_Path x509 -in $WAPIDIR/CA.cert -pubkey -noout > $WAPIDIR/CA_pub.key
if [ $? -ne 0 ]; then
					echo "$0 : Execute $Openssl_Path x509 -in $WAPIDIR/CA.cert -pubkey -noout > $WAPIDIR/CA_pub.key failure"
					exit 1
fi


#general CA crl
$Openssl_Path ca -gencrl -config $OPENSSL_CONF -crldays 365 -crlexts crl_ext -out $WAPIDIR/CA.crl
if [ $? -ne 0 ]; then
					echo "$0 : Execute $Openssl_Path ca -gencrl -config $OPENSSL_CONF -crldays 365 -crlexts crl_ext -out $WAPIDIR/CA.crl failure"
					exit 1
fi


#echo "Generate ca private key, cert and crl OK!"

#echo "Begin to store ca cert, private key and crl ..."
#store ca cert into flash
$StoreWapi_Path -caCert
if [ $? -ne 0 ]; then
	echo "$0 : Execute $StoreWapi_Path -caCert failure"
	exit 1
fi

#store ca private key into flash
$StoreWapi_Path -caKey
if [ $? -ne 0 ]; then
	echo "$0 : Execute $StoreWapi_Path -caKey failure"
	exit 1
fi

#store ca crl into flash
$StoreWapi_Path -caCrl
if [ $? -ne 0 ]; then
	echo "$0 : Execute $StoreWapi_Path -caCrl failure"
	exit 1
fi

#echo "Store ca cert, private key and crl OK!"

