#!/bin/sh

if [ $# -lt 1 ]; then echo "Usage: $0 iface";  exit 1 ; fi

CONFIG_ROOT_DIR="/var/rtl8192c"
CONFIG_DIR=$CONFIG_ROOT_DIR/$1

./script/default_setting.sh $1

SCRIPT_DIR=`cat $CONFIG_ROOT_DIR/wifi_script_dir`
BIN_DIR=`cat $CONFIG_ROOT_DIR/wifi_bin_dir`

if [ -f $BIN_DIR/iwpriv ]; then
	echo "iwpriv path is " $BIN_DIR/iwpriv
else
	echo "ERROR : Can't find iwpriv path. Path=" $BIN_DIR/iwpriv
	exit 1
fi

export SCRIPT_DIR
export BIN_DIR

### WAPI related mib start
iwpriv $1 set_mib encmode=0
iwpriv $1 set_mib authtype=0
iwpriv $1 set_mib wapiPsk=1234567890,a		// PSK key and length
iwpriv $1 set_mib wapiType=2          
iwpriv $1 set_mib wapiUCastKeyType=0 
iwpriv $1 set_mib wapiMCastKeyType=0
iwpriv $1 set_mib 802_1x=0          
iwpriv $1 set_mib psk_enable=0
iwpriv $1 set_mib wpa_cipher=0  
iwpriv $1 set_mib wpa2_cipher=0
### WAPI related mib end

./script/init.sh  ## use enctyption shell in /root/script, like wpa2-aes.sh, ...

#IP_ADDR=`cat $CONFIG_DIR/ip_addr`
#ifconfig $1 $IP_ADDR


