#!/bin/sh

if [ $# -lt 2 ]; then echo "Usage: $0 ap_iface client_iface";  exit 1 ; fi

AP_INTF=$1
CLIENT_INTF=$2

CONFIG_ROOT_DIR="/var/rtl8192c"
AP_CONFIG_DIR=$CONFIG_ROOT_DIR/$AP_INTF
CLIENT_CONFIG_DIR=$CONFIG_ROOT_DIR/$CLIENT_INTF

./script/default_setting.sh $AP_INTF
./script/default_setting.sh $CLIENT_INTF

SCRIPT_DIR=`cat $CONFIG_ROOT_DIR/wifi_script_dir`
BIN_DIR=`cat $CONFIG_ROOT_DIR/wifi_bin_dir`

if [ -f $BIN_DIR/iwpriv ]; then
	echo "iwpriv path is " $BIN_DIR/iwpriv
else
	echo "ERROR : Can't find iwpriv path. Path=" $BIN_DIR/iwpriv
	exit 1
fi

export SCRIPT_DIR
export BIN_DIR

echo "9" > $AP_CONFIG_DIR/channel
echo "family-test" > $AP_CONFIG_DIR/ssid
#./script/wpa2-aes.sh $AP_INTF ap

# [wlan_mode] 0: AP mode 1: Client mode
echo "1" > $CLIENT_CONFIG_DIR/wlan_mode
# [network_type] 0: Infrastructure 1: Ad-hoc
echo "0" > $CLIENT_CONFIG_DIR/network_type
# [ssid] SSID which client want to join
echo "E5756_5.15" > $CLIENT_CONFIG_DIR/ssid
#./script/wpa2-aes.sh $CLIENT_INTF client

./script/init.sh

#IP_ADDR=`cat $CONFIG_DIR/ip_addr`
#ifconfig $1 $IP_ADDR
