#!/bin/sh

CONFIG_ROOT_DIR="/var/rtl8192c"
INTF="wlan0"
CONFIG_DIR=$CONFIG_ROOT_DIR/$INTF

if [ ! -d "$CONFIG_ROOT_DIR" ]; then
     mkdir $CONFIG_ROOT_DIR
fi

if [ -f "$CONFIG_ROOT_DIR/wifi_script_dir" ]; then
	SCRIPT_DIR=`cat $CONFIG_ROOT_DIR/wifi_script_dir`
else
	SCRIPT_DIR=`pwd`/script
	echo $SCRIPT_DIR > $CONFIG_ROOT_DIR/wifi_script_dir
fi

if [ -f "$CONFIG_ROOT_DIR/wifi_bin_dir" ]; then
	BIN_DIR=`cat $CONFIG_ROOT_DIR/wifi_bin_dir`
else
	BIN_DIR="/bin"
	echo $BIN_DIR > $CONFIG_ROOT_DIR/wifi_bin_dir
fi

START_WLAN_ORG=$SCRIPT_DIR/wlan_8192c.sh
START_WLAN=$SCRIPT_DIR/mywlan_8192c.sh
START_WLAN_APP=$SCRIPT_DIR/wlanapp_8192c.sh

SET_WLAN="iwpriv $INTF"
SET_WLAN_PARAM="$SET_WLAN set_mib"

IFCONFIG=ifconfig

ADD_BR=0
BR_INTF="br0"
#LAN_INTF="eth0"
LAN_INTF=

WLAN_INTF=$INTF
VA_INTF="$INTF-va0"
VXD_INTF="$INTF-vxd"
WDS_INTF="$INTF-wds0"

ALL_AP_INTF="$INTF"
ALL_M_AP_INTF="$INTF $VA_INTF"
ALL_RP_INTF="$INTF $VXD_INTF"
ALL_WDS_INTF="$INTF $WDS_INTF"

ALL_WLAN_INTF="$WLAN_INTF $VA_INTF $VXD_INTF"

TOP_VAR_DIR="/var"

WLAN_PREFIX=wlan
WLAN_PREFIX_LEN=${#WLAN_PREFIX}
WLAN_NAME_LEN=$(($WLAN_PREFIX_LEN+1))

BRCTL="brctl"
IWPRIV="iwpriv"

# wep_type 1: wep-64 2: wep-128
wep_type=1
# wep_key_type - 0: hex mode 1: ascii
wep_key_type=0
# wep_key_idx
wep_key_idx=1

wep64_h_key1="3132333435"
wep64_h_key2="3132333435"
wep64_h_key3="3132333435"
wep64_h_key4="3132333435"

wep64_a_key1="12345"
wep64_a_key2="12345"
wep64_a_key3="12345"
wep64_a_key4="12345"

wep128_h_key1="12345678901234567890123456"
wep128_h_key2="12345678901234567890123456"
wep128_h_key3="12345678901234567890123456"
wep128_h_key4="12345678901234567890123456"

wep128_a_key1="31323334353637383930313233"
wep128_a_key2="31323334353637383930313233"
wep128_a_key3="31323334353637383930313233"
wep128_a_key4="31323334353637383930313233"

wpa_psk="1qaz1qaz"

LOCAL_IP="192.168.1.254"

STA_SSID="nicecat"
AP_SSID="cliff-test"

ap_channel="1"

#MACID="00:01:73:01:FF:AB"

#LOCAL=00:01:73:01:ff:10    
WDS_PEER_MAC="002288773327"
WDS_IP="192.168.99.100"

ENC="wpa2-aes"

VAP=0
RP=0
WPS=0

set_open() {
    echo "0" > $CONFIG_ROOT_DIR/$1/macclone_enable

    echo "0" > $CONFIG_ROOT_DIR/$1/encrypt
    echo "0" > $CONFIG_ROOT_DIR/$1/wep
    echo "0" > $CONFIG_ROOT_DIR/$1/wep_default_key
    echo "1" > $CONFIG_ROOT_DIR/$1/wep_key_type
    echo "2" > $CONFIG_ROOT_DIR/$1/auth_type

    echo "0" > $CONFIG_ROOT_DIR/$1/wsc_configured
    echo "1" > $CONFIG_ROOT_DIR/$1/wsc_auth
    echo "1" > $CONFIG_ROOT_DIR/$1/wsc_enc    

    if [ "$RP" = "0" ]; then
        echo 0 > $CONFIG_ROOT_DIR/repeater_enabled
    fi	
}

set_wep() {
    # wep_key_type - 0: hex mode 1: ascii
    # wep : 1: wep-64 2: wep-1if [ "$RP" = "0" ]; then    # wep_key_idx
    echo "1" > $CONFIG_ROOT_DIR/$1/encrypt
    echo $wep_type > $CONFIG_ROOT_DIR/$1/wep
    echo $wep_key_idx > $CONFIG_ROOT_DIR/$1/wep_default_key
    echo $wep_key_type > $CONFIG_ROOT_DIR/$1/wep_key_type
    echo "2" > $CONFIG_ROOT_DIR/$1/auth_type

    echo $wep64_h_key1 > $CONFIG_ROOT_DIR/$1/wepkey1_64_hex
    echo $wep64_h_key2 > $CONFIG_ROOT_DIR/$1/wepkey2_64_hex
    echo $wep64_h_key3 > $CONFIG_ROOT_DIR/$1/wepkey2_64_hex
    echo $wep64_h_key4 > $CONFIG_ROOT_DIR/$1/wepkey3_64_hex

    echo $wep64_a_key1 > $CONFIG_ROOT_DIR/$1/wepkey1_64_asc
    echo $wep64_a_key2 > $CONFIG_ROOT_DIR/$1/wepkey2_64_asc
    echo $wep64_a_key3 > $CONFIG_ROOT_DIR/$1/wepkey2_64_asc
    echo $wep64_a_key4 > $CONFIG_ROOT_DIR/$1/wepkey3_64_asc

    echo $wep128_h_key1 > $CONFIG_ROOT_DIR/$1/wepkey1_128_hex
    echo $wep128_h_key2 > $CONFIG_ROOT_DIR/$1/wepkey2_128_hex
    echo $wep128_h_key3 > $CONFIG_ROOT_DIR/$1/wepkey2_128_hex
    echo $wep128_h_key4 > $CONFIG_ROOT_DIR/$1/wepkey3_128_hex

    echo $wep128_a_key1 > $CONFIG_ROOT_DIR/$1/wepkey1_128_asc
    echo $wep128_a_key2 > $CONFIG_ROOT_DIR/$1/wepkey2_128_asc
    echo $wep128_a_key3 > $CONFIG_ROOT_DIR/$1/wepkey2_128_asc
    echo $wep128_a_key4 > $CONFIG_ROOT_DIR/$1/wepkey3_128_asc

    echo "1" > $CONFIG_ROOT_DIR/$1/wsc_configured
    echo "1" > $CONFIG_ROOT_DIR/$1/wsc_auth
    echo "2" > $CONFIG_ROOT_DIR/$1/wsc_enc
    echo "0" > $CONFIG_ROOT_DIR/$1/wsc_configbyextreg
}

set_wpa_tkip() {
    	
    echo "2" > $CONFIG_ROOT_DIR/$1/encrypt
    echo "0" > $CONFIG_ROOT_DIR/$1/enable_1x
    echo "2" > $CONFIG_ROOT_DIR/$1/wpa_auth
    echo "1" > $CONFIG_ROOT_DIR/$1/wpa_cipher
    echo $wpa_psk > $CONFIG_ROOT_DIR/$1/wpa_psk

    echo "1" > $CONFIG_ROOT_DIR/$1/wsc_configured
    echo "2" > $CONFIG_ROOT_DIR/$1/wsc_auth
    echo "4" > $CONFIG_ROOT_DIR/$1/wsc_enc
    echo "0" > $CONFIG_ROOT_DIR/$1/wsc_configbyextreg
    echo $wpa_psk > $CONFIG_ROOT_DIR/$1/wsc_psk
}

set_wpa_aes() {
    echo "2" > $CONFIG_ROOT_DIR/$1/encrypt
    echo "0" > $CONFIG_ROOT_DIR/$1/enable_1x
    echo "2" > $CONFIG_ROOT_DIR/$1/wpa_auth
    echo "2" > $CONFIG_ROOT_DIR/$1/wpa_cipher
    echo $wpa_psk > $CONFIG_ROOT_DIR/$1/wpa_psk

    echo "1" > $CONFIG_ROOT_DIR/$1/wsc_configured
    echo "2" > $CONFIG_ROOT_DIR/$1/wsc_auth
    echo "8" > $CONFIG_ROOT_DIR/$1/wsc_enc
    echo "0" > $CONFIG_ROOT_DIR/$1/wsc_configbyextreg
    echo $wpa_psk > $CONFIG_ROOT_DIR/$1/wsc_psk
}

set_wpa2_tkip () {
    echo "4" > $CONFIG_ROOT_DIR/$1/encrypt
    echo "0" > $CONFIG_ROOT_DIR/$1/enable_1x
    echo "2" > $CONFIG_ROOT_DIR/$1/wpa_auth
    echo "1" > $CONFIG_ROOT_DIR/$1/wpa2_cipher
    echo $wpa_psk > $CONFIG_ROOT_DIR/$1/wpa_psk

    echo "1" > $CONFIG_ROOT_DIR/$1/wsc_configured
    echo "32" > $CONFIG_ROOT_DIR/$1/wsc_auth
    echo "4" > $CONFIG_ROOT_DIR/$1/wsc_enc
    echo "0" > $CONFIG_ROOT_DIR/$1/wsc_configbyextreg
    echo $wpa_psk > $CONFIG_ROOT_DIR/$1/wsc_psk
}

set_wpa2_aes () {
    echo "4" > $CONFIG_ROOT_DIR/$1/encrypt
    echo "0" > $CONFIG_ROOT_DIR/$1/enable_1x
    echo "2" > $CONFIG_ROOT_DIR/$1/wpa_auth
    echo "2" > $CONFIG_ROOT_DIR/$1/wpa2_cipher
    echo $wpa_psk > $CONFIG_ROOT_DIR/$1/wpa_psk

    echo "1" > $CONFIG_ROOT_DIR/$1/wsc_configured
    echo "32" > $CONFIG_ROOT_DIR/$1/wsc_auth
    echo "8" > $CONFIG_ROOT_DIR/$1/wsc_enc
    echo "0" > $CONFIG_ROOT_DIR/$1/wsc_configbyextreg
    echo $wpa_psk > $CONFIG_ROOT_DIR/$1/wsc_psk
}

set_mixed() {
    echo "6" > $CONFIG_ROOT_DIR/$1/encrypt
    echo "0" > $CONFIG_ROOT_DIR/$1/enable_1x
    echo "2" > $CONFIG_ROOT_DIR/$1/wpa_auth
    echo "3" > $CONFIG_ROOT_DIR/$1/wpa_cipher
    echo "3" > $CONFIG_ROOT_DIR/$1/wpa2_cipher
    echo $wpa_psk > $CONFIG_ROOT_DIR/$1/wpa_psk

    echo "1" > $CONFIG_ROOT_DIR/$1/wsc_configured
    echo "34" > $CONFIG_ROOT_DIR/$1/wsc_auth
    echo "12" > $CONFIG_ROOT_DIR/$1/wsc_enc
    echo "0" > $CONFIG_ROOT_DIR/$1/wsc_configbyextreg
    echo $wpa_psk > $CONFIG_ROOT_DIR/$1/wsc_psk
}

set_enc() {
    # set_enc [enc] [intf]	
    set_open $2	
    case $1 in
       open)
          echo "do nothing"
       ;;
       wep)	  
	  set_wep $2
       ;;
       wpa_tkip)
	  set_wpa_tkip $2
       ;;
       wpa_aes)
	  set_wpa_aes $2 
       ;;
       wpa2_tkip)
          set_wpa2_tkip	$2       
       ;;
       wpa2_aes)
	  set_wpa2_aes $2 
       ;;	       
       mixed)
	  set_mixed $2
       ;;
       802.1x)
	  echo "not supported yet"     
       ;;	       
       *)
       echo "usage: enc: open, wep, wpa_tkip, wpa2_aes, mixed"
       exit 1       
    esac	    
}

start_nat() {

     EIF="eth0"
     IIF="br0"
     INNET="192.168.10.0/24"

     echo "1" > /proc/sys/net/ipv4/ip_forward

     iptables -F
     iptables -X
     iptables -t nat -F
     iptables -t nat -X 
  
     iptables -P INPUT DROP
     iptables -P OUTPUT ACCEPT
     iptables -P FORWARD ACCEPT

     iptables -A INPUT -m state --state RELATED,ESTABLISHED -j ACCEPT

     iptables -t nat -A POSTROUTING -o $EIF -s $INNET -j MASQUERADE
}

stop_nat() {

      iptables -F
      iptables -X
      iptables -t nat -F
      iptables -t nat -X

}

start_ap() {
    if [ "$WPS" = "0" ]; then	
        for intf in $@
        do	    
            echo "0" > $CONFIG_ROOT_DIR/$intf/wlan_mode
            set_enc $ENC $intf # [enc] [intf]

            NUM=${intf#w*va};
            echo "start my $NUM"

            echo "$AP_SSID-$intf" > $CONFIG_ROOT_DIR/$intf/ssid	
            echo $ap_channel > $CONFIG_ROOT_DIR/$intf/channel
         done
    
         #$IFCONFIG $INTF hw ether $MACID
    fi
    
    rtl_act_wlan_if start $@ # all if

    if [ "$RP" = "0" ]; then
        rtl_br_lan_if start $@ $LAN_INTF #all if

        #$IFCONFIG $INTF hw ether $MACID

        if [ "$ADD_BR" = "1" ]; then
           $IFCONFIG $BR_INTF $LOCAL_IP up
        fi
        
        $START_WLAN_APP start $@ $BR_INTF 

        #start_nat
    fi	 
}
 
start_cli() {
    if [ "$WPS" = "0" ]; then	
       set_enc $1 $2

        # auto channel
        channel=0

        #wlan_mode=0 : AP
        #wlan_mode=1 : Client | Ad-hoc
        #               network_type=0 : Clien
        #               network_type=1 : Ad-hoc
        wlan_mode=1
        network_type=0

        #1:B, 2:G, 4:A, 8:N, 64:AC
        #band=11 : BGN
        band=11

        #phyBandSelect=1 : 2G
        #phyBandSelect=2 : 5G
        phyBandSelect=1

        echo $channel > $CONFIG_ROOT_DIR/$2/channel
        echo $wlan_mode > $CONFIG_ROOT_DIR/$2/wlan_mode
        echo $network_type > $CONFIG_ROOT_DIR/$2/network_type
        echo $STA_SSID > $CONFIG_ROOT_DIR/repeater_ssid
        echo $STA_SSID > $CONFIG_ROOT_DIR/$2/ssid
        echo $band > $CONFIG_ROOT_DIR/$2/band
        echo $phyBandSelect > $CONFIG_ROOT_DIR/$2/phyBandSelect

        #WPS_DISABLE=0

        #echo $WPS_DISABLE > $CONFIG_ROOT_DIR/$2/wpa_auth    

        #echo 0 > $CONFIG_ROOT_DIR/$2/wsc_enc
    fi
    
    #$IFCONFIG $INTF down    
    #$START_WLAN_ORG $INTF
    #$IFCONFIG $INTF hw ether $MACID
    #$IFCONFIG $INTF $LOCAL_IP up

    rtl_act_wlan_if start $2
    
    #$IWPRIV $2 set_mib wsc_enable=1

    if [ "$RP" = "0" ]; then
       #$IFCONFIG $2 hw ether $MACID

       rtl_br_lan_if start $2 $BR_INTF

       #$IWRPIV $INTF set_mib nat25_disable=1

       #$IFCONFIG $INTF hw ether $MACID

       if [ "$ADD_BR" = "1" ]; then
           $IFCONFIG $BR_INTF $LOCAL_IP up
       fi
       
       $START_WLAN_APP start $2 $BR_INTF
    fi

    #echo 1 > $CONFIG_ROOT_DIR/$2/wsc_enc
    #$IWPRIV $2 set_mib wsc_enable=1
    cat /var/run/wscd-wlan0.pid
}

start_rp() {
   echo 1 > $CONFIG_ROOT_DIR/repeater_enabled
   echo $AP_SSID > $CONFIG_ROOT_DIR/repeater_ssid

   ENC=$1
   VAP=0
   RP=1

   start_ap $ALL_AP_INTF

   #$IFCONFIG $INTF up

   VXD_INTF="$INTF-vxd"
   start_cli $1 $VXD_INTF

   $IFCONFIG $VXD_INTF up
   $IFCONFIG $INTF up

   rtl_br_lan_if start $VXD_INTF $INTF

   if [ "$ADD_BR" = "1" ]; then
       $IFCONFIG $BR_INTF $LOCAL_IP up
   fi
}

start_rp11() {

    echo 1 > $CONFIG_ROOT_DIR/repeater_enabled
    echo $AP_SSID > $CONFIG_ROOT_DIR/repeater_ssid

    VXD_INTF="$INTF-vxd"	

    start_cli $1 $VXD_INTF

    set_enc $1 $INTF

    wlan_mode=0
    network_type=0
    repeater_enabled=1

    echo $wlan_mode > $CONFIG_ROOT_DIR/$INTF/wlan_mode
    echo $network_type > $CONFIG_ROOT_DIR/$INTF/network_type
    echo $repeater_enabled > $CONFIG_ROOT_DIR/repeater_enabled
    echo $AP_SSID > $CONFIG_ROOT_DIR/$INTF/ssid

    rtl_act_wlan_if start $INTF

    $IFCONFIG $INTF 0.0.0.0 up

    $BRCTL addif $BR_INTF $INTF
}

start_rp1() {

    start_cli $1 $INTF
    
    VXD_INTF="$INTF-vxd"

    set_enc $1 $VXD_INTF
    
    wlan_mode=0
    network_type=0
    repeater_enabled=1

    echo $wlan_mode > $CONFIG_ROOT_DIR/$VXD_INTF/wlan_mode
    echo $network_type > $CONFIG_ROOT_DIR/$VXD_INTF/network_type
    echo $repeater_enabled > $CONFIG_ROOT_DIR/repeater_enabled
    echo $AP_SSID > $CONFIG_ROOT_DIR/$VXD_INTF/ssid

    rtl_act_wlan_if start $VXD_INTF

    MACID1="00:01:73:01:FF:11"
    MACID2="00:22:88:77:33:27"

    #$IFCONFIG $VXD_INTF hw ether $MACID1
  
    #iwpriv wlan0-vxd set_mib ssid="cliff-test"
    $IWPRIV $VXD_INTF set_mib ssid=$AP_SSID

    #rtl_br_lan_if start $ALL_RP_INTF

    #$IFCONFIG $BR_INTF $LOCAL_IP up

    $IFCONFIG $VXD_INTF 0.0.0.0 up 
    
    $BRCTL addif $BR_INTF $VXD_INTF
}

rtl_br_lan_if() {
        # func args: cmd lan0 lan1 ...
        # shutdown LAN interface (ethernt, wlan)
        
        if [ "$1" = "start" ]; then
            if [ "$ADD_BR" = "1" ]; then
                $BRCTL addbr $BR_INTF
                $IFCONFIG $BR_INTF up
            fi
        fi
        for ARG in $@ ; do
                #INTF=`$IFCONFIG $ARG`
                #echo "$1 $INTF"
                if [ "$ARG" = "start" ] || [ "$ARG" = "stop" ]; then
                    continue;
                fi
                
                if [ "$1" = "stop" ]; then
                    $IFCONFIG $ARG down
                    if [ $ARG != $1 ]; then
                         $BRCTL delif $BR_INTF $ARG 2> /dev/null
                    fi
	        else    
                    if [ $ARG != $1 ]; then
                         $IFCONFIG $ARG 0.0.0.0 up
                         $BRCTL addif $BR_INTF $ARG 2> /dev/null
                    fi                    
                fi
        done
        if [ "$1" = "stop" ]; then
             if [ "$ADD_BR" = "1" ]; then
                $IFCONFIG $BR_INTF down
                $BRCTL delbr $BR_INTF
             fi
        fi
}

# Start WLAN interface
rtl_act_wlan_if() {
     VA_INTF="$INTF-va*"
     VXD_IF="$INTF-vxd*"

     #echo "VAP:$VAP"
     $BIN_DIR/webs -x
     
     #echo "$WLAN_PREFIX $WLAN_PREFIX_LEN $WLAN_NAME"
     for WLAN in $@ ; do
         case $WLAN in
           $VA_INTF)
             #echo "va: $WLAN"
             #$IWPRIV $WLAN set_mib vap_enable=0
             EXT="va"	     
             ;; 
           $VXD_IF)
             #echo "vxd: $WLAN"
             #$IWPRIV $WLAN set_mib vap_enable=0
             $IWPRIV $WLAN copy_mib
	     EXT="vxd"	   
             ;;
           $INTF)  
	     #echo "wlan intf: $WLAN"	   
	     $IWPRIV $WLAN set_mib vap_enable=$VAP
	     EXT="root"
	     ;;	   
           *)
             #echo "cmd: $WLAN"		    
	     continue	   
             ;;
         esac
	 $IFCONFIG $WLAN down
	 if [ "$1" = "start" ]; then
  	     echo "Initialize $WLAN intf"
             $START_WLAN $WLAN $INTF $EXT
         fi    
     done
}

## kill 802.1x, autoconf and IAPP daemon ##
rtl_kill_iwcontrol_pid() {
        PIDFILE="$TOP_VAR_DIR/run/iwcontrol.pid"
        if [ -f $PIDFILE ] ; then
                PID=`cat $PIDFILE`
                echo "IWCONTROL_PID=$PID"
                if [ "$PID" != "0" ]; then
                        kill -9 $PID 2>/dev/null
                fi
                rm -f $PIDFILE
        fi
}

rtl_kill_wlan_pid() {
        for WLAN in $@ ; do
                PIDFILE=$TOP_VAR_DIR/run/auth-$WLAN.pid
                if [ -f $PIDFILE ] ; then
                        PID=`cat $PIDFILE`
                        echo "AUTH_PID=$PID"
                        if [ "$PID" != "0" ]; then
                                kill -9 $PID 2>/dev/null
                        fi
                        rm -f $PIDFILE

                        PIDFILE=$TOP_VAR_DIR/run/auth-$WLAN-vxd.pid
                        if [ -f $PIDFILE ] ; then
                                PID=`cat $PIDFILE`
                                if [ "$PID" != "0" ]; then
                                        kill -9 $PID 2>/dev/null
                                fi
                                rm -f $PIDFILE
                        fi
                fi

                # for WPS ---------------------------------->>
                PIDFILE=$TOP_VAR_DIR/run/wscd-$WLAN.pid
                if [ "$both_band_ap" = "1" ]; then
                        PIDFILE=$TOP_VAR_DIR/run/wscd-wlan0-wlan1.pid
                fi

                if [ -f $PIDFILE ] ; then
                        PID=`cat $PIDFILE`
                        echo "WSCD_PID=$PID"
                        if [ "$PID" != "0" ]; then
                                kill -9 $PID 2>/dev/null
                        fi
                        rm -f $PIDFILE
                fi
        done
        #<<----------------------------------- for WPS
}

stop_all() {
    HAS_APP=1
    if [ "$1" = "m-ap" ];then
	ALL_INTF=$ALL_M_AP_INTF    
    elif [ "$1" = "ap" ];then
        ALL_INTF=$INTF	    
	#stop_nat
    elif [ "$1" = "rp" ]; then
	ALL_INTF=$ALL_RP_INTF
    elif [ "$1" = "wds" ]; then	
	ALL_INTF=$ALL_WDS_INTF    
	HAS_APP=0
    else
        ALL_INTF=$INTF
        HAS_APP=0	
    fi	    
   
    $IWPRIV $INTF set_mib wsc_enable=0

    rtl_act_wlan_if stop $ALL_INTF

    rtl_br_lan_if stop $ALL_INTF $LAN_INTF

    $START_WLAN_APP kill $ALL_INTF $BR_INTF

    killall webs 2> /dev/null
    rtl_kill_iwcontrol_pid $ALL_INTF
    rtl_kill_wlan_pid $ALL_INTF
    rm -f $TOP_VAR_DIR/*.fifo
}

start_wds() {

    if [ "$1" = "open"]; then
	ENC_AUTH="0"
    elif [ "$1" = "wep" ]; then
	ENC_AUTH="1"
    elif [ "$1" = "wpa-tkip" ]; then
	ENC_AUTH="2"      	
    elif [ "$1" = "wpa2-aes" ]; then
	ENC_AUTH="4"	
    fi	    

    $IWPRIV $INTF set_mib wds_enable=1
    $IWPRIV $INTF set_mib wds_pure=0
    $IWPRIV $INTF set_mib wds_priority=1
    $IWPRIV $INTF set_mib wds_num=0
    $IWPRIV $INTF set_mib wds_encrypt=$ENC_AUTH  ## 0:none 1:wep40 2:tkip 4:aes 5:wep104
    $IWPRIV $INTF set_mib wds_wepkey=$wep_key
    $IWPRIV $INTF set_mib wds_passphrase=$wpa_psk
    $IWPRIV $INTF set_mib wds_add=$WDS_PEER_MAC,0  ## peer mac address, rate

    #$IWPRIV $INTF set_mib wsc_enable=0

    rtl_act_wlan_if start $INTF

    $IFCONFIG $WDS_INTF up

    rtl_br_lan_if start $ALL_WDS_INTF

    echo 1 > /proc/sys/net/ipv6/conf/$WDS_INTF/disable_ipv6

    if [ "$ADD_BR" = "1" ]; then
      $IFCONFIG $BR_INTF $WDS_IP
    fi  
    
    #$IFCONFIG $INTF-wds0 up
}

wps_restart() {
    MODE=`cat $CONFIG_ROOT_DIR/$2/wlan_mode`

    if [ "$MODE" = "0" ];then
       stop_all ap
       start_ap $ALL_AP_INTF
    else
       stop_all cli
       start_cli $INTF
    fi	    
}

load_default() {
    for intf in $ALL_WLAN_INTF
    do
        $SCRIPT_DIR/default_setting.sh $intf
    done	    
}

case $1 in
    load)
    load_default	    
    ;;	    
    ap)
    ENC=$2	    
    VAP=0
    start_ap $ALL_AP_INTF
    ;;
    m-ap)
    ENC=$2    
    VAP=1
    start_ap $ALL_M_AP_INTF
    ;;
    cli)
    start_cli $2 $INTF
    ;;
    wps_restart)
    WPS=1
    wps_restart
    ;;
    rp)
    start_rp $2
    ;;    
    wds)
    start_wds $2	    
    ;;	    
    cli_stop) 
    stop_all cli 
    ;;    
    ap_stop) 
    stop_all ap
    ;;
    m-ap_stop)
    stop_all m-ap
    ;;
    rp_stop)
    stop_all rp
    ;;
    wds_stop)
    stop_all wds	    
    ;;	    
    *)
       echo "usage: $0 [ ap | m-ap | cli | rp | wds ] [ enc ]"    
       exit 1
esac

