#!/bin/sh

CONFIG_ROOT_DIR="/var/rtl8192c"
SCRIPT_DIR=`cat $CONFIG_ROOT_DIR/wifi_script_dir`
START_WLAN=$SCRIPT_DIR/wlan_8192c.sh
CONFIG_DIR="$CONFIG_ROOT_DIR/$1"
SET_WLAN="iwpriv $1"
SET_WLAN_PARAM="$SET_WLAN set_mib"

IFCONFIG=ifconfig

##################### check interface name , This is invalid in VAP interface ################
if_name=$1
len=`echo ${#if_name}`
EXT=`echo $1 | cut -b 7-9`
if [ "$EXT" = "vxd" ] || [ $len -eq 5 ]; then
	echo EXT=$EXT
else
	echo "Error : Interface name error , The script only be used in Root device or vxd device"
fi

############# check Parameter number is vaild ##############

if [ $# -lt 3 ]; then
echo "ERROR : incomplete command."
echo "Example:" $0 "<interface name> <ssid> <MAC address>"
exit 1
fi


################ wifi MIB initial value ###################
channel=0

#wlan_mode=0 : AP
#wlan_mode=1 : Client | Ad-hoc
#		network_type=0 : Clien
#		network_type=1 : Ad-hoc
wlan_mode=1
network_type=0

#1:B, 2:G, 4:A, 8:N, 64:AC
#band=11 : BGN
band=11

#phyBandSelect=1 : 2G
#phyBandSelect=2 : 5G
phyBandSelect=1

ssid="$2"

$IFCONFIG $1 down

################ Save initial value into files ###################
echo $channel > $CONFIG_DIR/channel
echo $wlan_mode > $CONFIG_DIR/wlan_mode
echo $network_type > $CONFIG_DIR/network_type
echo "$ssid" > $CONFIG_ROOT_DIR/repeater_ssid
echo "$ssid" > $CONFIG_DIR/ssid
echo $band > $CONFIG_DIR/band
echo $phyBandSelect > $CONFIG_DIR/phyBandSelect

################ write initial value to wifi device ###################
$START_WLAN $1

ifconfig $1 hw ether $3
$IFCONFIG $1 up
