#!/bin/sh

# APMC (AP Management Clienet)

. /sbin/global.sh

# init $lan_if (not include WLAN) for different OperationMode:
#   0 = Bridge Mode
#   1 = Gateway Mode
#   2 = Ethernet Converter Mode
#   3 = AP Client
# (see: internet.sh)
init_if()
{
    ifconfig eth2 0.0.0.0

    if [ "$CONFIG_RAETH_ROUTER" = "y" -o "$CONFIG_MAC_TO_MAC_MODE" = "y" -o "$CONFIG_RT_3052_ESW" = "y" ]; then
        #insmod -q 8021q --> this module doesn't exist
        vconfig add eth2 1 > /dev/null 2>&1
        set_vlan_map eth2.1 > /dev/null 2>&1
        ifconfig eth2.1 down
        ifconfig eth2.1 0.0.0.0
    elif [ "$CONFIG_ICPLUS_PHY" = "y" ]; then
        ifconfig eth2:1 0.0.0.0 1>&2 2>/dev/null
    fi

    if [ "$opmode" = "0" ]; then
        WL_VLAN=`nvram_get 2860 WL_VLAN`
        AP_800_MODE=`nvram_get 2860 800_ap_mode`
        # 1. AP mode:           OperationMode=0, 800_ap_mode=0
        # 3. AP Br P-2-P mode:  OperationMode=0, 800_ap_mode=1
        # 4. AP Br P-2-MP mode: OperationMode=0, 800_ap_mode=2
        # 5. AP Br WDS mode:    OperationMode=0, 800_ap_mode=3
        #bridge all interface together
        if [ "$WL_VLAN" == "0" ] || [ "$AP_800_MODE" == "1" ] || [ "$AP_800_MODE" == "2" ]; then
            #set VLAN
			config-vlan.sh 3 LLLLL
            brctl addbr br0
            brctl setfd br0 1
            brctl addif br0 eth2.1
        else
			#set SSID with different VLAN interface
			#set VLAN
			config-vlan.sh 3 WLLLL			

            brctl addbr br0
            brctl setfd br0 1
            brctl addif br0 eth2.1
        fi

    elif [ "$opmode" = "1" ]; then
        if [ "$CONFIG_RAETH_ROUTER" = "y" -o "$CONFIG_MAC_TO_MAC_MODE" = "y" -o "$CONFIG_RT_3052_ESW" = "y" ]; then
            if [ "$CONFIG_RAETH_ROUTER" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
                if [ "$CONFIG_WAN_AT_P1" = "y" ]; then
                    echo '##### config IC+ vlan partition (LWLLL) #####'
                    config-vlan.sh 0 LWLLL
                elif [ "$CONFIG_WAN_AT_P0" = "y" ]; then
                    echo '##### config IC+ vlan partition (WLLLL) #####'
                    config-vlan.sh 0 WLLLL
                else
                    echo '##### config IC+ vlan partition (LLLLW) #####'
                    config-vlan.sh 0 LLLLW
                fi
            fi
            if [ "$CONFIG_MAC_TO_MAC_MODE" = "y" ]; then
                echo '##### config Vtss vlan partition #####'
                config-vlan.sh 1 1
            fi
            if [ "$CONFIG_RT_3052_ESW" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
                if [ "$CONFIG_P5_RGMII_TO_MAC_MODE" = "y" ]; then
                    echo "##### restore RT3052 to dump switch #####"
                    config-vlan.sh 2 0
                    echo "##### config Vtss vlan partition #####"
                    config-vlan.sh 1 1
                else
                    if [ "$CONFIG_WAN_AT_P1" = "y" ]; then
                        echo '##### config RT3052 vlan partition (LWLLL) #####'
                        config-vlan.sh 2 LWLLL
                    elif [ "$CONFIG_WAN_AT_P0" = "y" ]; then
                        echo '##### config RT3052 vlan partition (WLLLL) #####'
                        config-vlan.sh 2 WLLLL
                    else
                        echo '##### config RT3052 vlan partition (LLLLW) #####'
                        config-vlan.sh 2 LLLLW
                    fi
                fi
            fi
            brctl addbr br0
            brctl setfd br0 1
            brctl addif br0 eth2.1
        fi

        # IC+ 100 PHY (one port only)
        if [ "$CONFIG_ICPLUS_PHY" = "y" ]; then
            echo '##### connected to one port 100 PHY #####'
            if [ "$CONFIG_RT2860V2_AP_MBSS" = "y" -a "$bssidnum" != "1" ]; then
                brctl addbr br0
                brctl setfd br0 1
            fi
        fi

    elif [ "$opmode" = "2" ]; then
        # 2. Station-Infrastructure mode:  OperationMode=2
        if [ "$CONFIG_RAETH_ROUTER" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
            echo "##### restore IC+ to dump switch #####"
            config-vlan.sh 0 0
        fi
        if [ "$CONFIG_MAC_TO_MAC_MODE" = "y" ]; then
            echo "##### restore Vtss to dump switch #####"
            config-vlan.sh 1 0
        fi
        if [ "$CONFIG_RT_3052_ESW" = "y" ]; then
            if [ "$CONFIG_P5_RGMII_TO_MAC_MODE" = "y" ]; then
                echo "##### restore RT3052 to dump switch #####"
                config-vlan.sh 2 0
                echo "##### restore Vtss to dump switch #####"
                config-vlan.sh 1 0
            else
                echo "##### restore RT3052 to dump switch #####"
                config-vlan.sh 2 0
            fi
        fi
        brctl addbr br0
        brctl setfd br0 1
        brctl addif br0 eth2

    elif [ "$opmode" = "3" ]; then
        WL_VLAN=`nvram_get 2860 WL_VLAN`
        # 6. Universal Repeater mode:  OperationMode=3
        if [ "$WL_VLAN" == "0" ]; then
            if [ "$CONFIG_RAETH_ROUTER" = "y" -o "$CONFIG_MAC_TO_MAC_MODE" = "y" -o "$CONFIG_RT_3052_ESW" = "y" ]; then
                #set VLAN: restore6855Esw(), only bind port5(ex-switch) and CPU port
				config-vlan.sh 3 0
                brctl addbr br0
                brctl setfd br0 1
                brctl addif br0 eth2
            fi
        else
            #set SSID with different VLAN interface
            #set VLAN: restore6855Esw(), only bind port5(ex-switch) and CPU port
			config-vlan.sh 3 0

            brctl addbr br0
            brctl setfd br0 1
            brctl addif br0 eth2.1
        fi

    else
        config-vlan.sh 2 0

        brctl addbr br0
        brctl setfd br0 1
        brctl addif br0 eth2
    fi
}

init_net()
{
    goahead &
    tr069_client &
    dray_fwup &
    telnetd
}

apmc_en=`nvram_get 2860 apmc_en`
if [ "$CONFIG_USER_APM_CLIENT" = "y" -a "$apmc_en" = "1" ]; then
    IF_BR0=`ifconfig br0 | grep "Link"`
    [ -z "$IF_BR0" ] && init_if

    IP_BR0=`ifconfig br0 | grep "inet addr" | sed 's/.*inet addr:\(.*\)  Bcast.*/\1/'`

    dhcpc_en=`nvram_get 2860 apmc_dhcpc_en`
    if [ "$dhcpc_en" != "0" ];then
        # Register-DHCP
        echo APM registering via DHCP ...
        [ "$IP_BR0" ] && OPT_r="-r $IP_BR0"

        ap_en=`nvram_get 2860 apmc_auto_provision_en`
        [ -z $ap_en ] && ap_en=1
        VENDORCLASS="AP810_$(ifconfig br0|grep HWaddr|awk '{print $5}'|sed 's/://g') $ap_en"
        udhcpc -V "$VENDORCLASS" -n -i $lan_if $OPT_r -s /sbin/udhcpc_apmc.sh -p /var/run/udhcpc_apmc.pid &

    else
        # Register-Static
        ip=$(nvram_get lan_ipaddr)
        nm=$(nvram_get lan_netmask)
        opmode=$(nvram_get 2860 OperationMode)
        if [ -z "$(ifconfig $lan_if | grep 'UP ')" ]; then
            ifconfig $lan_if $ip netmask $nm
            ifconfig $lan_if up
            sleep 3
        fi
        if [ "$opmode" = "2" -o "$opmode" = "3" ]; then   # (see internet.sh: ApCliSetWAN; udhcpc.sh)
            lan_route=$(ip route | grep "$ip" | awk '{print $1}')
            [ $lan_route ] && ip route del $lan_route 2>/dev/null
            eval $(ipcalc -n $ip $nm)
            route add -net $NETWORK netmask $nm dev br0 2>/dev/null
        fi
        if [ -z "`ps|grep [g]oahead`" ]; then
            init_net
        fi

        echo APM register static
        goahead apm_reg
    fi

else    # Bootup without APMC
    init_net
fi
