/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef __MT6575_CA9_POWER_H__
#define __MT6575_CA9_POWER_H__

typedef enum {
    SCU_IC_STANDBY_ON,
    SCU_IC_STANDBY_OFF,
    SCU_STANDBY_ON,
    SCU_STANDBY_OFF
} SCU_CONTROL;

typedef enum {
    SCU_CPU_PWR_NORMAL = 0x0,
    SCU_CPU_PWR_DORMANT = 0x2,
    SCU_CPU_PWR_OFF = 0x3
} SCU_CPU_PWR_STATE;

typedef enum {
    CA9_DYNA_CLK_GATING_DISALBE,
    CA9_DYNA_CLK_GATING_ENABLE
} CA9_CLK_GATING_CTRL;

typedef enum {
    L2C_DYNA_CLK_GATING_DISALBE = 0,
    L2C_STANDBY_DISABLE = 0,
    L2C_STANDBY_ENABLE = 1,
    L2C_DYNA_CLK_GATING_ENABLE = 2
} L2C_POWER_CTRL;

extern int scu_control(const SCU_CONTROL ctrl);
extern int scu_set_cpu_pwr_status(const SCU_CPU_PWR_STATE state);
extern int mt6575_ca9_power_ctrl(const CA9_CLK_GATING_CTRL ctrl);
extern int mt6575_l2c_power_ctrl(const L2C_POWER_CTRL ctrl);

#endif  /* !__MT6575_CA9_POWER_H__ */
