/**
 * FSM thread state functions declarations.
 *
 * File: spd_main_st.h
 *
 * @copyright
 * Copyright (c) 2002 - 2006 SFNT Finland Oy, all rights reserved.
 *
 */

#ifndef SPD_MAIN_ST_H
#define SPD_MAIN_ST_H

Boolean pm_get_next_ts_items(SshPm pm, SshPmRule rule);
SshUInt32 pm_get_next_engine_rule(SshPmRule rule);

void
ssh_pm_delete_rule_cb(SshPm pm, Boolean done,
                      SshUInt32 rule_index, SshUInt32 peer_handle,
                      SshUInt8 ipproto, SshUInt32 outbound_spi, 
		      SshUInt32 inbound_spi, void *context);
void ssh_pm_servers_stop_cb(void *context);
void
ssh_pm_add_rule_cb(SshPm pm, SshUInt32 ind,
		   const SshEnginePolicyRule rule,
		   void *context);

SSH_FSM_STEP(pm_cm_access_create_rule);
SSH_FSM_STEP(pm_cm_access_create_rule_done);
SSH_FSM_STEP(pm_cm_access_delete_rule);
SSH_FSM_STEP(pm_cm_access_done);
SSH_FSM_STEP(pm_cm_access_resolve_name);
SSH_FSM_STEP(pm_cm_access_start);
SSH_FSM_STEP(pm_ike_id_psk_lookup_finish);
SSH_FSM_STEP(pm_ike_id_psk_lookup_start);
SSH_FSM_STEP(pm_ike_sa_delete);
SSH_FSM_STEP(pm_ras_addrpool_alloc);
SSH_FSM_STEP(pm_ras_addrpool_alloc_done);
SSH_FSM_STEP(pm_rekey_ike_sa_start);
SSH_FSM_STEP(pm_rekey_ike_sa_update_ike_mapping);
SSH_FSM_STEP(pm_rekey_ike_sa_update_ipsec_sas);
SSH_FSM_STEP(pm_rekey_ike_sa_finish);
SSH_FSM_STEP(pm_ipsec_remote_access_attrs_allocate);
SSH_FSM_STEP(pm_ipsec_select_policy_rule);
SSH_FSM_STEP(pm_ipsec_set_authorization_groups);
SSH_FSM_STEP(pm_ipsec_set_authorization_groups_done);
SSH_FSM_STEP(pm_ipsec_xauth_wait);
SSH_FSM_STEP(pm_ipsec_spi_allocate);
SSH_FSM_STEP(pm_ipsec_spi_allocate_done);
SSH_FSM_STEP(pm_ipsec_spi_delete);
SSH_FSM_STEP(pm_ipsec_spi_delete_done);
SSH_FSM_STEP(pm_st_dns_iterate_done);
SSH_FSM_STEP(pm_st_dns_iterate_next);
SSH_FSM_STEP(pm_st_dns_qryupd_done);
SSH_FSM_STEP(pm_st_dns_qryupd_qry_start);
SSH_FSM_STEP(pm_st_dns_qryupd_upd_start);
SSH_FSM_STEP(pm_st_dns_query_end);
SSH_FSM_STEP(pm_st_dns_query_start);
SSH_FSM_STEP(pm_st_dns_update_done);
SSH_FSM_STEP(pm_st_dns_update_next);
SSH_FSM_STEP(pm_st_dns_update_start);
SSH_FSM_STEP(pm_st_dpd_i_n_failed);
SSH_FSM_STEP(pm_st_dpd_i_n_finish);
SSH_FSM_STEP(pm_st_dpd_i_n_select_p1);
SSH_FSM_STEP(pm_st_dpd_i_n_start);
SSH_FSM_STEP(pm_st_dpd_i_n_start_dpd);
SSH_FSM_STEP(pm_st_dpd_i_n_start_p1);
SSH_FSM_STEP(pm_st_dpd_i_n_success);
SSH_FSM_STEP(pm_st_dpd_i_n_wait_dpd);
SSH_FSM_STEP(pm_st_dpd_i_n_wait_p1);
SSH_FSM_STEP(ssh_ipm_http_st_audit);
SSH_FSM_STEP(ssh_ipm_http_st_done);
SSH_FSM_STEP(ssh_ipm_http_st_error);
SSH_FSM_STEP(ssh_ipm_http_st_error_not_found);
SSH_FSM_STEP(ssh_ipm_http_st_finish);
SSH_FSM_STEP(ssh_ipm_http_st_flows);
SSH_FSM_STEP(ssh_ipm_http_st_flows_detail);
SSH_FSM_STEP(ssh_ipm_http_st_flows_detail_stats);
SSH_FSM_STEP(ssh_ipm_http_st_flows_flow_index);
SSH_FSM_STEP(ssh_ipm_http_st_flows_flow_info);
SSH_FSM_STEP(ssh_ipm_http_st_global);
SSH_FSM_STEP(ssh_ipm_http_st_global_stats);
SSH_FSM_STEP(ssh_ipm_http_st_ike);
SSH_FSM_STEP(ssh_ipm_http_st_ike_cert);
SSH_FSM_STEP(ssh_ipm_http_st_index);
SSH_FSM_STEP(ssh_ipm_http_st_interfaces);
SSH_FSM_STEP(ssh_ipm_http_st_ipsec_sas_detail);
SSH_FSM_STEP(ssh_ipm_http_st_ipsec_sas_detail_flow_index);
SSH_FSM_STEP(ssh_ipm_http_st_ipsec_sas_detail_flow_info);
SSH_FSM_STEP(ssh_ipm_http_st_ipsec_sas_detail_rule_index);
SSH_FSM_STEP(ssh_ipm_http_st_ipsec_sas_detail_rule_info);
SSH_FSM_STEP(ssh_ipm_http_st_ipsec_sas_detail_tr_stats);
SSH_FSM_STEP(ssh_ipm_http_st_ipsec_sas_overall);
SSH_FSM_STEP(ssh_ipm_http_st_ipsec_sas_overall_tr_index);
SSH_FSM_STEP(ssh_ipm_http_st_ipsec_sas_overall_tr_info);
SSH_FSM_STEP(ssh_ipm_http_st_rules);
SSH_FSM_STEP(ssh_ipm_http_st_rules_detail);
SSH_FSM_STEP(ssh_ipm_http_st_rules_detail_stats);
SSH_FSM_STEP(ssh_ipm_http_st_rules_rule_index);
SSH_FSM_STEP(ssh_ipm_http_st_rules_rule_info);
SSH_FSM_STEP(ssh_ipm_http_st_toc);
SSH_FSM_STEP(ssh_ipm_http_st_trailer);
SSH_FSM_STEP(ssh_ipm_http_st_version);
SSH_FSM_STEP(ssh_ipm_http_st_version_global_stats);
SSH_FSM_STEP(ssh_ipm_st_config_bootstrap_commit);
SSH_FSM_STEP(ssh_ipm_st_config_bootstrap_rule);
SSH_FSM_STEP(ssh_ipm_st_config_done);
SSH_FSM_STEP(ssh_ipm_st_config_error);
SSH_FSM_STEP(ssh_ipm_st_config_parse);
SSH_FSM_STEP(ssh_ipm_st_config_parse_result);
SSH_FSM_STEP(ssh_ipm_st_config_parse_stream);
SSH_FSM_STEP(ssh_ipm_st_config_start);
SSH_FSM_STEP(ssh_ipm_st_create_result);
SSH_FSM_STEP(ssh_ipm_st_delete_sas);
SSH_FSM_STEP(ssh_ipm_st_toggle_tunnels);
SSH_FSM_STEP(ssh_ipm_st_reconfigure);
SSH_FSM_STEP(ssh_ipm_st_redo_flows);
SSH_FSM_STEP(ssh_ipm_st_run);
SSH_FSM_STEP(ssh_ipm_st_shutdown);
SSH_FSM_STEP(ssh_ipm_st_shutdown_complete);
SSH_FSM_STEP(ssh_ipm_st_shutdown_context);
SSH_FSM_STEP(ssh_ipm_st_start);

SSH_FSM_STEP(ssh_pm_st_appgw_connected);
SSH_FSM_STEP(ssh_pm_st_appgw_init_failed);
SSH_FSM_STEP(ssh_pm_st_appgw_mappings);
SSH_FSM_STEP(ssh_pm_st_appgw_mappings_done);
SSH_FSM_STEP(ssh_pm_st_appgw_open_port);
SSH_FSM_STEP(ssh_pm_st_appgw_open_port_abort);
SSH_FSM_STEP(ssh_pm_st_appgw_open_port_create_rule);
SSH_FSM_STEP(ssh_pm_st_appgw_open_port_create_rule_result);
SSH_FSM_STEP(ssh_pm_st_appgw_open_port_failed);
SSH_FSM_STEP(ssh_pm_st_appgw_open_port_finish);
SSH_FSM_STEP(ssh_pm_st_appgw_start);
SSH_FSM_STEP(ssh_pm_st_appgw_tcp);
SSH_FSM_STEP(ssh_pm_st_appgw_tcp_open_initiator_stream);
SSH_FSM_STEP(ssh_pm_st_appgw_tcp_responder_stream_done);
SSH_FSM_STEP(ssh_pm_st_appgw_terminate);
SSH_FSM_STEP(ssh_pm_st_appgw_udp);
SSH_FSM_STEP(ssh_pm_st_appgw_udp_process_packet);

SSH_FSM_STEP(ssh_pm_st_config_start);
SSH_FSM_STEP(ssh_pm_st_cr_done);
SSH_FSM_STEP(ssh_pm_st_cr_send_delete);
SSH_FSM_STEP(ssh_pm_st_cr_start);
SSH_FSM_STEP(ssh_pm_st_cr_start_p1);
SSH_FSM_STEP(ssh_pm_st_cr_wait_p1);
SSH_FSM_STEP(ssh_pm_st_ek_certs);
SSH_FSM_STEP(ssh_pm_st_ek_get_cert_result);
SSH_FSM_STEP(ssh_pm_st_ek_get_private_key_result);
SSH_FSM_STEP(ssh_pm_st_ek_key_done);
SSH_FSM_STEP(ssh_pm_st_ek_lookup_change);
SSH_FSM_STEP(ssh_pm_st_ek_private_key);
SSH_FSM_STEP(ssh_pm_st_ek_shutdown);
SSH_FSM_STEP(ssh_pm_st_ek_start);
SSH_FSM_STEP(ssh_pm_st_lns_session_add_arp_result);
SSH_FSM_STEP(ssh_pm_st_lns_session_add_rule_result);
SSH_FSM_STEP(ssh_pm_st_lns_session_alloc_attributes);
SSH_FSM_STEP(ssh_pm_st_lns_session_alloc_attributes_result);
SSH_FSM_STEP(ssh_pm_st_lns_session_established);
SSH_FSM_STEP(ssh_pm_st_lns_session_opened);
SSH_FSM_STEP(ssh_pm_st_lns_session_terminate);
SSH_FSM_STEP(ssh_pm_st_lns_session_terminate_delete_outbound_rule);
SSH_FSM_STEP(ssh_pm_st_lns_session_wait_ppp);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request_aborted);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request_accept);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request_add_control_rule);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request_add_l2tp_control_rule_result);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request_get_rule_result);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request_out_of_resources);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request_reject);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request_route_result);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request_terminate);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_request_transform_result);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_terminate);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_terminate_delete_control);
SSH_FSM_STEP(ssh_pm_st_lns_tunnel_terminate_delete_sa);
SSH_FSM_STEP(ssh_pm_st_qm_i_check_apply_rule);
SSH_FSM_STEP(ssh_pm_st_qm_i_check_apply_rule_result);
SSH_FSM_STEP(ssh_pm_st_main_auto_start);
SSH_FSM_STEP(ssh_pm_st_main_batch_start);
SSH_FSM_STEP(ssh_pm_st_main_batch_suspend_ike);
SSH_FSM_STEP(ssh_pm_st_main_batch);
SSH_FSM_STEP(ssh_pm_st_main_batch_abort);
SSH_FSM_STEP(ssh_pm_st_main_batch_abort_delete);
SSH_FSM_STEP(ssh_pm_st_main_batch_abort_delete_rule);
SSH_FSM_STEP(ssh_pm_st_main_batch_addition);
SSH_FSM_STEP(ssh_pm_st_main_batch_addition_result);
SSH_FSM_STEP(ssh_pm_st_main_batch_addition_enforcement);
SSH_FSM_STEP(ssh_pm_st_main_batch_addition_enforcement_result);
SSH_FSM_STEP(ssh_pm_st_main_batch_addition_create_ike_rule);
SSH_FSM_STEP(ssh_pm_st_main_batch_addition_add_ike_trigger);
SSH_FSM_STEP(ssh_pm_st_main_batch_addition_add_ike_trigger_result);
SSH_FSM_STEP(ssh_pm_st_main_batch_addition_create_ike_pass_rule);
SSH_FSM_STEP(ssh_pm_st_main_batch_addition_add_ike_pass_rule);
SSH_FSM_STEP(ssh_pm_st_main_batch_addition_add_ike_pass_rule_result);
SSH_FSM_STEP(ssh_pm_st_main_batch_additions);
SSH_FSM_STEP(ssh_pm_st_main_batch_deletions);
SSH_FSM_STEP(ssh_pm_st_main_batch_deletions_delete);
SSH_FSM_STEP(ssh_pm_st_main_batch_deletions_delete_rule);
SSH_FSM_STEP(ssh_pm_st_main_batch_sanity_check);
SSH_FSM_STEP(ssh_pm_st_main_batch_done_enable_policy_lookup);
SSH_FSM_STEP(ssh_pm_st_main_batch_done_resume);
SSH_FSM_STEP(ssh_pm_st_main_batch_done);
SSH_FSM_STEP(ssh_pm_st_main_iface_change);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_done);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_nat);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_pending_iface);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_rule);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_rule_add);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_rule_add_result);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_rule_delete);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_rule_done);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_rule_enforcement);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_rule_enforcement_result);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_rules);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_update_tunnels);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_servers);
SSH_FSM_STEP(ssh_pm_st_main_iface_change_servers_check_done);
SSH_FSM_STEP(ssh_pm_st_main_initialize);
SSH_FSM_STEP(ssh_pm_st_main_run);
SSH_FSM_STEP(ssh_pm_st_main_send_random_salt);
SSH_FSM_STEP(ssh_pm_st_main_shutdown);
SSH_FSM_STEP(pm_shutdown_abort_ike_negotiations);
SSH_FSM_STEP(pm_shutdown_wait_qm_termination);
SSH_FSM_STEP(pm_shutdown_appgws);
SSH_FSM_STEP(pm_shutdown_complete);
SSH_FSM_STEP(pm_shutdown_delete_sas);
SSH_FSM_STEP(pm_shutdown_disconnect_engine);
SSH_FSM_STEP(pm_shutdown_ike_servers);
SSH_FSM_STEP(pm_shutdown_l2tp);
SSH_FSM_STEP(pm_shutdown_l2tp_servers);
SSH_FSM_STEP(pm_shutdown_stop_cm);
SSH_FSM_STEP(pm_shutdown_wait_appgws);
SSH_FSM_STEP(pm_shutdown_wait_ek_thread);
SSH_FSM_STEP(pm_shutdown_wait_ike_shutdown);
SSH_FSM_STEP(pm_shutdown_wait_sub_threads);
SSH_FSM_STEP(ssh_pm_st_main_start);
SSH_FSM_STEP(ssh_pm_st_main_start_complete);
SSH_FSM_STEP(ssh_pm_st_main_start_get_virtual_adapters);
SSH_FSM_STEP(ssh_pm_st_main_start_get_virtual_adapters_result);
SSH_FSM_STEP(ssh_pm_st_main_start_default_rules);
SSH_FSM_STEP(ssh_pm_st_main_start_default_rules_add_result);
SSH_FSM_STEP(ssh_pm_st_main_start_dns_rules);
SSH_FSM_STEP(ssh_pm_st_main_start_dns_rules_add_result);
SSH_FSM_STEP(ssh_pm_st_main_start_default_ike_rules);
SSH_FSM_STEP(ssh_pm_st_main_start_default_ike_rules_add_result);
SSH_FSM_STEP(ssh_pm_st_main_start_unknown_ipsec_rules);
SSH_FSM_STEP(ssh_pm_st_main_start_unknown_ipsec_rules_add_result);
SSH_FSM_STEP(ssh_pm_st_main_start_wait_interfaces);
SSH_FSM_STEP(ssh_pm_st_p1_negotiation);
SSH_FSM_STEP(ssh_pm_st_p1_negotiation_check_cfgmode);
SSH_FSM_STEP(ssh_pm_st_p1_negotiation_tcp_encaps_check_natt);
SSH_FSM_STEP(ssh_pm_st_p1_negotiation_done);
SSH_FSM_STEP(ssh_pm_st_passwd_xauth_check_reply);
SSH_FSM_STEP(ssh_pm_st_passwd_xauth_do_set);
SSH_FSM_STEP(ssh_pm_st_passwd_xauth_error);
SSH_FSM_STEP(ssh_pm_st_passwd_xauth_finish);
SSH_FSM_STEP(ssh_pm_st_passwd_xauth_start);
SSH_FSM_STEP(ssh_pm_st_qm_i_add_rule_result);
SSH_FSM_STEP(ssh_pm_st_qm_i_auto_start);
SSH_FSM_STEP(ssh_pm_st_qm_i_failed);
SSH_FSM_STEP(ssh_pm_st_qm_i_make_sa_rule);
SSH_FSM_STEP(ssh_pm_st_qm_i_manual_sa_handler_result);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_alloc_ike_sa);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_check_initial_contact);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_do_info);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_do_qm);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_failed);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_find_ike_peer);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_create_ike_mapping);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_create_ike_mapping_result);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_restart_qm);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_prepare_qm);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_qm_result);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_route_result);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_sa_handler_result);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_select_p1);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_select_server);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_start);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_success);
SSH_FSM_STEP(ssh_pm_st_qm_i_n_wait_p1);
SSH_FSM_STEP(ssh_pm_st_qm_i_negotiation_done);
SSH_FSM_STEP(ssh_pm_st_qm_i_rekey);
SSH_FSM_STEP(ssh_pm_st_qm_i_reprocess_trigger);
SSH_FSM_STEP(ssh_pm_st_qm_i_sa_lookup_result);
SSH_FSM_STEP(ssh_pm_st_qm_i_start_negotiation);
SSH_FSM_STEP(ssh_pm_st_qm_i_success);
SSH_FSM_STEP(ssh_pm_st_qm_i_trigger);
SSH_FSM_STEP(ssh_pm_st_qm_terminate);
SSH_FSM_STEP(ssh_pm_st_raq_finish);
SSH_FSM_STEP(ssh_pm_st_raq_load_check_dfa_engine_status);
SSH_FSM_STEP(ssh_pm_st_raq_load_check_raq_file_status);
SSH_FSM_STEP(ssh_pm_st_raq_load_dfa_enumerate_next);
SSH_FSM_STEP(ssh_pm_st_raq_load_dfa_enumerate_start);
SSH_FSM_STEP(ssh_pm_st_raq_load_enumerate_loginfo_next);
SSH_FSM_STEP(ssh_pm_st_raq_load_enumerate_loginfo_start);
SSH_FSM_STEP(ssh_pm_st_raq_load_enumerate_rules_next);
SSH_FSM_STEP(ssh_pm_st_raq_load_enumerate_rules_start);
SSH_FSM_STEP(ssh_pm_st_raq_load_error);
SSH_FSM_STEP(ssh_pm_st_raq_load_flush_old_rules);
SSH_FSM_STEP(ssh_pm_st_raq_load_send_chunk_to_engine);
SSH_FSM_STEP(ssh_pm_st_raq_load_send_rule_to_engine);
SSH_FSM_STEP(ssh_pm_st_raq_load_start);
SSH_FSM_STEP(ssh_pm_st_raq_remove_begin_flush);
SSH_FSM_STEP(ssh_pm_st_raq_remove_flush_dfa);
SSH_FSM_STEP(ssh_pm_st_raq_remove_flush_rules);
SSH_FSM_STEP(ssh_pm_st_raq_remove_start);
SSH_FSM_STEP(ssh_pm_st_raq_unload_start);
SSH_FSM_STEP(ssh_pm_st_sa_handler_add_rule);
SSH_FSM_STEP(ssh_pm_st_sa_handler_add_rule_result);
SSH_FSM_STEP(ssh_pm_st_sa_handler_create_ike_apply_rule);
SSH_FSM_STEP(ssh_pm_st_sa_handler_add_ike_apply_rule);
SSH_FSM_STEP(ssh_pm_st_sa_handler_add_ike_apply_rule_result);
SSH_FSM_STEP(ssh_pm_st_sa_handler_next_ike_apply_rule);
SSH_FSM_STEP(ssh_pm_st_sa_handler_route);
SSH_FSM_STEP(ssh_pm_st_sa_handler_create_trd);
SSH_FSM_STEP(ssh_pm_st_sa_handler_create_trd_result);
SSH_FSM_STEP(ssh_pm_st_sa_handler_failed);
SSH_FSM_STEP(ssh_pm_st_sa_handler_check_v1_responder_rekey);
SSH_FSM_STEP(ssh_pm_st_sa_handler_check_v1_responder_rekey_result);
SSH_FSM_STEP(ssh_pm_st_sa_handler_rekey);
SSH_FSM_STEP(ssh_pm_st_sa_handler_rekey_result);
SSH_FSM_STEP(ssh_pm_st_sa_handler_rekey_outbound);
SSH_FSM_STEP(ssh_pm_st_sa_handler_start);
SSH_FSM_STEP(ssh_pm_st_sa_handler_register_outbound_spi);
SSH_FSM_STEP(ssh_pm_st_sa_handler_success);
SSH_FSM_STEP(ssh_pm_st_sa_handler_initiator_check_access_groups);
SSH_FSM_STEP(ssh_pm_st_sa_handler_initiator_set_access_groups);
SSH_FSM_STEP(ssh_pm_st_sa_handler_terminate);
SSH_FSM_STEP(ssh_pm_st_vip_start);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_result);
SSH_FSM_STEP(ssh_pm_st_vip_get_sgw_route);
SSH_FSM_STEP(ssh_pm_st_vip_get_sgw_route_result);
SSH_FSM_STEP(ssh_pm_st_vip_add_sgw_route);
SSH_FSM_STEP(ssh_pm_st_vip_add_sgw_route_result);
SSH_FSM_STEP(ssh_pm_st_vip_select_addresses);
SSH_FSM_STEP(ssh_pm_st_vip_configure_interface_up);
SSH_FSM_STEP(ssh_pm_st_vip_configure_interface_up_result);
SSH_FSM_STEP(ssh_pm_st_vip_wait_interface_up);
SSH_FSM_STEP(ssh_pm_st_vip_create_routes);
SSH_FSM_STEP(ssh_pm_st_vip_add_routes);
SSH_FSM_STEP(ssh_pm_st_vip_add_routes_result);
SSH_FSM_STEP(ssh_pm_st_vip_add_name_servers);
SSH_FSM_STEP(ssh_pm_st_vip_add_name_servers_result);
SSH_FSM_STEP(ssh_pm_st_vip_setup_tunnel);
SSH_FSM_STEP(ssh_pm_st_vip_setup_tunnel_result);
SSH_FSM_STEP(ssh_pm_st_vip_register);
SSH_FSM_STEP(ssh_pm_st_vip_up);
SSH_FSM_STEP(ssh_pm_st_vip_setup_failed);
SSH_FSM_STEP(ssh_pm_st_vip_established);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_session_result);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_name_servers);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_name_servers_result);
SSH_FSM_STEP(ssh_pm_st_vip_remove_routes);
SSH_FSM_STEP(ssh_pm_st_vip_remove_routes_result);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_configure_interface_down);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_configure_interface_down_result);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_wait_interface_down);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_sgw_route);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_sgw_route_result);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_wait_references);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_complete);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_cfgmode);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_cfgmode_done);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_cfgmode_failed);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_cfgmode_wait_cfgmode);
SSH_FSM_STEP(ssh_pm_st_vip_qm_failed);
SSH_FSM_STEP(ssh_pm_st_vip_qm_negotiation_done);
SSH_FSM_STEP(ssh_pm_st_vip_i_make_sa_rule);
SSH_FSM_STEP(ssh_pm_st_vip_qm_i_add_rule_result);
SSH_FSM_STEP(ssh_pm_st_vip_start_qm_negotiation);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_session_dhcp);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_l2tp);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_l2tp_failed);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_l2tp_failed_done);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_l2tp_next_peer);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_l2tp_query_authentication);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_l2tp_query_result);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_l2tp_route_result);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_l2tp_start);
SSH_FSM_STEP(ssh_pm_st_vip_get_attrs_l2tp_wait_lac);
SSH_FSM_STEP(ssh_pm_st_vip_l2tp_lac_close_session);
SSH_FSM_STEP(ssh_pm_st_vip_l2tp_lac_lookup_sa);
SSH_FSM_STEP(ssh_pm_st_vip_l2tp_lac_lookup_sa_result);
SSH_FSM_STEP(ssh_pm_st_vip_l2tp_lac_start);
SSH_FSM_STEP(ssh_pm_st_vip_l2tp_lac_start_ppp);
SSH_FSM_STEP(ssh_pm_st_vip_l2tp_lac_terminate);
SSH_FSM_STEP(ssh_pm_st_vip_l2tp_lac_wait_events);
SSH_FSM_STEP(ssh_pm_st_vip_l2tp_lac_wait_open);
SSH_FSM_STEP(ssh_pm_st_vip_setup_tunnel_l2tp);
SSH_FSM_STEP(ssh_pm_st_vip_setup_tunnel_l2tp_add_rule_result);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_session_l2tp);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_session_l2tp_finish);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_cleanup_l2tp);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_cleanup_l2tp_delete_sa_rule);
SSH_FSM_STEP(ssh_pm_st_vip_shutdown_cleanup_l2tp_finish);
SSH_FSM_STEP(pm_ras_attrs_alloc);
SSH_FSM_STEP(pm_ras_register_clients);
SSH_FSM_STEP(pm_ras_attrs_register_clients);
SSH_FSM_STEP(pm_ras_attrs_done);
SSH_FSM_STEP(ssh_pm_st_mobike_i_start);
SSH_FSM_STEP(ssh_pm_st_mobike_i_address_update);
SSH_FSM_STEP(ssh_pm_st_mobike_i_address_update_result);
SSH_FSM_STEP(ssh_pm_st_mobike_i_update_ike_sa);
SSH_FSM_STEP(ssh_pm_st_mobike_i_update_ipsec_sa);
SSH_FSM_STEP(ssh_pm_st_mobike_i_update_ipsec_sa_result);
SSH_FSM_STEP(ssh_pm_st_mobike_i_success);
SSH_FSM_STEP(ssh_pm_st_mobike_i_failed);
SSH_FSM_STEP(ssh_pm_st_mobike_r_start);
SSH_FSM_STEP(ssh_pm_st_mobike_r_update_ike_sa);
SSH_FSM_STEP(ssh_pm_st_mobike_r_check_rrc);
SSH_FSM_STEP(ssh_pm_st_mobike_r_get_ike_mapping);
SSH_FSM_STEP(ssh_pm_st_mobike_r_pre_rrc);
SSH_FSM_STEP(ssh_pm_st_mobike_r_pre_rrc_result);
SSH_FSM_STEP(ssh_pm_st_mobike_r_update_ipsec_sa);
SSH_FSM_STEP(ssh_pm_st_mobike_r_update_ipsec_sa_result);
SSH_FSM_STEP(ssh_pm_st_mobike_r_post_rrc);
SSH_FSM_STEP(ssh_pm_st_mobike_r_post_rrc_result);
SSH_FSM_STEP(ssh_pm_st_mobike_r_success);
SSH_FSM_STEP(ssh_pm_st_mobike_r_failed);
SSH_FSM_STEP(ssh_pm_st_mobike_r_route_remote);
SSH_FSM_STEP(ssh_pm_st_mobike_r_route_remote_result);
SSH_FSM_STEP(ssh_pm_st_ike_spd_select_ike_sa_start);
SSH_FSM_STEP(ssh_pm_st_ike_spd_select_ike_sa_get_ike_mapping);
SSH_FSM_STEP(ssh_pm_st_ike_spd_select_ike_sa);
SSH_FSM_STEP(ssh_pm_st_ike_spd_select_ipsec_sa_fetch_trd);
SSH_FSM_STEP(ssh_pm_st_ike_spd_select_ipsec_sa);
#endif /* not SPD_MAIN_ST_H */
