#include <common.h>
#include <command.h>
#include <malloc.h>
#include <devices.h>
#include <version.h>
#include <nand.h>
#include <asm/hardware.h>
#include <asm/arch/bsp.h>

typedef unsigned char       U8;
typedef unsigned short      U16;
typedef unsigned long       U32;
typedef unsigned long long  U64;

extern nand_info_t nand_info[];       /* info for NAND chips */

void nand_init (void);
int do_go (char *);
void SoC_APB_setup(void);
void SoC_AHB_setup(void);
void	SoC_ARAM_setup(void);
//void SoC_PLL_init(void);
void icache_enable (void);
void SoC_mem_init(u32 board_config);
extern void apply_ddr_setting(void);

int raise( int sig ) ;


void bsp_init(void)
{

#if (CONFIG_ROUTER || CONFIG_PACKET_IAD || CONFIG_FEROUTER)
	SoC_PLL_init();
#elif (CONFIG_C1KEVM || CONFIG_C1KMFCN_EVM || CONFIG_C1KM83240 || CONFIG_C1KASIC)
	SoC_PLL_init(CFG_CLK);
#else
#error "             Pass the board name to the make"
#error "             Ex:   $make router/packet-iad"
#endif

	SoC_APB_setup();
	SoC_AHB_setup();
	SoC_ARAM_setup();

	icache_enable();

	serial_init();

#ifdef CONFIG_ROUTER
	SoC_mem_init(5);
#elif  CONFIG_PACKET_IAD
	SoC_mem_init(4);
#elif CONFIG_FEROUTER
	SoC_mem_init(7);
#elif  (CONFIG_C1KEVM || CONFIG_C1KMFCN_EVM || CONFIG_C1KM83240 || CONFIG_C1KASIC)
	apply_ddr_setting();
#else
#error "             Pass the board name to the make"
#error "             Ex:   $make router_config/c1kevm_config"
#endif

#ifdef CONFIG_C1KM83240
	spi_hw_init();
#endif

#if (CONFIG_C1KEVM || CONFIG_C1KMFCN_EVM || CONFIG_C1KM83240 || CONFIG_C1KASIC)
        SoC_Partno_setup();
#endif

}
void relocate_nand_u_boot (void)
{
    nand_info_t *nand;
    ulong offset;
    ulong addr;		
    ulong cnt;

        nand_init();            /* go init the NAND */
	nand = &nand_info[nand_curr_device];
	offset = 0;
	cnt =  120 * nand->oobblock;
	addr = UBOOT_LOAD_ADDR;
        /* read */
        nand_read_options_t opts;
        memset(&opts, 0, sizeof(opts));
        opts.buffer     = (u_char*) addr;
        opts.length     = 120 * nand->oobblock;
        opts.offset     = 0;
        opts.quiet      = 1;
#if 1
	/* This skips the Bad blocks while reading data */
        nand_read_opts(nand, &opts);
#else
	nand_read(nand, offset, &cnt, (u_char *) addr);
#endif

	if( do_go((char *)addr))
		while(1){}
}
int do_go (char *start_addr)
{
        ulong   addr, rc;
        int     rcode = 0;
	int 	argc = 1;
        addr = UBOOT_LOAD_ADDR;
        rc = ((ulong (*)(int, char *[]))addr) (--argc, start_addr);
        if (rc != 0) rcode = 1;
        return rcode;
}

int raise( int sig ) 
{
  while(1) ;

  return 0 ;
}
