/* Chris, add start, 20091117, calculate crc32 */

#include <stdio.h>
#include <stdlib.h>
extern unsigned long crc32 (unsigned long crc, const char *buf, unsigned int len);

int main (int argc, char **argv)
{
	if (argc != 2)
	{
		printf("mkcrc32 <FILE>\n");
		return 0;
	}
	
	FILE * pFile;
	long lSize;
	char * buffer;
	size_t result;
	unsigned long crc;

	pFile = fopen ( argv[1] , "rb" );
	if (pFile==NULL)
	{
		printf("File error\n");
		exit (1);
	}

	// obtain file size:
	fseek (pFile , 0 , SEEK_END);
	lSize = ftell (pFile);
	rewind (pFile);

	// allocate memory to contain the whole file:
	buffer = (char*) malloc (sizeof(char)*lSize);
	if (buffer == NULL)
	{
		printf("Memory error\n");
		exit (2);
	}

	// copy the file into the buffer:
	result = fread (buffer,1,lSize,pFile);
	if (result != lSize)
	{
		printf("Reading error\n");
		exit (3);
	}

	/* the whole file is now loaded in the memory buffer. */
	fclose (pFile);
	
	crc = crc32 (0, (const unsigned char *) buffer, (unsigned long)lSize);
	free (buffer);
	printf("%08lx", crc);
	return 0;
}
/* Chris, add end, 20091117 */
