#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
###################################################################
# Packages configuration page
#
# Description:
#	Allows installation and removal of packages.
#
# Author(s) [in order of work date]:
#   OpenWrt developers (??)
#   todo: person who added descriptions..
#   Dmytro
#   eJunky
#   emag
#   Jeremy Collake <jeremy.collake@gmail.com>
#
# Major revisions:
#
# NVRAM variables referenced:
#   none
#
# Configuration files referenced:
#   none
#
# Utilities/applets referenced:
#   ipkg
#
#

header "System" "Packages" "<img src=\"/images/pkg.jpg\" alt />&nbsp;@TR<<system_ipkg_Packages#Packages>>" '' "$SCRIPT_NAME"

cat <<EOF
<script type="text/javascript">
function confirmT(action,pkg) {
if ( pkg == "uclibc" || pkg == "base-files" || pkg == "bridge" || pkg == "busybox" || pkg == "dnsmasq" || pkg == "dropbear" || pkg == "haserl" || pkg == "hotplug" || pkg == "iptables" || pkg == "kernel" || pkg == "mtd" || pkg == "wireless-tools" || pkg == "wlc") {
alert ("             <<< @TR<<big_warning|WARNING>> >>> \n\n@TR<<system_ipkg_Package|Package>> \"" + pkg + "\" @TR<<should not be removed>>!\n\n>>> @TR<<Removing may brick your router.>> <<<\n\n@TR<<System requires>> \"" + pkg + "\" @TR<<package to run.>>\n\n") ;
}
var actionStr = action=="install" ? "@TR<<system_ipkg_install|install>>" : 
	(action=="remove" ? "@TR<<system_ipkg_remove|remove>>" : action);
if (window.confirm("@TR<<Please Confirm>>!\n\n@TR<<Do you want to>> " + actionStr + " \"" + pkg + "\" @TR<<system_ipkg_package|package>>?")){
window.location="ipkg.sh?action=" + action + "&amp;pkg=" + pkg
} }
</script>
EOF

?>
<?
display_form <<EOF
start_form||||nohelp
EOF
?>
<?
display_form <<EOF
end_form
EOF
?>

<?
if [ "$FORM_action" = "update" ]; then
	echo "<pre>@TR<<system_ipkg_pleasewait#Please wait>> ...<br />"
	ipkg update
	echo "</pre>"
elif [ "$FORM_action" = "install" ]; then
	echo "<pre>@TR<<system_ipkg_pleasewait#Please wait>> ...<br />"
	install_package `echo "$FORM_pkg" | sed -e 's, ,+,g'`
	if [ "$?" != "0" ]; then
		ipkg update
		install_package `echo "$FORM_pkg" | sed -e 's, ,+,g'`
	fi
	echo "</pre>"
elif [ "$FORM_action" = "remove" ]; then
	echo "<pre>@TR<<system_ipkg_pleasewait#Please wait>> ...<br />"
	ipkg remove `echo "$FORM_pkg" | sed -e 's, ,+,g'`
	echo "</pre>"
fi
?>
	<h3>@TR<<system_ipkg_installedpackages#Installed Packages>></h3>
	<br />
	<table class="packages"><tr class="packages"><th width="150">@TR<<system_ipkg_th_action#Action>></th><th width="200">@TR<<system_ipkg_th_package#Package>></th><th width=150>@TR<<system_ipkg_th_version#Version>></th><th>@TR<<system_ipkg_th_desc#Description>></th></tr>
<?
ipkg list_installed | awk -F ' ' '
($2 !~ /terminated/) && ($1 !~ /Done./) {
	link=$1
	gsub(/\+/,"%2B",link)
	gsub(/^ */,"",link)
	gsub(/ *$/,"",link)
	version=$3
	desc=$5
	for (i=6; i <= NF; i++)
			desc = desc " " $i
	gsub(/&/, "\\&amp;", desc)
	gsub(/</, "\\&lt;", desc)
	gsub(/>/, "\\&gt;", desc)
	print "<tr class=\"packages\"><td><a href=\"javascript:confirmT('\''remove'\'','\''" link "'\'')\">@TR<<system_ipkg_Uninstall#Uninstall>></a></td><td>" $1 "</td><td>" version "</td><td>" desc "</td></tr>"
}
'
?>
	</table>
<?

footer ?>
<!--
##WEBIF:name:1System:300:Packages
-->
