#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
###################################################################
# Wireless configuration
#

###################################################################
# Parse Settings, this function is called when doing a config_load
config_cb() {
config_get TYPE "$CONFIG_SECTION" TYPE
case "$TYPE" in
        wifi-device)
                append DEVICES "$CONFIG_SECTION"
        ;;
        wifi-iface)
                append vface "$CONFIG_SECTION" "$N"
        ;;
        interface)
	        append network_devices "$CONFIG_SECTION"
        ;;
esac
}
uci_load network
#NETWORK_DEVICES="none $network_devices"
NETWORK_DEVICES="none"
uci_load webif
uci_load wireless

#####################################################################
# This is looped for every physical wireless card (wifi-device)
#
config_get card general card
config_get type general type
DEVICES=$type
if [ "$card" = "1" ] ; then
for device in $DEVICES; do
	if empty "$FORM_submit"; then
	bridged=`uci get bridge.general.wifi`
		config_get iftype "$device" type
		config_get country $device country
	  config_get FORM_mode_ap $device mode
	  config_get FORM_channel $device channel
	  config_get FORM_rate $device rate
	  config_get FORM_disabled $device disabled
	  config_get FORM_channel_width $device channel_width
	  config_get FORM_channel_ext $device channel_ext
	  config_get FORM_band $device band
	  config_get FORM_ipaddr $device ipaddr
	  config_get FORM_netmask $device netmask
	  config_get FORM_wmm_enable $device wmm
	  config_get FORM_ssid $device ssid
	  config_get FORM_hidden $device hidden
	  config_get FORM_auth $device auth
	  config_get FORM_encryption $device encryption
	  case "$FORM_auth" in
	  open) config_get FORM_encryption_open $device encryption ;;
	  shared) config_get FORM_encryption_shared $device encryption ;;
	  wpapsk|wpa2psk) config_get FORM_encryption_wpa $device encryption ;;
	  esac
#	  case "$FORM_auth" in
#	  open|shared) config_get FORM_encryption $device encryption_open ;;
#	  wpa|wpa2|wpapsk|wpa2psk) config_get FORM_encryption $device encryption_wpa ;;
#	  esac
		config_get FORM_key $device key
		case "$FORM_key" in
			1|2|3|4) FORM_wep_key="$FORM_key"
					FORM_key="";;
		esac
		config_get FORM_key1 $device key1
		config_get FORM_key2 $device key2
		config_get FORM_key3 $device key3
		config_get FORM_key4 $device key4
		config_get FORM_server $device server
		config_get FORM_radius_port $device port

	else
	bridged=`uci get bridge.general.wifi`
		config_get country $device country
		config_get iftype "$device" type
		eval FORM_mode_ap="\$FORM_mode_ap_$device"
		eval FORM_ssid="\$FORM_ssid_$device"
		case "$FORM_mode_ap" in
			11a) eval FORM_channel="\$FORM_achannel_$device";;
			*)eval FORM_channel="\$FORM_bgchannel_$device";;
		esac
		case "$FORM_mode_ap" in
			11b) eval FORM_rate="\$FORM_brateform_$device";;
			11g) eval FORM_rate="\$FORM_grateform_$device";;
			11bg) eval FORM_rate="\$FORM_grateform_$device";;
			11n) eval FORM_rate="\$FORM_nrateform_$device";;
			11bgn) eval FORM_rate="\$FORM_bgnrateform_$device";;
		esac
		eval FORM_hidden="\$FORM_hidden_$device"
		eval FORM_disabled="\$FORM_disabled_$device"
		eval FORM_channel_width="\$FORM_channel_width_$device"
		eval FORM_channel_ext="\$FORM_channel_ext_$device"
		eval FORM_band="\$FORM_band_$device"
		eval FORM_ipaddr="\$FORM_ipaddr_$device"
		eval FORM_netmask="\$FORM_netmask_$device"
		eval FORM_wmm="\$FORM_wmm_$device"
		eval FORM_auth="\$FORM_auth_$device"
#		case "$FORM_auth" in
#		open) FORM_encryption_open="FORM_encryption"
#		eval FORM_encryption_open="\$FORM_encryption_open_$device" ;;
#		shared) eval FORM_encryption="\$FORM_encryption_shared_$device" ;;
#		wpa|wpa2|wpapsk|wpa2psk) eval FORM_encryption="\$FORM_encryption_wpa_$device" ;;
#		esac
#		eval FORM_key="\$FORM_radius_key_$device"
		eval FORM_encryption_open="\$FORM_encryption_open_$device" 
		eval FORM_encryption_shared="\$FORM_encryption_shared_$device" 
		eval FORM_encryption_wpa="\$FORM_encryption_wpa_$device" 
		case "$FORM_encryption" in
		  wpapsk|wpa2psk) eval FORM_key="\$FORM_wpa_psk_$device";;
		  wpa|wpa2) eval FORM_key="\$FORM_radius_key_$device";;
		esac
		eval FORM_server="\$FORM_server_$device"
		eval FORM_radius_ipaddr="\$FORM_radius_ipaddr_$device"
		eval FORM_radius_port="\$FORM_radius_port_$device"
		eval FORM_wep_key="\$FORM_wep_key_$device"
		eval FORM_key1="\$FORM_key1_$device"
		eval FORM_key2="\$FORM_key2_$device"
		eval FORM_key3="\$FORM_key3_$device"
		eval FORM_key4="\$FORM_key4_$device"
	fi
	
        append forms "start_form|@TR<<Wireless Adapter>> $device @TR<< Configuration>>" "$N"
	if [ "$iftype" = "atheros" ]; then
        	append forms "helpitem|Atheros Wireless Configuration" "$N"
		append forms "helptext|Helptext Atheros Wireless Configuration#The router can be configured to handle multiple virtual interfaces which can be set to different modes and encryptions. Limitations are 1x sta, 0-4x ap or 1-4x ap or 1x adhoc" "$N"
	elif [ "$iftype" = "rt2860" ]; then
        	append forms "helpitem|Ralink Wireless 2860 Configuration" "$N"
		append forms "helptext|Helptext Ralink Wireless Configuration#The router can be configured to handle multiple virtual interfaces which can be set to different modes and encryptions." "$N"
	elif [ "$iftype" = "rt2870" ]; then
        	append forms "helpitem|Ralink Wireless 2870 Configuration" "$N"
		append forms "helptext|Helptext Ralink Wireless Configuration#The router can be configured to handle multiple virtual interfaces which can be set to different modes and encryptions." "$N"
	elif [ "$iftype" = "rt2880" ]; then
        	append forms "helpitem|Ralink Wireless 2880 Configuration" "$N"
		append forms "helptext|Helptext Ralink Wireless Configuration#The router can be configured to handle multiple virtual interfaces which can be set to different modes and encryptions." "$N"
	elif [ "$iftype" = "metalink" ]; then
        	append forms "helpitem|Metalink Wireless Configuration" "$N"
		append forms "helptext|Helptext Metalink Wireless Configuration#The router can be configured to handle multiple virtual interfaces which can be set to different modes and encryptions." "$N"
	elif [ "$iftype" = "atherosmb81" ]; then
        	append forms "helpitem|Atheros MB81 Wireless Configuration" "$N"
		append forms "helptext|Helptext Atheros MB81 Wireless Configuration#The router can be configured to handle multiple virtual interfaces which can be set to different modes and encryptions." "$N"
	fi
	
        mode_disabled="field|@TR<<Radio>>
		select|disabled_$device|$FORM_disabled
		option|1|@TR<<Off>>
        	option|0|@TR<<On>>"
        append forms "$mode_disabled" "$N"
        	
        if [ "$iftype" = "atheros" ]; then
        	mode_fields="field|@TR<<Mode>>
			select|mode_ap_$device|$FORM_mode_ap"
#		echo "$dmesg_txt" |grep -q "${device}: 11g"
#		if [ "$?" = "0" ]; then
			mode_fields="$mode_fields
				option|11bg|@TR<<B + G>>
				option|11g|@TR<<G Only>>"
#		fi
#		echo "$dmesg_txt" |grep -q "${device}: 11b"
#		if [ "$?" = "0" ]; then
			mode_fields="$mode_fields
				option|11b|@TR<<B Only>>"
#		fi
#		echo "$dmesg_txt" |grep -q "${device}: 11a"
#		if [ "$?" = "0" ]; then
#			mode_fields="$mode_fields
#				option|11a|@TR<<A Only>>"
#		fi
        append forms "$mode_fields" "$N"
        fi
        	
        if [ "$iftype" = "rt2860" ]; then
        	mode_fields="field|@TR<<Mode>>
			select|mode_ap_$device|$FORM_mode_ap"
			mode_fields="$mode_fields
				option|11bg|@TR<<B + G>>
				option|11n|@TR<<N Only>>
				option|11b|@TR<<B Only>>
				option|11g|@TR<<G Only>>
				option|11bgn|@TR<<B + G + N>>
				option|11a|@TR<<A>>
				option|11an|@TR<<A + N>>"
        append forms "$mode_fields" "$N"
        fi
        
        if [ "$iftype" = "rt2870" ]; then
        	mode_fields="field|@TR<<Mode>>
			select|mode_ap_$device|$FORM_mode_ap"
			mode_fields="$mode_fields
				option|11bg|@TR<<B + G>>
				option|11n|@TR<<N Only>>
				option|11b|@TR<<B Only>>
				option|11g|@TR<<G Only>>
				option|11bgn|@TR<<B + G + N>>
				option|11a|@TR<<A>>
				option|11an|@TR<<A + N>>"
        append forms "$mode_fields" "$N"
        fi
        
        if [ "$iftype" = "rt2880" ]; then
        	mode_fields="field|@TR<<Mode>>
			select|mode_ap_$device|$FORM_mode_ap"
			mode_fields="$mode_fields
				option|11bg|@TR<<B + G>>
				option|11n|@TR<<N Only>>
				option|11b|@TR<<B Only>>
				option|11g|@TR<<G Only>>
				option|11bgn|@TR<<B + G + N>>
				option|11a|@TR<<A>>
				option|11an|@TR<<A + N>>"
        append forms "$mode_fields" "$N"
        fi
        
        if [ "$iftype" = "metalink" ]; then
        	mode_fields="field|@TR<<Mode>>
			select|mode_ap_$device|$FORM_mode_ap"
			mode_fields="$mode_fields
				option|11bg|@TR<<B + G>>
				option|11n|@TR<<N Only>>
				option|11b|@TR<<B Only>>
				option|11g|@TR<<G Only>>
				option|11bgn|@TR<<B + G + N>>"
        append forms "$mode_fields" "$N"
        fi
        
        if [ "$iftype" = "atherosmb81" ]; then
        	mode_fields="field|@TR<<Mode>>
			select|mode_ap_$device|$FORM_mode_ap"
			mode_fields="$mode_fields
				option|11bg|@TR<<B + G>>
				option|11n|@TR<<N Only>>
				option|11b|@TR<<B Only>>
				option|11g|@TR<<G Only>>
				option|11bgn|@TR<<B + G + N>>
				option|11a|@TR<<A>>
				option|11an|@TR<<A + N>>"
        append forms "$mode_fields" "$N"
        fi
        
        # Initialize channels based on country code
        # (--- hardly a switch here ---)
        case "$country" in
                All|all|ALL) 
                	    BGCHANNELS="1 2 3 4 5 6 7 8 9 10 11 12 13 14"; CHANNEL_MAX=14
                	    ACHANNELS="36 40 42 44 48 50 52 56 58 60 64 149 152 153 157 160 161 156";;
                *) 
                   BGCHANNELS="1 2 3 4 5 6 7 8 9 10 11"; CHANNEL_MAX=11
                   ACHANNELS="36 40 42 44 48 50 52 56 58 60 64 149 152 153 157 160 161 156";;
        esac
        
        BG_CHANNELS="field|@TR<<Channel>>|bgchannelform_$device|hidden
                select|bgchannel_$device|$FORM_channel
                option|0|@TR<<Auto>>"
        for ch in $BGCHANNELS; do
                BG_CHANNELS="$BG_CHANNELS
                        option|$ch"
        done
        
        A_CHANNELS="field|@TR<<Channel>>|achannelform_$device|hidden
                select|achannel_$device|$FORM_channel
                option|0|@TR<<Auto>>"
        for ch in $ACHANNELS; do
                A_CHANNELS="$A_CHANNELS
                        option|$ch"
        done
	append forms "$BG_CHANNELS" "$N"
	append forms "$A_CHANNELS" "$N"
		
	channel_width="field|@TR<<Channel Width>>|channel_width_$device|hidden
			select|channel_width_$device|$FORM_channel_width
			option|20|20
			option|40|40"
	append forms "$channel_width" "$N"

	channel_ext="field|@TR<<Channel Ext>>|channel_ext_$device|hidden
			select|channel_ext_$device|$FORM_channel_ext
			option|0|below
			option|1|above"
	append forms "$channel_ext" "$N"

	band="field|@TR<<Band>>|band_$device|hidden
			select|band_$device|$FORM_band
			option|2.4|2.4
			option|5.2|5.2"
	append forms "$band" "$N"
	
	BRATE="Auto 1 2 5.5 11"
	GRATE="Auto 1 2 5.5 6 9 11 12 18 24 36 48 54"
	NRATE="Auto MCS0 MCS1 MCS2 MCS3 MCS4 MCS5 MCS6 MCS7 MCS8 MCS9 MCS10 MCS11 MCS12 MCS13 MCS14 MCS15"
	BGNRATE="Auto 1 2 5.5 6 9 11 12 18 24 36 48 54 MCS0 MCS1 MCS2 MCS3 MCS4 MCS5 MCS6 MCS7 MCS8 MCS9 MCS10 MCS11 MCS12 MCS13 MCS14 MCS15"
	
	B_RATE="field|@TR<<Rate>>|brateform_$device|hidden
		select|brateform_$device|$FORM_rate"
	for rate in $BRATE; do
		B_RATE="$B_RATE
			option|$rate"
	done
	
	G_RATE="field|@TR<<Rate>>|grateform_$device|hidden
		select|grateform_$device|$FORM_rate"
	for rate in $GRATE; do
		G_RATE="$G_RATE
			option|$rate"
	done
	
	N_RATE="field|@TR<<Rate>>|nrateform_$device|hidden
		select|nrateform_$device|$FORM_rate"
	for rate in $NRATE; do
		N_RATE="$N_RATE
			option|$rate"
	done
	
	BGN_RATE="field|@TR<<Rate>>|bgnrateform_$device|hidden
		select|bgnrateform_$device|$FORM_rate"
	for rate in $BGNRATE; do
		BGN_RATE="$BGN_RATE
			option|$rate"
	done
	
	append forms "$B_RATE" "$N"
	append forms "$G_RATE" "$N"
	append forms "$N_RATE" "$N"
	append forms "$BGN_RATE" "$N"

        wmm_enable="field|@TR<<WMM>>|wmm_enable_$device|hidden
		select|wmm_enable_$device|$FORM_wmm_enable
		option|1|@TR<<On>>
        	option|0|@TR<<Off>>"
        wmm_help="helpitem|WMM (Wireless Multi Media)
        	helptext|WMM enables DSCP and VLAN tag based QoS."
        append forms "$wmm_enable" "$N"
	if [ "$iftype" = "rt2860" ]; then
	        append forms "$wmm_help" "$N"
	elif [ "$iftype" = "rt2870" ]; then
		append forms "$wmm_help" "$N"
	elif [ "$iftype" = "rt2880" ]; then
		append forms "$wmm_help" "$N"
	fi

	ssid="field|@TR<<ESSID>>|ssid_form_$device
		text|ssid_$device|$FORM_ssid"
	append forms "$ssid" "$N"
	
	hidden="field|@TR<<ESSID Broadcast>>|hidden_$device
		select|hidden_$device|$FORM_hidden
		option|0|@TR<<Show>>
		option|1|@TR<<Hide>>"
	append forms "$hidden" "$N"

#      encryption_forms="field|@TR<<Encryption Type>>
#        select|encryption_$device|$FORM_encryption
#        option|none|@TR<<Disabled>>
#        option|wep|WEP
#        option|psk|WPA (@TR<<PSK>>)
#        option|psk2|WPA2 (@TR<<PSK>>)
#        option|wpa|WPA (RADIUS)
#        option|wpa2|WPA2 (RADIUS)"
#      append forms "$encryption_forms" "$N"

      auth_forms="field|@TR<<Authentication Type>>
        select|auth_$device|$FORM_auth
        option|open|@TR<<Open>>
        option|shared|@TR<<Shared>>
        option|wpapsk|@TR<<WPA-PSK>>
        option|wpa2psk|@TR<<WPA2-PSK>>"
      append forms "$auth_forms" "$N"
      encryption_open_forms="field|@TR<<Encryption Type>>|encryption_open|hidden
        select|encryption_open_$device|$FORM_encryption_open
        option|none|@TR<<NONE>>
        option|wep|@TR<<WEP>>"
      append forms "$encryption_open_forms" "$N"
      encryption_shared_forms="field|@TR<<Encryption Type>>|encryption_shared|hidden
        select|encryption_shared_$device|$FORM_encryption_shared
        option|wep|@TR<<WEP>>"
      append forms "$encryption_shared_forms" "$N"
      encryption_wpa_forms="field|@TR<<Encryption Type>>|encryption_wpa|hidden
        select|encryption_wpa_$device|$FORM_encryption_wpa
        option|tkip|@TR<<TKIP>>
        option|aes|@TR<<AES>>"
      append forms "$encryption_wpa_forms" "$N"

#      wpa="field|WPA @TR<<PSK>>|wpapsk_$device|hidden
#        password|wpa_psk_$device|$FORM_key
#        field|@TR<<RADIUS IP Address>>|radius_ip_$device|hidden
#        text|server_$device|$FORM_server
#        field|@TR<<RADIUS Port>>|radius_port_form_$device|hidden
#        text|radius_port_$device|$FORM_radius_port
#        field|@TR<<RADIUS Server Key>>|radiuskey_$device|hidden
#        text|radius_key_$device|$FORM_key"
#      append forms "$wpa" "$N"

      wpa="field|Passphrase|wpapsk_$device|hidden
        text|wpa_psk_$device|$FORM_key
        field|@TR<<RADIUS IP Address>>|radius_ip_$device|hidden
        text|server_$device|$FORM_server
        field|@TR<<RADIUS Port>>|radius_port_form_$device|hidden
        text|radius_port_$device|$FORM_radius_port
        field|@TR<<RADIUS Server Key>>|radiuskey_$device|hidden
        text|radius_key_$device|$FORM_key"
      append forms "$wpa" "$N"

      wep="field|@TR<<Passphrase>>|wep_keyphrase_$device|hidden
        text|wep_passphrase_$device|$FORM_wep_passphrase
        string|<br />
        field|&nbsp;|wep_generate_keys_$device|hidden
        submit|generate_wep_40_$device|@TR<<Generate 40bit Keys>>
        submit|generate_wep_128_$device|@TR<<Generate 128bit Key>>
        string|<br />
        field|@TR<<WEP Key 1>>|wep_key_1_$device|hidden
        radio|wep_key_$device|$FORM_wep_key|1
        text|key1_$device|$FORM_key1|<br />
        field|@TR<<WEP Key 2>>|wep_key_2_$device|hidden
        radio|wep_key_$device|$FORM_wep_key|2
        text|key2_$device|$FORM_key2|<br />
        field|@TR<<WEP Key 3>>|wep_key_3_$device|hidden
        radio|wep_key_$device|$FORM_wep_key|3
        text|key3_$device|$FORM_key3|<br />
        field|@TR<<WEP Key 4>>|wep_key_4_$device|hidden
        radio|wep_key_$device|$FORM_wep_key|4
        text|key4_$device|$FORM_key4|<br />"
      append forms "$wep" "$N"
      
		append forms "helpitem|Encryption Type" "$N"
		append forms "helptext|HelpText Encryption Type#WEP key should be alpha-numeric and should not end with "0" and it should be either 10 or 26 characters or you can type something in WEP PASS and generate it through GUI." "$N"
		append forms "helptext|HelpText Encryption Type#WPA-PSK key should be alpha-numeric and minimum 8 to maximum 64 characters." "$N"
		append forms "helptext|HelpText Encryption Type#WPA-RADIUS key should be alpha-numeric and minimum 4 to maximum 63 characters." "$N"


        append forms "end_form" "$N"
        append forms "start_form" "$N"

	config_get Temp_ipaddr $type ipaddr
	ipaddr="field|@TR<<IP Address>>|ipaddr_form_$device
		#text|ipaddr_$device|$FORM_ipaddr
		text|ipaddr_$device|$Temp_ipaddr
		helpitem|IP Address
		helptext|IP address for wireless interface is assigned here, provided it is not bridged with LAN. If it is bridged with LAN, this configuration will be disabled."
	append forms "$ipaddr" "$N"

	config_get Temp_netmask $type netmask
	netmask="field|@TR<<Netmask>>|netmask_form_$device
		#text|netmask_$device|$FORM_netmask
		text|netmask_$device|$Temp_netmask"
	append forms "$netmask" "$N"

	append forms "field||spacer" "$N"
	append forms "string|<br>" "$N"
	append forms "string|<br>" "$N"
	append forms "string|<a class=\"addnew_ico\" href=\"network-wlan-advance.sh\"><span class=\"add\">Advanced</span></a>" "$N"

        append forms "end_form" "$N"
        append forms "submit|save|@TR<<Save>>" "$N"

	###################################################################
	# set JavaScript
	javascript_forms="
		v = isset('encryption_$device','wep');
		set_visible('wep_key_1_$device', v);
		set_visible('wep_key_2_$device', v);
		set_visible('wep_key_3_$device', v);
		set_visible('wep_key_4_$device', v);
		set_visible('wep_keyphrase_$device', v);
		set_visible('wep_keys_$device', v);
		set_visible('wep_generate_keys_$device', v);
		v = isset('auth_$device','open');
		set_visible('encryption_open', v);
		set_visible('encryption_open_$device', v);
		v = isset('auth_$device','shared');
		set_visible('encryption_shared', v);
		set_visible('encryption_shared_$device', v);
		v = (isset('auth_$device','wpapsk') || isset('auth_$device','wpa2psk'));
		set_visible('encryption_wpa', v);
		set_visible('encryption_wpa_$device', v);
		v = ((isset('auth_$device','open') && isset('encryption_open_$device','wep')) || (isset('auth_$device','shared') && isset('encryption_shared_$device','wep')));
		set_visible('wep_key_1_$device', v);
		set_visible('wep_key_2_$device', v);
		set_visible('wep_key_3_$device', v);
		set_visible('wep_key_4_$device', v);
		set_visible('wep_keyphrase_$device', v);
		set_visible('wep_keys_$device', v);
		set_visible('wep_generate_keys_$device', v);
		//
		// force encryption listbox to no selection if user tries
		// to set WPA (PSK) with Ad-hoc mode.
		//
		if (isset('mode_$device','adhoc'))
		{
			if (isset('encryption_$device','psk'))
			{
				document.getElementById('encryption_$device').value = 'off';
			}
		}
		//
		// force encryption listbox to no selection if user tries
		// to set WPA (Radius) with anything but AP mode.
		//
		if (!isset('mode_$device','ap'))
		{
			if (isset('encryption_$device','wpa') || isset('encryption_$device','wpa2'))
			{
				document.getElementById('encryption_$device').value = 'off';
			}
		}
		v = (isset('mode_ap_$device','11b') || isset('mode_ap_$device','11bg') || isset('mode_ap_$device','11g') || isset('mode_ap_$device','11n') || isset('mode_ap_$device','11bgn'));
		set_visible('bgchannelform_$device', v);
		v = (isset('mode_ap_$device','11a') || isset('mode_ap_$device','11an'));
		set_visible('achannelform_$device', v);
		v = (isset('mode_ap_$device','11b'));
		set_visible('brateform_$device', v);
		v = (isset('mode_ap_$device','11g') || isset('mode_ap_$device','11bg') || isset('mode_ap_$device','11a'));
		set_visible('grateform_$device', v);
		v = (isset('mode_ap_$device','11n'));
		set_visible('nrateform_$device', v);
		v = (isset('mode_ap_$device','11bgn') || isset('mode_ap_$device','11an'));
		set_visible('bgnrateform_$device', v);
		v = (!isset('mode_$device','wds'));
		set_visible('ssid_form_$device', v);
		set_visible('hidden_$device', v);
		v = (isset('encryption_wpa_$device','wpapsk') || isset('encryption_wpa_$device','wpa2psk'));
		set_visible('wpapsk_$device', v);
		v = (!isset('auth_$device','open') && !isset('auth_$device','shared') && !isset('auth_$device','wpa') && !isset('auth_$device','wpa2') && (isset('encryption_wpa_$device','tkip') || isset('encryption_wpa_$device','aes')));
		set_visible('wpapsk_$device', v);
		v = (('$iftype'=='atheros') && (!isset('mode_$device','sta')) && (isset('encryption_$device','psk') || isset('encryption_$device','psk2') || isset('encryption_$device','wpa') || isset('encryption_$device','wpa2')));
		set_visible('install_hostapd_$device', v);
		v = (('$iftype'=='atheros') && (isset('mode_$device','sta')) && (isset('encryption_$device','psk') || isset('encryption_$device','psk2') || isset('encryption_$device','wpa') || isset('encryption_$device','wpa2')));
		set_visible('install_wpa_supplicant_$device', v);
		v = (isset('auth_$device','wpa') || isset('auth_$device','wpa2'));
		set_visible('radiuskey_$device', v);
		set_visible('radius_ip_$device', v);
		set_visible('radius_port_form_$device', v);
		v = (('$iftype'=='rt2860') || ('$iftype'=='rt2870') || ('$iftype'=='rt2880') || ('$iftype'=='metalink') || ('$iftype'=='atherosmb81'));
		set_visible('channel_width_$device', v);
		set_visible('channel_ext_$device', v);
		v = ('$iftype'=='metalink');
		set_visible('band_$device', v);
		v = (('$iftype'=='rt2860') || ('$iftype'=='rt2870') || ('$iftype'=='rt2880'));
		set_visible('wmm_enable_$device', v);
		
		if('$bridged' == '1')
		{
		document.getElementById('ipaddr_$device').disabled = true;
		document.getElementById('netmask_$device').disabled = true;
		}
		"
	append js "$javascript_forms" "$N"
			
	###################################################################
	# set validate forms
	case "$FORM_encryption" in
		wpapsk|wpa2psk) append validate_forms "wpapsk|FORM_wpa_psk_$device|@TR<<WPA PSK#WPA Pre-Shared Key>>|required|$FORM_key" "$N";;
		wpa|wpa2) append validate_forms "string|FORM_radius_key_$device|@TR<<RADIUS Server Key>>|min=4 max=63 required|$FORM_key" "$N"
			append validate_forms "ip|FORM_server_$device|@TR<<RADIUS IP Address>>|required|$FORM_server" "$N"
			append validate_forms "port|FORM_radius_port_$device|@TR<<RADIUS Port>>|required|$FORM_radius_port" "$N";;
		wep)
			append validate_forms "int|FORM_wep_key_$device|@TR<<Selected WEP Key>>|min=1 max=4|$FORM_wep_key" "$N"
			append validate_forms "wep|FORM_key1_$device|@TR<<WEP Key>> 1||$FORM_key1" "$N"
			append validate_forms "wep|FORM_key2_$device|@TR<<WEP Key>> 2||$FORM_key2" "$N"
			append validate_forms "wep|FORM_key3_$device|@TR<<WEP Key>> 3||$FORM_key3" "$N"
			append validate_forms "wep|FORM_key4_$device|@TR<<WEP Key>> 4||$FORM_key4" "$N";;
	esac
	append validate_forms "name|FORM_ssid_$device|@TR<<ESSID>>|required|$FORM_ssid" "$N"
	append validate_forms "int|FORM_distance_$device|@TR<<Wireless Distance>>||$FORM_distance" "$N"
	if [ "$bridged" != "1" ] ; then
	req="required"
	fi
	append validate_forms "ip|FORM_ipaddr_$device|@TR<<IP Address>>|$req|$FORM_ipaddr" "$N"
	append validate_forms "ip|FORM_netmask_$device|@TR<<Netmask>>||$FORM_netmask" "$N"
done
fi

if ! empty "$FORM_submit"; then
	empty "$FORM_generate_wep_128" && empty "$FORM_generate_wep_40" &&
	{
		SAVED=1
		validate <<EOF
$validate_forms
EOF
		equal "$?" 0 && {
			for device in $DEVICES; do
				eval FORM_mode_ap="\$FORM_mode_ap_$device"
		case "$FORM_mode_ap" in
			11a|11an) eval FORM_channel="\$FORM_achannel_$device";;
			*)eval FORM_channel="\$FORM_bgchannel_$device";;
		esac
		case "$FORM_mode_ap" in
			11b) eval FORM_rate="\$FORM_brateform_$device";;
			11g) eval FORM_rate="\$FORM_grateform_$device";;
			11bg) eval FORM_rate="\$FORM_grateform_$device";;
			11n) eval FORM_rate="\$FORM_nrateform_$device";;
			11bgn) eval FORM_rate="\$FORM_bgnrateform_$device";;
		esac
				eval FORM_disabled="\$FORM_disabled_$device"
				eval FORM_channel_width="\$FORM_channel_width_$device"
				eval FORM_channel_ext="\$FORM_channel_ext_$device"
				eval FORM_band="\$FORM_band_$device"
				eval FORM_ipaddr="\$FORM_ipaddr_$device"
				eval FORM_netmask="\$FORM_netmask_$device"
				eval FORM_wmm="\$FORM_wmm_$device"
				eval FORM_ssid="\$FORM_ssid_$device"
				eval FORM_hidden="\$FORM_hidden_$device"
				eval FORM_auth="\$FORM_auth_$device"
				case "$FORM_auth" in
				open) eval FORM_encryption="\$FORM_encryption_open_$device" ;;
				shared) eval FORM_encryption="\$FORM_encryption_shared_$device" ;;
				wpapsk|wpa2psk) eval FORM_encryption="\$FORM_encryption_wpa_$device" ;;
				esac
				eval FORM_server="\$FORM_server_$device"
				eval FORM_radius_port="\$FORM_radius_port_$device"
				eval FORM_radius_key="\$FORM_radius_key_$device"
				eval FORM_radius_ipaddr="\$FORM_radius_ipaddr_$device"
				eval FORM_wpa_psk="\$FORM_wpa_psk_$device"
				eval FORM_wep_key="\$FORM_wep_key_$device"
				eval FORM_key1="\$FORM_key1_$device"
				eval FORM_key2="\$FORM_key2_$device"
				eval FORM_key3="\$FORM_key3_$device"
				eval FORM_key4="\$FORM_key4_$device"

				uci_set "wireless" "$device" "mode" "$FORM_mode_ap"
				uci_set "wireless" "$device" "channel" "$FORM_channel"
				uci_set "wireless" "$device" "rate" "$FORM_rate"
				uci_set "wireless" "$device" "disabled" "$FORM_disabled"
				case "$FORM_disabled" in
				0) uci_set "wireless" "$device" "enable" "1" ;;
				1) uci_set "wireless" "$device" "enable" "0" ;;
				esac
				uci_set "wireless" "$device" "channel_width" "$FORM_channel_width"
				uci_set "wireless" "$device" "channel_ext" "$FORM_channel_ext"
				uci_set "wireless" "$device" "band" "$FORM_band"
				config_get Temp_ipaddr $type ipaddr
				config_get Temp_netmask $type netmask
				if [ "$bridged" != "1" ] ; then
		                  wifi_dhcp_enable=`uci get dhcp.wifi.enabled`
 		                  equal "$wifi_dhcp_enable" 1 && {
				    dhcp_wifi_conf="n"
				    equal "$Temp_ipaddr" "$FORM_ipaddr" || dhcp_wifi_conf="y"
				    equal "$Temp_netmask" "$FORM_netmask" || dhcp_wifi_conf="y"
				    equal "$dhcp_wifi_conf" "y" && {
				      uci_add "dhcp" "dhcp" "wifi"
                		    }
				  }
				  uci_set "wireless" "$device" "ipaddr" "$FORM_ipaddr"
				  uci_set "wireless" "$device" "netmask" "$FORM_netmask"
				else
				  uci_set "wireless" "$device" "ipaddr" "$Temp_ipaddr"
				  uci_set "wireless" "$device" "netmask" "$Temp_netmask"
				fi
				uci_set "wireless" "$device" "wmm" "$FORM_wmm"
				uci_set "wireless" "$device" "ssid" "$FORM_ssid"
				uci_set "wireless" "$device" "hidden" "$FORM_hidden"
				uci_set "wireless" "$device" "auth" "$FORM_auth"
				uci_set "wireless" "$device" "encryption" "$FORM_encryption"
				uci_set "wireless" "$device" "server" "$FORM_server"
				uci_set "wireless" "$device" "port" "$FORM_radius_port"
				uci_set "wireless" "$device" "radius_ipaddr" "$FORM_radius_ipaddr"
				case "$FORM_encryption" in
				  wep) uci_set "wireless" "$device" "key" "$FORM_wep_key";;
				esac
				case "$FORM_auth" in
#				  wep) uci_set "wireless" "$device" "key" "$FORM_wep_key";;
				  wpapsk|wpa2psk) uci_set "wireless" "$device" "key" "$FORM_wpa_psk";;
				  wpa|wpa2) uci_set "wireless" "$device" "key" "$FORM_radius_key";;
				esac
				uci_set "wireless" "$device" "key1" "$FORM_key1"
				uci_set "wireless" "$device" "key2" "$FORM_key2"
				uci_set "wireless" "$device" "key3" "$FORM_key3"
				uci_set "wireless" "$device" "key4" "$FORM_key4"

				#############################################################
				#for interface1
				if [ "$bridged" != "1" ] ; then
				uci_set "wireless" "iface1" "ipaddr" "$FORM_ipaddr"
				uci_set "wireless" "iface1" "netmask" "$FORM_netmask"
				fi
				uci_set "wireless" "iface1" "hidden" "$FORM_hidden"
				uci_set "wireless" "iface1" "server" "$FORM_server"
				uci_set "wireless" "iface1" "port" "$FORM_radius_port"
				uci_set "wireless" "iface1" "radius_ipaddr" "$FORM_radius_ipaddr"
				uci_set "wireless" "iface1" "auth" "$FORM_auth"
				uci_set "wireless" "iface1" "encryption" "$FORM_encryption"
				case "$FORM_encryption" in
				  wep) uci_set "wireless" "iface1" "key" "$FORM_wep_key";;
				esac
				case "$FORM_auth" in
				  wpapsk|wpa2psk) uci_set "wireless" "iface1" "key" "$FORM_wpa_psk";;
				  wpa|wpa2) uci_set "wireless" "iface1" "key" "$FORM_radius_key";;
				esac
				uci_set "wireless" "iface1" "key1" "$FORM_key1"
				uci_set "wireless" "iface1" "key2" "$FORM_key2"
				uci_set "wireless" "iface1" "key3" "$FORM_key3"
				uci_set "wireless" "iface1" "key4" "$FORM_key4"

				#############################################################
				#for interface2
				if [ "$bridged" != "1" ] ; then
				uci_set "wireless" "iface2" "ipaddr" "$FORM_ipaddr"
				uci_set "wireless" "iface2" "netmask" "$FORM_netmask"
				fi
				uci_set "wireless" "iface2" "hidden" "$FORM_hidden"
				uci_set "wireless" "iface2" "server" "$FORM_server"
				uci_set "wireless" "iface2" "port" "$FORM_radius_port"
				uci_set "wireless" "iface2" "radius_ipaddr" "$FORM_radius_ipaddr"
				uci_set "wireless" "iface2" "auth" "$FORM_auth"
				uci_set "wireless" "iface2" "encryption" "$FORM_encryption"
				case "$FORM_encryption" in
				  wep) uci_set "wireless" "iface2" "key" "$FORM_wep_key";;
				esac
				case "$FORM_auth" in
				  wpapsk|wpa2psk) uci_set "wireless" "iface2" "key" "$FORM_wpa_psk";;
				  wpa|wpa2) uci_set "wireless" "iface2" "key" "$FORM_radius_key";;
				esac
				uci_set "wireless" "iface2" "key1" "$FORM_key1"
				uci_set "wireless" "iface2" "key2" "$FORM_key2"
				uci_set "wireless" "iface2" "key3" "$FORM_key3"
				uci_set "wireless" "iface2" "key4" "$FORM_key4"

				#############################################################
				#for interface3
				if [ "$bridged" != "1" ] ; then
				uci_set "wireless" "iface3" "ipaddr" "$FORM_ipaddr"
				uci_set "wireless" "iface3" "netmask" "$FORM_netmask"
				fi
				uci_set "wireless" "iface3" "hidden" "$FORM_hidden"
				uci_set "wireless" "iface3" "server" "$FORM_server"
				uci_set "wireless" "iface3" "port" "$FORM_radius_port"
				uci_set "wireless" "iface3" "radius_ipaddr" "$FORM_radius_ipaddr"
				uci_set "wireless" "iface3" "auth" "$FORM_auth"
				uci_set "wireless" "iface3" "encryption" "$FORM_encryption"
				case "$FORM_encryption" in
				  wep) uci_set "wireless" "iface3" "key" "$FORM_wep_key";;
				esac
				case "$FORM_auth" in
				  wpapsk|wpa2psk) uci_set "wireless" "iface3" "key" "$FORM_wpa_psk";;
				  wpa|wpa2) uci_set "wireless" "iface3" "key" "$FORM_radius_key";;
				esac
				uci_set "wireless" "iface3" "key1" "$FORM_key1"
				uci_set "wireless" "iface3" "key2" "$FORM_key2"
				uci_set "wireless" "iface3" "key3" "$FORM_key3"
				uci_set "wireless" "iface3" "key4" "$FORM_key4"
			done
		}
	}
fi



#####################################################################
# modechange script
#
header "Network" "Wireless" "@TR<<Wireless Configuration>>" 'onload="modechange()"' "$SCRIPT_NAME"
cat <<EOF
<script type="text/javascript" src="/webif.js"></script>
<script type="text/javascript">
<!--
function modechange()
{
	var v;
	$js

	hide('save');
	show('save');
}
-->
</script>

EOF


display_form <<EOF
onchange|modechange
$validate_error
$forms
EOF

###################################################################
# Generate 4 40-bit WEP keys or 1 128-bit WEP Key
eval FORM_wep_passphrase="\$FORM_wep_passphrase_$device"
eval FORM_generate_wep_128="\$FORM_generate_wep_128_$device"
eval FORM_generate_wep_40="\$FORM_generate_wep_40_$device"
! empty "$FORM_generate_wep_128" &&
{
	FORM_wep_key="1"
	FORM_key1=""
	FORM_key2=""
	FORM_key3=""
	FORM_key4=""
	# generate a single 128(104)bit key
	if empty "$FORM_wep_passphrase"; then
		echo "<div class=warning>$EMPTY_passphrase_error</div>"
	else
		textkeys=$(wepkeygen -s "$FORM_wep_passphrase"  |
		awk 'BEGIN { count=0 };
			{ total[count]=$1, count+=1; }
		END { print total[0] ":" total[1] ":" total[2] ":" total[3]}')
		FORM_key1=$(echo "$textkeys" | cut -d ':' -f 0-13 | sed s/':'//g)
		FORM_key2=""
		FORM_key3=""
		FORM_key4=""
		FORM_encryption="wep"
	fi
}

! empty "$FORM_generate_wep_40" &&
{
	FORM_wep_key="1"
	FORM_key1=""
	FORM_key2=""
	FORM_key3=""
	FORM_key4=""
	# generate a four 40 bit keys
	if empty "$FORM_wep_passphrase"; then
		echo "<div class=warning>$EMPTY_passphrase_error</div>"
	else
		textkeys=$(wepkeygen "$FORM_wep_passphrase" | sed s/':'//g)
		keycount=1
		for curkey in $textkeys; do
		case $keycount in
			1) FORM_key1=$curkey;;
			2) FORM_key2=$curkey;;
			3) FORM_key3=$curkey;;
			4) FORM_key4=$curkey
			break;;
		esac
		let "keycount+=1"
		done
		FORM_encryption="wep"
	fi
}

footer ?>
<!--
##WEBIF:name:Network:300:Wireless
-->
