#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "dhcp"

if empty "$FORM_submit"; then
	FORM_dhcp_start=${dhcp_start:-$(uci get dhcp.cfg1.start)}
	FORM_dhcp_limit=${dhcp_limit:-$(uci get dhcp.cfg1.limit)}
	FORM_dhcp_lease_time=${dhcp_lease_time:-$(uci get dhcp.cfg1.leasetime)}
	FORM_dhcp_interface=${dhcp_interface:-$(uci get dhcp.cfg1.interface)}
#string|FORM_dhcp_interface|DHCP interface||$FORM_dhcp_interface
else
	SAVED=1
	validate <<EOF
int|FORM_dhcp_start|DHCP start|required min=1 max=255|$FORM_dhcp_start
int|FORM_dhcp_linit|DHCP limit|required min=1 max=255|$FORM_dhcp_limit
string|FORM_dhcp_lease_time|DHCP lease time|required|$FORM_dhcp_lease_time
EOF
	equal "$?" 0 && {
		uci_set dhcp cfg1 start $FORM_dhcp_start
		uci_set dhcp cfg1 limit $FORM_dhcp_limit
		uci_set dhcp cfg1 leasetime $FORM_dhcp_lease_time
		uci_set dhcp cfg1 interface $FORM_dhcp_interface
	}
fi

header "Network" "Dnsmasq" "@TR<<DHCP Configuration>>" '' "$SCRIPT_NAME"

display_form <<EOF
start_form|@TR<<DHCP Configuration>> $FORM_iface
field|@TR<<Start>>|dhcp_start
text|dhcp_start|$FORM_dhcp_start
field|@TR<<Limit>>|dhcp_limit
text|dhcp_limit|$FORM_dhcp_limit
field|@TR<<Lease Time>>|dhcp_lease_time
text|dhcp_lease_time|$FORM_dhcp_lease_time
field|@TR<<Interface>>
select|dhcp_interface|$FORM_dhcp_interface
option|wan|wan
option|lan|lan
helpitem|DHCP Configuration Settings
helptext|Helptext DHCP Configuration Settings#Provide DHCP range (start and limit), LEASE TIME(Ex:-24h means 24 hours) and INTERFACE
end_form
EOF

footer ?>
<!--
##WEBIF:name:xNetwork:450:Dnsmasq
-->
