#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "firewall"

! empty "$FORM_new_schedule" && {
        SAVED=1
validate <<EOF
hostname|FORM_name|@TR<<Schedule Name>>|required|$FORM_name
EOF
        equal "$?" 0 && {
        scheduleid=`uci get firewall.general.schedule_count`
        scheduleid=`expr $scheduleid + 1`
	uci_add firewall firewall schedule$scheduleid
	uci_set firewall schedule$scheduleid name "$FORM_name"
	uci_set firewall schedule$scheduleid start_day "$FORM_start_day"
	uci_set firewall schedule$scheduleid end_day "$FORM_end_day"
	uci_set firewall schedule$scheduleid start_time "$FORM_start_time"
	uci_set firewall schedule$scheduleid end_time "$FORM_end_time"
	uci_set firewall general schedule_count "$scheduleid"
	}
}

! empty "$FORM_display_schedule" && {
	scheduleid=$FORM_display_schedule
	FORM_name=${name:-$(uci get firewall.schedule$scheduleid.name)}
	FORM_start_day=${start_day:-$(uci get firewall.schedule$scheduleid.start_day)}
	FORM_end_day=${end_day:-$(uci get firewall.schedule$scheduleid.end_day)}
	FORM_start_time=${start_time:-$(uci get firewall.schedule$scheduleid.start_time)}
	FORM_end_time=${end_time:-$(uci get firewall.schedule$scheduleid.end_time)}
}

! empty "$FORM_save_schedule" && {
validate <<EOF
hostname|FORM_name|@TR<<Schedule Name>>|required|$FORM_name
EOF
	equal "$?" 0 && {
	uci_set firewall schedule$FORM_scheduleid name "$FORM_name"
	uci_set firewall schedule$FORM_scheduleid start_day "$FORM_start_day"
	uci_set firewall schedule$FORM_scheduleid end_day "$FORM_end_day"
	uci_set firewall schedule$FORM_scheduleid start_time "$FORM_start_time"
	uci_set firewall schedule$FORM_scheduleid end_time "$FORM_end_time"
	}
}

! empty "$FORM_delete" && {
	schedulecount=`uci get firewall.general.schedule_count`
	scheduleid=$FORM_delete
	uci_remove firewall schedule$scheduleid
	while [ $scheduleid -le $schedulecount ]
	do
	uci_rename firewall schedule`expr $scheduleid + 1` schedule$scheduleid
	scheduleid=`expr $scheduleid + 1`
	done
	uci_set firewall general schedule_count `expr $schedulecount - 1`
}

#####################################################################
header "Security" "Schedules" "@TR<<Schedules>>" ''
#####################################################################
wan=`uci get bridge.general.wan`
equal $wan 1 && {
display_form << EOF
string|<h3>WAN is part of bridge.</h3>
EOF
}

! equal $wan 1 && {

days="option|mon|@TR<<Monday>>
option|tue|@TR<<Tuesday>>
option|wed|@TR<<Wednesday>>
option|thr|@TR<<Thursday>>
option|fri|@TR<<Friday>>
option|sat|@TR<<Saturday>>
option|sun|@TR<<Sunday>>"

time_var="0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24"
for i in $time_var; do
	time="$time
	option|$i"
done

count=`uci get firewall.general.schedule_count`
echo "<th colspan=\"11\"><h3>" List of Schedules: "</h3></th>"
echo "<div class=\"settings\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>Serial No.</th><th>Schedule Name</th><th>Days</th><th>Time</th><th style=\"text-align: center;\">Actions</th></tr>"
i=1
while [ $i -le $count ]
do
name=`uci get firewall.schedule$i.name`
startday=`uci get firewall.schedule$i.start_day`
endday=`uci get firewall.schedule$i.end_day`
starttime=`uci get firewall.schedule$i.start_time`
endtime=`uci get firewall.schedule$i.end_time`
echo "<tr><td>$i</td><td>$name</td><td>$startday - $endday</td><td>$starttime - $endtime</td>"
echo "<td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_schedule=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>"
echo " "
echo "<a href=\"$SCRIPT_NAME?delete=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a>"
echo "</td></tr>"
i=`expr $i + 1`
done
echo "</tbody></table><div class=\"clearfix\">&nbsp;</div></div><br>"

empty "$FORM_display_schedule" && {
display_form <<EOF
start_form|@TR<<New Schedule>>
formtag_begin|new_schedule|$SCRIPT_NAME
field|@TR<<Schedule Name>>|name
text|name|$FORM_name
field|@TR<<Day>>
select|start_day|$FORM_start_day
$days
string|to
select|end_day|$FORM_end_day
$days
field|@TR<<Time>>
select|start_time|$FORM_start_time
$time
string|to
select|end_time|$FORM_end_time
$time
field||spacer1
string|<br />
submit|new_schedule|@TR<<Add>>
reset||@TR<<Clear>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_schedule" && {
display_form <<EOF
start_form|@TR<<Edit Schedule $FORM_display_schedule>>
formtag_begin|save_schedule|$SCRIPT_NAME
field|@TR<<Serial No>>
text|scheduleid|$FORM_display_schedule|||readonly
field|@TR<<Schedule Name>>|name
text|name|$FORM_name
field|@TR<<Day>>
select|start_day|$FORM_start_day
$days
string|to
select|end_day|$FORM_end_day
$days
field|@TR<<Time>>
select|start_time|$FORM_start_time
$time
string|to
select|end_time|$FORM_end_time
$time
field||spacer1
string|<br />
submit|save_schedule|@TR<<Save>>
reset||@TR<<Reset>>
formtag_end
end_form
EOF
}

}

footer ?>

<!--
##WEBIF:name:xSecurity:300:Schedules
-->
