#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "firewall"
. /www/cgi-bin/webif/firewall-subcategories.sh

! empty "$FORM_new_rule" && {
        SAVED=1
	case $FORM_address in
	specify)
	     V_IP="required"
	     ;;
	esac
validate <<EOF
ip|FORM_ipaddr|@TR<<IP Address>>|$V_IP|$FORM_ipaddr
string|FORM_proto|@TR<<Protocol>>||$FORM_proto
int|FORM_sport|@TR<<Source Port>>||$FORM_sport
int|FORM_dport|@TR<<Destination Port>>||$FORM_dport
EOF
        equal "$?" 0 && {
        ruleid=`uci get firewall.general.number`
	ruleid=`expr $ruleid + 1`
	uci_add firewall filter rule$ruleid
	case $FORM_address in
		any) uci_set firewall rule$ruleid ipaddr "$FORM_address"
		     ;;
		specify) uci_set firewall rule$ruleid ipaddr "$FORM_ipaddr"
		         ;;
	esac
	uci_set firewall rule$ruleid proto "$FORM_proto"
	uci_set firewall rule$ruleid sport "$FORM_sport"
	uci_set firewall rule$ruleid dport "$FORM_dport"
	uci_set firewall general number $ruleid
	}
}

! empty "$FORM_display_edit_rule" && {
	ruleid=$FORM_display_edit_rule
	temp=`uci get firewall.rule$ruleid.ipaddr`
	case $temp in
		any) 
		FORM_address="any"
		;;
		*) 
		FORM_address="specify"
		FORM_ipaddr=${ipaddr:-$(uci get firewall.rule$ruleid.ipaddr)}
		;;
	esac
	FORM_proto=${proto:-$(uci get firewall.rule$ruleid.proto)}
	FORM_sport=${sport:-$(uci get firewall.rule$ruleid.sport)}
	FORM_dport=${dport:-$(uci get firewall.rule$ruleid.dport)}
}

! empty "$FORM_save_edit_rule" && {
#	ruleid="$FORM_ruleid"
	SAVED=1
	case $FORM_address in
		specify)
		V_IP="required"
		;;
	esac
validate <<EOF
ip|FORM_ipaddr|@TR<<IP Address>>|$V_IP|$FORM_ipaddr
string|FORM_proto|@TR<<Protocol>>||$FORM_proto
int|FORM_sport|@TR<<Source Port>>||$FORM_sport
int|FORM_dport|@TR<<Destination Port>>||$FORM_dport
EOF
	equal "$?" 0 && {
	case $FORM_address in
		any)
		uci_set firewall rule$FORM_ruleid ipaddr "$FORM_address"
		;;
		specify)
		uci_set firewall rule$FORM_ruleid ipaddr "$FORM_ipaddr"
		;;
	esac
	uci_set firewall rule$FORM_ruleid proto "$FORM_proto"
	case $FORM_proto in
		tcp|udp)
		uci_set firewall rule$FORM_ruleid sport "$FORM_sport"
		uci_set firewall rule$FORM_ruleid dport "$FORM_dport"
		;;
		*)
		uci_set firewall rule$FORM_ruleid sport ""
		uci_set firewall rule$FORM_ruleid dport ""
		;;
	esac
	}
}

! empty "$FORM_delete" && {
	number=`uci get firewall.general.number`
	ruleid=$FORM_delete
	uci_remove firewall rule$ruleid
	while [ $ruleid -le $number ]
	do
	uci_rename firewall rule`expr $ruleid + 1` rule$ruleid
	ruleid=`expr $ruleid + 1`
	done
	uci_set firewall general number `expr $number - 1`
#	uci commit firewall
}

#####################################################################
header "Firewall" "Filter" "@TR<<Filter Configuration>>" ' onload="modechange()" '

#####################################################################
cat <<EOF
<script type="text/javascript" src="/webif.js "></script>
<script type="text/javascript">
<!--
function modechange()
{
	var v;
	v = isset('address', 'specify');
	set_visible('field_ipaddr', v);

	v = isset('proto', 'tcp') || isset('proto', 'udp');
	set_visible('field_sport', v);
	set_visible('field_dport', v);

	hide('save');
	show('save');
}
-->
</script>
EOF
display_form <<EOF
start_form|@TR<<List of Existing Rules>>
end_form
EOF

count=`uci get firewall.general.number`
echo "<table style=\"width: 70%; text-align: left;\" border=\"1\" cellpadding=\"2\" cellspacing=\"2\" align=\"center\"><tr><th>Rule ID</th><th>Source IP</th><th>Protocol</th><th>Source Port</th><th>Dst port</th><th>Actions</th></tr>"
i=1
while [ $i -le $count ]
do
src=`uci get firewall.rule$i.ipaddr`
proto=`uci get firewall.rule$i.proto`
sport=`uci get firewall.rule$i.sport`
dport=`uci get firewall.rule$i.dport`
echo "<tr><td>$i</td>"
echo "<td>$src</td>"
echo "<td>$proto</td>"
if [ $sport ];then
echo "<td>$sport</td>"
else
echo "<td>-----</td>"
fi
if [ $dport ];then
echo "<td>$dport</td>"
else
echo "<td>-----</td>"
fi

echo "<td><a href=\"$SCRIPT_NAME?display_edit_rule=$i\">@TR<<edit>></a>"
echo "/"
echo "<a href=\"$SCRIPT_NAME?delete=$i\" >@TR<<delete>></a>"
echo "</td></tr>"

i=`expr $i + 1`
done
echo "</table><br>"

display_form <<EOF
start_form
field||spacer1
string|<br />
formtag_begin|new_filter_rule|$SCRIPT_NAME
submit|new_filter_rule| @TR<< New Rule >>
formtag_end
end_form
EOF

! empty "$FORM_new_filter_rule" && {

display_form <<EOF
onchange|modechange
start_form|@TR<<Packet Filter New Rule>>
formtag_begin|new_rule|$SCRIPT_NAME
field|@TR<<Address>>
select|address|$FORM_address
option|any|@TR<<any>>
option|specify|@TR<<specify>>
field|@TR<<Specify IP Address>>|field_ipaddr|hidden
text|ipaddr|$FORM_ipaddr
field|@TR<<Protocol>>
select|proto|$FORM_proto
option|any|@TR<<any>>
option|tcp|@TR<<tcp>>
option|udp|@TR<<udp>>
field|@TR<<Source Port>>|field_sport|hidden
text|sport|$FORM_sport
field|@TR<<Destination Port>>|field_dport|hidden
text|dport|$FORM_dport
field||spacer1
string|<br />
submit|new_rule|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_edit_rule" && {

display_form <<EOF
onchange|modechange
start_form|@TR<<Edit Rule $FORM_display_edit_rule>>
formtag_begin|save_edit_rule|$SCRIPT_NAME
field|@TR<<Rule ID>>
text|ruleid|$FORM_display_edit_rule|||readonly
field|@TR<<Address>>
select|address|$FORM_address
option|any|@TR<<any>>
option|specify|@TR<<specify>>
field|@TR<<Specify IP Address>>|field_ipaddr|hidden
text|ipaddr|$FORM_ipaddr
field|@TR<<Protocol>>
select|proto|$FORM_proto
option|any|@TR<<any>>
option|tcp|@TR<<tcp>>
option|udp|@TR<<udp>>
field|@TR<<Source Port>>|field_sport|hidden
text|sport|$FORM_sport
field|@TR<<Destination Port>>|field_dport|hidden
text|dport|$FORM_dport
field||spacer1
string|<br />
submit|save_edit_rule|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

footer ?>
