#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
. /etc/functions.sh
uci_load "asterisk"

! empty "$FORM_set_default" && {
uci_set asterisk general dial_timeout "8000"
uci_set asterisk general interdigit_timeout "1300"
}

if empty "$FORM_submit"; then
	config_get FORM_codec_ulaw general codec_ulaw
	config_get FORM_codec_alaw general codec_alaw
	config_get FORM_codec_g729 general codec_g729
	config_get FORM_codec_g722 general codec_g722
	config_get FORM_codec_g723 general codec_g723
	config_get FORM_codec_iLBC general codec_iLBC
	config_get FORM_codec_iLBC_1 general codec_iLBC_1
	config_get FORM_codec_g726_32 general codec_g726_32
	config_get FORM_codec_g726_40 general codec_g726_40
	config_get FORM_codec_g726_16 general codec_g726_16
	config_get FORM_codec_g726_24 general codec_g726_24
	config_get FORM_codec_amr general codec_amr
	config_get FORM_bitrate_codec_amr general bitrate_codec_amr
	config_get FORM_codec_amr_wb general codec_amr_wb
	config_get FORM_bitrate_codec_amr_wb general bitrate_codec_amr_wb
	config_get FORM_dial_timeout general dial_timeout
	config_get FORM_interdigit_timeout general interdigit_timeout
	config_get FORM_ntt general ntt
	config_get FORM_band general band
	config_get FORM_passthru_mode general passthru_mode
	else
	SAVED=1
validate <<EOF
int|FORM_dial_timeout|@TR<<Dial Timeout>>|min=8000|$FORM_dial_timeout
int|FORM_interdigit_timeout|@TR<<Interdigit Timeout>>|min=1300|$FORM_interdigit_timeout
EOF
	equal "$?" 0 && {
	uci_set asterisk general codec_ulaw "$FORM_codec_ulaw"
	uci_set asterisk general codec_alaw "$FORM_codec_alaw"
	uci_set asterisk general codec_g729 "$FORM_codec_g729"
	uci_set asterisk general codec_g722 "$FORM_codec_g722"
	uci_set asterisk general codec_g723 "$FORM_codec_g723"
	uci_set asterisk general codec_iLBC "$FORM_codec_iLBC"
	uci_set asterisk general codec_iLBC_1 "$FORM_codec_iLBC_1"
	uci_set asterisk general codec_g726_32 "$FORM_codec_g726_32"
	uci_set asterisk general codec_g726_40 "$FORM_codec_g726_40"
	uci_set asterisk general codec_g726_16 "$FORM_codec_g726_16"
	uci_set asterisk general codec_g726_24 "$FORM_codec_g726_24"
	uci_set asterisk general codec_amr "$FORM_codec_amr"
	uci_set asterisk general bitrate_codec_amr "$FORM_bitrate_codec_amr"
	uci_set asterisk general codec_amr_wb "$FORM_codec_amr_wb"
	uci_set asterisk general bitrate_codec_amr_wb "$FORM_bitrate_codec_amr_wb"
	uci_set asterisk general dial_timeout "$FORM_dial_timeout"
	uci_set asterisk general interdigit_timeout "$FORM_interdigit_timeout"
	uci_set asterisk general ntt "$FORM_ntt"
	uci_set asterisk general band "$FORM_band"
	uci_set asterisk general passthru_mode "$FORM_passthru_mode"
	config_set general codec_ulaw "$FORM_codec_ulaw"
	config_set general codec_alaw "$FORM_codec_alaw"
	config_set general codec_g729 "$FORM_codec_g729"
	config_set general codec_g722 "$FORM_codec_g722"
	config_set general codec_g723 "$FORM_codec_g723"
	config_set general codec_iLBC "$FORM_codec_iLBC"
	config_set general codec_iLBC_1 "$FORM_codec_iLBC_1"
	config_set general codec_g726_32 "$FORM_codec_g726_32"
	config_set general codec_g726_40 "$FORM_codec_g726_40"
	config_set general codec_g726_16 "$FORM_codec_g726_16"
	config_set general codec_g726_24 "$FORM_codec_g726_24"
	config_set general codec_amr "$FORM_codec_amr"
	config_set general bitrate_codec_amr "$FORM_bitrate_codec_amr"
	config_set general codec_amr_wb "$FORM_codec_amr_wb"
	config_set general bitrate_codec_amr_wb "$FORM_bitrate_codec_amr_wb"
	config_set general dial_timeout "$FORM_dial_timeout"
	config_set general interdigit_timeout "$FORM_interdigit_timeout"
	config_set general ntt "$FORM_ntt"
	config_set general band "$FORM_band"
	config_set general passthru_mode "$FORM_passthru_mode"
	}
fi

header "Telephony" "Global Config" "@TR<<Global Configuration>>" 'onload="setcodecsstatinwbmode();document.forms[0].onsubmit=function(){return checkcodecs()}"' "$SCRIPT_NAME"
cat <<EOF
<script type="text/javascript" src="/webif.js"></script>
<script type="text/javascript">
<!--
function checkcodecs()
{
  var no_code_selected = 0 ;
  
  if ( ( document.forms[0].codec_ulaw.checked ) ||
       ( document.forms[0].codec_alaw.checked ) ||
       ( document.forms[0].codec_g722.checked ) ||
       ( document.forms[0].codec_g723.checked ) ||
       ( document.forms[0].codec_g729.checked ) ||
       ( document.forms[0].codec_iLBC.checked ) ||
       ( document.forms[0].codec_iLBC_1.checked ) ||
       ( document.forms[0].codec_g726_32.checked ) ||
       ( document.forms[0].codec_g726_40.checked ) ||
       ( document.forms[0].codec_g726_16.checked ) ||
       ( document.forms[0].codec_g726_24.checked ) ||
       ( document.forms[0].codec_amr.checked ) ||
       ( document.forms[0].codec_amr_wb.checked ) )
  {
    no_code_selected = 0 ;
  }
  else
  {
    no_code_selected = 1 ;
  }
  if ( no_code_selected )
  {
    answer = confirm("No codec selected. Do you want to continue?")
    if ( answer )
    {
      return true ;
    }
    else
    {
      return false ;
    }
  }
  return true ;
}

function selectall()
{
    document.forms[0].codec_ulaw.checked    = true ;
    document.forms[0].codec_alaw.checked    = true ;
    document.forms[0].codec_g722.checked    = true ;
    document.forms[0].codec_g723.checked    = true ;
    document.forms[0].codec_g729.checked    = true ;
    document.forms[0].codec_iLBC.checked    = true ;
    document.forms[0].codec_iLBC_1.checked  = true ;
    document.forms[0].codec_g726_32.checked = true ;
    document.forms[0].codec_g726_40.checked = true ;
    document.forms[0].codec_g726_16.checked = true ;
    document.forms[0].codec_g726_24.checked = true ;
    document.forms[0].codec_amr.checked     = true ;
    document.forms[0].codec_amr_wb.checked  = true ; 

    return true ;
}
function clearall()
{
    document.forms[0].codec_ulaw.checked    = false ;
    document.forms[0].codec_alaw.checked    = false ;
    document.forms[0].codec_g722.checked    = false ;
    document.forms[0].codec_g723.checked    = false ;
    document.forms[0].codec_g729.checked    = false ;
    document.forms[0].codec_iLBC.checked    = false ;
    document.forms[0].codec_iLBC_1.checked  = false ;
    document.forms[0].codec_g726_32.checked = false ;
    document.forms[0].codec_g726_40.checked = false ;
    document.forms[0].codec_g726_16.checked = false ;
    document.forms[0].codec_g726_24.checked = false ;
    document.forms[0].codec_amr.checked     = false ;
    document.forms[0].codec_amr_wb.checked  = false ; 

    return true ;
}
function setcodecsstatinwbmode()
{
  if ( document.getElementById('band') != null )
  {
//    alert("entered defined section");
    if ( document.forms[0].band[1].checked == true )
    {
	document.forms[0].codec_g723.checked    = false ;
	document.forms[0].codec_iLBC.checked    = false ;
	document.forms[0].codec_g723.disabled   = true  ;
	document.forms[0].codec_iLBC.disabled   = true  ;
    }
    else
    {
	document.forms[0].codec_g723.disabled   = false  ;
	document.forms[0].codec_iLBC.disabled   = false  ;
    }
  }
  else
  {
 //   alert("entered undefined section");
  }
}

-->
</script>
EOF
board=`uci get webif.general.device_name`
if [ "$board" = "Mindspeed Comcerto 1000" ];then
#form_band="onclick|disp_alert
form_band=" onclick|setcodecsstatinwbmode
start_form|@TR<<Band Selection>>
field|@TR<<Band>>|field_band
radio|band|$FORM_band|narrow|@TR<<Narrow Band>>
radio|band|$FORM_band|wide|@TR<<Wide Band>>
end_form"
fi

display_form <<EOF
start_form|@TR<<Codec Selection For PBX>>
field|@TR<<Codecs>>|field_codecs
checkbox|codec_ulaw|$FORM_codec_ulaw|yes|G.711 u-Law &nbsp;&nbsp;&nbsp;&nbsp; 64 kb/s
field|@TR<<>>
checkbox|codec_alaw|$FORM_codec_alaw|yes|G.711 a-Law &nbsp;&nbsp;&nbsp;&nbsp; 64 kb/s
field|@TR<<>>
checkbox|codec_g722|$FORM_codec_g722|yes|G.722 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 64 kb/s
field|@TR<<>>
checkbox|codec_g723|$FORM_codec_g723|yes|G.723.1 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 6.3 kb/s
field|@TR<<>>
checkbox|codec_g729|$FORM_codec_g729|yes|G.729a &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 8 kb/s
field|@TR<<>>
checkbox|codec_iLBC|$FORM_codec_iLBC|yes|iLBC &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 13.33 kb/s
field|@TR<<>>
checkbox|codec_iLBC_1|$FORM_codec_iLBC_1|yes|iLBC &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 15.20 kb/s
field|@TR<<>>
checkbox|codec_g726_32|$FORM_codec_g726_32|yes|G.726 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 32 kb/s
field|@TR<<>>
checkbox|codec_g726_40|$FORM_codec_g726_40|yes|G.726 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 40 kb/s
field|@TR<<>>
checkbox|codec_g726_16|$FORM_codec_g726_16|yes|G.726 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 16 kb/s
field|@TR<<>>
checkbox|codec_g726_24|$FORM_codec_g726_24|yes|G.726 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 24 kb/s
field|@TR<<>>
checkbox|codec_amr|$FORM_codec_amr|yes|AMR &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
select|bitrate_codec_amr|$FORM_bitrate_codec_amr
option|7|12.20 kb/s
option|6|10.20 kb/s
option|5|7.95 kb/s
option|4|7.40 kb/s
option|3|6.70 kb/s
option|2|5.90 kb/s
option|1|5.15 kb/s
option|0|4.75 kb/s
field|@TR<<>>
checkbox|codec_amr_wb|$FORM_codec_amr_wb|yes|AMR-WB &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
select|bitrate_codec_amr_wb|$FORM_bitrate_codec_amr_wb
option|8|23.85 kb/s
option|7|23.05 kb/s
option|6|19.85 kb/s
option|5|18.25 kb/s
option|4|15.85 kb/s
option|3|14.25 kb/s
option|2|12.65 kb/s
option|1|8.85 kb/s
option|0|6.60 kb/s
field|@TR<<>>
string|<a href="#" onclick="selectall()" >Select ALL Codecs</a>
string|<a href="#" onclick="clearall()" >clear ALL Codecs</a>
end_form
start_form|@TR<<Timeout Values>>
field|@TR<<Dial Timeout (msec)>>|dial_timeout
text|dial_timeout|$FORM_dial_timeout
field|@TR<<Interdigit Timeout (msec)>>|interdigit_timeout
text|interdigit_timeout|$FORM_interdigit_timeout
field|Set to Default Values
string|<a href="$SCRIPT_NAME?set_default=1">set default</a>
#helpitem|Set to Default Timeout Values
#helptext|<a href="$SCRIPT_NAME?set_default=1">set default</a>
end_form
start_form|@TR<<NTT Caller ID Support>>
field|@TR<<NTT Caller ID>>|ntt
checkbox|ntt|$FORM_ntt|yes
end_form
start_form|@TR<<Pass Through Mode Support>>
field|@TR<<Pass Through Mode>>|passthru_mode
checkbox|passthru_mode|$FORM_passthru_mode|yes
end_form
EOF
display_form <<EOF
$form_band
submit|save|@TR<<Save>>
EOF

footer ?>

<!--
##WEBIF:name:Telephony:300:Global Config
-->
