#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "asterisk"

! empty "$FORM_display_analog_phone" && {
	analogid=$FORM_display_analog_phone
	config_get FORM_analog_name analog$analogid name
	config_get FORM_analog_number analog$analogid number
	config_get FORM_field_analog_voicemail analog$analogid voicemail
	config_get FORM_field_dsp_acp analog$analogid field_dsp_acp
	config_get FORM_field_vad analog$analogid field_vad
}

! empty "$FORM_save_analog_phone" && {
	SAVED=1
validate <<EOF
string|FORM_analog_name|@TR<<Analog phone name>>|required|$FORM_analog_name
int|FORM_analog_number|@TR<<Analog phone number>>|required|$FORM_analog_number
string|FORM_field_analog_voicemail|@TR<<Voice mail>>||$FORM_field_analog_voicemail
EOF
	equal "$?" 0 && {
        uci_set asterisk analog$FORM_analogid name "$FORM_analog_name"
        uci_set asterisk analog$FORM_analogid number "$FORM_analog_number"
        uci_set asterisk analog$FORM_analogid voicemail "$FORM_field_analog_voicemail"
        uci_set asterisk analog$FORM_analogid ulaw "$FORM_codec_ulaw"
        uci_set asterisk analog$FORM_analogid alaw "$FORM_codec_alaw"
        uci_set asterisk analog$FORM_analogid g729 "$FORM_codec_g729"
        uci_set asterisk analog$FORM_analogid field_dsp_acp "$FORM_field_dsp_acp"
        uci_set asterisk analog$FORM_analogid field_vad "$FORM_field_vad"
	config_set analog$FORM_analogid name "$FORM_analog_name"
	config_set analog$FORM_analogid number "$FORM_analog_number"
	config_set analog$FORM_analogid voicemail "$FORM_field_analog_voicemail"
	config_set analog$FORM_analogid ulaw "$FORM_codec_ulaw"
	config_set analog$FORM_analogid alaw "$FORM_codec_alaw"
	config_set analog$FORM_analogid g729 "$FORM_codec_g729"
	config_set analog$FORM_analogid field_dsp_acp "$FORM_field_dsp_acp"
	config_set analog$FORM_analogid field_vad "$FORM_field_vad"
	}
}

! empty "$FORM_delete_analog_phone" && {
	analogid=$FORM_delete_analog_phone
        uci_set asterisk analog$analogid name ""
        uci_set asterisk analog$analogid number ""
        uci_set asterisk analog$analogid voicemail ""
	config_set analog$analogid name ""
	config_set analog$analogid number ""
	config_set analog$analogid voicemail ""
}

! empty "$FORM_display_analog_advance" && {
		analogid=$FORM_display_analog_advance
		config_get FORM_analog_name analog$analogid name
		config_get FORM_analog_number analog$analogid number
		config_get FORM_field_ec_enable analog$analogid field_ec_enable
		config_get FORM_field_dc_filter_enable analog$analogid field_dc_filter_enable
		config_get FORM_field_hec_filter_enable analog$analogid field_hec_filter_enable
		config_get FORM_field_npl_control_enable analog$analogid field_npl_control_enable
		config_get FORM_npl_tune analog$analogid npl_tune
		config_get FORM_field_comfort_noise analog$analogid field_comfort_noise
		config_get FORM_field_ec_tail analog$analogid field_ec_tail
}

! empty "$FORM_save_analog_advance" && {
        SAVED=1
        equal "$?" 0 && {
        uci_set asterisk analog$FORM_analogid field_ec_enable "$FORM_field_ec_enable"
        uci_set asterisk analog$FORM_analogid field_dc_filter_enable "$FORM_field_dc_filter_enable"
        uci_set asterisk analog$FORM_analogid field_hec_filter_enable "$FORM_field_hec_filter_enable"
        uci_set asterisk analog$FORM_analogid field_npl_control_enable "$FORM_field_npl_control_enable"
        uci_set asterisk analog$FORM_analogid npl_tune "$FORM_npl_tune"
        uci_set asterisk analog$FORM_analogid field_comfort_noise "$FORM_field_comfort_noise"
        uci_set asterisk analog$FORM_analogid field_ec_tail "$FORM_field_ec_tail"
	config_set analog$FORM_analogid field_ec_enable "$FORM_field_ec_enable"
	config_set analog$FORM_analogid field_dc_filter_enable "$FORM_field_dc_filter_enable"
	config_set analog$FORM_analogid field_hec_filter_enable "$FORM_field_hec_filter_enable"
	config_set analog$FORM_analogid field_npl_control_enable "$FORM_field_npl_control_enable"
	config_set analog$FORM_analogid npl_tune "$FORM_npl_tune"
	config_set analog$FORM_analogid field_comfort_noise "$FORM_field_comfort_noise"
	config_set analog$FORM_analogid field_ec_tail "$FORM_field_ec_tail"
        }
}

! empty "$FORM_display_analog_advance_ec" && {
		analogid=$FORM_display_analog_advance_ec
		config_get FORM_analog_name analog$analogid name
		config_get FORM_analog_number analog$analogid number
		config_get FORM_field_full_filter analog$analogid field_full_filter
		config_get FORM_field_fast_convergence_control analog$analogid field_fast_convergence_control
}

! empty "$FORM_save_analog_advance_ec" && {
        SAVED=1
        equal "$?" 0 && {
        uci_set asterisk analog$FORM_analogid field_full_filter "$FORM_field_full_filter"
        uci_set asterisk analog$FORM_analogid field_fast_convergence_control "$FORM_field_fast_convergence_control"
	config_set analog$FORM_analogid field_full_filter "$FORM_field_full_filter"
	config_set analog$FORM_analogid field_fast_convergence_control "$FORM_field_fast_convergence_control"
        }
}

! empty "$FORM_display_fxo_advance" && {
		config_get FORM_fxo_name fxo name
		config_get FORM_fxo_number fxo number
		config_get FORM_field_ec_enable fxo field_ec_enable
		config_get FORM_field_dc_filter_enable fxo field_dc_filter_enable
		config_get FORM_field_hec_filter_enable fxo field_hec_filter_enable
		config_get FORM_field_npl_control_enable fxo field_npl_control_enable
		config_get FORM_npl_tune fxo npl_tune
		config_get FORM_field_comfort_noise fxo field_comfort_noise
		config_get FORM_field_ec_tail fxo field_ec_tail
}

! empty "$FORM_save_fxo_advance" && {
        SAVED=1
        equal "$?" 0 && {
        uci_set asterisk fxo field_ec_enable "$FORM_field_ec_enable"
        uci_set asterisk fxo field_dc_filter_enable "$FORM_field_dc_filter_enable"
        uci_set asterisk fxo field_hec_filter_enable "$FORM_field_hec_filter_enable"
        uci_set asterisk fxo field_npl_control_enable "$FORM_field_npl_control_enable"
        uci_set asterisk fxo npl_tune "$FORM_npl_tune"
        uci_set asterisk fxo field_comfort_noise "$FORM_field_comfort_noise"
        uci_set asterisk fxo field_ec_tail "$FORM_field_ec_tail"
	config_set fxo field_ec_enable "$FORM_field_ec_enable"
	config_set fxo field_dc_filter_enable "$FORM_field_dc_filter_enable"
	config_set fxo field_hec_filter_enable "$FORM_field_hec_filter_enable"
	config_set fxo field_npl_control_enable "$FORM_field_npl_control_enable"
	config_set fxo npl_tune "$FORM_npl_tune"
	config_set fxo field_comfort_noise "$FORM_field_comfort_noise"
	config_set fxo field_ec_tail "$FORM_field_ec_tail"
        }
}

! empty "$FORM_display_fxo_advance_ec" && {
		config_get FORM_fxo_name fxo name
		config_get FORM_fxo_number fxo number
		config_get FORM_field_full_filter fxo field_full_filter
		config_get FORM_field_fast_convergence_control fxo field_fast_convergence_control
}

! empty "$FORM_save_fxo_advance_ec" && {
        SAVED=1
        equal "$?" 0 && {
        uci_set asterisk fxo field_full_filter "$FORM_field_full_filter"
        uci_set asterisk fxo field_fast_convergence_control "$FORM_field_fast_convergence_control"
	config_set fxo field_full_filter "$FORM_field_full_filter"
	config_set fxo field_fast_convergence_control "$FORM_field_fast_convergence_control"
        }
}

! empty "$FORM_delete_fxo" && {
        uci_set asterisk fxo name ""
        uci_set asterisk fxo number ""
}

! empty "$FORM_display_fxo" && {
	config_get FORM_fxo_name fxo name
	config_get FORM_fxo_number fxo number
}

! empty "$FORM_save_fxo" && {
	SAVED=1
validate <<EOF
string|FORM_fxo_name|@TR<<fxo phone name>>|required|$FORM_fxo_name
int|FORM_fxo_number|@TR<<fxo phone number>>|required|$FORM_fxo_number
EOF
	equal "$?" 0 && {
        uci_set asterisk fxo name "$FORM_fxo_name"
        uci_set asterisk fxo number "$FORM_fxo_number"
	config_set fxo name "$FORM_fxo_name"
	config_set fxo number "$FORM_fxo_number"
	}
}

! empty "$FORM_new_voip_phone" && {
        SAVED=1
validate <<EOF
string|FORM_voip_name|@TR<<Voip phone name>>|required|$FORM_voip_name
int|FORM_voip_number|@TR<<Voip phone number>>|required|$FORM_voip_number
string|FORM_field_voip_protocol|@TR<<Protocol>>||$FORM_field_voip_protocol
string|FORM_voip_auth_pwd|@TR<<Auth pwd>>||$FORM_voip_auth_pwd
EOF
        equal "$?" 0 && {
	voipid=`uci get asterisk.general.voipphones`
	voipid=`expr $voipid + 1`
	uci_add asterisk voipphone voip$voipid
	uci_set asterisk voip$voipid name "$FORM_voip_name"
	uci_set asterisk voip$voipid number "$FORM_voip_number"
	uci_set asterisk voip$voipid protocol "$FORM_field_voip_protocol"
	uci_set asterisk voip$voipid type "$FORM_field_voip_type"
	uci_set asterisk voip$voipid authpwd "$FORM_voip_auth_pwd"
	uci_set asterisk voip$voipid voicemail "$FORM_field_voip_voicemail"
	uci_set asterisk general voipphones $voipid
	config_set voip$voipid name "$FORM_voip_name"
	config_set voip$voipid number "$FORM_voip_number"
	config_set voip$voipid protocol "$FORM_field_voip_protocol"
	config_set voip$voipid type "$FORM_field_voip_type"
	config_set voip$voipid authpwd "$FORM_voip_auth_pwd"
	config_set voip$voipid voicemail "$FORM_field_voip_voicemail"
	}
}

! empty "$FORM_display_voip_phone" && {
	voipid=$FORM_display_voip_phone
	config_get FORM_voip_name voip$voipid name
	config_get FORM_voip_number voip$voipid number
	config_get FORM_field_voip_protocol voip$voipid protocol
	config_get FORM_field_voip_type voip$voipid type
	config_get FORM_voip_auth_pwd voip$voipid authpwd
	config_get FORM_field_voip_voicemail voip$voipid voicemail
}

! empty "$FORM_save_voip_phone" && {
        SAVED=1
validate <<EOF
string|FORM_voip_name|@TR<<Voip phone name>>|required|$FORM_voip_name
int|FORM_voip_number|@TR<<Voip phone number>>|required|$FORM_voip_number
string|FORM_field_voip_protocol|@TR<<Protocol>>||$FORM_field_voip_protocol
string|FORM_voip_auth_pwd|@TR<<Auth pwd>>||$FORM_voip_auth_pwd
EOF
        equal "$?" 0 && {
        uci_set asterisk voip$FORM_voipid name "$FORM_voip_name"
        uci_set asterisk voip$FORM_voipid number "$FORM_voip_number"
        uci_set asterisk voip$FORM_voipid protocol "$FORM_field_voip_protocol"
        uci_set asterisk voip$FORM_voipid type "$FORM_field_voip_type"
        uci_set asterisk voip$FORM_voipid authpwd "$FORM_voip_auth_pwd"
        uci_set asterisk voip$FORM_voipid voicemail "$FORM_field_voip_voicemail"
	config_set voip$FORM_voipid name "$FORM_voip_name"
	config_set voip$FORM_voipid number "$FORM_voip_number"
	config_set voip$FORM_voipid protocol "$FORM_field_voip_protocol"
	config_set voip$FORM_voipid type "$FORM_field_voip_type"
	config_set voip$FORM_voipid authpwd "$FORM_voip_auth_pwd"
	config_set voip$FORM_voipid voicemail "$FORM_field_voip_voicemail"
	}
}

! empty "$FORM_delete_voip_phone" && {
	number=`uci get asterisk.general.voipphones`
	voipid=$FORM_delete_voip_phone
	uci_remove asterisk voip$voipid
	while [ $voipid -lt $number ]
	do
	uci_rename asterisk voip`expr $voipid + 1` voip$voipid
	voipid=`expr $voipid + 1`
	done
	uci_set asterisk general voipphones `expr $number - 1`
}

#####################################################################
header "Telephony" "Extensions" "@TR<<Dial Plan>>" '' 
#####################################################################

count=`uci get asterisk.general.analogphones`
echo "<th colspan=\"11\"><h3>" Analog Extensions: "</h3></th>"
echo "<div class=\"settings\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>Phone ID</th><th>Phone Number</th><th>Display Name</th><th style=\"text-align: center;\">Actions</th></tr>"
i=1
while [ $i -le $count ]
do
config_get analog_name analog$i name
config_get analog_number analog$i number
#config_get dsp_acp analog$i field_dsp_acp
#config_get vad analog$i field_vad
#if [ "$dsp_acp" ];then
#dsp="$dsp_acp"
#else
#dsp="disable"
#fi
#if [ "$vad" ];then
#vad="$vad"
#else
#vad="disable"
#fi
echo "<tr class=\"tr_bg\"><td>$i</td><td>$analog_number</td><td>$analog_name</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_analog_phone=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete_analog_phone=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
i=`expr $i + 1`
done
echo "</tbody></table><div class=\"clearfix\">&nbsp;</div></div>"

! empty "$FORM_display_analog_phone" && {

display_form <<EOF
onchange|modechange
start_form|@TR<<Edit Analog Phone $FORM_display_analog_phone>>
formtag_begin|save_analog_phone|$SCRIPT_NAME
field|@TR<<Analog Phone ID>>
text|analogid|$FORM_display_analog_phone|||readonly
field|@TR<<Name>>|field_analog_name
text|analog_name|$FORM_analog_name
field|@TR<<Number>>|field_analog_number
text|analog_number|$FORM_analog_number
field|@TR<<Voicemail>>|field_analog_voicemail
checkbox|field_analog_voicemail|$FORM_field_analog_voicemail|enable
field|@TR<<DSP on ACP>>|field_dsp_acp
checkbox|field_dsp_acp|$FORM_field_dsp_acp|enable
field|@TR<<VAD>>|field_vad
checkbox|field_vad|$FORM_field_vad|enable
field||spacer1
string|<br />
helpitem|Advance configuration
helptext|<a href="$SCRIPT_NAME?display_analog_advance=$FORM_display_analog_phone">Echo-Cancellation</a>
helptext|<a href="$SCRIPT_NAME?display_analog_advance_ec=$FORM_display_analog_phone">Enhanced Echo-Cancellation</a>
submit|save_analog_phone|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_analog_advance" && {

display_form <<EOF
start_form|@TR<<Edit Echo Cancellation for Analog Phone $FORM_display_analog_advance>>
formtag_begin|save_analog_advance|$SCRIPT_NAME
field|@TR<<Analog Phone ID>>
text|analogid|$FORM_display_analog_advance|||readonly
field|@TR<<Name>>|field_analog_name
string|$FORM_analog_name
field|@TR<<Number>>|field_analog_number
string|$FORM_analog_number

field|@TR<<Enable Echo Cancellation>>|field_ec_enable
checkbox|field_ec_enable|$FORM_field_ec_enable|enable
field|@TR<<Enable DC Removal Filter>>|field_dc_filter_enable
checkbox|field_dc_filter_enable|$FORM_field_dc_filter_enable|enable
field|@TR<<Freeze HEC Filter Coefficient>>|field_hec_filter_enable
checkbox|field_hec_filter_enable|$FORM_field_hec_filter_enable|enable
field|@TR<<Enable NLP Control>>|field_npl_control_enable
checkbox|field_npl_control_enable|$FORM_field_npl_control_enable|enable
field|@TR<<NLP Tune>>
select|npl_tune|$FORM_npl_tune
option|00|00
option|01|01
option|10|10
field|@TR<<Comfort Noise Generation>>|field_comfort_noise
checkbox|field_comfort_noise|$FORM_field_comfort_noise|enable
field|@TR<<Network Echo Cancellation Tail Length>>|field_ec_tail
select|field_ec_tail|$FORM_field_ec_tail
option|0001|16 ms
option|0011|32 ms
option|0101|48 ms

field||spacer1
string|<br />
submit|save_analog_advance|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_analog_advance_ec" && {

display_form <<EOF
start_form|@TR<<Edit Enhanced Echo Cancellation for Analog Phone $FORM_display_analog_advance_ec>>
formtag_begin|save_analog_advance_ec|$SCRIPT_NAME
field|@TR<<Analog Phone ID>>
text|analogid|$FORM_display_analog_advance_ec|||readonly
field|@TR<<Name>>|field_analog_name
string|$FORM_analog_name
field|@TR<<Number>>|field_analog_number
string|$FORM_analog_number

field|@TR<<Full-Filter Echo Path Change Detection>>|field_full_filter
checkbox|field_full_filter|$FORM_field_full_filter|enable
field|@TR<<Fast Convergence Control>>|field_fast_convergence_control
checkbox|field_fast_convergence_control|$FORM_field_fast_convergence_control|enable

field||spacer1
string|<br />
submit|save_analog_advance_ec|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

echo "<th colspan=\"11\"><h3>" FXO Extensions: "</h3></th>"
echo "<div class=\"settings\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>Phone ID</th><th>Extension Number</th><th>Display Name</th><th style=\"text-align: center;\">Action</th></tr>"
i=1
config_get name fxo name
config_get number fxo number
echo "<tr class=\"tr_bg\"><td>$i</td><td>$number</td><td>$name</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_fxo=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a> </td></tr>"
echo "</tbody></table><div class=\"clearfix\">&nbsp;</div></div>"

! empty "$FORM_display_fxo" && {

display_form <<EOF
onchange|modechange
start_form|@TR<<Edit FXO Extension>>
formtag_begin|save_fxo_phone|$SCRIPT_NAME
field|@TR<<Name>>|field_fxo_name
text|fxo_name|$FORM_fxo_name
field|@TR<<Number>>|field_fxo_number
text|fxo_number|$FORM_fxo_number
field||spacer1
helpitem|Advance configuration
helptext|<a href="$SCRIPT_NAME?display_fxo_advance=$FORM_display_fxo">Echo-Cancellation</a>
helptext|<a href="$SCRIPT_NAME?display_fxo_advance_ec=$FORM_display_fxo">Enhanced Echo-Cancellation</a>
string|<br />
submit|save_fxo|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_fxo_advance" && {

display_form <<EOF
start_form|@TR<<Edit Echo Cancellation for FXO Phone>>
formtag_begin|save_fxo_advance|$SCRIPT_NAME
field|@TR<<Name>>|field_fxo_name
string|$FORM_fxo_name
field|@TR<<Number>>|field_fxo_number
string|$FORM_fxo_number

field|@TR<<Enable Echo Cancellation>>|field_ec_enable
checkbox|field_ec_enable|$FORM_field_ec_enable|enable
field|@TR<<Enable DC Removal Filter>>|field_dc_filter_enable
checkbox|field_dc_filter_enable|$FORM_field_dc_filter_enable|enable
field|@TR<<Freeze HEC Filter Coefficient>>|field_hec_filter_enable
checkbox|field_hec_filter_enable|$FORM_field_hec_filter_enable|enable
field|@TR<<Enable NLP Control>>|field_npl_control_enable
checkbox|field_npl_control_enable|$FORM_field_npl_control_enable|enable
field|@TR<<NLP Tune>>
select|npl_tune|$FORM_npl_tune
option|00|00
option|01|01
option|10|10
field|@TR<<Comfort Noise Generation>>|field_comfort_noise
checkbox|field_comfort_noise|$FORM_field_comfort_noise|enable
field|@TR<<Network Echo Cancellation Tail Length>>|field_ec_tail
select|field_ec_tail|$FORM_field_ec_tail
option|0001|16 ms
option|0011|32 ms
option|0101|48 ms

field||spacer1
string|<br />
submit|save_fxo_advance|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_fxo_advance_ec" && {

display_form <<EOF
start_form|@TR<<Edit Enhanced Echo Cancellation for FXO Phone>>
formtag_begin|save_fxo_advance_ec|$SCRIPT_NAME
field|@TR<<Name>>|field_fxo_name
string|$FORM_fxo_name
field|@TR<<Number>>|field_fxo_number
string|$FORM_fxo_number

field|@TR<<Full-Filter Echo Path Change Detection>>|field_full_filter
checkbox|field_full_filter|$FORM_field_full_filter|enable
field|@TR<<Fast Convergence Control>>|field_fast_convergence_control
checkbox|field_fast_convergence_control|$FORM_field_fast_convergence_control|enable

field||spacer1
string|<br />
submit|save_fxo_advance_ec|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

count=`uci get asterisk.general.voipphones`
echo "<th colspan=\"11\"><h3>" VoIP Extensions: "</h3></th>"
echo "<div class=\"settings\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>Phone ID</th><th>Phone Number</th><th>Display Name</th><th style=\"text-align: center;\">Actions</th></tr>"
i=1
while [ $i -le $count ]
do
config_get voip_name voip$i name
config_get voip_number voip$i number
echo "<tr class=\"tr_bg\"><td>$i</td><td>$voip_number</td><td>$voip_name</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_voip_phone=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete_voip_phone=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
i=`expr $i + 1`
done
echo "</tbody></table><div class=\"clearfix\">&nbsp;</div></div>"

display_form <<EOF
start_form
field||spacer1
string|<br />
formtag_begin|add_new_voip|$SCRIPT_NAME
submit|add_new_voip|@TR<< Add New >>
formtag_end
end_form
EOF

! empty "$FORM_add_new_voip" && {

display_form <<EOF
start_form|@TR<<New VoIP Extension>>
formtag_begin|new_voip_phone|$SCRIPT_NAME
field|@TR<<Name>>|field_voip_name
text|voip_name|$FORM_voip_name
field|@TR<<Number/Auth Name>>|field_voip_number
text|voip_number|$FORM_voip_number
field|@TR<<Protocol>>|field_voip_protocol
select|field_voip_protocol|$FORM_field_voip_protocol
option|sip|@TR<<SIP>>
#option|H.323|@TR<<H.323>>
field|@TR<<Type>>|field_voip_type
select|field_voip_type|$FORM_field_voip_type
option|friend|@TR<<friend>>
option|peer|@TR<<peer>>
field|@TR<<Authentication Password>>|field_voip_auth_pwd
password|voip_auth_pwd|$FORM_voip_auth_pwd
field|@TR<<Voicemail>>|field_voip_voicemail
checkbox|field_voip_voicemail|$FORM_field_voip_voicemail|enable
field||spacer1
string|<br />
submit|new_voip_phone|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_voip_phone" && {

display_form <<EOF
onchange|modechange
start_form|@TR<<Edit Voip Phone $FORM_display_voip_phone>>
formtag_begin|save_voip_phone|$SCRIPT_NAME
field|@TR<<Voip Phone ID>>
text|voipid|$FORM_display_voip_phone|||readonly
field|@TR<<Name>>|field_voip_name
text|voip_name|$FORM_voip_name
field|@TR<<Number/Auth Name>>|field_voip_number
text|voip_number|$FORM_voip_number
field|@TR<<Protocol>>|field_voip_protocol
select|field_voip_protocol|$FORM_field_voip_protocol
option|sip|@TR<<SIP>>
#option|H.323|@TR<<H.323>>
field|@TR<<Type>>|field_voip_type
select|field_voip_type|$FORM_field_voip_type
option|friend|@TR<<friend>>
option|peer|@TR<<peer>>
field|@TR<<Authentication Password>>|field_voip_auth_pwd
password|voip_auth_pwd|$FORM_voip_auth_pwd
field|@TR<<Voicemail>>|field_voip_voicemail
checkbox|field_voip_voicemail|$FORM_field_voip_voicemail|enable
field||spacer1>
string|<br />
submit|save_voip_phone|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

footer ?>

<!--
##WEBIF:name:Telephony:100:Extensions
-->
