#!/bin/sh /etc/rc.common
### HA function is only deployed on Vigor3900
#This script is used to polling two special events:
#G40237: If all WAN switch ports are down, stop send CARP
#G40733: If HA LAN switch ports are all down, we assume one of Slaves is taking the role of Master, ifdown my all WAN interfaces to prevent conflict
#Mechanism for multi-HA LAN environment(Hot-Standby method)

UCI_CONFIG="ucarp_hs"
last_lan_status=""
last_all_wans=""
EVENT_STOP_CARP_AD=""
EVENT_IFDOWN_ALL_WAN=""

[ -f /var/run/ucarp/HSmaster.pid ] && echo $$ >/var/run/ucarp/HSmaster.pid

config_load $UCI_CONFIG

model=$(head -n 1 /etc/version)
if [ "$model" = "Vigor3900" ] ;then
	sw_model_param="Vigor3900"
	switch_model=$(cat /tmp/v39sw_model)
elif [ "$model" = "Vigor2960" -o "$model" = "Vigor2960F" ] ;then
	sw_model_param="Vigor2960"
	switch_model=$(cat /tmp/v29sw_model)
fi
ha_authkey=`uci get ucarp_mode.general.authkey`
lan_interfaces=`uci filter network physical eth0`
eth2_interfaces=`uci filter network physical eth2`
usb_interfaces=`uci filter network physical usb`
wan_interfaces="$eth2_interfaces $usb_interfaces"
preempt_mode=`uci get ucarp_mode.general.preempt_mode`
manual_status=`uci get ucarp_mode.general.manual_status`
manual_threshold=`uci get ucarp_mode.general.manual_threshold`
manual_threshold=$(($manual_threshold * 60))
lan_port_detect=`uci get ucarp_mode.general.lan_port_detect`
wan_port_detect=`uci get ucarp_mode.general.wan_port_detect`
start_time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')

check_all_vip_existed(){
	config_get lan $1 lan
	config_get vip $1 vip
	ifname=lan-$lan
	arping -f -c 1 -w 2 -i $ifname $vip >/dev/null 2>&1
	if [ "$?" != "0" ] ;then
		vip_is_existed=0
		logger -p 152.5 "[High Availability] check_all_vip_existed($$): vip($vip) does not exist!"
	fi
}

send_garp_vip()
{
	config_get vip $1 vip
	config_get lan $1 lan
	ifname=lan-$lan
	macaddr=`uci get network.$lan.macaddr`
	arping -b -c 1 -i $ifname -S $macaddr $vip >/dev/null 2>&1
}

attach_vip()
{
	#Attach VIP to LAN
	config_get vip $1 vip
	config_get lan $1 lan
	ifname=lan-$lan
	lan_mask=`uci get network.$lan.static_netmask`
	macaddr=`uci get network.$lan.macaddr`
	/usr/sbin/ip addr add $vip/$lan_mask dev $ifname brd + 2>/dev/null >/dev/null
	[ "$?" = "0" ] && logger -p 152.5 "[High Availability] master-polling_HS($$): Attach VIP($vip) of profile:($1) to $ifname"
	#Add VIP into ipset:ip_lanX for user management dst bypassing
	ipset -A ip_$lan $vip
	#flush incomplete vip record in arp table if it's existed
	arp -d $vip -i $ifname >/dev/bull 2>/dev/null
	#send garp of VIP
	arping -b -c 1 -i $ifname -S $macaddr $vip >/dev/null 2>&1
	logger -p 152.5 "[High Availability] master-polling_HS($$): Send gratuitous arp of VIP($vip)"
}
remove_vip()	#also clear old vip record in arp table
{
	#Remove VIP from LAN
	config_get vip $1 vip
	config_get lan $1 lan
	ifname=lan-$lan
	lan_mask=`uci get network.$lan.static_netmask`
	/usr/sbin/ip addr del $vip/$lan_mask dev $ifname 2> /dev/null >/dev/null
	[ "$?" = 0 ] && logger -p 152.5 "[High Availability] master-polling_HS($$): Remove VIP($vip) of profile:($1) from $ifname"
	#remove VIP from ipset:ip_lanX for user management dst bypassing
	ipset -D ip_$lan $vip
	arp -d $vip -i $ifname >/dev/bull 2>/dev/null
	arping -f -c 2 -w 2 -i $ifname $vip >/dev/bull 2>&1
}

restore_CARP_ad()
{
	[ -f /var/run/ucarp/$1.pid ] && {
		ucarp_PID=`cat /var/run/ucarp/$1.pid`
		[ -z "$ucarp_PID" ] || kill -SIGUSR2 $ucarp_PID 2>/dev/null
	}
}

stop_CARP_ad() {
	[ -f /var/run/ucarp/$1.pid ] && {
		ucarp_PID=`cat /var/run/ucarp/$1.pid`
		[ -z "$ucarp_PID" ] || kill -SIGUSR1 $ucarp_PID 2>/dev/null
	}
}

disable_extra_subnet()
{
	local ifc=$1
	second_subnet=`uci get -d, network.$ifc.static_2nd_subnet`
	echo "$second_subnet" | grep , >/dev/null
	do_loop=$?
	i=0
	[ -n "$second_subnet" ] && {
		while true; do
			i=$(($i+1))
			set -- `echo $second_subnet | cut -d, -f $i`
			if [ "$3" = "NAT" ]; then
				ipset -D lan_nat_subnet $1/$2
				ipset -D lan_${config}_subnet $1/$2
			elif [ "$3" = "ROUTING" ]; then
				ipset -D lan_routing_subnet $1/$2
			else [ -z "$3" ]
				break
			fi
			ip addr del $1/$2 dev lan-$ifc brd +
			json delete network.$ifc.2nd_subnet
			logger -p 152.5 "[High Availability] master-polling_HS($$): remove subnet:$1/$2 from $ifc"
			[ "$do_loop" -eq 0 ] || break
		done
	}
}
enable_extra_subnet()
{
	local ifc=$1
	second_subnet=`uci get -d, network.$ifc.static_2nd_subnet`
	echo "$second_subnet" | grep , >/dev/null
	do_loop=$?
	i=0
	[ -n "$second_subnet" ] && {
		while true; do
			i=$(($i+1))
			set -- `echo $second_subnet | cut -d, -f $i`
			if [ "$3" = "NAT" ]; then
				ipset -A lan_nat_subnet $1/$2
				ipset -A lan_${config}_subnet $1/$2
			elif [ "$3" = "ROUTING" ]; then
				ipset -A lan_routing_subnet $1/$2
			else [ -z "$3" ]
				break
			fi
			ip addr add $1/$2 dev lan-$ifc brd +
			json set network.$ifc 2nd_subnet=",$1/$2($3)"
			logger -p 152.5 "[High Availability] master-polling_HS($$): add subnet:$1/$2 to $ifc"
			##### send gratuitous arp
			macaddr=`uci get network.$ifc.macaddr`
			[ -n "$macaddr" -a -n "$1" ] && {
				logger -p 152.5 "[High Availability] master-polling_HS($$): send garp of extra subnet ip:$1"
				arping -b -c 1 -i lan-$ifc -S $macaddr $1 >/dev/null 2>&1
			}
			[ "$do_loop" -eq 0 ] || break
		done
	}
}

#In Hot-standby mode, All HA LAN's switch ports must be up => Master works well
#Any of ports is down =>treat Master is malfunction
judge_LAN_detect_strict()
{
	config_get lan $1 lan
	lan_vlanid=`uci get network.$lan.vlan_id`
	vlan_member=`uci get vlan_lan.$lan_vlanid.member`
	for member in $vlan_member ;do
		lan_port_status=`json -f /var/status_system_interface get switch_lan.lan$member.status`
		if [ -n "$lan_port_status" -a "$lan_port_status" != "up" ] ;then
			detect_lan_result="down"
			break
		fi
	done
}
#In Hot-standby mode, at least one of HA LAN's switch ports is up => Master works well
#All of ports is down =>treat Master is malfunction
judge_LAN_detect_loose()
{
	config_get lan $1 lan
	lan_vlanid=`uci get network.$lan.vlan_id`
	vlan_member=`uci get vlan_lan.$lan_vlanid.member`
	#logger -p 152.5 "[High Availability] DEBUG master-polling_HS($$): judge_LAN_detect_loose: lan=$lan, lan_vlanid=$lan_vlanid, vlan_member=$vlan_member"
	for member in $vlan_member ;do
		lan_port_status=`json -f /var/status_system_interface get switch_lan.lan$member.status`
		#logger -p 152.5 "[High Availability] DEBUG master-polling_HS($$): judge_LAN_detect_loose: ($lan)lan_port_status=$lan_port_status"
		if [ -z "$lan_port_status" -o "$lan_port_status" = "up" ] ;then
			#logger -p 152.5 "[High Availability] DEBUG master-polling_HS($$): judge_LAN_detect_loose: LAN PORTs Status IS UP"
			detect_lan_result="up"
			break
		fi
	done
}

set_status_to_master() {
	uci set $UCI_CONFIG.$1.ha_profile_status=Master
}
set_to_mal_master_WAN(){
	uci set $UCI_CONFIG.$1.ha_profile_status=WAN_Failed
}
set_to_mal_master_LAN(){
	uci set $UCI_CONFIG.$1.ha_profile_status=LAN_Failed
}

check_rebind_flag()
{
	local ucarp_pid
	ucarp_pid=`cat var/run/ucarp/$1.pid`
	[ -e "/tmp/HA_rebind_$ucarp_pid" ] && {
		rebind_flag=`cat /tmp/HA_rebind_$ucarp_pid`
		if [ "$rebind_flag" == "1" ] ;then
			logger -p 152.5 "[High Availability] master-polling_HS($$): rebind flag is set! do re-attaching. (HS profile:$1)"
			attach_vip $1
			config_get bind_lan $1 lan
			enable_extra_subnet $bind_lan
		fi
		rm -f "/tmp/HA_rebind_$ucarp_pid"
	}
}

while true; do
	################################### G40237: If all WAN switch ports are down, stop ucarp sending CARP ad
	################### Query status of WAN switch ports;If any port is up, detect result=up
	if [ "$wan_port_detect" = "enable" ] ;then
		detect_wan_result="down"
		enabled_WANs=`json -f /var/cd_status get global.interfaces`
		if [ -n "$enabled_WANs" ] ;then
			for detect_wan in $enabled_WANs ;do
				wan_port_down=`json -f /var/cd_status get interface.$detect_wan.port_down`
				if [ "$wan_port_down" = "0" ] ;then
					detect_wan_result="up"
				fi
			done
			################### Handle detect WANs case
			if [ "$detect_wan_result" = "up" ] ;then
				if [ -z "$last_all_wans" -o "$last_all_wans" = "down" ] ;then
					last_all_wans=up
					logger -p 152.5 "[High Availability] master-polling_HS($$): Pass check Event:WAN_Failed, start to send CARP"
					EVENT_STOP_CARP_AD=no
					config_foreach restore_CARP_ad ha
					config_foreach attach_vip ha
					#add extra subnets on LANs
					for ifc in $lan_interfaces; do
						[ $(uci get network.$ifc.status) = "enable" ] && enable_extra_subnet $ifc
					done
					##### G38957: Enable ALL LANs DHCP Service(Include non-HA LAN)
					for i in $lan_interfaces ;do
						[ -z `uci filter $UCI_CONFIG lan $i` ] && continue
						json set ucarp.$i dhcp_state=up
						logger -p 152.5 "[High Availability] master-polling_HS($$): start ($i) dhcp service"
					done
					config_foreach set_status_to_master
					/etc/init.d/dhcpd apply &
					##### G49223: LAN pppoe server
					/etc/init.d/pppoe_server restart
					##### Send signal of "DevChange" to ubf_polling_d
					web_portal_status=`uci get general_conf.base.status`
					[ "$web_portal_status" == "enable" ] && kill -SIGUSR1 `pidof ubf_polling_d` >/dev/null 2>&1
					##### G49368: restart vlan
					/etc/init.d/rtk8366_vlan restart &
				fi
			elif [ "$detect_wan_result" = "down" ] ;then
				if [ -z "$last_all_wans" -o "$last_all_wans" = "up" ] ;then
					last_all_wans=down
					logger -p 152.5 "[High Availability] master-polling_HS($$) Event: WAN_Failed occurs, stop sending CARP"
					EVENT_STOP_CARP_AD=yes
					config_foreach stop_CARP_ad ha
					config_foreach remove_vip ha
					#remove extra subnets on LANs
					for ifc in $lan_interfaces; do
						disable_extra_subnet $ifc
					done
					##### G38957: Disable ALL LAN DHCP Service(Includes non-HA LAN)
					for i in $lan_interfaces ;do
						[ -z `uci filter $UCI_CONFIG lan $i` ] && continue
						json set ucarp.$i dhcp_state=down
						logger -p 152.5 "[High Availability] master-polling_HS($$): stop ($i) dhcp service"
					done
					config_foreach set_to_mal_master_WAN
					/etc/init.d/dhcpd apply &
					##### G49223: LAN pppoe server
					/etc/init.d/pppoe_server stop
					##### Send signal of "DevChange" to ubf_polling_d
					web_portal_status=`uci get general_conf.base.status`
					[ "$web_portal_status" == "enable" ] && kill -SIGUSR1 `pidof ubf_polling_d` >/dev/null 2>&1
					##### G49368: restart vlan
					/etc/init.d/rtk8366_vlan restart &
				fi
			fi
		else
			EVENT_STOP_CARP_AD=""
		fi
	else
		EVENT_STOP_CARP_AD=""
	fi
	
	################################### G40733:If LAN switch ports are all down, shutdown all WAN interfaces
	################### Determine LAN detection result
	if [ -z "$lan_port_detect" -o "$lan_port_detect" = "disable" ] ;then
		detect_lan_result="up"
	elif [ "$lan_port_detect" = "loose" ] ;then
		detect_lan_result="down"
		config_foreach judge_LAN_detect_loose ha
	elif [ "$lan_port_detect" = "strict" ] ;then
		detect_lan_result="up"
		config_foreach judge_LAN_detect_strict ha
	fi
	################### Handle detect LANs case:
	if [ "$detect_lan_result" = "up" ] ;then
		#If I was DOWN previously, i should do ifdown this time
		if [ -z "$last_lan_status" -o "$last_lan_status" = "DOWN" ] ;then
			CAN_DO_IFUP="yes"
			#1.If EVENT_STOP_CARP_AD is set, abort ifup procedure because router is already malfunction
			if [ "$EVENT_STOP_CARP_AD" = "yes" ] ;then
				#echo "master-polling_HS($$) Event: EVENT_STOP_CARP_AD is occur, abort ifup" >/dev/console
				CAN_DO_IFUP="no"
			fi
			#2.After several check, if CAN_DO_IFUP is "yes", start ifup procedure
			if [ "$CAN_DO_IFUP" = "yes" ] ;then
				EVENT_IFDOWN_ALL_WAN=no
				last_lan_status=UP
				/etc/init.d/ipsec stop
				#echo "master-polling_HS($$) Pass check Event:LAN_Failed" >/dev/console
				logger -p 152.5 "[High Availability] master_polling_HS($$): prepare to ifup procedure..."
				#remove HA_ifdown_lock to active ifup
				[ -f "/tmp/HA_ifdown_lock" ] && {
					rm -f /tmp/HA_ifdown_lock
					logger -p 152.5 "[High Availability] master-polling_HS($$): before ifup procedure, remove HA_ifdown_lock first"
				}
				#### Enable extra subnet on LANs or Ifup all WAN+USB
				for ifc in $lan_interfaces; do
					[ $(uci get network.$ifc.status) = "enable" ] && enable_extra_subnet $ifc
				done
				for ifc in $wan_interfaces; do
					if [ $(uci get network.$ifc.status) = "enable" ] ;then
						#Set prev_port_status to unknown, let conn_dect will re-adjudgement its status
						json -f /var/cd_status set interface.$ifc prev_port_status=
						#Reason: if previous WAN switch port status is down, 
							#ifup WAN by here will cause conn_dect to skip (port becomes down) procedure, 
							#because conn_dect see it as a down->down case
						ifc_connstatus=`json get network.$ifc.connection`
						if [ "$ifc_connstatus" = "up" ] ;then
							#echo "master-polling_HS($$): $ifc is already up, skip ifup" >/dev/console
							[ "$ifc" = "wan4" ] && {
								[ $(uci get network.$ifc.proto) = "dmz" ] && ifup $ifc &
							}
						else
							logger -p 152.5 "[High Availability] master-polling_HS($$): ifup $ifc"
							ifup $ifc
						fi
					else
						#echo "master-polling_HS($$): profile $ifc is disabled, skip ifup" >/dev/console
						dummy=
					fi
				done
				#### Add VIP on all HA LANs
				config_foreach attach_vip ha
				#restore VRRP from all HA LANs
				config_foreach restore_CARP_ad ha
				config_foreach set_status_to_master
				##### G38957: Enable LAN DHCP Service
				for i in $lan_interfaces ;do
					[ -z `uci filter $UCI_CONFIG lan $i` ] && continue
					json set ucarp.$i dhcp_state=up
					logger -p 152.5 "[High Availability] master-polling_HS($$): start ($i) dhcp service"
				done
				/etc/init.d/dhcpd apply &
				
				##### G49223: restart LAN pppoe server
				/etc/init.d/pppoe_server restart
				
				##### Send signal of "DevChange" to ubf_polling_d
				web_portal_status=`uci get general_conf.base.status`
				[ "$web_portal_status" == "enable" ] && kill -SIGUSR1 `pidof ubf_polling_d` >/dev/null 2>&1
				
				####G42275:Reset WCF status to enable for License re-check (dray-fwup)
				######=>G48625: disable this wrong mechanism
				#uci set fw_cf_license.fwlicense.status=enable
				#/etc/init.d/url_filter restart >/dev/null 2>&1
				#### clear old routes
				/usr/sbin/ip route flush cache >/dev/null 2>/dev/null
				conntrack -F >/dev/null 2>/dev/null
				##### G49368: restart vlan
				/etc/init.d/rtk8366_vlan restart &
				/etc/init.d/ipsec restart &
			fi
		fi
	elif [ "$detect_lan_result" = "down" ] ;then
		#If I was UP previously, i should do ifdown this time
		if [ -z "$last_lan_status" -o "$last_lan_status" = "UP" ] ;then
			#echo "master-polling_HS($$) Event: HA LAN_Failed occurs, failover my master state" >/dev/console
			logger -p 152.5 "[High Availability] master-polling_HS($$): LAN_Failed occurs, disable my master property"
			CAN_DO_IFDOWN="yes"
			#If EVENT_STOP_CARP_AD is yes, abort ifup procedure
			if [ "$EVENT_STOP_CARP_AD" = "yes" ] ;then
				#echo "master-polling_HS($$) Event: EVENT_STOP_CARP_AD is occur, no need to do ifdown" >/dev/console
				CAN_DO_IFDOWN="no"
			fi
			if [ "$CAN_DO_IFDOWN" = "yes" ] ;then
				logger -p 152.5 "[High Availability] master_polling_HS($$): prepare to ifdown procedure..."
				EVENT_IFDOWN_ALL_WAN=yes
				last_lan_status=DOWN
				#create critical section lock to prevent HA was turn off when doing following items:
				touch /tmp/ucarp/master-polling_HS_CSlock
				#create a lock to depress conn_dect and ifup, prevent them try to UP interface
				[ -f "/tmp/HA_ifdown_lock" ] || {
					touch /tmp/HA_ifdown_lock
					logger -p 152.5 "[High Availability] master-polling_HS($$): create HA_ifdown_lock"
				}
				#### Disable extra subnet on LANs, Ifdown all WAN+USB
				for ifc in $lan_interfaces; do
					[ $(uci get network.$ifc.status) = "enable" ] && disable_extra_subnet $ifc
				done
				for ifc in $wan_interfaces; do
					if [ $(uci get network.$ifc.status) = "enable" ] ;then
						#Whatever if interface connection status is down or up, all do ifdown
						[ "$ifc" = "wan4" ] && {
							[ $(uci get network.$ifc.proto) = "dmz" ] && json set network.wan4 connection=down
						}
						logger -p 152.5 "[High Availability] master-polling_HS($$): ifdown $ifc"
						ifdown $ifc &
					else
						#echo "master-polling_HS($$): profile $ifc is disabled, skip ifdown" >/dev/console
						dummy=
					fi
				done
				#Remove VIP on all HA LANs
				config_foreach remove_vip ha
				#Stop sending VRRP from all HA LANs
				config_foreach stop_CARP_ad ha
				config_foreach set_to_mal_master_LAN
				##### G38957: Disable LAN DHCP Service
				for i in $lan_interfaces ;do
					[ -z `uci filter $UCI_CONFIG lan $i` ] && continue
					json set ucarp.$i dhcp_state=down
					logger -p 152.5 "[High Availability] master-polling_HS($$): stop ($i) dhcp service"
				done
				/etc/init.d/dhcpd apply &
				
				##### G49223: stop LAN pppoe server
				/etc/init.d/pppoe_server stop
				
				##### Send signal of "DevChange" to ubf_polling_d
				web_portal_status=`uci get general_conf.base.status`
				[ "$web_portal_status" == "enable" ] && kill -SIGUSR1 `pidof ubf_polling_d` >/dev/null 2>&1
				
				#### clear old routes
				/usr/sbin/ip route flush cache >/dev/null 2>/dev/null
				conntrack -F >/dev/null 2>/dev/null
				##### G49368: restart vlan
				/etc/init.d/rtk8366_vlan restart &
			fi
		fi
	fi
	if [ -z "$EVENT_STOP_CARP_AD" -o "$EVENT_STOP_CARP_AD" = "no" -a "$CAN_DO_IFUP" = "yes" ] ;then
		#When ucarp detects and executes "iface-rebinding" event, the flag:/tmp/HA_rebind_$ucarp_pid will be created.
		#We need to re-attach the vip to iface again
		config_foreach check_rebind_flag
		#Periodically announce that VIP is belong to me if I am a healthy master.
		#This action helps to speed up asserting VIP owner to LAN CPE
		config_foreach send_garp_vip ha
	fi
	sleep 10
done
