#!/bin/sh
#ifname=$1
#vip=$2
ha_profile=$3
GLOBAL_LOCK="/tmp/ucarp/ha-up_AS_lock"

#spin-lock to wait ha-down_AS.sh completed
enter_time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
while true; do
	#spin if my ha-down lock is found
	if [ -f /tmp/ucarp/ha_down_lock_AS_${ha_profile} ] ;then
		logger -p 152.5 "[High Availability] ha-up_AS($ha_profile)($$): Found my ha_down lock, wait..."
		BREAK_LOCK_INTV=30
		nowtime=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		DIFF=$(($nowtime - $enter_time))
		if [ $DIFF -le $BREAK_LOCK_INTV ] ;then
			sleep 5
			continue
		else
			logger -p 152.5 "[High Availability] ha-up_AS($ha_profile)($$): over $BREAK_LOCK_INTV secs, break my ha_down lock"
			rm -f /tmp/ucarp/ha_down_lock_AS_${ha_profile} 2>/dev/null
		fi
	else
		break
	fi
done

#create my lock
[ -f /tmp/ucarp/ha_up_lock_AS_$ha_profile ] && return
touch /tmp/ucarp/ha_up_lock_AS_$ha_profile
#logger -p 152.5 "[High Availability] ha-up_AS($ha_profile)($$): create my script lock"

lock $GLOBAL_LOCK
if [ -f "/var/run/ucarp/ha_poll_wanport_AS.pid" ] ;then
	logger -p 152.5 "[High Availability] ha-up_AS($ha_profile)($$): ha_poll_wanport_AS is already running, need not create another one"
else
	##### start the global ALL WAN switch port detection for master-polling
	touch "/var/run/ucarp/ha_poll_wanport_AS.pid"
	/etc/ucarp/ha_poll_wanport_AS.sh &
	logger -p 152.5 "[High Availability] ha-up_AS($ha_profile)($$): start ha_poll_wanport_AS"
fi
lock -u $GLOBAL_LOCK

if [ -f "/var/run/ucarp/${ha_profile}_ASmaster.pid" ] ;then
	logger -p 152.5 "[High Availability] ha-up_AS($ha_profile)($$): master-polling_AS is already running, need not create another one"
else
	touch "/var/run/ucarp/${ha_profile}_ASmaster.pid"
	logger -p 152.5 "[High Availability] ha-up_AS($ha_profile)($$): Now I become Master state"
	##### update state to master(A non-used settings, but this can help for debug)
	## In AS method, ifup do not need to check this state. The state is used in HS method only.
	json set ucarp.${ha_profile} state=master
	##### start master-polling_AS
	/etc/ucarp/master-polling_AS.sh $ha_profile &
	logger -p 152.5 "[High Availability] ha-up_AS($ha_profile)($$): start master-polling_AS"
fi

#release script lock
rm -f /tmp/ucarp/ha_up_lock_AS_$ha_profile
#logger -p 152.5 "[High Availability] ha-up_AS($ha_profile)($$): scirpt executes done, remove my script lock"
