#!/bin/sh
append DRIVERS "rt2870"
#DEBUG=echo
scan_rt2870() {
	local device="$1"
}


disable_rt2870() (
	local device="$1"

	$DEBUG ifconfig "$device" down

	return 0
)

enable_rt2870() {
for i in 0 1 2 3; do
case $i in
0)
dev=ra$i
device=ra$i
;;
*)
dev=iface$i
device=ra$i
;;
esac
	config_get disabled "${dev}" disabled
	if [ "$disabled" = "0" ]; then
	
		disable_rt2870 "$device"
	
		config_get ipaddr "$dev" ipaddr
		if [ -n "$ipaddr" ]; then
		$DEBUG ifconfig "$device" $ipaddr
		fi
	
		config_get netmask "$dev" netmask
		if [ -n "$netmask" ]; then
			$DEBUG ifconfig "$device" netmask $netmask
		fi
	
		$DEBUG ifconfig "$device" up
	
		config_get fr_threshold "advance" fr_threshold
		$DEBUG iwpriv "$device" set FragThreshold="$fr_threshold"
	
		config_get rts_threshold "advance" rts_threshold
		$DEBUG iwpriv "$device" set RTSThreshold="$rts_threshold"
	
		config_get wmm "$dev" wmm
		$DEBUG iwpriv "$device" set WmmCapable="$wmm"
	
		config_get channel "$dev" channel
		$DEBUG iwpriv "$device" set Channel="$channel" >/dev/null 2>/dev/null
	
		config_get ssid "$dev" ssid
		$DEBUG iwpriv "$device" set SSID="$ssid" >/dev/null 2>/dev/null
	
		config_get_bool hidden "$dev" hidden 0
		$DEBUG iwpriv "$device" set HideSSID="$hidden" >/dev/null 2>/dev/null
	
		config_get rate "$dev" rate
		$DEBUG iwpriv "$device" set BasicRate="$rate"  >/dev/null 2>/dev/null
	
		config_get mode "$dev" mode
		case "$mode" in
			11bg)
				$DEBUG iwpriv "$device" set WirelessMode=0 >/dev/null 2>/dev/null
			;;
	
			11b)
				$DEBUG iwpriv "$device" set WirelessMode=1 >/dev/null 2>/dev/null
			;;
	
			11a)
				$DEBUG iwpriv "$device" set WirelessMode=2 >/dev/null 2>/dev/null
			;;
	
			11g)
				$DEBUG iwpriv "$device" set WirelessMode=4 >/dev/null 2>/dev/null
			;;
	
			11n)
				$DEBUG iwpriv "$device" set WirelessMode=6 >/dev/null 2>/dev/null
			;;
	
			11gn)
				$DEBUG iwpriv "$device" set WirelessMode=7 >/dev/null 2>/dev/null
			;;
	
			11an)
				$DEBUG iwpriv "$device" set WirelessMode=8 >/dev/null 2>/dev/null
			;;
	
			*|11bgn)
				$DEBUG iwpriv "$device" set WirelessMode=9 >/dev/null 2>/dev/null
			;;
		esac
	
		case "$mode" in
		*n)
			config_get channel_width "$dev" channel_width
			case "$channel_width" in
			40)
				$DEBUG iwpriv "$device" set HT_BW=1 >/dev/null 2>/dev/null
			;;
			*|20)
				$DEBUG iwpriv "$device" set HT_BW=0 >/dev/null 2>/dev/null
			;;
			esac
	
			config_get channel_ext "$dev" channel_ext
			case "$channel_ext" in
			0)
				$DEBUG iwpriv "$device" set HtExtcha=0
			;;
			*|1)
				$DEBUG iwpriv "$device" set HtExtcha=1
			;;
			esac
		;;
		*)
		;;
		esac

		config_get auth "$dev" auth
		config_get enc "$dev" encryption
		case "$auth" in
		open|shared)
			case "$enc" in
			WEP|wep)
				for idx in 1 2 3 4; do
					config_get key "dev" "key${idx}"
					$DEBUG iwpriv "$device" set Key${idx}Str=${key}
				done
				config_get key "$dev" key
				$DEBUG iwpriv "$device" set Key1Str=${key}
				case "$auth" in
				open) $DEBUG iwpriv "$device" set AuthMode=OPEN ;;
				shared) $DEBUG iwpriv "$device" set AuthMode=SHARED ;;
				esac
				$DEBUG iwpriv "$device" set EncrypType=WEP
				$DEBUG iwpriv "$device" set SSID="$ssid"
				;;
			*|none|NONE)
				$DEBUG iwpriv "$device" set AuthMode=OPEN
				$DEBUG iwpriv "$device" set EncrypType=NONE
				$DEBUG iwpriv "$device" set SSID="$ssid"
				;;
			esac ;;
		wpa|WPA|wpapsk|WPAPSK)
			config_get key "$dev" "key"
			$DEBUG iwpriv "$device" set WPAPSK="$key"
			$DEBUG iwpriv "$device" set AuthMode=WPAPSK
			case "$enc" in
			tkip|TKIP) $DEBUG iwpriv "$device" set EncrypType=TKIP ;;
			aes|AES) $DEBUG iwpriv "$device" set EncrypType=AES ;;
			esac
			$DEBUG iwpriv "$device" set SSID="$ssid"
			;;
		wpa2|WPA2|wpa2psk|WPA2PSK)
			config_get key "$dev" "key"
			$DEBUG iwpriv "$device" set WPAPSK="$key"
			$DEBUG iwpriv "$device" set AuthMode=WPA2PSK
			case "$enc" in
			tkip|TKIP) $DEBUG iwpriv "$device" set EncrypType=TKIP ;;
			aes|AES) $DEBUG iwpriv "$device" set EncrypType=AES ;;
			esac
			$DEBUG iwpriv "$device" set SSID="$ssid"
			;;
		esac
	
#		config_get enc "$dev" encryption
#		case "$enc" in
#			WEP|wep)
#				for idx in 1 2 3 4; do
#					config_get key "dev" "key${idx}"
#					iwpriv "$device" set Key${idx}Str=${key}
#				done
#	
#				config_get key "$dev" key
#				iwpriv "$device" set Key1Str=${key}
#	
#				iwpriv "$device" set AuthMode=SHARED
#				iwpriv "$device" set EncrypType=WEP
#				iwpriv "$device" set SSID="$ssid"
#			;;
#	
#			PSK|psk|WPA|wpa)
#				config_get key "$dev" key
#				iwpriv "$device" set WPAPSK=${key}
#	
#				iwpriv "$device" set AuthMode=WPAPSK
#				iwpriv "$device" set EncrypType=TKIPAES				
#				iwpriv "$device" set SSID="$ssid"
#			;;
#	
#			PSK2|psk2|WPA2|wpa2)
#				config_get key "$dev" key
#					iwpriv "$device" set WPAPSK=${key}
#	
#				iwpriv "$device" set AuthMode=WPA2PSK
#					iwpriv "$device" set EncrypType=TKIPAES				
#				iwpriv "$device" set SSID="$ssid"
#			;;
#			PSK1PSK2|psk1psk2|WPA1WPA2|wpa1wpa2)
#				config_get key "$dev" key
#				iwpriv "$device" set WPAPSK=${key}
#	
#				iwpriv "$device" set AuthMode=WPAPSKWPA2PSK
#				iwpriv "$device" set EncrypType=TKIPAES				
#				iwpriv "$device" set SSID="$ssid"
#			;;
#	
#			*|open|OPEN)
#				iwpriv "$device" set AuthMode=OPEN
#				iwpriv "$device" set EncrypType=NONE
#				iwpriv "$device" set SSID="$ssid"
#			;;
#		esac
	fi
done
}


detect_rt2870() {
        [ "$(cat /proc/bus/usb/devices | grep 15a9| grep 0006)" = "" ] && return
        cd /sys/class/net
        for dev in $(ls -d ra* 2>&-); do
        uci set wireless.${dev}.type=rt2870
        uci commit wireless
        done
    found=`uci get wireless.general.found`
    if [ "$found" = "0" ] ; then
    cd /sys/class/net
    ls -d ra* 2>&-
    if [ "$?" = "0" ] ; then
    echo "Ralink card found"
    uci set wireless.general.found=1
    uci set wireless.general.type=ra0
    uci set wireless.general.card=1
    uci commit wireless
    else
    uci set wireless.general.card=0
    uci commit wireless
    fi
    fi
}
