scan_pptp() {
	scan_ppp "$@"
}

setup_interface_pptp() {
	local iface="$1"
	local config="$2"
	local caller="$4"

	pptp_fpp_off=$(uci -q get pptpd_config.pptpd.disable_pptp_fpp || echo '1')
	[ "$pptp_fpp_off" == "0" ] && {
		logger -p local1.notice "Enable PPTP Acceleration"
		echo "Enable PPTP Acceleration" > /dev/console
		echo 1 > /proc/pptp_fpp
	} || {
		logger -p local1.notice "Disable PPTP Acceleration"
		echo "Disable PPTP Acceleration" > /dev/console
		echo 0 > /proc/pptp_fpp
	}

	config_get always_on "$config" pptp_always_on
	[ "$always_on" = "enable" -o "$caller" = "wcd" ] || return 0

	config_get device "$config" device

	#for module in crc-ccitt slhc ppp_generic ppp_async ppp_mppe pppox pptp ip_gre; do
	#	/sbin/insmod $module 2>&- >&-
	#done
	#sleep 1

	config_get pptp_over "$config" pptp_over
	setup_interface "$iface" "$config" "$pptp_over"

	config_get mtu "$config" pptp_mtu
	config_get server "$config" pptp_server
	mtu=${mtu:-1452}

#	server=$(/usr/bin/nslookup $server 2> /dev/null | awk '/Name:/,/Address:/{print $2}' | tail -n 1)
#	[ -z "$server" ] && return

	##### set a static route for pptp_server since default route will be replaced later
	server_gw=`json get network.$config.server_gw`
	over_ifname=`json get network.$config.over_ifname`
	sroute=$(route add -host $server gw $server_gw dev $over_ifname 2>/dev/null && echo 1 || echo 0)
	[ "$sroute" = "1" ] || {
		sleep 3
		sroute=$(route add -host $server gw $server_gw dev $over_ifname 2>/dev/null && echo 1 || echo 0)
		[ "$sroute" = "1" ] || return
	}
	#prevent pptp proto to use pppoe fixed IP case
	fixed_ip_option="noipdefault"
	
	start_pppd "$config" \
		$fixed_ip_option \
		plugin /usr/lib/pppd/2.4.3/pptp.so \
		pptp_server $server \
		file /etc/ppp/options.pptp \
		mtu $mtu mru $mtu nolzs
}
