#!/bin/sh
append DRIVERS "metalink"

scan_metalink() {
	local device="$1"
}


disable_metalink() (
	local device="$1"

	ifconfig "$device" down

	return 0
)

enable_metalink() {

	disable_metalink "$device"

	config_get channel "$device" channel
	iwconfig "$device" channel ${channel}

	config_get ssid "$device" ssid
	iwconfig "$device" essid ${ssid}
	iwconfig "$device" txpower 0

#	config_get fr_threshold "advance" fr_threshold
#	iwconfig "$device" frag "$fr_threshold"

	config_get rts_threshold "advance" rts_threshold
	iwconfig "$device" rts "$rts_threshold"

	echo 0x00000015	> /proc/sys/dev/mtlk/"$device"/BasicRateSet
	echo 20		> /proc/sys/dev/mtlk/"$device"/BeaconKeepaliveTimeout
	echo 0xffff80ff > /proc/sys/dev/mtlk/"$device"/OperateRateSet
	echo 1		> /proc/sys/dev/mtlk/"$device"/ShortSlotTimeOptionEnabled
	echo 0          > /proc/sys/dev/mtlk/"$device"/WDSEnabled

	config_get_bool hidden "$device" hidden 0
	echo "$hidden" > /proc/sys/dev/mtlk/"$device"/HiddenSSID

	config_get mode "$device" mode
	case "$mode" in
	*n)
		echo 1 > /proc/sys/dev/mtlk/"$device"/IsHTEnabled

		config_get channel_width "$device" channel_width
		case "$channel_width" in
		20)
			echo 0 > /proc/sys/dev/mtlk/"$device"/ChannelBonding
			;;

		*|40)
			echo 1 > /proc/sys/dev/mtlk/"$device"/ChannelBonding
			;;
		esac

		config_get channel_ext "$device" channel_ext
		case "$channel_ext" in
		0)
			echo 1 > /proc/sys/dev/mtlk/"$device"/UpperLowerChannelBonding
			;;

		*|1)
			echo 0 > /proc/sys/dev/mtlk/"$device"/UpperLowerChannelBonding
			;;
		esac

		;;

	*)
		echo 0 > /proc/sys/dev/mtlk/"$device"/IsHTEnabled
		;;
	esac


	config_get band "$device" band
	case "$band" in
	2.4)
		echo 1 > /proc/sys/dev/mtlk/"$device"/FrequencyBand
		;;

	5.2)
		echo 0 > /proc/sys/dev/mtlk/"$device"/FrequencyBand
		;;

	*|both)
		echo 2 > /proc/sys/dev/mtlk/"$device"/FrequencyBand
		;;
	esac


	config_get enc "$device" encryption
	case "$enc" in
	WEP|wep)
		for idx in 1 2 3 4; do
			config_get key "$device" "key${idx}"
			iwconfig "$device" enc "[$idx]" "${key:-off}"
		done

		config_get key "$device" key
		key="${key:-1}"
		case "$key" in
		[1234])
			iwconfig "$device" enc "[$key]"
			;;
		*)
			iwconfig "$device" enc "$key"
			;;
		esac

		;;

	PSK|psk|WPA|wpa)
		;;

	PSK2|psk2|WPA2|wpa2)
		;;

	*|open|OPEN)
		iwconfig "$device" enc off
		;;
	esac

	config_get ipaddr "$device" ipaddr
	if [ -n "$ipaddr" ]; then
		ifconfig "$device" $ipaddr
	fi

	config_get netmask "$device" netmask
	if [ -n "$netmask" ]; then
		ifconfig "$device" netmask $netmask
	fi

	ifconfig "$device" up
}


detect_metalink() {
	cd /sys/class/net

	for dev in $(ls -d wlan* 2>&-); do
		uci set wireless.${dev}.type=metalink
		uci commit wireless
	done

	found=`uci get wireless.general.found`

	if [ "$found" = "0" ]; then
		cd /sys/class/net
		ls -d wlan* 2>&-
		if [ "$?" = "0" ]; then
			echo "Metalink card found"
			uci set wireless.general.found=1
			uci set wireless.general.type=wlan0
			uci set wireless.general.card=1
			uci commit wireless
		else
			uci set wireless.general.card=0
			uci commit wireless
		fi
	fi
}
