#!/bin/sh

#Added by Vincent F. 2014/04/11
#Purpose of this script:
#Every time when interface up/down,
#  check policy route user defined table contents.

# DECLARATIONs----------------------------------------------------------
TAR=$1
ITF=$2

UCI_CONFIG="policy_rt"
M_CHAIN="POLICY_RT"
D_CHAIN="POLICY_RT_DROP"
M_OFFSET=1

POLICY_RT_DIR="/tmp/policy_rt/"
JSON="json -f ${POLICY_RT_DIR}json"
LOCKFILE="${POLICY_RT_DIR}lock"

need_failback=0
#----------------------------------------------------------------------

# Debug functions----------------------------------------------------------------
DBG_LOG() {
	echo "[policy_rt.sh][`date +%Y/%m/%d-%H:%M:%S`] $1" > /dev/console
	echo "[`date +%Y/%m/%d-%H:%M:%S`] $1" >> /tmp/dbg_log/policy_route.log
	return
}

DBG_PRINT() {
	#echo "[policy_rt.sh][`date +%Y/%m/%d-%H:%M:%S`] $1" > /dev/console
	return
}
#--------------------------------------------------------------------------------

# FUNCTIONs ===========================================================
cal_mark() { #input: $1(list_idx)
	local idx
	local mark
	idx=$(($1 + $1 + 1)) #last bit declare mark2 routing
	mark=`printf %x $idx`
	echo $mark
}

list_find() { #input: $1(profile_name)
	local idx

	idx=`$JSON get $1.i`
	[ "$idx" ] && echo $idx || echo 0
}

list_get_key() { #input: $1(profile_name)
	echo "`$JSON get $1.k`"
}
list_get_status() { #input: $1(profile_name)
	echo "`$JSON get $1.s`"
}
list_set_status() { #input: $1(profile_name), $2(status)
	#$2=1: route table is alive
	#$2=0: route table is dead
	#$2= : don't care 'cos failover is disabled
	$JSON set $1 s=$2
}

do_failover() { #input: $1(profile_name), $2(list_idx), $3(table_id)
	local mark
	local st_table
	local st
	local key
	local seq
	local fback
	mark=`cal_mark $2`

	#failover function
	st_table=`/usr/sbin/ip route show table $3`
	st=`list_get_status $1`
	if [ "$st" ]; then
		#handle failover
		if [ "$st" == "0" -a "$st_table" ]; then
			#activate
			key=`list_get_key $1`
			if [ "$key" ]; then
				[ "$key" != "null" ] && key=`echo "$key" |sed s/\;/\,/g` || key=
				seq=`uci get $UCI_CONFIG.$1.uciid`
				seq=$(($seq + $M_OFFSET))
				DBG_PRINT "iptables -t mangle -R $M_CHAIN $seq $key -j MARK2 --set-mark 0x$mark/0xff --action RETURN"
				/usr/sbin/iptables -t mangle -R $M_CHAIN $seq $key -j MARK2 --set-mark 0x$mark/0xff --action RETURN
				[ $? -eq 0 ] || DBG_LOG "failover fail: iptables -t mangle -R $M_CHAIN $seq $key -j MARK2 --set-mark 0x$mark/0xff --action RETURN"
				list_set_status $1 1
					
				#handle failback
				fback=`uci get $UCI_CONFIG.$1.failback`
				[ "$fback" == "enable" ] && need_failback=1
			else
				DBG_LOG "Fatal ERROR: lost $1 failover key!"
				list_set_status $1
			fi
		elif [ "$st" == "1" -a -z "$st_table" ]; then
			#stop
			key="-u -m mark2 --mark 0x0"
			seq=`uci get $UCI_CONFIG.$1.uciid`
			seq=$(($seq + $M_OFFSET))
			DBG_PRINT "iptables -t mangle -R $M_CHAIN $seq $key -j MARK2 --set-mark 0x$mark/0xff --action RETURN"
			/usr/sbin/iptables -t mangle -R $M_CHAIN $seq $key -j MARK2 --set-mark 0x$mark/0xff --action RETURN
			[ $? -eq 0 ] || DBG_LOG "failover fail: iptables -t mangle -R $M_CHAIN $seq $key -j MARK2 --set-mark 0x$mark/0xff --action RETURN"
			list_set_status $1 0
		fi
	else
		#failover disabled
		/usr/sbin/iptables -t mangle -D $D_CHAIN -m mark2 --mark 0x$mark/0xff -j DROP >/dev/null 2>&1
		if [ -z "$st_table" ]; then
			DBG_PRINT "DROP traffic with mark2 0x$mark/0xff"
			/usr/sbin/iptables -t mangle -A $D_CHAIN -m mark2 --mark 0x$mark/0xff -j DROP
		fi
		/usr/sbin/flush_route_cache.sh "policy_rt.sh" all 0 $mark/0xff
	fi
}
#======================================================================

#######################################################################
# Main ================================================================
[ "$TAR" -a "$ITF" ] || exit 0
[ -d $POLICY_RT_DIR ] || exit 0

#rule: wan load balance
if [ "$TAR" == "itf" -o "$TAR" == "lb" ]; then
	members=`uci filter $UCI_CONFIG out_rule wan_lb_pool`
	if [ "$members" ]; then
		/usr/sbin/draylock 300 $LOCKFILE 120 3 || exit 0
		for mem in $members ; do
			#check is related
			get=`uci get $UCI_CONFIG.$mem.out_pool`
			[ "$get" != "$ITF" ] && continue
			get=`uci get $UCI_CONFIG.$mem.status`
			[ "$get" != "enable" ] && continue

			#do failover
			list_idx=`list_find $mem`
			[ $list_idx -le 0 ] && continue
			table_id=`/sbin/get_route_table_id $ITF`
			do_failover $mem $list_idx $table_id
		done
		/usr/sbin/draylock -u $LOCKFILE
	fi
fi

#rule: user defined
if [ "$TAR" == "itf" ]; then
	members=`uci filter $UCI_CONFIG out_rule usr_defined`
	if [ "$members" ]; then
		#interface basic info.
		itf_phy=`uci get network.$ITF.physical`
		itf_st=`json get network.$ITF.connection`
		itf_ifname=`json get network.$ITF.ifname`

		/usr/sbin/draylock 300 $LOCKFILE 120 3 || exit 0
		for mem in $members ; do
			#check is related
			get=`uci get $UCI_CONFIG.$mem.out_itf`
			[ "$get" != "$ITF" ] && continue
			get=`uci get $UCI_CONFIG.$mem.status`
			[ "$get" != "enable" ] && continue

			#reset table and do failover
			list_idx=`list_find $mem`
			[ $list_idx -le 0 ] && continue
			gw=`uci get $UCI_CONFIG.$mem.out_gateway`
			if [ "$itf_phy" != "eth0" -a -z "$gw" ]; then
				table_id=`/sbin/get_route_table_id $ITF`
			else
				table_id=$(($list_idx + 10000))
				/usr/sbin/ip route flush table $table_id
				if [ "$itf_st" == "up" -a -n "$itf_ifname" ]; then
					[ "$gw" ] && via="via $gw" || via=
					DBG_PRINT "ip route add table $table_id default $via dev $itf_ifname"
					/usr/sbin/ip route add table $table_id default $via dev $itf_ifname
				fi
			fi
			do_failover $mem $list_idx $table_id
		done
		/usr/sbin/draylock -u $LOCKFILE
	fi
fi

#rule: ipsec
if [ "$TAR" == "ipsec" ]; then
	members=`uci filter $UCI_CONFIG out_rule ipsec`
	if [ "$members" ]; then
		/usr/sbin/draylock 300 $LOCKFILE 120 3 || exit 0
		DBG_PRINT "ITF:$ITF check ipsec:$members"
		if [ "a$ITF" != "a-any" ]; then
			for mem in $members ; do
				#check is related
				get=`uci get $UCI_CONFIG.$mem.out_ipsec`
				[ "$get" != "$ITF" ] && continue
				get=`uci get $UCI_CONFIG.$mem.status`
				[ "$get" != "enable" ] && continue
	
				#do failover
				list_idx=`list_find $mem`
				[ $list_idx -le 0 ] && continue
				table_id=`/sbin/get_route_table_id $ITF "" VPN_L2L_LB`
				do_failover $mem $list_idx $table_id
			done
		else
			for mem in $members ; do
				#get interface
				get=`uci get $UCI_CONFIG.$mem.status`
				[ "$get" != "enable" ] && continue
				get=`uci get $UCI_CONFIG.$mem.out_ipsec`

				#do failover
				list_idx=`list_find $mem`
				[ $list_idx -le 0 ] && continue
				table_id=`/sbin/get_route_table_id $get "" VPN_L2L_LB`
				do_failover $mem $list_idx $table_id
			done
		fi
		/usr/sbin/draylock -u $LOCKFILE
	fi
fi

#rule: pptp
if [ "$TAR" == "pptp" ]; then
	members=`uci filter $UCI_CONFIG out_rule pptp`
	if [ "$members" ]; then
		/usr/sbin/draylock 300 $LOCKFILE 120 3 || exit 0
		DBG_PRINT "ITF:$ITF check pptp:$members"
		for mem in $members ; do
			#check is related
			get=`uci get $UCI_CONFIG.$mem.out_pptp`
			[ "$get" != "$ITF" ] && continue
			get=`uci get $UCI_CONFIG.$mem.status`
			[ "$get" != "enable" ] && continue

			#do failover
			list_idx=`list_find $mem`
			[ $list_idx -le 0 ] && continue
			table_id=`/sbin/get_route_table_id_for_pptp $ITF`
			do_failover $mem $list_idx $table_id
		done
		/usr/sbin/draylock -u $LOCKFILE
	fi
fi

#do failback
if [ "$need_failback" == "1" ]; then
	DBG_PRINT "do failback"
	/usr/sbin/flush_route_cache.sh "policy_rt.sh"
	conntrack -F
fi
