#!/bin/sh

# Command:
# /usr/sbin/restart_lan_ipv6.sh [call_from] [status_changed_wan] [ipv6_prefix]

# Usage:
# This command will:
#   1) If lan's proto6=sla-wan and sla-wan=[status_changed_wan], re-ifup lan
#   2) If lan's proto6=link-local, set proto6=dhcp-sla and sla-wan=[status_changed_wan], then re-ifup lan.

# Parameters:
# [call_from]			: For debug use. To check where call this script.
# [status_changed_wan]	: Format is wan1.
# [ipv6_prefix]			: ex. 2001:b010:7030:1501::/64

# Examples:
# /usr/sbin/restart_lan_ipv6.sh DEBUG wan1 2001:b010:7030::/48
#     this command will re-ifup all LANs which proto6 is link-local or sla-wan is wan1.

CALL_FROM=$1
IFACE=$2
PRELEN=${3##*/}

DBG_PRINT() {
	#echo "[restart_lan_ipv6.sh][`date +%Y/%m/%d-%H:%M:%S`] $1" > /dev/console
	logger "[restart_lan_ipv6.sh][`date +%Y/%m/%d-%H:%M:%S`] $1"
	return
}

ifup_related_lan() {
	local get
	local proto6
	local check

	config_get get $1 status
	[ "$get" == "enable" ] || return

	config_get proto6 $1 proto6
	if [ "$proto6" == "dhcp-sla" ]; then
		config_get get $1 dhcp6_sla_wan
		[ "$get" == "$IFACE" ] || return

		DBG_PRINT "re-ifup dhcp-sla $1"
		/sbin/ifup $1
	elif [ "$proto6" == "link-local" ]; then
		config_get get $1 physical
		[ "$get" == "eth0" ] || return

		check=0
		if [ $PRELEN -le 56 ]; then
			#configure multiple LANs with different sla-id
			check=1
		elif [ $active_lans -eq 0 -a $sla_id -eq $sla_id_from ]; then
			#only configure 1 LAN
			check=1
		fi

		#auto configure lan IPv6. If prefix length > 56, only configure 1 lan
		[ $check -eq 1 ] && {
			uci set network.$1.proto6=dhcp-sla
			sla_id=$(($sla_id + 1))
			uci set network.$1.dhcp6_sla_id=$sla_id
			uci set network.$1.dhcp6_sla_wan=$IFACE
			uci commit network.$1

			DBG_PRINT "set $1 link-local to dhcp-sla $IFACE with sla_id $sla_id and re-ifup"
			/sbin/ifup $1
		}
	fi
}

cnt_active_lan() {
	local get
	config_get get $1 proto6
	[ "$get" == "dhcp-sla" ] || return
	#config_get get $1 dhcp6_sla_wan
	#[ "$get" == "$IFACE" ] || return
	config_get get $1 status
	[ "$get" == "enable" ] || return

	active_lans=$(($active_lans + 1))
	config_get get $1 dhcp6_sla_id
	[ "$get" ] || get=0
	[ $sla_id_from -lt $get ] && sla_id_from=$get
}

[ "$IFACE" ] || exit 0
[ "$PRELEN" ] || PRELEN=64
DBG_PRINT "Call from $CALL_FROM, status_changed_wan: $IFACE, prefix_len: $PRELEN"

. /etc/functions.sh
config_load network
active_lans=0
sla_id_from=0
config_foreach cnt_active_lan #count LANs which sla_wan is $IFACE
sla_id=$sla_id_from
config_foreach ifup_related_lan
