#####
# This script call iptstate with different table option(nat ,local ,openport) to print different session table.
# And build INTERFACE_IP_FILE to store interface's ip for iptstate to change ip into interface name.
#####

#!/bin/sh
INTERFACE_IP_FILE=/tmp/interface_ip_file
VPN_SUBNET_FILE=/tmp/vpn_subnet_file

#table_option: nat ,local ,openport ,vpn
table_option=$1

#find up interface
grep_up=$(json show network | grep 'connection=up')
interfaces=$(echo -e "$grep_up" | awk -F '.' '{print $2}')

#remove old INTERFACE_IP_FILE
if [ -f $INTERFACE_IP_FILE ];then
	rm $INTERFACE_IP_FILE
fi

#print new INTERFACE_IP_FILE
for tmp_if in $interfaces
do
	tmp_ip=$(json get network.$tmp_if.ipaddr)
	if_name=$(json get network.$tmp_if.ifname)
	if [ "$tmp_ip" != "" ];then
		echo $if_name $tmp_ip >> $INTERFACE_IP_FILE
	fi
	tmp_ip6=$(json get network.$tmp_if.ip6addr | awk -F '/' '{print $1}')
	if [ "$tmp_ip6" != "" ];then
		echo $if_name $tmp_ip6 >> $INTERFACE_IP_FILE
	fi
	alias=$(json get network.$tmp_if.ip_alias)
	if [ "$alias" != "" ];then
		json get network.$tmp_if.ip_alias | sed 's/ /\n/g' | awk -F '/' -v ifn="$if_name " '{print ifn $1}' >> $INTERFACE_IP_FILE
	fi
done


#ipset -nL exception_subnet_set
#ipset -nL exception_subnet_gre_set
if [ "$table_option" == "vpn" ];then

	#remove old VPN_SUBNET_FILE
	if [ -f $VPN_SUBNET_FILE ];then
		rm $VPN_SUBNET_FILE
	fi
	ipset -nL exception_subnet_set | grep -A 100 "Members" | grep -v "Members:" >> $VPN_SUBNET_FILE
	ipset -nL exception_subnet_gre_set | grep -A 100 "Members" | grep -v "Members:" >> $VPN_SUBNET_FILE
	ifconfig | grep -A 1 -e "^ppp[123][0-9][0-9][0-9][ ]* Link encap:Point-to-Point Protocol" | grep P-t-P |awk -F ' ' '{print $3}'| sed 's/P-t-P://g' >> $VPN_SUBNET_FILE
	#
	#	ppp0 ~ ppp999 : PPPoE server  <===== NOT SUPPORT THIS
	#	ppp1000 ~ ppp1999 : pptp
	#	ppp2000 ~ ppp2999 : l2tp
	#	ppp3000 ~ ppp3999 : sslvpn
	#
fi

#call iptstate
if [ "$table_option" == "nat" ];then
	iptstate  -1 -t -p -o -Z nat
elif [ "$table_option" == "local" ];then
	iptstate  -1 -t -p -o -Z local
elif [ "$table_option" == "openport" ];then
	iptstate  -1 -t -p -o -Z openport
elif [ "$table_option" == "vpn" ];then
	iptstate  -1 -t -p -o -Z vpn
else
	iptstate  -1 -t -p -o
fi