#!/bin/sh

profile_id=$1
MSG=$2
MSG_TYPE=$3
#echo "profile_id="$profile_id

MAIL_PROFILE=$(uci -q get config_mail_alert.$profile_id.mail_profile)
NOTIFY_PROFILE=$(uci -q get config_mail_alert.$profile_id.notify_profile)

routername=$(uci get syslogd.syslogd.routername)
model_name=$(uci get device_info.deviceinfo.ModelName)
date=$(eval date -R)

GET_MAIL_ALERT_SUBJECT () {
	profile=$1
	msg_type=$2

	FLAG=$(uci -q get config_notify.$profile.wan_dis)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "1" ]; then
		echo "[Mail Alert] from ${routername:-$model_name} [WAN Disconnect]"
		return
	fi

	FLAG=$(uci -q get config_notify.$profile.wan_con)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "2" ]; then
		echo "[Mail Alert] from ${routername:-$model_name} [WAN Connect]"
		return
	fi

	FLAG=$(uci -q get config_notify.$profile.vpn_dis)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "3" ]; then
		echo "[Mail Alert] from ${routername:-$model_name} [VPN Disconnect]"
		return		
	fi

	FLAG=$(uci -q get config_notify.$profile.vpn_con)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "4" ]; then
		echo "[Mail Alert] from ${routername:-$model_name} [VPN Connect]"
		return
	fi

	FLAG=$(uci -q get config_notify.$profile.temper)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "5" ]; then
		echo "[Mail Alert] from ${routername:-$model_name} [Temper]"
		return
	fi
	
	FLAG=$(uci -q get config_notify.$profile.router_reboot)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "6" ]; then
		echo "[Mail Alert] from ${routername:-$model_name} [Router Reboot]"
		return
	fi
	
	FLAG=$(uci -q get config_notify.$profile.syslog)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "99" ]; then
		echo "[Mail Alert] from ${routername:-$model_name} [Router Syslog]"
		return
	fi

	return 0
}


status=$(uci -q get config_mail.$MAIL_PROFILE.status)
if [ "$status" = "disable" ]; then
exit
fi

mailto=$(uci -q get config_mail_alert.$profile_id.recip)
if [ "$mailto" = "" ]; then
exit
fi

smtpserver=$(uci -q get config_mail.$MAIL_PROFILE.smtpserver)
if [ "$smtpserver" = "" ]; then
exit
fi 

smtpport=$(uci -q get config_mail.$MAIL_PROFILE.smtpport)
if [ "$smtpport" = "" ]; then
exit
fi 

ssl_tls=$(uci -q get config_mail.$MAIL_PROFILE.ssl_tls)

user_login=$(uci -q get config_mail.$MAIL_PROFILE.user_login)

user_name=$(uci -q get config_mail.$MAIL_PROFILE.user_name)

user_password=$(uci -q get config_mail.$MAIL_PROFILE.user_password)

mailfrom=$(uci -q get config_mail.$MAIL_PROFILE.mailfrom)

ip_regex="[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}"
echo "$smtpserver" | grep -o "$ip_regex" >/dev/null
if [ "$?" == "0" ] ;then
	mail_server_ip=$smtpserver
else
	mail_server_ip=$(echo $(nslookup "$smtpserver" 2>/dev/null) |  grep -o "Name:.*" | grep -o "$ip_regex")
fi
/usr/sbin/flush_route_cache.sh mail_alert_updater 0 $mail_server_ip


rm /etc/msmtprc
#echo account default > /tmp/mail_alert/msmtprc_mailalert
echo host $smtpserver > /tmp/mail_alert/msmtprc_mailalert
echo port $smtpport >> /tmp/mail_alert/msmtprc_mailalert
if [ "$ssl_tls" = "enable" ];then
	echo "tls on" >> /tmp/mail_alert/msmtprc_mailalert
	echo "tls_certcheck off" >> /tmp/mail_alert/msmtprc_mailalert
	starttls=$(uci -q get config_mail.$MAIL_PROFILE.starttls)
	if [ "$starttls" = "enable" -o "$smtpport" = "587" ];then
		echo "tls_starttls on" >> /tmp/mail_alert/msmtprc_mailalert
	else
		echo "tls_starttls off" >> /tmp/mail_alert/msmtprc_mailalert
	fi
fi
if [ "$user_login" == "enable" ];then
if [ "$ssl_tls" = "enable" ];then
		echo auth on >> /tmp/mail_alert/msmtprc_mailalert
	else
		echo auth login >> /tmp/mail_alert/msmtprc_mailalert
	fi
	echo user $user_name >> /tmp/mail_alert/msmtprc_mailalert
	echo password $user_password >> /tmp/mail_alert/msmtprc_mailalert
else
	echo auth off >> /tmp/mail_alert/msmtprc_mailalert
fi        
echo auto_from off >> /tmp/mail_alert/msmtprc_mailalert
echo from $mailfrom >> /tmp/mail_alert/msmtprc_mailalert
echo logfile  /var/mail_alert.log >> /tmp/mail_alert/msmtprc_mailalert

echo "set sendmail=\"/usr/bin/msmtp --file=/tmp/mail_alert/msmtprc_mailalert\"" > /tmp/mail_alert/muttrc
echo set use_from=yes >> /tmp/mail_alert/muttrc
echo set from=$mailfrom >> /tmp/mail_alert/muttrc
echo set envelope_from=yes  >> /tmp/mail_alert/muttrc
echo set realname=\"$mailfrom\" >> /tmp/mail_alert/muttrc
echo set copy=no >> /tmp/mail_alert/muttrc

subject=$(GET_MAIL_ALERT_SUBJECT $NOTIFY_PROFILE $MSG_TYPE)
echo "subject=$subject"

if [ "$3" == "99" ] ;then
	syslog_file="/tmp/mail_alert/$2.tar.gz"
	if [ ! -f $syslog_file ]; then
		bad_mail=`grep -r "$2" /tmp/mail_alert/outbox/ | awk -F ':' '{print $1}'`
		rm -f $bad_mail
		rm -f /tmp/mail_alert/$2
		exit
	fi
	
	mail_msg="$(cat /tmp/mail_alert/$2)\n$date"
	echo -e $mail_msg | mutt -F /tmp/mail_alert/muttrc -s "$subject" $mailto -a $syslog_file >/dev/null 2>&1
	if [ "$?" = "0" ]; then
		echo "rm outbox $4"
		rm -f $4
		rm -f /tmp/mail_alert/$2
		rm -f $syslog_file
	fi
else
	echo "$2" > /tmp/mail_alert/content
	echo $date >> /tmp/mail_alert/content
	
	cat /tmp/mail_alert/content | mutt -F /tmp/mail_alert/muttrc -s "$subject" $mailto >/dev/null 2>&1
	if [ "$?" = "0" ]; then
		echo "rm outbox $4"
		rm -f $4
		rm -f /tmp/mail_alert/content
	fi
fi

