#!/bin/sh

. /etc/functions.sh

#####====MAIL/SMS ALERT CODE====#####
#WAN_DIS				1			#
#WAN_CONN				2			#
#VPN_DIS				3			#
#VPN_CONN				4			#
#TEMP					5			#
#REBOOT					6			#
#####################################

myPath="/tmp/sms/outbox"

if [ ! -x "$myPath" ]; then
	mkdir $myPath -p
	echo "create folder"
fi

check_SMS_ALERT_Status () {
	profile_id=$1
	msg_type=$2

	FLAG=$(uci -q get config_notify.$profile_id.wan_dis)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "1" ]; then
		echo 1
		return
	fi

	FLAG=$(uci -q get config_notify.$profile_id.wan_con)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "2" ]; then
		echo 1
		return
	fi

	FLAG=$(uci -q get config_notify.$profile_id.vpn_dis)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "3" ]; then
		echo 1
		return		
	fi

	FLAG=$(uci -q get config_notify.$profile_id.vpn_con)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "4" ]; then
		echo 1
		return
	fi

	FLAG=$(uci -q get config_notify.$profile_id.temper)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "5" ]; then
		echo 1
		return
	fi
	
	FLAG=$(uci -q get config_notify.$profile_id.router_reboot)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "6" ]; then
		echo 1
		return
	fi

	return 0
}

check_SMS_ALERT_SMS_Profile_quota(){

	profile_id=$1
	quota=$(uci -q get config_sms.$profile_id.quota)
	if [ "$quota" == "0" ]; then
		echo 0
		return
	fi

	echo 1
	return
}

MSG_TYPE=$1
MSG=$2

		for i in $(seq 1 10)
		do
			SMS_ALERT_PROFILE=$i
			#echo "SMS_ALERT_PROFILE=$SMS_ALERT_PROFILE"

			SMS_ALERT_ENABLE=$(uci -q get config_sms_alert.$i.status)
			#echo "SMS_ALERT_ENABLE=$SMS_ALERT_ENABLE"

			if [ "$SMS_ALERT_ENABLE" != "enable" ]; then
				#echo ">>contiune"
				continue
			fi
			NOTIFY_PROFILE=$(uci -q get config_sms_alert.$i.notify_profile)
			#echo "NOTIFY_PROFILE=$NOTIFY_PROFILE"
			
			NOTIFY_ENABLE=$(check_SMS_ALERT_Status $NOTIFY_PROFILE $MSG_TYPE)
			#echo "NOTIFY_ENABLE=$NOTIFY_ENABLE"
			
			if [ "$NOTIFY_ENABLE" == "1" ]; then
				SMS_PROFILE=$(uci -q get config_sms_alert.$i.sms_profile)
				#echo "SMS_PROFILE=$SMS_PROFILE"
				SMS_PROFILE_QUOTA=$(check_SMS_ALERT_SMS_Profile_quota $SMS_PROFILE)
				#echo "SMS_PROFILE_QUOTA=$SMS_PROFILE_QUOTA"
				if [ "$SMS_PROFILE_QUOTA" -gt "0" ]; then
					#echo "do shell"

					file_time=`date +%Y_%m%d_%H%M%S`
					echo "file_time=$file_time"
					mydir="$myPath/$file_time"
					echo "mydir=$mydir"
					$cat > $mydir

					filetowrite="$SMS_ALERT_PROFILE##<<##>>##$MSG"
					echo $filetowrite > $mydir

				fi
			fi
		done
return 0