#!/bin/sh

daily()
{
	user=`uci filter appuser quota_rst_freq everyday`
	[ -n "$user" ] && {
		for item in $user; do
			uci set appuser.$item.time_used=0
			uci set appuser.$item.traffic_used=0
			uci set appuser.$item.time_proportion=0/`uci get appuser.$item.quota_time`
			uci set appuser.$item.traffic_proportion=0/`uci get appuser.$item.quota_traffic`
		done
		uci commit appuser
	}
}

monthly()
{
	user=`uci filter appuser quota_rst_freq everymonth`
	[ -n "$user" ] && {
		for item in $user; do
			uci set appuser.$item.time_used=0
			uci set appuser.$item.traffic_used=0
			uci set appuser.$item.time_proportion=0/`uci get appuser.$item.quota_time`
			uci set appuser.$item.traffic_proportion=0/`uci get appuser.$item.quota_traffic`
		done
		uci commit appuser
	}
}

case "$1" in
"daily")
	daily
;;
"monthly")
	monthly
;;
*)
;;
esac
