#!/bin/sh


app_call_sch()
{
	local status
	local startdate
	local enddate
	local starttime
	local endtime
	local weekdays
	local frequency
	local operation
	local interface
	local type
	local date_act
	local time_act
	local freq_act
	local start
	local stop
	local tmp
	local starthead
	local starttail
	local endhead
	local endtail

	config_get status $1 status
	config_get startdate $1 startdate
	config_get enddate $1 enddate
	config_get starttime $1 starttime
	config_get endtime $1 endtime
	config_get weekdays $1 weekdays
	config_get frequency $1 frequency
	config_get type $1 type

	tzlevel=$(cat /etc/TZ | cut -c 4-5)

	if [ -s /etc/TZ ] ;then
		starthead=$(echo $starttime | cut -d':' -f 1)
	    starthead=$(expr $starthead + $tzlevel)
		if [ "$starthead" -lt 0  ] ;then
			starthead=$(expr $starthead + 24)
		fi
		starttail=$(echo $starttime | cut -d':' -f 2,3)
	else
		starthead=$(echo $starttime | cut -d':' -f 1)	
		starttail=$(echo $starttime | cut -d':' -f 2,3)	
	fi
	

	if [ -s /etc/TZ ] ;then
		endhead=$(echo $endtime | cut -d':' -f 1)
	    endhead=$(expr $endhead + $tzlevel)
		if [ "$endhead" -lt 0  ] ;then
			endhead=$(expr $endhead + 24)
		fi
		endtail=$(echo $endtime | cut -d':' -f 2,3)
	else
		endhead=$(echo $endtime | cut -d':' -f 1)	
		endtail=$(echo $endtime | cut -d':' -f 2,3)	
	fi

	if [ "$frequency" = "once" ];then
		if [ "$type" = "date_to_date" ];then
			if [ "$startdate" != "" ] && [ "$enddate" != "" ] && [ "$starttime" != "" ] && [ "$endtime" != "" ] ;then
				date_act="--datestart ${startdate}T${starttime} --datestop ${enddate}T${endtime} --utc"	
			fi 
		else
			freq_act=""
			if [ "$starttime" != "" ] && [ "$endtime" != "" ] ;then
				date_act=" --timestart $starthead:$starttail --timestop $endhead:$endtail $freq_act "	
			fi	
		fi	
	else
		
		tmp=$(echo $weekdays | sed -r "s/[ ]+/,/g")
		
		if [ "$weekdays" == "" ];then
			freq_act=""
		else
			freq_act=" --weekdays $tmp"
		fi
		
		if [ "$starttime" != "" ] && [ "$endtime" != "" ] && [ "$weekdays" != "" ];then
			date_act=" --timestart $starthead:$starttail --timestop $endhead:$endtail $freq_act "		
		fi 
	fi
	
	time_schedule="-m time $date_act"	
	
}

sch_match_string()
{
	config_load call_sch
	app_call_sch $1
}