ext=$(word $(words $(subst ., ,$(1))),$(subst ., ,$(1)))

# unpacking files with +s may break on some platforms. this typically emits error code 2
ifneq ($(HOST_OS),Linux)
  HOST_TAR:=trapret 2 $(TAR)
else
  HOST_TAR:=$(TAR)
endif
TAR_CMD:= $(HOST_TAR) -C $(PKG_SRC_DIR)/.. $(TAR_OPTIONS)
UNZIP_CMD:= unzip -d $(PKG_SRC_DIR)/.. $(DL_DIR)/$(PKG_SOURCE)

ifeq ($(PKG_SOURCE),)
  PKG_UNPACK_SRC ?= true
endif
ifeq ($(strip $(PKG_UNPACK_SRC)),)
  ifeq ($(strip $(PKG_CAT)),)
    # try to autodetect file type
    EXT:=$(call ext,$(PKG_SOURCE))
    EXT1:=$(EXT)

    ifeq ($(filter gz tgz,$(EXT)),$(EXT))
      EXT:=$(call ext,$(PKG_SOURCE:.$(EXT)=))
      UNPACK:=gzip -dc $(DL_DIR)/$(PKG_SOURCE) |
    endif	
    ifeq ($(filter bzip2 bz2 bz tbz2 tbz,$(EXT)),$(EXT))
      EXT:=$(call ext,$(PKG_SOURCE:.$(EXT)=))
      UNPACK:=bzcat $(DL_DIR)/$(PKG_SOURCE) |
    endif
    ifeq ($(filter tgz tbz tbz2,$(EXT1)),$(EXT1))
      EXT:=tar
    endif
    UNPACK ?= cat $(DL_DIR)/$(PKG_SOURCE) |
    ifeq ($(EXT),tar)
      PKG_UNPACK_SRC:=$(UNPACK) $(TAR_CMD)
    endif
    ifeq ($(EXT),cpio)
      PKG_UNPACK_SRC:=$(UNPACK) (cd $(PKG_SRC_DIR)/..; cpio -i -d)
    endif
    ifeq ($(EXT),zip)
      PKG_UNPACK_SRC:=$(UNZIP_CMD)
    endif
  endif
 
  # compatibility code for packages that set PKG_CAT
  ifeq ($(strip $(PKG_UNPACK_SRC)),)
    # use existing PKG_CAT
    PKG_UNPACK_SRC:=$(PKG_CAT) $(DL_DIR)/$(PKG_SOURCE) | $(TAR_CMD)
    ifeq ($(PKG_CAT),unzip)
      PKG_UNPACK_SRC:=$(UNZIP_CMD)
    endif
    # replace zcat with $(ZCAT), because some system don't support it properly
    ifeq ($(PKG_CAT),zcat)
      PKG_UNPACK_SRC:=gzip -dc $(DL_DIR)/$(PKG_SOURCE) | $(TAR_CMD)
    endif
  endif
  ifneq ($(strip $(CRLF_WORKAROUND)),)
    PKG_UNPACK_SRC += && find $(PKG_SRC_DIR) -type f -print0 | xargs -0 perl -pi -e 's!\r$$$$!!g'
  endif
endif
