/*
 * Copyright (C) 2004 LSIIT Laboratory.
 * Universit Louis Pasteur, Strasbourg, France.
 * All rights reserved.
 *
 * Original version by Christophe Jelger (jelger@dpt-info.u-strasbg.fr)
 * Developed by Frdric Beck (beck@startx.u-strasbg.fr)
 * Currently maintained and updated by Christophe Jelger
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* Sends a SIGUSR1 signal to the proxy, waits for it to write the stat file, and prints the result */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <fcntl.h>

int main(void)
{
	FILE *stat_f, *pid_f;
	char buffer[256];
	pid_t pid;

	if ( (pid_f = fopen("/var/run/MLD_Proxy.pid", "r")) != NULL )
	{
		if(fgets(buffer, 255,pid_f) != '\0')
		{
			sscanf( buffer, "%d", &pid);
			printf("Sending SIGUSR1 to proccess %d...\n", pid);
			kill(pid,SIGUSR1);
		}
	}
	else
	{
		perror("fopen MLD_Proxy.pid");
		exit(-1);
	}
	
	sleep(2);	/* waits until the stat file is generated */
	
	if ( (stat_f = fopen("./MLD_Proxy.stat", "r")) != NULL )
	{
		while(fgets(buffer, 255,stat_f) != '\0')
		{
			printf("\t%s",buffer);
		}
	}
	else
	{
		perror("fopen MLD_Proxy.stat");
		exit(-1);
	}
	
	
	return 0;
}
