/*
 * Copyright (C) 2004 LSIIT Laboratory.
 * Universit Louis Pasteur, Strasbourg, France.
 * All rights reserved.
 *
 * Original version by Christophe Jelger (jelger@dpt-info.u-strasbg.fr)
 * Developed by Frdric Beck (beck@startx.u-strasbg.fr)
 * Currently maintained and updated by Christophe Jelger
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/**
 * The Global header file which holds the definitions used by all the 
 * classes and files of the daemon
 */

#ifndef _MLD_PROXY_H_
#define _MLD_PROXY_H_


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/ethernet.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>
#include <linux/if_packet.h>
#include <netinet/in.h>
#include <netinet/ip6.h>
#include <netinet/icmp6.h>
#include <netinet/udp.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <fcntl.h>
#include <bits/ioctls.h>
#include <asm/byteorder.h>
#include <string.h>
#include <time.h>
#include "MLD_MN.h"
#include "MLD_forward.h"
#include "MLD_membership.h"


/*   DEFINE   */
/** no log_file */
#define	QUIET		0		
/** log_file level standard */
#define	NORMAL		1		
/** log_file verbose */
#define	VERBOSE		2		
/** Boolean true */
#define	TRUE		1		
/** Boolean false */
#define	FALSE		0		
/** Link local scope */
#define	MC_LINK		10		
/** Site scope */
#define	MC_SITE		11		
/** Scope global */
#define	MC_GLOBAL	12		
/** ASM model */
#define	MC_ASM		3		
/** SSM model */
#define	MC_SSM		4		
/** Both models are available */
#define	MC_BOTH		5		
/** Filter include mode */
#define	MC_INCLUDE	51		
/** Filter exclude mode */
#define	MC_EXCLUDE	61		
/** Default value of the timer on a group forwarding entry for an interface */
#define	ENTRY_VAL	300	

/** IPv6 Link Local scope */
#define IPV6_LINKLOCAL 0x20
/** IPv6 Global scope */
#define IPV6_GLOBAL 0x00
/** Size of the buffer to receive MLD messages */
#define MLD_BUFFER_SIZE 1024
/** Size of the buffer to receive data messages */
#define DATA_BUFFER_SIZE 2048

/** Length of e General MLDv1 Query */
#define V1_QUERY_SIZE 24
/** Length of e General MLDv2 Query */
#define V2_QUERY_SIZE 28
/* this is use to build a HOP-by-HOP router alert option in function send_v1_report */
#define IPV6_TLV_PADN 1
#define IPV6_TLV_ROUTERALERT 5

#define CHECK_TIMER_PERIOD 1
#define DELAY_BEFORE_NEW_QUERY 10

/* to send last query just before timer expires for an interface/group */
char last_query[128];
int last_query_size;
struct sockaddr_ll last_query_ll;

/* VARIABLES */

/** The file descriptor for the log file */
extern FILE * log_file;
/** The debug level in which the daemon runs, which is QUIET,NORMAL or VERBOSE */ 
extern int debug_lvl;
/** The multicast mode in which the daemon runs */
extern int mc_mode;
/** The name of the LAN interface used to join multicast groups instead of the mobiles */
extern char int_lan[16];
/** The number of mipv6 tunels */
extern int nb_tunnel ;
/** The number after the prefixe for the first tunnel */
extern int first_index;
/** The prefixe used to identify the tunnels */
extern char prefixe_tunnel[16];
/** The scopes of the multicast groups which the daemon forwards */
extern int fwd_scope;
/** If this flag is set to TRUE, the daemon forwards the data sent by the MN, else if at FALSE it doesn't */
extern int mn_src;
/** If this flag is set to TRUE, the daemon sends automatic MLDv1 reports after receiving a MLDv2 one, else if at FALSE it doesn't */
extern int immediate_report_v1;
/** The value of the timer of an entry in the forwarding table */
extern int entry_validity;
/** The Forwarding Table */
extern forward_t *fwd_tab;
/** The MN Table */
extern MN_t *mn_tab;
/** The Membership Table */
extern membership_t member_tab;

/** Socket used to join multicast groups on behalf of mobile nodes, i.e. on the LAN interface */
extern int sock_lan;
/** Socket to receive MLD reports from the mobile nodes */
extern int sock_mld;
/** Socket used to forward multicast data to the mobile nodes */
extern int sock_fwd;	/* used to forward with PF_PACKET and SOCK_DGRAM (give sockaddr_ll, not ethernet header) */

/* index for LAN and ADHOC interfaces */

extern int int_lan_id;
extern int int_adhoc_id;
char int_adhoc[16];
struct in6_addr lan_global_addr;

/** The structure of a MLDv1 report */
struct mld6_v1_hdr {
	/** The ICMPv6 structure */
	struct icmp6_hdr	mld_icmp6_hdr;
	/** The IPv6 address of the multicast group */
	struct in6_addr		mld6_addr;
};

/** The structure of a MLDv2 Group record */
struct mld6_v2_hdr {
	/** The type of the record : Change to exclude mode... */
	char			mode;
	/** The length of the auxiliary data */
	char 			aux_data_len;
	/** The number of sources */
	u_int16_t 		num_src;
	/** The group address */
	struct in6_addr 	mld6_addr;
	/* Here are the sources addresses, will be acceded with pointers when necessary */
};


/** The structure of a MLD Query */
struct mld6_v2_query{
	/** The ICMPv6 structure */
	struct icmp6_hdr	mld_icmp6_hdr;
	/** IPv6 address of the multicast group */
	struct in6_addr		grp_addr;
	/** Zero */
	u_int16_t zero2;
	/** Number of sources */
	u_int16_t nb_src;
	/* nb_src struct in6_addr to identify the sources */
};

/* definitions for MLDv2 from icmpv6.h*/
#define MLD2_MODE_IS_INCLUDE	1
#define MLD2_MODE_IS_EXCLUDE	2
#define MLD2_CHANGE_TO_INCLUDE	3
#define MLD2_CHANGE_TO_EXCLUDE	4
#define MLD2_ALLOW_NEW_SOURCES	5
#define MLD2_BLOCK_OLD_SOURCES	6

/* this must be an IANA-assigned value; 206 for testing only -> here we give both values to ensure compatibility */
#define ICMPV6_MLD2_REPORT		143
#define ICMPV6_MLDv2_REPORT		206

/* special messages for SAFARI forwarder */

#define ICMP6_SPEC_MSG	  210
#define ICMP6_SPEC_REPORT 1
#define ICMP6_SPEC_QUERY  2

/* this is use to build a HOP-by-HOP router alert option in function send_v1_report */
#define IPV6_TLV_PADN 1
#define IPV6_TLV_ROUTERALERT 5


/* FUNCTIONS */
/** Reads the configuration file and set the global variables to the right value */
void read_conf_file();
/** Gets the IPv6 address of an interface in the /proc/net/if_inet6 file
 * @param if_index The system index of the interface, IPV6_LINKLOCAL or IPV6_GLOBAL
 * @param scope The scope of the interface address
 * @param addr The structure where we save the address
 * @return 0 on success, -1 on error
 */

int get_v6_addr( int if_index, int scope, struct in6_addr * addr );
/**
 * The handler called if the daemon is stopped
 * @param sig The signal identifier
*/
void handler_quit(int sig);
/**
 * The handler called if stat printing is asked
 * @param sig The signal identifier
*/
void handler_stat(int sig);

/**
 * Called with SIGALRM every 2 seconds to check the timers
*/
void check(int sig);

/**
 * Write the PID in a file named MLD_Proxy.pid in /var/run/
 * @param pid The PID of the daemon
 * @return TRUE on success, FALSE otherwise
*/
int write_pid(pid_t pid);

/**
 * Initialisation of the socket on the lan interface, used to join groups on behalf the mobile nodes
 * @return TRUE if success, FALSE otherwise
 */
int init_sock_lan();
/**
 * Initialisation of the socket used to receive MLD Reports
 * @return TRUE if success, FALSE otherwise
 */
int init_sock_mld();
/**
 * Initialisation of the socket used to forward data to the mobile nodes
 * @return TRUE if success, FALSE otherwise
 */
int init_sock_fwd();

/**
 * Function called if a MLD message is received on sock_mld
 * @return TRUE on succes,FALSE otherwise
 */
int mld_rcv();

/**
 * Function called if multicast data are received on sock_lan 
 * @return TRUE on success, FALSE otherwise
 */
 int fwd_rcv();
 
/**
 * Build and send a MLDv1 Report for the given group on the givzen interface
 * @param grp_addr The Group Address
 * @param oif The interface on which send the report
 * @return 0 on SUCCESS, -1 otherwise
 */
int send_v1_report( struct in6_addr grp_addr, int oif );

/**
 * Build and send a MLDv1 Query 
 * @param iface The interface identifier on which send the MLD Query
 * @return 0 on SUCCESS, -1 otherwise
 */
int send_general_query(int iface);


/**
 * Print stats on the packets sent and received for each MN and group
 * @param fwd_list The forwarding table
 * @param mn_list The MN list
 * @param list The MN list
*/
void print_stat(forward_t *fwd_list, MN_t *mn_list);

/**
 * Print stats on the packets sent and received for each MN and group
 * @param fwd_list The forwarding table
 * @param mn_list The MN list
 * @param list The MN list
*/
void fprint_stat(forward_t *fwd_list, MN_t *mn_list);

#endif
