/* -- updatedd: dyndns.h --
 *
 * Copyright (C) 2002, 2003, 2004 Philipp Benner
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <ret_codes.h>

#define DYNDNSHOST    "members.dyndns.org"
#define NOIPHOST      "dynupdate.no-ip.com"
#define DTDNSHOST     "www.dtdns.com"
#define CHANGEIPHOST  "www.changeip.com"
#define HUAGAIHOST    "huagai.net"
#define DYNNAMESERVER "au.dynamic-nameserver.com"
#define _3322HOST     "members.3322.org"
#define VIGORDDNS     "ns1.vigorddns.com"
#define STRATODDNS    "dyndns.strato.com"

#define PORT        80
#define IPLEN       16

char *STR_Service_Provider[] = {DYNDNSHOST, NOIPHOST, DTDNSHOST, CHANGEIPHOST, HUAGAIHOST, DYNNAMESERVER, _3322HOST, VIGORDDNS, STRATODDNS};

#define BUFSIZE        512

struct arguments;

typedef int (*FUNC_UPDATE)(const int s, struct arguments *args);

struct arguments {
    int  enable;
    char interface[8];
    int  service_provider;
    char system[16];
    char hostname[128];
    char login[64];
    char password[64];
    char wildcard[8];
    char backmx[8];
    char mx[128];

    char oldIPaddress[IPLEN];
    char IPaddress[IPLEN];
    FUNC_UPDATE update_function;
};

static struct yesno {
    const char *yes;
    const char *no;
} yn = { "yes", "no" };

static const char *dd_system[] = { 
    "dyndns",
    "statdns",
    "custom",
    NULL
};

static struct dyndns_return_codes {
    const char *code;
    const char *message;
    const int  error;
} return_codes[] = {
    { "badauth",     "Bad authorization (username or password).",        1 },
    { "badsys",      "The system parameter given was not valid.",        1 },
    { "badagent",    "The useragent your client sent has been blocked "
                     "at the access level.",                             1 },
    { "good",        "Update good and successful, IP updated.",          0 },
    { "nochg",       "No changes, update considered abusive.",           0 },
    { "points",      "DtDNS update OK.",                                 0 },
    { "Successful",  "ChangeIP update OK.",                              0 },
    { "not valid",   "The password you supplied is not valid.",          0 },
    { "notfqdn",     "A Fully-Qualified Domain Name was not provided.",  1 },
    { "nohost",      "The hostname specified does not exist.",           1 },
    { "!donator",    "The offline setting was set, when the user is "
                     "not a donator.",                                   1 },
    { "!yours",      "The hostname specified exists, but not under "
                     "the username currently being used.",               1 },
    { "!active",     "The hostname specified is in a Custom DNS "
                     "domain which has not yet been activated.",         1 },
    { "abuse",       "The hostname specified is blocked for abuse",      1 },
    { "notfqdn",     "No hosts are given.",                              1 },
    { "numhost",     "Too many or too few hosts found.",                 1 },
    { "dnserr",      "DNS error encountered.",                           1 },
    { "nouser",      "No user on VigorDDNS.",                            1 },
    { "badpass",     "Bad password on VigorDDNS.",                       1 },
    { "nodomain",    "No domain on VigorDDNS.",                          1 },
    { "wrongdomain", "Wrong domain on VigorDDNS.",                       1 },
    { "outofdate",   "Out of date on VigorDDNS.",                        1 },
    { "black",       "Black on VigorDDNS.",                              1 },
    { "blacklist",   "Black list on VigorDDNS.",                         1 },    
    { "success",     "VigorDDNS update OK.",                             0 },
    { "noneed",      "VigorDDNS already updated OK.",                    0 },
    { NULL,          NULL,                                               0 }
};

int  get_flags(struct arguments *args, int argc, char *argv[]);
int  update_dyndns(const int s, struct arguments *args);
int  update_no_ip(const int s, struct arguments *args);
int  update_dtdns(const int s, struct arguments *args);
int  update_changeip(const int s, struct arguments *args);
int  update_huagai(const int s, struct arguments *args);
int  update_3322(const int s, struct arguments *args);
int  update_vigorddns(const int s, struct arguments *args);
int  update_stratoddns(const int s, struct arguments *args);
int  update_dynamic_nameserver(const int s, struct arguments *args);
int  check_server_msg(const int s, const char *hostnames);
void get_arguments_from_cli(int);

FUNC_UPDATE Update_Function_Service_Provider[] = 
{update_dyndns, update_no_ip, update_dtdns, update_changeip, update_huagai, update_dynamic_nameserver, update_3322, update_vigorddns, update_stratoddns};

