/*
 * Copyright (C) 2004 LSIIT Laboratory.
 * Universit Louis Pasteur, Strasbourg, France.
 * All rights reserved.
 *
 * Original version by Christophe Jelger (jelger@dpt-info.u-strasbg.fr)
 * Developed by Frdric Beck (beck@startx.u-strasbg.fr)
 * Currently maintained and updated by Christophe Jelger
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "MLD_Proxy.h"
#include "MLD_MN.h"
#include "MLD_forward.h"
#include "MLD_membership.h"
#include <sys/select.h>
#include <unistd.h>


/*****   MAIN   *****/
int main(void)
{
	int pid = -1;					/* used to get the pid for */
	fd_set ens;						/* used to store descriptors in select */
	int max_desc = 0;				/* used in the select */
	struct timeval timer = {1,0};	/* timer in the select : 1 second */
	int nb_evts = 0;				/* number of events in the select */
	
	sigset_t our_sigset, empty_sigset;
	
	/* open the log file */
	if( (log_file=fopen("MLD_Proxy.log","w")) == NULL)
	{
		perror("MLD_Proxy.log");
		exit(-1);
	}
	
	/* init with config file */
	read_conf_file();
	
	if( debug_lvl == QUIET )
	{
		pid_t pid;
		pid = fork();
		if(pid > 0) return 1;
	}
		
	/* gets the pid */
	pid = (int)getpid();
	if( write_pid( pid ) == FALSE)
	{
		if(debug_lvl == VERBOSE)
			fprintf(stderr,"Unable to write PID in /var/run/MLD_Proxy.pid\n");
		fprintf(log_file,"Unable to write PID in /var/run/MLD_Proxy.pid\n");
	}
	
	fprintf(log_file,"MLD_Proxy Started with pid %d, reading configuration file ...\n",pid);
	if(debug_lvl == VERBOSE)
		fprintf(stderr,"\nMLD_Proxy Started with pid %d, reading configuration file ...\n",pid);
	
	/* init mobile table */
	if( init_MN_table(&mn_tab,int_adhoc,nb_tunnel,first_index) == FALSE )
	{
		exit(-1);
	}
	else
	{
		if(debug_lvl == VERBOSE)
			fprintf(stderr,"Init of MFC done.\n");
		fprintf(log_file,"Init of MFC done.\n");
	}
	
	/* init membership list */
	if(init_membership(&member_tab, int_lan) == FALSE)
	{
		exit(-1);
	}
	else
	{
		if(debug_lvl == VERBOSE)
			fprintf(stderr,"Init of membership list done.\n");
		fprintf(log_file,"Init of membership list done.\n");
	}
	
	/* Initialisation of the sockets used */
	if(init_sock_lan() == FALSE)
	{
		fprintf(log_file,"\nInit of LAN Socket Failed.\n");
		fprintf(stderr,"\nInit of LAN Socket Failed.\n");
		exit(-1);
	}
	else
	{
		if(debug_lvl == VERBOSE)
			fprintf(stderr,"Init of LAN Socket done.\n");
		fprintf(log_file,"Init of LAN Socket done.\n");
	}
	if(init_sock_mld() == FALSE)
	{
		fprintf(log_file,"Init of MLD Socket Failed.\n");
		fprintf(stderr,"Init of MLD Socket Failed.\n");
		exit(-1);
	}
	else
	{
		if(debug_lvl == VERBOSE)
			fprintf(stderr,"Init of MLD Socket done.\n");
		fprintf(log_file,"Init of MLD Socket done.\n");
	}
	if(init_sock_fwd() == FALSE)
	{
		fprintf(log_file,"Init of Forwarding Socket Failed.\n");
		fprintf(stderr,"Init of Forwarding Socket Failed.\n");
		exit(-1);
	}
	else
	{
		if(debug_lvl == VERBOSE)
			fprintf(stderr,"Init of Forwarding Socket done.\n");
		fprintf(log_file,"Init of Forwarding Socket done.\n");
	}
	
	if(debug_lvl == VERBOSE)
		fprintf(stderr,"MLD_Proxy READY, entering active listening and forwarding ...\n\n");
	fprintf(log_file,"MLD_Proxy READY, entering active listening and forwarding ...\n\n");
	
	/* signal redirections */
	signal( SIGINT, handler_quit );
	signal( SIGUSR1, handler_stat );
	signal( SIGALRM, check );
	alarm(CHECK_TIMER_PERIOD);
	
	if( sock_lan>sock_mld)
		max_desc = sock_lan;
	else
		max_desc = sock_mld;
	
	sigemptyset(&empty_sigset);
	sigemptyset(&our_sigset);
	sigaddset(&our_sigset, SIGUSR1);
	sigaddset(&our_sigset, SIGINT);
	sigaddset(&our_sigset, SIGALRM);
	
	/* main loop */
	while(TRUE)
	{
		/* Initialisation of the structure for select */
		FD_ZERO(&ens);
		FD_SET(sock_lan,&ens);
		/* FD_SET(sock_fwd,&ens); socket only used to send data */
		FD_SET(sock_mld,&ens);
		/* reinit timer */
		timer.tv_sec = 1;
		timer.tv_usec = 0;
	
		// nb_evts = pselect( max_desc+1,&ens,NULL,NULL,NULL,&empty_sigset);
	
		/* for some reason select() behaves strangely if a signal is */
		/* is caught when waiting for data on sockets */
		/* --> signals are therefore blocked before calling socket() */
	
		sigprocmask(SIG_BLOCK, &our_sigset, NULL);
		nb_evts = select( max_desc+1,&ens,NULL,NULL,&timer);
		sigprocmask(SIG_UNBLOCK, &our_sigset, NULL);
	
		if( FD_ISSET(sock_mld,&ens) )
		{
			/* check MLD message */
			mld_rcv();
		}
		
		if( FD_ISSET(sock_lan,&ens) )
		{
			/* data have to be forwarded */
			fwd_rcv();
		}
		
		// check_timers(&fwd_tab);
		// check_forward(&fwd_tab,&member_tab);
	}
	
	free_forwarded_group(&fwd_tab);
	free_MN(&mn_tab);
	free_membership(&member_tab);
	fclose(log_file);
	close(sock_lan);
	close(sock_mld);
	close(sock_fwd);
	return 0;
}
