/*
 *
 *  Copyright (C) 2007 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _QOS_FOPS_H
#define _QOS_FOPS_H

/*
* Definitions
*
*/

enum QOS_TRAFFIC_TYPES {
	RESERVED,
	MANAGED,
	POLICED,
	DROPPED,
	UNMANAGED
}; 


enum QOS_ERRORS
{
	QOS_OK = 0,
	QOS_TCAM_NO_MORE_ROOM = 1,
	QOS_TCAM_INDEX_ERR = 2
};


/*
* ADMITTANCE
*
*/

#define ADM0	0
#define ADM1	1
#define ADM_MAX_QFULL	1024

//#warning TCAM entries set to 4 (debug purpose only, default is 32) 
#define ADM_MAX_TCAM_ENTRIES	32

#define ADM_MAX_POLICER_ENTRIES	2

#define ADM_RESET_ALL 0

enum ADM_DROP_ZONE 
{
	ADM_DROPZONE0,
	ADM_DROPZONE1,
	ADM_DROPZONE2,
	ADM_DROPZONE3,
	ADM_NUM_DROPZONE
};

enum ADM_MODE 
{
	DISCARD_MODE,
	FLOW_CONTROL_MODE,
	DISABLED_MODE,
	ADM_MAX_MODE
};

enum QOS_TCAM_ADD_TYPE
{
	TCAM_ADD_TOP,
	TCAM_ADD_BOTTOM,
	TCAM_ADD_BEFORE
};


struct _ADM_LRU_STATS
{
	unsigned int entry;
	unsigned int count;
	unsigned char hit_count[ADM_MAX_TCAM_ENTRIES]; //max hit count reported by HW is 255
};

struct _ADM_LRU_CONF
{
	unsigned int period;
	unsigned int mask;
};
#define LRU_PERIOD_MIN 0
#define LRU_PERIOD_MAX 0
#define LRU_PERIOD_DEFAULT 0

#define LRU_MASK_MIN 0
#define LRU_MASK_MAX 0
#define LRU_MASK_DEFAULT 0

struct _ADM_TCAM_ENTRY
{
	unsigned char	policer; /* 0, 1=policer0, 2=policer1 */
	unsigned char	drop;
	unsigned char	reserved;
	unsigned short	etype;
	unsigned short	vlan;
	unsigned char	pppoe_ipv4;
	unsigned char	pppoe_ipv6;
	unsigned short	iptos;
	unsigned short	ipproto;
	unsigned char	ipfamily; /* not used by hw */
	unsigned long	saddr[4];
	unsigned long	daddr[4];
	unsigned short	sport_max;
	unsigned short	sport_min;
	unsigned short	dport_max;
	unsigned short	dport_min;
	unsigned char	multicast;
	unsigned short	etype_mask;
	unsigned short	vlan_mask;
	unsigned long	saddr_mask; /* select # of low order bits are ignored */
	unsigned long	daddr_mask;
	unsigned char	sport_enable; /* selects if sport_max/min are used */
	unsigned char	dport_enable; /* selects if dport_max/min are used */
	unsigned long	iptos_mask;
	unsigned long	pppoe_mask;
	unsigned long	ipproto_mask;
	unsigned long	broadcast_mask;
	unsigned long	multicast_mask;
};

#define	ADM_TCAM_FREE 		0xFF	/* the tcam slot is free and can be used to add new entry */
#define TCAM_UNSET_FAMILY	0
#define TCAM_IPV4_FAMILY	1
#define TCAM_IPV6_FAMILY	2
#define TCAM_OTHER_FAMILY	3

struct _ADM_TCAM_CONF
{
	unsigned char 	index;
	unsigned char	add_type; /* top=0, bottom=1, insert before=2*/
	unsigned char	position; /* insert entry before posistion */
	unsigned char	state;
	struct _ADM_TCAM_ENTRY entry;
};

struct _ADM_TCAM_STATE
{
	unsigned char 	index;
	unsigned char	state;
};


struct _ADM_POLICER_CONF
{
	unsigned char index;
	unsigned char state;
	unsigned long rate;
	unsigned long max_credit;
	unsigned long init_burst;
};
#define POLICER_STATE_DEFAULT 0

#define POLICER_RATE_MIN 0
#define POLICER_RATE_MAX 0
#define POLICER_RATE_DEFAULT 0

#define POLICER_CREDIT_MIN 0
#define POLICER_CREDIT_MAX 0
#define POLICER_CREDIT_DEFAULT 0

#define POLICER_BURST_MIN 0
#define POLICER_BURST_MAX 0
#define POLICER_BURST_DEFAULT 0

struct _ADM_COUNTER
{
	unsigned long port_byte;
	unsigned long port_packet;
	unsigned long reserved_byte;
	unsigned long reserved_packet;
	unsigned long managed_byte;
	unsigned long managed_packet;
	unsigned long packet_dropped;
	unsigned long packet_dropped_error;
	unsigned long packet_dropped_denied;
	unsigned long packet_dropped_policer0;
	unsigned long packet_dropped_policer1;
	unsigned long packet_dropped_qfull;
	unsigned long packet_dropped_shaper;
	unsigned long packet_dropped_managed;
	unsigned long packet_dropped_unmanaged;
};

struct _ADM_DISCARD_CONF
{
	unsigned char 	enable;		/* allows admittace block to drop packets if needed */
	unsigned long	zone_prob[ADM_NUM_DROPZONE];
	unsigned long	queue_full_threshold; /* not used anymore as queue length is set by upper layer (linux of fpp) */
	unsigned long	queue_drop_min; /* below this, accept all traffic except ones in excess of policed rate (expressed in % of qfull) */
	unsigned long	queue_drop_max; /* only reserved traffic accepted if reached by current q depth (expressed in % of qfull)*/
	unsigned long	qavg_depth;
	unsigned long	decay_timer_value;
};
#define DISCARD_ENABLE_DEFAULT 0

#define DISACRD_ZONE_PROB3_DEFAULT	8	
#define DISCARD_ZONE_PROB2_DEFAULT	4
#define DISCARD_ZONE_PROB1_DEFAULT	1
#define DISCARD_ZONE_PROB0_DEFAULT	0
#define DISCARD_ZONE_PROBX_MIN
#define DISCARD_ZONE_PROBX_MAX

#define DISCARD_QFULL_TRESH_MIN		0
#define DISCARD_QFULL_TRESH_MAX		128
#define DISCARD_QFULL_TRESH_DEFAULT	DISCARD_QFULL_TRESH_MAX

#define DISCARD_QDROPMIN_DEFAULT 0
#define DISCARD_QDROPMIN_MIN 0
#define DISCARD_QDROPMIN_MAX 0

#define DISCARD_QDROPMAX_DEFAULT 0
#define DISCARD_QDROPMAX_MIN 0
#define DISCARD_QDROPMAX_MAX 0

struct _ADM_FLOWCTRL_CONF
{
	unsigned char	enable;
	unsigned long	off_tresh;
	unsigned long	on_tresh;
	unsigned long	pause_timer;
};
#define FLOWCTRL_ENABLE_DEFAULT 0

#define FLOWCTRL_OFFTRESH_DEFAULT 0
#define FLOWCTRL_OFFTRESH_MIN 0
#define FLOWCTRL_OFFTRESH_MAX 0

#define FLOWCTRL_ONTRESH_DEFAULT 0
#define FLOWCTRL_ONTRESH_MIN 0
#define FLOWCTRL_ONTRESH_MAX 0


struct _ADM_SHAPER_CONF
{
	unsigned char	enable;
	unsigned long	rate;
	unsigned long	max_credit;
	unsigned long	init_burst;
	unsigned long	overhead;
};
#define SHAPER_ENABLE_DEFAULT 0
#define SHAPER_RATE_MIN 0
#define SHAPER_RATE_MAX 0
#define SHAPER_RATE_DEFAULT SHAPER_RATE_MIN

#define SHAPER_CREDIT_MIN 0
#define SHAPER_CREDIT_MAX 0
#define SHAPER_CREDIT_DEFAULT SHAPER_CREDIT_MIN

#define SHAPER_BURST_MIN 0
#define SHAPER_BURST_MAX 0
#define SHAPER_BURST_DEFAULT SHAPER_BURST_MIN

#define SHAPER_OVERHEAD_MIN 0
#define SHAPER_OVERHEAD_MAX 0
#define SHAPER_OVERHEAD_DEFAULT SHAPER_OVERHEAD_MIN

/*
* SCHEDULER
*
*/

#define SCH0	0
#define SCH1	1

#define SCH_MAX_SHAPERS			4
#define SCH_MAX_WEIGHTED_QUEUES		5

#define SCH_RESET_ALL 0

enum SCH_SHAPER 
{	
	SHAPER_PORT,
	SHAPER_GROUP,
	SHAPER_Q6,
	SHAPER_Q7
};

enum SCH_QUEUE 
{
	QUEUE_0,
	QUEUE_1,
	QUEUE_2,
	QUEUE_3,
	QUEUE_4,
	QUEUE_5,
	QUEUE_6,
	QUEUE_7,
	SCH_MAX_QUEUES
};

struct _SCH_COUNTER
{
	unsigned long port_byte;
	unsigned long port_packet;
	unsigned long q_byte[SCH_MAX_QUEUES];
	unsigned long q_packet[SCH_MAX_QUEUES];
	unsigned long q_idle[SCH_MAX_QUEUES];
};


struct _SCH_SHAPER_STATE
{
	unsigned char shaper;
	unsigned long state;
};

struct _SCH_SHAPER_CONF
{
	unsigned char shaper;
	unsigned char state;
	unsigned long rate;
	unsigned long max_credit;
	unsigned long init_burst;
};

struct _SCH_QUEUE_WEIGHT
{
	unsigned char queue;
	unsigned long weight;
};


/*
* IOCTLs
*
*/

#define	QOS_DEVICE_MAJOR_NUM		126	
#define QOS_DRIVER_NAME			"qoscom"

#define	ADM0_DEVICE_MINOR_NUM		0	
#define	ADM1_DEVICE_MINOR_NUM		1
#define	SCH0_DEVICE_MINOR_NUM		2	
#define	SCH1_DEVICE_MINOR_NUM		3

#define ADM_IOC_TYPE           'a'
#define SCH_IOC_TYPE           's'

#define ADM_IOC_SET_MODE		_IOW(ADM_IOC_TYPE, 1, unsigned char *)
#define ADM_IOC_GET_MODE		_IOR(ADM_IOC_TYPE, 2, unsigned char *)

#define ADM_IOC_SET_DISCARD_CONF	_IOW(ADM_IOC_TYPE, 3, struct _ADM_DISCARD_CONF *)
#define ADM_IOC_SET_FLOWCTRL_CONF	_IOW(ADM_IOC_TYPE, 4, struct _ADM_FLOWCTRL_CONF *)
#define ADM_IOC_SET_SHAPER_CONF		_IOW(ADM_IOC_TYPE, 5, struct _ADM_SHAPER_CONF *)
#define ADM_IOC_ADD_CAMENTRY		_IOWR(ADM_IOC_TYPE, 6, struct _ADM_TCAM_CONF *)
#define ADM_IOC_CHANGE_CAMENTRY		_IOW(ADM_IOC_TYPE, 7, struct _ADM_TCAM_CONF *)
#define ADM_IOC_SET_CAMENTRY_STATE	_IOW(ADM_IOC_TYPE, 8, struct _ADM_TCAM_STATE *)
#define ADM_IOC_REMOVE_CAMENTRY		_IOW(ADM_IOC_TYPE, 9, unsigned char *) 
#define ADM_IOC_GET_CAMENTRY		_IOWR(ADM_IOC_TYPE, 10, struct _ADM_TCAM_CONF *)
#define ADM_IOC_SET_POLICER_CONF	_IOW(ADM_IOC_TYPE, 11, struct _ADM_POLICER_CONF *)
#define ADM_IOC_GET_POLICER_CONF	_IOWR(ADM_IOC_TYPE, 12, struct _ADM_POLICER_CONF *)
#define ADM_IOC_SET_LRU_CONF		_IOW(ADM_IOC_TYPE, 13, struct _ADM_LRU_CONF *)
#define ADM_IOC_GET_LRU_STATS		_IOR(ADM_IOC_TYPE, 14, struct _ADM_LRU_STATS *)
#define ADM_IOC_GET_ADM_STATS		_IOR(ADM_IOC_TYPE, 15, struct _ADM_COUNTER *)
#define SCH_IOC_GET_STATS		_IOR(SCH_IOC_TYPE, 16, struct _SCH_COUNTER *)
#define SCH_IOC_SET_SHAPER_STATE	_IOW(SCH_IOC_TYPE, 17, struct _SCH_SHAPER_STATE *)
#define SCH_IOC_GET_SHAPER_STATE	_IOR(SCH_IOC_TYPE, 18, struct _SCH_SHAPER_STATE *)
#define SCH_IOC_SET_SHAPER_CONF		_IOW(SCH_IOC_TYPE, 19, struct _SCH_SHAPER_CONF *)
#define SCH_IOC_GET_SHAPER_CONF		_IOW(SCH_IOC_TYPE, 20, struct _SCH_SHAPER_CONF *)
#define SCH_IOC_SET_QUEUE_WEIGHT	_IOW(SCH_IOC_TYPE, 21, struct _SCH_QUEUE_WEIGHT *)
#define SCH_IOC_GET_QUEUE_WEIGHT	_IOW(SCH_IOC_TYPE, 22, struct _SCH_QUEUE_WEIGHT *)
#define ADM_IOC_RESET			_IOW(ADM_IOC_TYPE, 23, unsigned char *)
#define SCH_IOC_RESET			_IOW(SCH_IOC_TYPE, 24, unsigned char *)
#define ADM_IOC_GET_REGS		_IOW(ADM_IOC_TYPE, 25, unsigned char *)
#define ADM_IOC_GET_SHAPER_CONF		_IOW(ADM_IOC_TYPE, 26, struct _ADM_SHAPER_CONF *)


#endif /* _QOS_FOPS_H */
