/*
 *
 *  Copyright (C) 2008 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COMMON_H
#define _COMMON_H

#if !defined(CONFIG_ARCH_M83XXX)
#define  C1K_REG_SIM
#endif

#define EMAC0_BASE 0x100D0000
#define EMAC1_BASE 0x10190000

#define REFCLK	125000000UL

#ifdef C1K_REG_SIM
unsigned long get_gemac_base(int gemac);
#endif

static inline void SET_REG_BITSHIFT(volatile unsigned long * reg, unsigned long value, unsigned long width, unsigned long shift) 
{
	unsigned long tmp = *reg;
	tmp &= ~(width << shift); 
	tmp |= (value & width) << shift;
	*reg = tmp;
}


#endif /* _SCH_H */
