/*
 * Copyright (c) 2009 Petri Lehtinen <petri@digip.org>
 *
 * Jansson is free software; you can redistribute it and/or modify
 * it under the terms of the MIT license. See LICENSE for details.
 */

#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <jansson.h>
#include <ctype.h>



static const char *appname;
static const char *fileload = "/tmp/jsonstatus.txt";

static const int MAX_STR_LENGTH = 1024;

void str_replace(char *string, char orichar , char newchar){
	int i;
  	for(i = 0; i < strlen(string); ++i){
    	 if (string[i] == orichar){  // Look for a '
         string[i] = newchar; // replace with a `
     }
  }
}

int str_index(char *string, char indexchar){
	int i;
  	for(i = 0; i < strlen(string); ++i){
    	 if (string[i] == indexchar)
         	return i;
     }
	return -1;	 
}

static void json_usage(void)
{
	fprintf(stderr,
		"Usage: %s [<options>] <command> [<arguments>]\n\n"
		"Commands:\n"
		"\tshow       [node]\n"
		"\tget        leaf\n"
		"\tset        node leaf1=value1 leaf2=value2,value3\n"
		"\tfind       [node] value\n"
		"\tload       node\n"
		"\treplace    node oldvalue newvalue\n"    
		"\n"
		"Options:\n"
		"\t-f <file>  the file for json input\n"
		"\n",
		appname
	);
}


int showall(json_t *json,int argc, char **argv){

printf(json_dumps(json,0));
return 1;
}

int show(json_t *json,int argc, char **argv){

	

	char fullkey[1024];
	memset(fullkey,0,1024);	
	if(argc ==2){
		strcpy(fullkey,argv[1]);

		json_t *json2 = json_object_fullget(json,fullkey);
		if(json_is_string(json2)){
		//printf("%s=",fullkey));
		//printf(json_string_value(json2));
		printf(json_string_key_value(json2,fullkey));
		}
		else if(json_is_array(json2))
		{
		//printf("%s=",fullkey));
    	//char * ret= json_array_value(json2);
		//printf(json_array_value(json2));
		printf(json_array_key_value(json2,fullkey));
		}
		else if(json_is_object(json2))
		{
    	//char * ret= json_object_value(json2);
		//printf(ret);
		printf(json_object_key_value(json2,fullkey));
		}	
		
	}
	else
	{
		if(json_is_string(json)){
		//printf("%s=",fullkey));
		//printf(json_string_value(json2));
		printf(json_string_key_value(json,""));
		}
		else if(json_is_array(json))
		{
		//printf("%s=",fullkey));
    	//char * ret= json_array_value(json2);
		//printf(json_array_value(json2));
		printf(json_array_key_value(json,""));
		}
		else if(json_is_object(json))
		{
		printf(json_object_key_value(json,""));
		}	
		//json2 = json_object_fullget(json,"");
	}
	
	
return 1;
}


int get(json_t *json,char *fullkey){

	json_t *json2 = json_object_fullget(json,fullkey);

	if(json_is_string(json2))
		printf(json_string_value(json2));
	else if(json_is_array(json2))
	{
		//printf(json_array_value(json2));
    	char * ret= json_array_value(json2);
		printf(ret);
	}
	/*  no support object
	else if(json_is_object(json2))
	{
    	char * ret= json_object_value(json2);
		printf(ret);
	}
	*/
printf("\n");;
return 1;
}


int replaceArray(json_t *json,int argc, char **argv){

	if(argc!=4)
		return  -1;


	json_t *json2 = json_object_fullget(json,argv[1]);

	if(json_is_array(json2))
	{
    	json_array_replace(json2,argv[2],argv[3]);
	}
	else{
		printf("Node is not an array\n");
		return -1;
	}

	//get(json,argv[1]);
	json_dump_file(json, fileload, 0);	
return 1;
}


int findkeybyvalue(json_t *json,int argc, char **argv){

	json_t *json2 = NULL;
	if(argc == 3){
		json2 = json_object_fullget(json,argv[1]);
		if(json_is_string(json2)){
			if(strcmp(json_string_value(json2),argv[2])==0){
			printf(argv[1]);
			}
		}
		else if(json_is_array(json2))
		{
			if(strcmp(json_array_value(json2),argv[2])>=0){
			printf(argv[1]);
			}
		}
		else if(json_is_object(json2))
		{
			char * result = json_object_lookup(json2,argv[2]);
			printf(result);
		}
	}
	else if(argc == 2){
		json2 = json;

		if(json_is_string(json2)){
			if(strcmp(json_string_value(json2),argv[1])==0){
			printf(argv[1]);
			}
		}
		else if(json_is_array(json2))
		{
			if(strcmp(json_array_value(json2),argv[1])>=0){
			printf(argv[1]);
			}
		}
		else if(json_is_object(json2))
		{
			char * result = json_object_lookup(json2,argv[1]);
			printf(result);
		}			
	}
	else 
		return -1;
	
	
	printf("\n");
	
	//get(json,argv[1]);
return 1;
}



void strupper(char *s)
{
  while (*s)
  {
    {
      if (islower(*s))
        *s = toupper(*s);
      s++;
    }
  }
}       

char * formatkey(char * strin){

	char tmp[1024];
	memset(tmp,0,1024);
	strcpy(tmp,strin);
		
	str_replace(tmp,'.','_');
	strupper(tmp);
	return strdup(tmp);
}



int loadjson(json_t *json,int argc, char **argv){

	if(argc!=2)
		return  -1;
	
	json_t *json2 = json_object_fullget(json,argv[1]);
	
	if(json_is_string(json2)){

		printf(formatkey(argv[1]));
		printf("=");
		printf(json_string_value(json2));
		printf("\n");
		//printf(json_string_value(json2));
	}
	else if(json_is_array(json2))
	{

		//int size = json_array_size(json2);

		printf(formatkey(argv[1]));
		printf("=");
		char * tmp = json_array_value(json2);
		str_replace(tmp,' ',',');
		printf(tmp);
		printf("\n");
		
	}
	else if(json_is_object(json2))
	{
		json_t *tmpjson = NULL;
		void *iter;
		iter = json_object_iter((json_t *)json2);
		char tmpkey[256];

		while(iter)
     	{
       		memset(tmpkey,0,256);
       		void *next = json_object_iter_next((json_t *)json2, iter);


	   		tmpjson = json_object_iter_value(iter);
	   		const char *key= json_object_iter_key(iter);
				
	   		sprintf(tmpkey,"%s.%s",argv[1],key);

     		if(json_is_array(tmpjson)){
				//int size = json_array_size(tmpjson);

				printf(formatkey(tmpkey));
				printf("=");
				char * tmp = json_array_value(tmpjson);
				str_replace(tmp,' ',',');
				printf(tmp);
				printf(";");
			}
			else if(json_is_string(tmpjson)){
				printf(formatkey(tmpkey));
				printf("=");
				printf(json_string_value(tmpjson));
				printf(";");
			}
      
        	iter = next;
     	}

		printf("\n");
	}
return 1;
}





int jsonSetValues(json_t *json,int argc, char **argv){


	char fullkey[256];
	int i ;
	memset(fullkey,0,256);
	strcpy(fullkey,"");
	for(i=1; i<argc;i++){
		if(strstr(argv[i],"=")==NULL){
			strcpy(fullkey,argv[i]);
		}
		else{
			json_t *tmpjson = json_object_fullget(json,fullkey);

			int s1 = str_index(argv[i],'=');
			char key1[256];
			char value1[256];
			memset(key1,0,256);
			memset(value1,0,256);
			strncpy(key1,argv[i],s1);
			strcpy(value1,&argv[i][s1+1]);
		
			if(tmpjson!=NULL){
				json_t *setjson = json_object_get(tmpjson,key1);

				if(strstr(value1,",")==NULL){ //set to string
					if(setjson!=NULL)
						json_object_del(tmpjson, key1);
				
					setjson = json_string(value1);
					json_object_set(tmpjson, key1, setjson);
				}
				else{
// set to array
					if(setjson!=NULL && value1[0]!=',')
					 	json_object_del(tmpjson, key1);
					
					char * buf = value1;
					if(setjson==NULL || value1[0]!=','){
						setjson = json_array();
					}
					else{
						buf = &value1[1];
						if(!json_is_array(setjson))
					setjson = json_array();
						
					}
					int size = 0;
					while(str_index(buf,',')>0){
						char valuebuf[128];
						memset(valuebuf,0,128);
						int sec = str_index(buf,',');
						strncpy(valuebuf,buf,sec);
						buf = &buf[sec+1];
						json_t * tmpsetjson = json_string(valuebuf);
						json_array_append(setjson,tmpsetjson);
						size++;
						//printf("valuebuf=%s\n",valuebuf);
					}
					json_t * tmpsetjson = json_string(buf);
					json_array_append(setjson,tmpsetjson);
					json_object_set(tmpjson, key1, setjson);
				}
			}
			else{
				int sec = str_index(fullkey,'.');

				if(sec <0){
					tmpjson = json_object();
					json_object_set(json, fullkey, tmpjson);
				}
				else{
					tmpjson = json;
					char cfullkey[256];
					memset(cfullkey,0,256);
					strcpy(cfullkey,fullkey);
					int fullsec = sec+1;;
					while(sec > 0){
						char tmpkey[256];
						memset(tmpkey,0,256);
						strncpy(tmpkey,cfullkey,sec);
						memset(cfullkey,0,256);
						strcpy(cfullkey,&fullkey[fullsec]);
				
						if(json_object_get(tmpjson,tmpkey)==NULL){
							json_t *setjson  = json_object();
							//printf("set tmpkey=%s\n",tmpkey);
							json_object_set(tmpjson, tmpkey, setjson);
							tmpjson = setjson;
						}
						else{
							tmpjson = json_object_get(tmpjson,tmpkey);
						}
						fullsec = fullsec + sec +1;

						int sec = str_index(cfullkey,'.');

						if(sec <0){
							//printf("set cfullkey=%s\n",cfullkey);
							json_t *setjson  = json_object();
							json_object_set(tmpjson, cfullkey, setjson);
							break;
						}
					}
				}
				json_t *tmpjson = json_object_fullget(json,fullkey);				
				if(strstr(value1,",")==NULL){ //set to string
					json_t * setjson = json_string(value1);
					json_object_set(tmpjson, key1, setjson);
				}
				else{
// set to array
					json_t * setjson = json_array();
					char * buf = value1;
					int size = 0;
					if(value1[0]==',')
						buf = &value1[1];
					
					while(str_index(buf,',')>0){
						char valuebuf[128];
						memset(valuebuf,0,128);
						int sec = str_index(buf,',');
						strncpy(valuebuf,buf,sec);
						buf = &buf[sec+1];
						json_t * tmpsetjson1 = json_string(valuebuf);
						json_array_append(setjson,tmpsetjson1);
						size++;
						//printf("valuebuf=%s\n",valuebuf);
					}
					json_t * tmpsetjson1 = json_string(buf);
					json_array_append(setjson,tmpsetjson1);
					json_object_set(tmpjson, key1, setjson);
				}		

			}	
		}	
	}

	json_dump_file(json, fileload, 0);	
	//showall(json,0,NULL);	

return 1;
}


static int json_cmd(int argc, char **argv)
{
	json_t *json;
	json_error_t error;

	json = json_load_file(fileload, &error);

	if(json==NULL){
		json = json_object();
	}
	/*
	if (!strcasecmp(argv[0], "showall"))
		showall(json,argc, argv);
	else 
	*/
	if (!strcasecmp(argv[0], "set"))
		jsonSetValues(json,argc, argv);
	else if (!strcasecmp(argv[0], "show"))
		show(json,argc,argv);
	else if (!strcasecmp(argv[0], "get"))
		get(json,argv[1]);
	else if (!strcasecmp(argv[0], "replace"))
		replaceArray(json,argc,argv);
	else if (!strcasecmp(argv[0], "find"))
		findkeybyvalue(json,argc,argv);
	else if (!strcasecmp(argv[0], "load"))
		loadjson(json,argc,argv);
	else json_usage();
	return -1;

}

int main(int argc, char *argv[])
{
	appname = argv[0];

	//json_usage();
	int c;

	while((c = getopt(argc, argv, "c:d:f:LmnNp:P:sSqX")) != -1) {
		switch(c) {
			case 'f':
				fileload = optarg;
				break;
			default:
				json_usage();
				return 0;
		}
	}

	if (optind > 1)
		argv[optind - 1] = argv[0];
		argv += optind - 1;
		argc -= optind - 1;

	if (argc < 2) {
		json_usage();
		return 0;
	}
	json_cmd(argc - 1, argv + 1);
    return 0;
}

