#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "qos"

! empty "$FORM_new_group" && {
	SAVED=1
validate << EOF
EOF
	equal "$?" 0 && {
	count=`uci get qos.general.group_count`
	count=`expr $count + 1`
	uci_add qos qos group$count
	uci_set qos group$count name "$FORM_name"
	uci_set qos group$count iface "$FORM_iface"
	uci_set qos group$count rate "$FORM_rate"
	uci_set qos group$count bucket "$FORM_bucket"
	uci_set qos group$count status "$FORM_status"
	! empty "$FORM_0" && {
	uci_set qos group$count queue0 "$FORM_0"
	uci_set qos general queue0 "1"
	}
	! empty "$FORM_1" && {
	uci_set qos group$count queue1 "$FORM_1"
	uci_set qos general queue1 "1"
	}
	! empty "$FORM_2" && {
	uci_set qos group$count queue2 "$FORM_2"
	uci_set qos general queue2 "1"
	}
	! empty "$FORM_3" && {
	uci_set qos group$count queue3 "$FORM_3"
	uci_set qos general queue3 "1"
	}
	! empty "$FORM_4" && {
	uci_set qos group$count queue4 "$FORM_4"
	uci_set qos general queue4 "1"
	}
	! empty "$FORM_5" && {
	uci_set qos group$count queue5 "$FORM_5"
	uci_set qos general queue5 "1"
	}
	! empty "$FORM_6" && {
	uci_set qos group$count queue6 "$FORM_6"
	uci_set qos general queue6 "1"
	}
	uci_set qos general group_count "$count"
	config_set group$count name "$FORM_name"
	config_set group$count iface "$FORM_iface"
	config_set group$count rate "$FORM_rate"
	config_set group$count bucket "$FORM_bucket"
	config_set group$count status "$FORM_status"
	config_set group$count queue0 "$FORM_0"
	config_set group$count queue1 "$FORM_1"
	config_set group$count queue2 "$FORM_2"
	config_set group$count queue3 "$FORM_3"
	config_set group$count queue4 "$FORM_4"
	config_set group$count queue5 "$FORM_5"
	config_set group$count queue6 "$FORM_6"
	FORM_name=""
	FORM_iface=""
	FORM_rate=""
	FORM_bucket=""
	FORM_status=""
	}
}

! empty "$FORM_display_group" && {
	group=$FORM_display_group
	config_get FORM_name group$group name
	config_get FORM_iface group$group iface
	config_get FORM_rate group$group rate
	config_get FORM_bucket group$group bucket
	config_get FORM_status group$group status
	config_get FORM_0 group$group queue0
	config_get FORM_1 group$group queue1
	config_get FORM_2 group$group queue2
	config_get FORM_3 group$group queue3
	config_get FORM_4 group$group queue4
	config_get FORM_5 group$group queue5
	config_get FORM_6 group$group queue6
}	

! empty "$FORM_save_group" && {
	SAVED=1
validate <<EOF
EOF
	equal "$?" 0 && {
	count=$FORM_group
	uci_set qos group$count name "$FORM_name"
	uci_set qos group$count iface "$FORM_iface"
	uci_set qos group$count rate "$FORM_rate"
	uci_set qos group$count bucket "$FORM_bucket"
	uci_set qos group$count status "$FORM_status"
	uci_set qos group$count queue0 "$FORM_0"
	uci_set qos group$count queue1 "$FORM_1"
	uci_set qos group$count queue2 "$FORM_2"
	uci_set qos group$count queue3 "$FORM_3"
	uci_set qos group$count queue4 "$FORM_4"
	uci_set qos group$count queue5 "$FORM_5"
	uci_set qos group$count queue6 "$FORM_6"
	count=`uci get qos.general.group_count`
	id=1
	while [ $id -le $count ]
	do
	for k in 0 1 2 3 4 5 6
	do
	var=`uci get qos.group$id.queue$k`
	! empty $var && {
	uci_set qos general queue$k 1
	} || {
	uci_set qos general queue$k 0
	}
	done
	id=`expr $id + 1`
	done
	
	config_set group$count name "$FORM_name"
	config_set group$count iface "$FORM_iface"
	config_set group$count rate "$FORM_rate"
	config_set group$count bucket "$FORM_bucket"
	config_set group$count status "$FORM_status"
	config_set group$count queue0 "$FORM_0"
	config_set group$count queue1 "$FORM_1"
	config_set group$count queue2 "$FORM_2"
	config_set group$count queue3 "$FORM_3"
	config_set group$count queue4 "$FORM_4"
	config_set group$count queue5 "$FORM_5"
	config_set group$count queue6 "$FORM_6"
	FORM_name=""
	FORM_iface=""
	FORM_rate=""
	FORM_bucket=""
	FORM_status=""
	}
}

! empty "$FORM_delete" && {
count=`uci get qos.general.group_count`
groupid=$FORM_delete
for k in 0 1 2 3 4 5 6
do
var=`uci get qos.group$groupid.queue$k`
! empty $var && uci_set qos general queue$k 0
done
uci_remove qos group$groupid
while [ $groupid -lt $count ]
do
uci_rename qos group`expr $groupid + 1` group$groupid
groupid=`expr $groupid + 1`
done
uci_set qos general group_count `expr $count - 1`
}

#####################################################################
header "QoS" "Rate Limiting Configuration" "@TR<<Rate Limiting Configuration>>" ''
#####################################################################


echo "<div class=\"settings\">"
echo "<th colspan=\"11\"><h3><strong>" Rate Limiting Groups: "</strong></h3></th>"
echo "<div class=\"settings-content-inner\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>Name</th><th>Interface</th><th>Queues</th><th>Rate</th><th>Bucket Size</th><th>Status</th><th style=\"text-align: center;\">Actions</th></tr>"
count=`uci get qos.general.group_count`
if [ "$count" = 0 ]; then
  echo "<tr class=\"tr_bg\"><td colspan=\"7\">There are no rate limiting groups</td></tr>"
fi
i=1
while [ $i -le $count ]
do
config_get name group$i name
config_get iface group$i iface
config_get rate group$i rate
config_get bucket group$i bucket
config_get status group$i status
config_get queue0 group$i queue0
config_get queue1 group$i queue1
config_get queue2 group$i queue2
config_get queue3 group$i queue3
config_get queue4 group$i queue4
config_get queue5 group$i queue5
config_get queue6 group$i queue6

echo "<tr class=\"tr_bg\"><td>$name</td><td>$iface</td><td>$queue0 $queue1 $queue2 $queue3 $queue4 $queue5 $queue6</td><td>$rate</td><td>$bucket</td><td>$status</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_group=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
i=`expr $i + 1`
done
echo "</tbody></table></div><div class=\"clearfix\">&nbsp;</div></div><br>"

empty "$FORM_display_group" && {
#config_get queue0 general queue0
#config_get queue1 general queue1
#config_get queue2 general queue2
#config_get queue3 general queue3
#config_get queue4 general queue4
#config_get queue5 general queue5
#config_get queue6 general queue6
queue0=`uci get qos.general.queue0`
queue1=`uci get qos.general.queue1`
queue2=`uci get qos.general.queue2`
queue3=`uci get qos.general.queue3`
queue4=`uci get qos.general.queue4`
queue5=`uci get qos.general.queue5`
queue6=`uci get qos.general.queue6`

flag=0
! equal "$queue0" 1 && { 
check="checkbox|0|$FORM_0|0|@TR<<0>>"
flag=1
}
! equal "$queue1" 1 && {
check="$check
checkbox|1|$FORM_1|1|@TR<<1>>"
flag=1
}
! equal "$queue2" 1 && {
check="$check
checkbox|2|$FORM_2|2|@TR<<2>>"
flag=1
}
! equal "$queue3" 1 && {
check="$check
checkbox|3|$FORM_3|3|@TR<<3>>"
flag=1
}
! equal "$queue4" 1 && {
check="$check
checkbox|4|$FORM_4|4|@TR<<4>>"
flag=1
}
! equal "$queue5" 1 && {
check="$check
checkbox|5|$FORM_5|5|@TR<<5>>"
flag=1
}
! equal "$queue6" 1 && {
check="$check
checkbox|6|$FORM_6|6|@TR<<6>>"
flag=1
}

equal "$flag" 0 && form="string|<h3>There is no Queue available to creat Group.<h3>"
equal "$flag" 1 && form="
start_form|@TR<<New Group>>
formtag_begin|new_group|$SCRIPT_NAME
field|@TR<<Name>>
text|name|$FORM_name
field|@TR<<Interface>>
select|iface|$FORM_iface
option|lan|@TR<<LAN>>
option|wan|@TR<<WAN>>
field|@TR<<Queue>>
$check
helpitem|Note
helptext|Queue 7 cannot not ratelimited.
field|@TR<<Rate (Kbps)>>
text|rate|$FORM_rate
field|@TR<<Bucket Size (bytes)>>
text|bucket|$FORM_bucket
field|@TR<<Status>>
select|status|$FORM_status
option|1|@TR<<Enable>>
option|0|@TR<<Disable>>
field||spacer1
string|<br />
submit|new_group|@TR<<Add>>
reset||@TR<<Clear>>
formtag_end
end_form
"

display_form <<EOF
onchange|modechange
$form
EOF
}

! empty "$FORM_display_group" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<Edit Group $FORM_display_group>>
formtag_begin|save_group|$SCRIPT_NAME
field|@TR<<Group ID>>
text|group|$FORM_display_group|||readonly
field|@TR<<Name>>
text|name|$FORM_name
field|@TR<<Interface>>
select|iface|$FORM_iface
option|lan|@TR<<LAN>>
option|wan|@TR<<WAN>>
field|@TR<<Queue>>
checkbox|0|$FORM_0|0|@TR<<0>>
checkbox|1|$FORM_1|1|@TR<<1>>
checkbox|2|$FORM_2|2|@TR<<2>>
checkbox|3|$FORM_3|3|@TR<<3>>
checkbox|4|$FORM_4|4|@TR<<4>>
checkbox|5|$FORM_5|5|@TR<<5>>
checkbox|6|$FORM_6|6|@TR<<6>>
helpitem|Note
helptext|Queue 7 cannot not ratelimited.
field|@TR<<Rate (Kbps)>>
text|rate|$FORM_rate
field|@TR<<Bucket Size (bytes)>>
text|bucket|$FORM_bucket
field|@TR<<Status>>
select|status|$FORM_status
option|1|@TR<<Enable>>
option|0|@TR<<Disable>>
field||spacer1
string|<br />
submit|save_group|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

footer ?>

<!--
##WEBIF:name:QoS:300:Rate Limiting Configuration
-->
