#!/usr/bin/webif-page
<?
. "/usr/lib/webif/webif.sh"
uci_load "qos"

qos_main_page_display="y"

! empty "$FORM_ingress_mode" && {
	int=$FORM_int
	config_get FORM_mode $int mode
#	case "$FORM_mode" in
#	0) 
	config_get FORM_discard_zone0 $int discard_zone0
	config_get FORM_discard_zone1 $int discard_zone1
	config_get FORM_discard_zone2 $int discard_zone2
	config_get FORM_discard_zone3 $int discard_zone3
	config_get FORM_queue_min $int queue_min
	config_get FORM_queue_max $int queue_max
#	;;
#	1) 
	config_get FORM_off_tresh $int off_tresh
	config_get FORM_on_tresh $int on_tresh
#	;;
#	2) 
#	;;
#	esac
	qos_main_page_display=""
}

! empty "$FORM_save_ingress_mode" && {
SAVED=1
int=$FORM_int
validate <<EOF
EOF
	equal "$?" 0 && {
	uci_set qos $int mode "$FORM_mode"
	case "$FORM_mode" in
	0)
	uci_set qos $int discard_zone0 "$FORM_discard_zone0"
	uci_set qos $int discard_zone1 "$FORM_discard_zone1"
	uci_set qos $int discard_zone2 "$FORM_discard_zone2"
	uci_set qos $int discard_zone3 "$FORM_discard_zone3"
	uci_set qos $int queue_min "$FORM_queue_min"
	uci_set qos $int queue_max "$FORM_queue_max"
	;;
	1)
	uci_set qos $int off_tresh "$FORM_off_tresh"
	uci_set qos $int on_tresh "$FORM_on_tresh"
	;;
#	2)
#	;;
	esac
	}
	qos_main_page_display="y"
}

! empty "$FORM_ingress_shaper" && {
	int=$FORM_int
	config_get FORM_shaper $int shaper
	config_get FORM_rate $int rate
	config_get FORM_max_credit $int max_credit
	config_get FORM_over_head $int over_head
	qos_main_page_display=""
}

! empty "$FORM_save_ingress_shaper" && {
qos_main_page_display=""
FORM_ingress_shaper="Shaper"
SAVED=1
int=$FORM_int
validate <<EOF
int|FORM_rate|Shaper Rate|min=64000 max=2400000000|$FORM_rate
int|FORM_max_credit|Shaper Max Credit|min=0 max=1000000|$FORM_max_credit
int|FORM_over_head|Shaper Over Head|min=0 max=255|$FORM_over_head
EOF
	equal "$?" 0 && {
	uci_set qos $int shaper "$FORM_shaper"
	uci_set qos $int rate "$FORM_rate"
	uci_set qos $int max_credit "$FORM_max_credit"
	uci_set qos $int over_head "$FORM_over_head"
	qos_main_page_display="y"
        FORM_ingress_shaper=""
	}
}

! empty "$FORM_ingress_policer" && {
	int=$FORM_int
	config_get FORM_policer_1 $int policer_1
	config_get FORM_rate_1 $int rate_1
	config_get FORM_max_credit_1 $int max_credit_1
	config_get FORM_policer_2 $int policer_2
	config_get FORM_rate_2 $int rate_2
	config_get FORM_max_credit_2 $int max_credit_2
	qos_main_page_display=""
}

! empty "$FORM_save_ingress_policer" && {
qos_main_page_display=""
FORM_ingress_policer="Policer"
SAVED=1
int=$FORM_int
validate <<EOF
int|FORM_rate_1|Policer 1 Rate|min=15 max=243664|$FORM_rate_1
int|FORM_max_credit_1|Policer 1 Max Credit|min=0 max=1000000|$FORM_max_credit_1
int|FORM_rate_2|Policer 2 Rate|min=15 max=243664|$FORM_rate_2
int|FORM_max_credit_2|Policer 2 Max Credit|min=0 max=1000000|$FORM_max_credit_2
EOF
	equal "$?" 0 && {
	uci_set qos $int policer_1 "$FORM_policer_1"
	uci_set qos $int rate_1 "$FORM_rate_1"
	uci_set qos $int max_credit_1 "$FORM_max_credit_1"
	uci_set qos $int policer_2 "$FORM_policer_2"
	uci_set qos $int rate_2 "$FORM_rate_2"
	uci_set qos $int max_credit_2 "$FORM_max_credit_2"
	qos_main_page_display="y"
        FORM_ingress_policer=""
	}
}

! empty "$FORM_new_policy" && {
SAVED=1
validate <<EOF
EOF
	equal "$?" 0 && {
	config_get policyid general ingress_${FORM_int}_policy
	policyid=`expr $policyid + 1`
	uci_set qos general ingress_${FORM_int}_policy $policyid
#	policy=1
#	while [ $policyid -gt $policy ]
#	do
#		uci_rename qos ingress_${FORM_int}_`expr $policyid - 1` ingress_${FORM_int}_$policyid
#		policyid=`expr $policyid - 1`
#	done
	uci_add qos policy ingress_${FORM_int}_${policyid}
	uci_set qos ingress_${FORM_int}_${policyid} action "$FORM_action"
	uci_set qos ingress_${FORM_int}_${policyid} policer "$FORM_policer" 
	uci_set qos ingress_${FORM_int}_${policyid} src "$FORM_src"
	uci_set qos ingress_${FORM_int}_${policyid} src_mask "$FORM_src_mask"
	uci_set qos ingress_${FORM_int}_${policyid} sport_min "$FORM_src_port_min"
	uci_set qos ingress_${FORM_int}_${policyid} sport_max "$FORM_src_port_max"
	uci_set qos ingress_${FORM_int}_${policyid} dst "$FORM_dst"
	uci_set qos ingress_${FORM_int}_${policyid} dst_mask "$FORM_dst_mask"
	uci_set qos ingress_${FORM_int}_${policyid} dport_min "$FORM_dst_port_min"
	uci_set qos ingress_${FORM_int}_${policyid} dport_max "$FORM_dst_port_max"
	uci_set qos ingress_${FORM_int}_${policyid} ipproto "$FORM_ipproto"
        FORM_ingress_policy="Policy "
	}
        qos_main_page_display=""
}

! empty "$FORM_display_policy" && {
	policyid=$FORM_display_policy
	config_get FORM_action ingress_$policyid action
	config_get FORM_policer ingress_$policyid policer
	config_get FORM_src ingress_$policyid src
	config_get FORM_src_mask ingress_$policyid src_mask
	config_get FORM_src_port_min ingress_$policyid sport_min
	config_get FORM_src_port_max ingress_$policyid sport_max
	config_get FORM_dst ingress_$policyid dst
	config_get FORM_dst_mask ingress_$policyid dst_mask
	config_get FORM_dst_port_min ingress_$policyid dport_min
	config_get FORM_dst_port_max ingress_$policyid dport_max
	config_get FORM_ipproto ingress_$policyid ipproto
        qos_main_page_display=""
}

! empty "$FORM_save_policy" && {
SAVED=1
validate <<EOF
EOF
	equal "$?" 0 && {
	policyid=$FORM_policyid
	uci_set qos ingress_$policyid action "$FORM_action"
	uci_set qos ingress_$policyid policer "$FORM_policer" 
	uci_set qos ingress_$policyid src "$FORM_src"
	uci_set qos ingress_$policyid src_mask "$FORM_src_mask"
	uci_set qos ingress_$policyid sport_min "$FORM_src_port_min"
	uci_set qos ingress_$policyid sport_max "$FORM_src_port_max"
	uci_set qos ingress_$policyid dst "$FORM_dst"
	uci_set qos ingress_$policyid dst_mask "$FORM_dst_mask"
	uci_set qos ingress_$policyid dport_min "$FORM_dst_port_min"
	uci_set qos ingress_$policyid dport_max "$FORM_dst_port_max"
	uci_set qos ingress_$policyid ipproto "$FORM_ipproto"
        FORM_ingress_policy="Policy "
	}
        qos_main_page_display=""
}

! empty "$FORM_delete_policy" && {
	config_get policy general ingress_${FORM_int}_policy
	policyid=$FORM_delete_policy
	uci_remove qos ingress_$policyid
	while [ $policyid -lt $policy ]
	do
		uci_rename qos ingress_${FORM_int}_`expr $policyid + 1` ingress_${FORM_int}_$policyid
		policyid=`expr $policyid + 1`
	done
	uci_set qos general ingress_${FORM_int}_policy `expr $policy - 1`
        qos_main_page_display=""
        FORM_ingress_policy="Policy "
}

! empty "$FORM_up_policy" && {
	policy=$FORM_up_policy
	uci_rename qos ingress_${FORM_int}_$policy temp
	uci_rename qos ingress_${FORM_int}_`expr $policy + 1` ingress_${FORM_int}_$policy
	uci_rename qos temp ingress_${FORM_int}_`expr $policy + 1`
        qos_main_page_display=""
        FORM_ingress_policy="Policy "
}

! empty "$FORM_down_policy" && {
	policy=$FORM_down_policy
	uci_rename qos ingress_${FORM_int}_$policy temp
	uci_rename qos ingress_${FORM_int}_`expr $policy - 1` ingress_${FORM_int}_$policy
	uci_rename qos temp ingress_${FORM_int}_`expr $policy - 1`
        qos_main_page_display=""
        FORM_ingress_policy="Policy "
}

header "QoS" "INGRESS" "@TR<<INGRESS Configuration>>" ' onload="modechange()" ' "$SCRIPT_NAME" 

cat <<EOF
<script type="text/javascript" src="/webif.js "></script>
<script type="text/javascript">
<!--
function modechange()
{
	var v;
	v = isset('mode', '0');
	set_visible('field_discard_zone0', v);
	set_visible('field_discard_zone1', v);
	set_visible('field_discard_zone2', v);
	set_visible('field_discard_zone3', v);
	set_visible('field_queue_min', v);
	set_visible('field_queue_max', v);
	
	v = isset('mode', '1');
	set_visible('field_off_tresh', v);
	set_visible('field_on_tresh', v);
}
-->
</script>
EOF

uci_load "qos"

! empty "$FORM_ingress_policy" && {
    qos_main_page_display=""
}

! empty "$FORM_add_new_policy" && {
    qos_main_page_display=""
}

#empty "$FORM_int" && {
! empty "$qos_main_page_display" && {
display_form <<EOF
onchange|modechange
start_form
field|@TR<<Interface>>
select|int|$FORM_int
option|eth0|eth0
option|eth2|eth2
newfield|@TR<<For Mode configuration Click>>
submit|ingress_mode|@TR<<Mode  >>
field|@TR<<For Policy configuration Click>>
submit|ingress_policy|@TR<<Policy >>
field|@TR<<For Policer configuration Click>>
submit|ingress_policer|@TR<<Policer>>
field|@TR<<For Shaper configuration Click>>
submit|ingress_shaper|@TR<<Shaper>>
end_form
EOF
}

! empty "$FORM_ingress_mode" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<$FORM_int Mode Configuration>>
formtag_begin|save_ingress_mode|$SCRIPT_NAME
field|@TR<<Interface>>|int|hidden
text|int|$FORM_int|||readonly
field|@TR<<Mode>>
select|mode|$FORM_mode
option|0|Discard
option|1|Flow Control
option|2|Disabled

field|@TR<<Zone Probe 0>>|field_discard_zone0|hidden
text|discard_zone0|$FORM_discard_zone0
field|@TR<<Zone Probe 1>>|field_discard_zone1|hidden
text|discard_zone1|$FORM_discard_zone1
field|@TR<<Zone Probe 2>>|field_discard_zone2|hidden
text|discard_zone2|$FORM_discard_zone2
field|@TR<<Zone Probe 3>>|field_discard_zone3|hidden
text|discard_zone3|$FORM_discard_zone3
field|@TR<<Min Queue Depth>>|field_queue_min|hidden
text|queue_min|$FORM_queue_min
field|@TR<<Max Queue Depth>>|field_queue_max|hidden
text|queue_max|$FORM_queue_max

field|Off Thresh|field_off_tresh|hidden
text|off_tresh|$FORM_off_tresh
field|On Thresh|field_on_tresh|hidden
text|on_tresh|$FORM_on_tresh

field||spacer1
string|<br />
submit|save_ingress_mode|@TR<<Save>>
formtag_end
end_form
EOF
}

! empty "$FORM_ingress_shaper" && {
display_form <<EOF
start_form|@TR<<$FORM_int Shaper Configuration>>
formtag_begin|save_ingress_shaper|$SCRIPT_NAME
field|@TR<<Interface>>|int|hidden
text|int|$FORM_int|||readonly

field|@TR<<Shaper>>
select|shaper|$FORM_shaper
option|0|Disable
option|1|Enable
field|Rate (Bps)
text|rate|$FORM_rate
field|Max Credit (Bps)
text|max_credit|$FORM_max_credit
field|Over Head
text|over_head|$FORM_over_head

field||spacer1
string|<br />
submit|save_ingress_shaper|@TR<<Save>>
formtag_end
end_form
EOF
}

! empty "$FORM_ingress_policer" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<$FORM_int Policer Configuration>>
formtag_begin|save_ingress_policer|$SCRIPT_NAME
field|@TR<<Interface>>|int|hidden
text|int|$FORM_int|||readonly

field|<b><i>Policer 1 Configuration:</i></b>
field|@TR<<Status>>
select|policer_1|$FORM_policer_1
option|0|Disable
option|1|Enable
field|Rate (pps)
text|rate_1|$FORM_rate_1
field|Max Credit (pps)
text|max_credit_1|$FORM_max_credit_1

field|<b><i>Policer 2 Configuration:</i></b>
field|@TR<<Status>>
select|policer_2|$FORM_policer_2
option|0|Disable
option|1|Enable
field|Rate (pps)
text|rate_2|$FORM_rate_2
field|Max Credit (pps)
text|max_credit_2|$FORM_max_credit_2

field||spacer1
string|<br />
submit|save_ingress_policer|@TR<<Save>>
formtag_end
end_form
EOF
}

! empty "$FORM_ingress_policy" && {

display_form <<EOF
start_form
formtag_begin|add_new_policy|$SCRIPT_NAME
field|int|@TR<<int>>|hidden
text|int|$FORM_int
field
submit|add_new_policy|@TR<< Add New >>
formtag_end
end_form
EOF

#echo "<a class=\"addnew_ico\"href=\"$SCRIPT_NAME?add_new_policy=1\"><span class=\"add\">@TR<<Add New>></span></a><br><br>"

echo "<th colspan=\"11\"><h3>" List of Existing Policies for interface $FORM_int: "</h3></th>
<div class=\"settings\">
<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>
<tr class=\"odd\"><th>Actions</th><th>Src IP</th><th>Src Port</th><th>Dst IP</th><th>Dst Port</th><th>IP Proto</th><th style=\"text-align: center;\">Edit/Delete</th></tr>"
#<tr class=\"odd\"><th>Action</th><th>Policer</th><th>Src IP</th><th>Src Port</th><th>Dst IP</th><th>Dst Port</th><th>IP Proto</th><th style=\"text-align: center;\">Edit/Delete</th></tr>"
count=`uci get qos.general.ingress_${FORM_int}_policy`
if [ -z "$count" -o "$count" = 0 ]; then
  echo "<tr class=\"tr_bg\"><td colspan=\"7\">There are no policies</td></tr>"
fi
i=$count
#i=1
#while [ $i -le $count ]
while [ "$count" -gt 0 ]
do
config_get action ingress_${FORM_int}_$count action
[ -n "$action" ] || action="--"
#config_get policer ingress_${FORM_int}_$i policer
#[ -n "$policer" ] || policer="--"
config_get src ingress_${FORM_int}_$count src
[ -n "$src" ] || src="--"
config_get sport ingress_${FORM_int}_$count sport
[ -n "$sport" ] || sport="--"
config_get dst ingress_${FORM_int}_$count dst
[ -n "$dst" ] || dst="--"
config_get dport ingress_${FORM_int}_$count dport
[ -n "$dport" ] || dport="--"
config_get ipproto ingress_${FORM_int}_$count ipproto
[ -n "$ipproto" ] || ipproto="--"
#echo "<tr><td>$action</td><td>$policer</td><td>$src</td><td>$sport</td><td>$dst</td><td>$dport</td><td>$ipproto</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_policy=${FORM_int}_$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete_policy=${FORM_int}_$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
#echo "<tr><td>$action</td><td>$src</td><td>$sport</td><td>$dst</td><td>$dport</td><td>$ipproto</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_policy=${FORM_int}_$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?int=${FORM_int}?delete_policy=${FORM_int}_$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
if [ "$count" -eq $i ]; then
echo "<tr class=\"tr_bg\"><td>$action</td><td>$src</td><td>$sport</td><td>$dst</td><td>$dport</td><td>$ipproto</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?down_policy=$count&&int=${FORM_int}\"><img alt=\"@TR<<down>>\" src=\"/images/down.gif\" title=\"@TR<<down>>\" /></a>  <a href=\"$SCRIPT_NAME?display_policy=${FORM_int}_$count&&int=${FORM_int}\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete_policy=$count&&int=${FORM_int}\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
elif [ "$count" -eq 1 ] ; then
echo "<tr class=\"tr_bg\"><td>$action</td><td>$src</td><td>$sport</td><td>$dst</td><td>$dport</td><td>$ipproto</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?up_policy=$count&&int=${FORM_int}\"><img alt=\"@TR<<up>>\" src=\"/images/up.gif\" title=\"@TR<<up>>\" /></a>  <a href=\"$SCRIPT_NAME?display_policy=${FORM_int}_$count&&int=${FORM_int}\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete_policy=$count&&int=${FORM_int}\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
else
echo "<tr class=\"tr_bg\"><td>$action</td><td>$src</td><td>$sport</td><td>$dst</td><td>$dport</td><td>$ipproto</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?up_policy=$count&&int=${FORM_int}\"><img alt=\"@TR<<up>>\" src=\"/images/up.gif\" title=\"@TR<<up>>\" /></a>  <a href=\"$SCRIPT_NAME?down_policy=$count&&int=${FORM_int}\"><img alt=\"@TR<<down>>\" src=\"/images/down.gif\" title=\"@TR<<down>>\" /></a>  <a href=\"$SCRIPT_NAME?display_policy=${FORM_int}_$count&&int=${FORM_int}\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete_policy=$count&&int=${FORM_int}\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
fi
#i=`expr $i + 1`
count=`expr $count - 1`
done
echo "</tbody></table><div class=\"clearfix\">&nbsp;</div></div>"
}

! empty "$FORM_add_new_policy" && {
display_form <<EOF
onclick|modechange
start_form|@TR<<$FORM_int New Ingress Policy>>
formtag_begin|new_policy|$SCRIPT_NAME
field|int|@TR<<int>>|hidden
text|int|$FORM_int
field|@TR<<Action>>|field_action
select|action|$FORM_action
option|reserved|@TR<<Reserved>>
option|managed|@TR<<Managed>>
option|dropped|@TR<<Dropped>>
field|@TR<<Policer>>|field_policer
select|policer|$FORM_policer
option|0|@TR<<Disable>>
option|1|@TR<<Policer 1>>
option|2|@TR<<Policer 2>>
field|@TR<<Src IP>>|field_src
text|src|$FORM_src
field|@TR<<Src Netmask>>|field_src_mask
text|src_mask|$FORM_src_mask
field|@TR<<Src Port Min>>|field_src_port_min
text|src_port_min|$FORM_src_port_min
field|@TR<<Src Port Max>>|field_src_port_max
text|src_port_max|$FORM_src_port_max
field|@TR<<Dst IP>>|field_dst
text|dst|$FORM_dst
field|@TR<<Dst Netmask>>|field_dst_mask
text|dst_mask|$FORM_dst_mask
field|@TR<<Dst Port Min>>|field_dst_port_min
text|dst_port_min|$FORM_dst_port_min
field|@TR<<Dst Port Max>>|field_dst_port_max
text|dst_port_max|$FORM_dst_port_max
field|@TR<<IP Proto>>|field_ipproto
text|ipproto|$FORM_ipproto
field||spacer1
string|<br />
submit|new_policy|@TR<<Add>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_policy" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<Edit Policy $FORM_display_policy>>
formtag_begin|save_policy|$SCRIPT_NAME
field|int|@TR<<int>>|hidden
text|int|$FORM_int
field|@TR<<Policy ID>>|policyid|hidden
text|policyid|$FORM_display_policy|||readonly
field|@TR<<Action>>|field_action
select|action|$FORM_action
option|reserved|@TR<<Reserved>>
option|managed|@TR<<Managed>>
option|dropped|@TR<<Dropped>>
field|@TR<<Policer>>|field_policer
select|policer|$FORM_policer
option|0|@TR<<Disable>>
option|1|@TR<<Policer 1>>
option|2|@TR<<Policer 2>>
field|@TR<<Src IP>>|field_src
text|src|$FORM_src
field|@TR<<Src Netmask>>|field_src_mask
text|src_mask|$FORM_src_mask
field|@TR<<Src Port Min>>|field_src_port_min
text|src_port_min|$FORM_src_port_min
field|@TR<<Src Port Max>>|field_src_port_max
text|src_port_max|$FORM_src_port_max
field|@TR<<Dst IP>>|field_dst
text|dst|$FORM_dst
field|@TR<<Dst Netmask>>|field_dst_mask
text|dst_mask|$FORM_dst_mask
field|@TR<<Dst Port Min>>|field_dst_port_min
text|dst_port_min|$FORM_dst_port_min
field|@TR<<Dst Port Max>>|field_dst_port_max
text|dst_port_max|$FORM_dst_port_max
field|@TR<<IP Proto>>|field_ipproto
text|ipproto|$FORM_ipproto
field||spacer1>
string|<br />
submit|save_policy|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

footer ?>

<!--
##WEBIF:name:QoS:100:INGRESS
-->
