#!/usr/bin/webif-page
<?
. "/usr/lib/webif/webif.sh"
uci_load "qos"
qos_main_page_display="y"

! empty "$FORM_display_policy" && {
	policyid=$FORM_display_policy
	config_get FORM_src egress$policyid src
	config_get FORM_src_port egress$policyid sport
	config_get FORM_dst egress$policyid dst
	config_get FORM_dst_port egress$policyid dport
	config_get FORM_protocol egress$policyid proto
	config_get FORM_dscp egress$policyid dscp
	config_get FORM_dscp_set egress$policyid dscp_set
	config_get FORM_queue egress$policyid queue
	qos_main_page_display=""
}

! empty "$FORM_save_policy" && {
SAVED=1
validate <<EOF
EOF
	equal "$?" 0 && {
	policyid=$FORM_policyid
	uci_set qos egress$policyid src "$FORM_src"
	uci_set qos egress$policyid sport "$FORM_src_port"
	uci_set qos egress$policyid dst "$FORM_dst"
	uci_set qos egress$policyid dport "$FORM_dst_port"
	uci_set qos egress$policyid proto "$FORM_protocol"
	uci_set qos egress$policyid dscp "$FORM_dscp"
	uci_set qos egress$policyid dscp_set "$FORM_dscp_set"
	uci_set qos egress$policyid queue "$FORM_queue"
	FORM_egress_policy="Policy"
	}
	qos_main_page_display=""
}

! empty "$FORM_new_policy" && {
SAVED=1
validate <<EOF
EOF
	equal "$?" 0 && {
	config_get policyid general egress_policy
	policyid=`expr $policyid + 1`
	uci_set qos general egress_policy $policyid
#	policy=1
#	while [ $policyid -gt $policy ]
#	do
#		uci_rename qos egress`expr $policyid - 1` egress$policyid
#		policyid=`expr $policyid - 1`
#	done
	uci_add qos policy egress$policyid
	uci_set qos egress$policyid src "$FORM_src"
	uci_set qos egress$policyid sport "$FORM_src_port"
	uci_set qos egress$policyid dst "$FORM_dst"
	uci_set qos egress$policyid dport "$FORM_dst_port"
	uci_set qos egress$policyid proto "$FORM_protocol"
	uci_set qos egress$policyid dscp "$FORM_dscp"
	uci_set qos egress$policyid dscp_set "$FORM_dscp_set"
	uci_set qos egress$policyid queue "$FORM_queue"
	FORM_egress_policy="Policy"
	}
        qos_main_page_display=""
}

! empty "$FORM_delete_policy" && {
	config_get policy general egress_policy
	policyid=$FORM_delete_policy
	uci_remove qos egress$policyid
	while [ $policyid -lt $policy ]
	do
		uci_rename qos egress`expr $policyid + 1` egress$policyid
		policyid=`expr $policyid + 1`
	done
	uci_set qos general egress_policy `expr $policy - 1`
	FORM_egress_policy="Policy"
	qos_main_page_display=""
}

! empty "$FORM_up_policy" && {
        policy=$FORM_up_policy
        uci_rename qos egress$policy temp
        uci_rename qos egress`expr $policy - 1` egress$policy
        uci_rename qos temp egress`expr $policy - 1`
	FORM_egress_policy="Policy"
	qos_main_page_display=""
}

! empty "$FORM_down_policy" && {
        policy=$FORM_down_policy
        uci_rename qos egress$policy temp
        uci_rename qos egress`expr $policy + 1` egress$policy
        uci_rename qos temp egress`expr $policy + 1`
	FORM_egress_policy="Policy"
	qos_main_page_display=""
}

! empty "$FORM_egress_shaper" && {
	config_get FORM_port_status_eth0 shaper port_status_eth0
	config_get FORM_port_rate_eth0 shaper port_rate_eth0
	config_get FORM_port_max_credit_eth0 shaper port_max_credit_eth0
	config_get FORM_queue7_status_eth0 shaper queue7_status_eth0
	config_get FORM_queue7_rate_eth0 shaper queue7_rate_eth0
	config_get FORM_queue7_max_credit_eth0 shaper queue7_max_credit_eth0
	config_get FORM_queue6_status_eth0 shaper queue6_status_eth0
	config_get FORM_queue6_rate_eth0 shaper queue6_rate_eth0
	config_get FORM_queue6_max_credit_eth0 shaper queue6_max_credit_eth0
	config_get FORM_queue5_status_eth0 shaper queue5_status_eth0
	config_get FORM_queue5_rate_eth0 shaper queue5_rate_eth0
	config_get FORM_queue5_max_credit_eth0 shaper queue5_max_credit_eth0
	config_get FORM_queue5_weight_eth0 shaper queue5_weight_eth0
	config_get FORM_queue4_weight_eth0 shaper queue4_weight_eth0
	config_get FORM_queue3_weight_eth0 shaper queue3_weight_eth0
	config_get FORM_queue2_weight_eth0 shaper queue2_weight_eth0
	config_get FORM_queue1_weight_eth0 shaper queue1_weight_eth0

	config_get FORM_port_status_eth2 shaper port_status_eth2
	config_get FORM_port_rate_eth2 shaper port_rate_eth2
	config_get FORM_port_max_credit_eth2 shaper port_max_credit_eth2
	config_get FORM_queue7_status_eth2 shaper queue7_status_eth2
	config_get FORM_queue7_rate_eth2 shaper queue7_rate_eth2
	config_get FORM_queue7_max_credit_eth2 shaper queue7_max_credit_eth2
	config_get FORM_queue6_status_eth2 shaper queue6_status_eth2
	config_get FORM_queue6_rate_eth2 shaper queue6_rate_eth2
	config_get FORM_queue6_max_credit_eth2 shaper queue6_max_credit_eth2
	config_get FORM_queue5_status_eth2 shaper queue5_status_eth2
	config_get FORM_queue5_rate_eth2 shaper queue5_rate_eth2
	config_get FORM_queue5_max_credit_eth2 shaper queue5_max_credit_eth2
	config_get FORM_queue5_weight_eth2 shaper queue5_weight_eth2
	config_get FORM_queue4_weight_eth2 shaper queue4_weight_eth2
	config_get FORM_queue3_weight_eth2 shaper queue3_weight_eth2
	config_get FORM_queue2_weight_eth2 shaper queue2_weight_eth2
	config_get FORM_queue1_weight_eth2 shaper queue1_weight_eth2
	qos_main_page_display=""
}

! empty "$FORM_save_egress_shaper" && {
qos_main_page_display=""
FORM_egress_shaper="Shaper"
SAVED=1
int=$FORM_int

port_shaper_rate_req=""
port_shaper_max_credit_req=""
que7_shaper_rate_req=""
que7_shaper_max_credit_req=""
que6_shaper_rate_req=""
que6_shaper_max_credit_req=""
que1_5_shaper_rate_req=""
que1_5_shaper_max_credit_req=""
que1_5_weight_req=""
port_shaper_rate_eth2_req=""
port_shaper_max_credit_eth2_req=""
que7_shaper_rate_eth2_req=""
que7_shaper_max_credit_eth2_req=""
que6_shaper_rate_eth2_req=""
que6_shaper_max_credit_eth2_req=""
que1_5_shaper_rate_eth2_req=""
que1_5_shaper_max_credit_eth2_req=""
que1_5_weight_eth2_req=""

echo "FORM_int=$FORM_int" >>/test
case $FORM_int in 
   eth0) case $FORM_shaper in
           0) port_shaper_rate_req="required min=64000 max=1000000000"
              port_shaper_max_credit_req="required min=0 max=1000000";;
 
           1) que7_shaper_rate_req="required min=64000 max=1000000000"
              que7_shaper_max_credit_req="required min=0 max=1000000";;
              
           2) que6_shaper_rate_req="required min=64000 max=1000000000"
              que6_shaper_max_credit_req="required min=0 max=1000000";;
              
           3) que1_5_shaper_rate_req="required min=64000 max=1000000000"
              que1_5_shaper_max_credit_req="required min=0 max=1000000"
              que1_5_weight_req="required min=0 max=1000000";;
          esac
          ;;
          
   eth2) case $FORM_shaper in
           0) port_shaper_rate_eth2_req="required min=64000 max=1000000000"
              port_shaper_max_credit_eth2_req="required min=0 max=1000000";;
 
           1) que7_shaper_rate_eth2_req="required min=64000 max=1000000000"
              que7_shaper_max_credit_eth2_req="required min=0 max=1000000";;
              
           2) que6_shaper_rate_eth2_req="required min=64000 max=1000000000"
              que6_shaper_max_credit_eth2_req="required min=0 max=1000000";;
              
           3) que1_5_shaper_rate_eth2_req="required min=64000 max=1000000000"
              que1_5_shaper_max_credit_eth2_req="required min=0 max=1000000"
              que1_5_weight_eth2_req="required min=0 max=1000000";;
          esac
          ;;
esac

validate <<EOF
int|FORM_port_rate_eth0|Port Shaper Rate eth0|$port_shaper_rate_req|$FORM_port_rate_eth0
int|FORM_port_max_credit_eth0|Port Shaper Max Credit eth0|$port_shaper_max_credit_req|$FORM_port_max_credit_eth0
int|FORM_queue7_rate_eth0|Queue 7 Shaper Rate eth0|$que7_shaper_rate_req|$FORM_queue7_rate_eth0
int|FORM_queue7_max_credit_eth0|Queue 7 Shaper Max Credit eth0|$que7_shaper_max_credit_req|$FORM_queue7_max_credit_eth0
int|FORM_queue6_rate_eth0|Queue 6 Shaper Rate eth0|$que6_shaper_rate_req|$FORM_queue6_rate_eth0
int|FORM_queue6_max_credit_eth0|Queue 6 Shaper Max Credit eth0|$que6_shaper_max_credit_req|$FORM_queue6_max_credit_eth0
int|FORM_queue5_rate_eth0|Queue 1-5 Shaper Rate eth0|$que1_5_shaper_rate_req|$FORM_queue5_rate_eth0
int|FORM_queue5_max_credit_eth0|Queue 1-5 Shaper Max Credit eth0|$que1_5_shaper_max_credit_req|$FORM_queue5_max_credit_eth0
int|FORM_queue5_weight_eth0|Queue 5 Weight eth0|$que1_5_weight_req|$FORM_queue5_weight_eth0
int|FORM_queue4_weight_eth0|Queue 4 Weight eth0|$que1_5_weight_req|$FORM_queue4_weight_eth0
int|FORM_queue3_weight_eth0|Queue 3 Weight eth0|$que1_5_weight_req|$FORM_queue3_weight_eth0
int|FORM_queue2_weight_eth0|Queue 2 Weight eth0|$que1_5_weight_req|$FORM_queue2_weight_eth0
int|FORM_queue1_weight_eth0|Queue 1 Weight eth0|$que1_5_weight_req|$FORM_queue1_weight_eth0
int|FORM_port_rate_eth2|Port Shaper Rate eth2|$port_shaper_rate_eth2_req|$FORM_port_rate_eth2
int|FORM_port_max_credit_eth2|Port Shaper Max Credit eth2|$port_shaper_max_credit_eth2_req|$FORM_port_max_credit_eth2
int|FORM_queue7_rate_eth2|Queue 7 Shaper Rate eth2|$que7_shaper_rate_eth2_req|$FORM_queue7_rate_eth2
int|FORM_queue7_max_credit_eth2|Queue 7 Shaper Max Credit eth2|$que7_shaper_max_credit_eth2_req|$FORM_queue7_max_credit_eth2
int|FORM_queue6_rate_eth2|Queue 6 Shaper Rate eth2|$que6_shaper_rate_eth2_req|$FORM_queue6_rate_eth2
int|FORM_queue6_max_credit_eth2|Queue 6 Shaper Max Credit eth2|$que6_shaper_max_credit_eth2_req|$FORM_queue6_max_credit_eth2
int|FORM_queue5_rate_eth2|Queue 1-5 Shaper Rate eth2|$que1_5_shaper_rate_eth2_req|$FORM_queue5_rate_eth2
int|FORM_queue5_max_credit_eth2|Queue 1-5 Shaper Max Credit eth2|$que1_5_shaper_max_credit_eth2_req|$FORM_queue5_max_credit_eth2
int|FORM_queue5_weight_eth2|Queue 5 Weight eth2|$que1_5_weight_eth2_req|$FORM_queue5_weight_eth2
int|FORM_queue4_weight_eth2|Queue 4 Weight eth2|$que1_5_weight_eth2_req|$FORM_queue4_weight_eth2
int|FORM_queue3_weight_eth2|Queue 3 Weight eth2|$que1_5_weight_eth2_req|$FORM_queue3_weight_eth2
int|FORM_queue2_weight_eth2|Queue 2 Weight eth2|$que1_5_weight_eth2_req|$FORM_queue2_weight_eth2
int|FORM_queue1_weight_eth2|Queue 1 Weight eth2|$que1_5_weight_eth2_req|$FORM_queue1_weight_eth2
EOF
	equal "$?" 0 && {
	uci_set qos shaper port_status_eth0 "$FORM_port_status_eth0"
	uci_set qos shaper port_rate_eth0 "$FORM_port_rate_eth0"
	uci_set qos shaper port_max_credit_eth0 "$FORM_port_max_credit_eth0"
	uci_set qos shaper queue7_status_eth0 "$FORM_queue7_status_eth0"
	uci_set qos shaper queue7_rate_eth0 "$FORM_queue7_rate_eth0"
	uci_set qos shaper queue7_max_credit_eth0 "$FORM_queue7_max_credit_eth0"
	uci_set qos shaper queue6_status_eth0 "$FORM_queue6_status_eth0"
	uci_set qos shaper queue6_rate_eth0 "$FORM_queue6_rate_eth0"
	uci_set qos shaper queue6_max_credit_eth0 "$FORM_queue6_max_credit_eth0"
	uci_set qos shaper queue5_status_eth0 "$FORM_queue5_status_eth0"
	uci_set qos shaper queue5_rate_eth0 "$FORM_queue5_rate_eth0"
	uci_set qos shaper queue5_max_credit_eth0 "$FORM_queue5_max_credit_eth0"
	uci_set qos shaper queue5_weight_eth0 "$FORM_queue5_weight_eth0"
	uci_set qos shaper queue4_weight_eth0 "$FORM_queue4_weight_eth0"
	uci_set qos shaper queue3_weight_eth0 "$FORM_queue3_weight_eth0"
	uci_set qos shaper queue2_weight_eth0 "$FORM_queue2_weight_eth0"
	uci_set qos shaper queue1_weight_eth0 "$FORM_queue1_weight_eth0"
	
	uci_set qos shaper port_status_eth2 "$FORM_port_status_eth2"
	uci_set qos shaper port_rate_eth2 "$FORM_port_rate_eth2"
	uci_set qos shaper port_max_credit_eth2 "$FORM_port_max_credit_eth2"
	uci_set qos shaper queue7_status_eth2 "$FORM_queue7_status_eth2"
	uci_set qos shaper queue7_rate_eth2 "$FORM_queue7_rate_eth2"
	uci_set qos shaper queue7_max_credit_eth2 "$FORM_queue7_max_credit_eth2"
	uci_set qos shaper queue6_status_eth2 "$FORM_queue6_status_eth2"
	uci_set qos shaper queue6_rate_eth2 "$FORM_queue6_rate_eth2"
	uci_set qos shaper queue6_max_credit_eth2 "$FORM_queue6_max_credit_eth2"
	uci_set qos shaper queue5_status_eth2 "$FORM_queue5_status_eth2"
	uci_set qos shaper queue5_rate_eth2 "$FORM_queue5_rate_eth2"
	uci_set qos shaper queue5_max_credit_eth2 "$FORM_queue5_max_credit_eth2"
	uci_set qos shaper queue5_weight_eth2 "$FORM_queue5_weight_eth2"
	uci_set qos shaper queue4_weight_eth2 "$FORM_queue4_weight_eth2"
	uci_set qos shaper queue3_weight_eth2 "$FORM_queue3_weight_eth2"
	uci_set qos shaper queue2_weight_eth2 "$FORM_queue2_weight_eth2"
	uci_set qos shaper queue1_weight_eth2 "$FORM_queue1_weight_eth2"
	qos_main_page_display="y"
	FORM_egress_shaper=""
	}
}

header "QoS" "EGRESS" "@TR<<EGRESS Configuration>>" ' onload="modechange()" ' "$SCRIPT_NAME"

cat <<EOF
<script type="text/javascript" src="/webif.js "></script>
<script type="text/javascript">
<!--
function modechange()
{
	var v;
	v = (isset('int', 'eth0') && isset('shaper', '0'));
	set_visible('field_port_eth0', v);
	set_visible('field_port_status_eth0', v);
	set_visible('field_port_rate_eth0', v);
	set_visible('field_port_max_credit_eth0', v);

	v = (isset('int', 'eth0') && isset('shaper', '1'));
	set_visible('field_q7_eth0', v);
	set_visible('field_queue7_status_eth0', v);
	set_visible('field_queue7_rate_eth0', v);
	set_visible('field_queue7_max_credit_eth0', v);

	v = (isset('int', 'eth0') && isset('shaper', '2'));
	set_visible('field_q6_eth0', v);
	set_visible('field_queue6_status_eth0', v);
	set_visible('field_queue6_rate_eth0', v);
	set_visible('field_queue6_max_credit_eth0', v);

	v = (isset('int', 'eth0') && isset('shaper', '3'));
	set_visible('field_q5_eth0', v);
	set_visible('field_weight_eth0', v);
	set_visible('field_queue5_status_eth0', v);
	set_visible('field_queue5_rate_eth0', v);
	set_visible('field_queue5_max_credit_eth0', v);
	set_visible('field_queue5_weight_eth0', v);
	set_visible('field_queue4_weight_eth0', v);
	set_visible('field_queue3_weight_eth0', v);
	set_visible('field_queue2_weight_eth0', v);
	set_visible('field_queue1_weight_eth0', v);
	
	v = (isset('int', 'eth2') && isset('shaper', '0'));
	set_visible('field_port_eth2', v);
	set_visible('field_port_status_eth2', v);
	set_visible('field_port_rate_eth2', v);
	set_visible('field_port_max_credit_eth2', v);

	v = (isset('int', 'eth2') && isset('shaper', '1'));
	set_visible('field_q7_eth2', v);
	set_visible('field_queue7_status_eth2', v);
	set_visible('field_queue7_rate_eth2', v);
	set_visible('field_queue7_max_credit_eth2', v);

	v = (isset('int', 'eth2') && isset('shaper', '2'));
	set_visible('field_q6_eth2', v);
	set_visible('field_queue6_status_eth2', v);
	set_visible('field_queue6_rate_eth2', v);
	set_visible('field_queue6_max_credit_eth2', v);

	v = (isset('int', 'eth2') && isset('shaper', '3'));
	set_visible('field_q5_eth2', v);
	set_visible('field_weight_eth2', v);
	set_visible('field_queue5_status_eth2', v);
	set_visible('field_queue5_rate_eth2', v);
	set_visible('field_queue5_max_credit_eth2', v);
	set_visible('field_queue5_weight_eth2', v);
	set_visible('field_queue4_weight_eth2', v);
	set_visible('field_queue3_weight_eth2', v);
	set_visible('field_queue2_weight_eth2', v);
	set_visible('field_queue1_weight_eth2', v);
}
-->
</script>
EOF

uci_load "qos"

! empty "$FORM_egress_policy" && {
   qos_main_page_display=""
}

! empty "$FORM_add_new_policy" && {
   qos_main_page_display=""
}

#empty "$FORM_submit" && {
! empty "$qos_main_page_display" && {
display_form <<EOF
onchange|modechange
start_form
newfield|@TR<<For Policy configuration Click>>
submit|egress_policy|@TR<<Policy>>
field|@TR<<For Shaper configuration Click>>
submit|egress_shaper|@TR<<Shaper>>
end_form
EOF
}

! empty "$FORM_egress_policy" && {
display_form <<EOF
start_form
formtag_begin|add_new_policy|$SCRIPT_NAME
submit|add_new_policy|@TR<< Add New >>
formtag_end
end_form
EOF

#echo "<a class=\"addnew_ico\"href=\"$SCRIPT_NAME?add_new_vlan=1\"><span class=\"add\">@TR<<Add New>></span></a><br><br>"

config_get count general egress_policy
echo "<th colspan=\"11\"><h3>" List of Existing Policies: "</h3></th>
<div class=\"settings\">
<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>
<tr class=\"odd\"><th>Src IP</th><th>Src Port</th><th>Dst IP</th><th>Dst Port</th><th>Protocol</th><th>DSCP</th><th>Queue</th><th style=\"text-align: center;\">Edit/Delete</th></tr>"
if [ -z "$count" -o "$count" = 0 ]; then
  echo "<tr class=\"tr_bg\"><td colspan=\"8\">There are no policies</td></tr>"
fi
i=1
while [ $i -le $count ]
#while [ $count -gt 0 ]
do
config_get src egress$i src
[ -n "$src" ] || src="--"
config_get sport egress$i sport
[ -n "$sport" ] || sport="--"
config_get dst egress$i dst
[ -n "$dst" ] || dst="--"
config_get dport egress$i dport
[ -n "$dport" ] || dport="--"
config_get proto egress$i proto
[ -n "$proto" ] || proto="--"
config_get dscp egress$i dscp
[ -n "$dscp" ] || dscp="--"
config_get dscp_set egress$i dscp_set
[ -n "$dscp_set" ] || dscp_set="--"
config_get queue egress$i queue
[ -n "$queue" ] || queue="--"
if [ $i -eq 1 ]; then
echo "<tr class=\"tr_bg\"><td>$src</td><td>$sport</td><td>$dst</td><td>$dport</td><td>$proto</td><td>$dscp</td><td>$queue</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?down_policy=$i\"><img alt=\"@TR<<down>>\" src=\"/images/down.gif\" title=\"@TR<<down>>\" /></a>  <a href=\"$SCRIPT_NAME?display_policy=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete_policy=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
elif [ $i -eq $count ]; then
echo "<tr class=\"tr_bg\"><td>$src</td><td>$sport</td><td>$dst</td><td>$dport</td><td>$proto</td><td>$dscp</td><td>$queue</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?up_policy=$i\"><img alt=\"@TR<<up>>\" src=\"/images/up.gif\" title=\"@TR<<up>>\" /></a>  <a href=\"$SCRIPT_NAME?display_policy=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete_policy=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
else
echo "<tr class=\"tr_bg\"><td>$src</td><td>$sport</td><td>$dst</td><td>$dport</td><td>$proto</td><td>$dscp</td><td>$queue</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?up_policy=$i\"><img alt=\"@TR<<up>>\" src=\"/images/up.gif\" title=\"@TR<<up>>\" /></a>  <a href=\"$SCRIPT_NAME?down_policy=$i\"><img alt=\"@TR<<down>>\" src=\"/images/down.gif\" title=\"@TR<<down>>\" /></a>  <a href=\"$SCRIPT_NAME?display_policy=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete_policy=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
fi

i=`expr $i + 1`
done
echo "</tbody></table><div class=\"clearfix\">&nbsp;</div></div>"
}

! empty "$FORM_add_new_policy" && {
display_form <<EOF
start_form|@TR<<New Egress Policy>>
formtag_begin|new_policy|$SCRIPT_NAME
field|@TR<<Src IP>>|field_src
text|src|$FORM_src
field|@TR<<Src Port>>|field_src_port
text|src_port|$FORM_src_port
field|@TR<<Dst IP>>|field_dst
text|dst|$FORM_dst
field|@TR<<Dst Port>>|field_dst_port
text|dst_port|$FORM_dst_port
field|@TR<<Protocol>>|field_protocol
select|protocol|$FORM_protocol
option|any|@TR<<Any>>
option|tcp|@TR<<TCP>>
option|udp|@TR<<UDP>>
option|icmp|@TR<<ICMP>>
field|@TR<<DSCP Match>>|field_dscp
text|dscp|$FORM_dscp
field|@TR<<DSCP Mark Set>>|field_dscp_set
text|dscp_set|$FORM_dscp_set
field|@TR<<Queue>>|field_queue
select|queue|$FORM_queue
option|0|0
option|1|1
option|2|2
option|3|3
option|4|4
option|5|5
option|6|6
option|7|7
field||spacer1
string|<br />
submit|new_policy|@TR<<Add>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_policy" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<Edit Policy $FORM_display_policy>>
formtag_begin|save_policy|$SCRIPT_NAME
field|@TR<<Policy ID>>
text|policyid|$FORM_display_policy|||readonly
field|@TR<<Src IP>>|field_src
text|src|$FORM_src
field|@TR<<Src Port>>|field_src_port
text|src_port|$FORM_src_port
field|@TR<<Dst IP>>|field_dst
text|dst|$FORM_dst
field|@TR<<Dst Port>>|field_dst_port
text|dst_port|$FORM_dst_port
field|@TR<<Protocol>>|field_protocol
select|protocol|$FORM_protocol
option|any|@TR<<Any>>
option|tcp|@TR<<TCP>>
option|udp|@TR<<UDP>>
option|icmp|@TR<<ICMP>>
field|@TR<<DSCP Match>>|field_dscp
text|dscp|$FORM_dscp
field|@TR<<DSCP Mark Set>>|field_dscp_set
text|dscp_set|$FORM_dscp_set
field|@TR<<Queue>>|field_queue
select|queue|$FORM_queue
option|0|0
option|1|1
option|2|2
option|3|3
option|4|4
option|5|5
option|6|6
option|7|7
field||spacer1>
string|<br />
submit|save_policy|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_egress_shaper" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<Shaper Configuration>>
formtag_begin|save_egress_shaper|$SCRIPT_NAME

field|@TR<<Select interface for Shaper Configuration>>
select|int|$FORM_int
option|eth0|eth0
option|eth2|eth2
field|@TR<<Select Shaper>>
select|shaper|$FORM_shaper
option|0|Port Shaper
option|1|Queue 7 Shaper
option|2|Queue 6 Shaper
option|3|Queue 1-5 Shaper
field||spacer1>
string|<br />

field|<b><i>Port Shaper Configuration:</i></b>|field_port_eth0|hidden
field|@TR<<Status>>|field_port_status_eth0|hidden
select|port_status_eth0|$FORM_port_status_eth0
option|1|Enable
option|0|Disable
field|Rate (Bps)|field_port_rate_eth0|hidden
text|port_rate_eth0|$FORM_port_rate_eth0
field|Max Credit (Bps)|field_port_max_credit_eth0|hidden
text|port_max_credit_eth0|$FORM_port_max_credit_eth0

field|<b><i>Port Shaper Configuration:</i></b>|field_port_eth2|hidden
field|@TR<<Status>>|field_port_status_eth2|hidden
select|port_status_eth2|$FORM_port_status_eth2
option|1|Enable
option|0|Disable
field|Rate (Bps)|field_port_rate_eth2|hidden
text|port_rate_eth2|$FORM_port_rate_eth2
field|Max Credit (Bps)|field_port_max_credit_eth2|hidden
text|port_max_credit_eth2|$FORM_port_max_credit_eth2

field|<b><i>Q 7 Shaper Configuration:</i></b>|field_q7_eth0|hidden
field|@TR<<Status>>|field_queue7_status_eth0|hidden
select|queue7_status_eth0|$FORM_queue7_status_eth0
option|1|Enable
option|0|Disable
field|Rate (Bps)|field_queue7_rate_eth0|hidden
text|queue7_rate_eth0|$FORM_queue7_rate_eth0
field|Max Credit (Bps)|field_queue7_max_credit_eth0|hidden
text|queue7_max_credit_eth0|$FORM_queue7_max_credit_eth0

field|<b><i>Q 7 Shaper Configuration:</i></b>|field_q7_eth2|hidden
field|@TR<<Status>>|field_queue7_status_eth2|hidden
select|queue7_status_eth2|$FORM_queue7_status_eth2
option|1|Enable
option|0|Disable
field|Rate (Bps)|field_queue7_rate_eth2|hidden
text|queue7_rate_eth2|$FORM_queue7_rate_eth2
field|Max Credit (Bps)|field_queue7_max_credit_eth2|hidden
text|queue7_max_credit_eth2|$FORM_queue7_max_credit_eth2

field|<b><i>Q 6 Shaper Configuration:</i></b>|field_q6_eth0|hidden
field|@TR<<Status>>|field_queue6_status_eth0|hidden
select|queue6_status_eth0|$FORM_queue6_status_eth0
option|1|Enable
option|0|Disable
field|Rate (Bps)|field_queue6_rate_eth0|hidden
text|queue6_rate_eth0|$FORM_queue6_rate_eth0
field|Max Credit (Bps)|field_queue6_max_credit_eth0|hidden
text|queue6_max_credit_eth0|$FORM_queue6_max_credit_eth0

field|<b><i>Q 6 Shaper Configuration:</i></b>|field_q6_eth2|hidden
field|@TR<<Status>>|field_queue6_status_eth2|hidden
select|queue6_status_eth2|$FORM_queue6_status_eth2
option|1|Enable
option|0|Disable
field|Rate (Bps)|field_queue6_rate_eth2|hidden
text|queue6_rate_eth2|$FORM_queue6_rate_eth2
field|Max Credit (Bps)|field_queue6_max_credit_eth2|hidden
text|queue6_max_credit_eth2|$FORM_queue6_max_credit_eth2

field|<b><i>Q 1-5 Shaper Configuration:</i></b>|field_q5_eth0|hidden
field|@TR<<Status>>|field_queue5_status_eth0|hidden
select|queue5_status_eth0|$FORM_queue5_status_eth0
option|1|Enable
option|0|Disable
field|Rate (Bps)|field_queue5_rate_eth0|hidden
text|queue5_rate_eth0|$FORM_queue5_rate_eth0
field|Max Credit (Bps)|field_queue5_max_credit_eth0|hidden
text|queue5_max_credit_eth0|$FORM_queue5_max_credit_eth0

field|<b><i>Q 1-5 Shaper Configuration:</i></b>|field_q5_eth2|hidden
field|@TR<<Status>>|field_queue5_status_eth2|hidden
select|queue5_status_eth2|$FORM_queue5_status_eth2
option|1|Enable
option|0|Disable
field|Rate (Bps)|field_queue5_rate_eth2|hidden
text|queue5_rate_eth2|$FORM_queue5_rate_eth2
field|Max Credit (Bps)|field_queue5_max_credit_eth2|hidden
text|queue5_max_credit_eth2|$FORM_queue5_max_credit_eth2

field|<b><i>Q 1-5 Weight Configuration:</i></b>|field_weight_eth0|hidden
field|Queue 5 Weight (Bytes)|field_queue5_weight_eth0|hidden
text|queue5_weight_eth0|$FORM_queue5_weight_eth0
field|Queue 4 Weight (Bytes)|field_queue4_weight_eth0|hidden
text|queue4_weight_eth0|$FORM_queue4_weight_eth0
field|Queue 3 Weight (Bytes)|field_queue3_weight_eth0|hidden
text|queue3_weight_eth0|$FORM_queue3_weight_eth0
field|Queue 2 Weight (Bytes)|field_queue2_weight_eth0|hidden
text|queue2_weight_eth0|$FORM_queue2_weight_eth0
field|Queue 1 Weight (Bytes)|field_queue1_weight_eth0|hidden
text|queue1_weight_eth0|$FORM_queue1_weight_eth0

field|<b><i>Q 1-5 Weight Configuration:</i></b>|field_weight_eth2|hidden
field|Queue 5 Weight (Bytes)|field_queue5_weight_eth2|hidden
text|queue5_weight_eth2|$FORM_queue5_weight_eth2
field|Queue 4 Weight (Bytes)|field_queue4_weight_eth2|hidden
text|queue4_weight_eth2|$FORM_queue4_weight_eth2
field|Queue 3 Weight (Bytes)|field_queue3_weight_eth2|hidden
text|queue3_weight_eth2|$FORM_queue3_weight_eth2
field|Queue 2 Weight (Bytes)|field_queue2_weight_eth2|hidden
text|queue2_weight_eth2|$FORM_queue2_weight_eth2
field|Queue 1 Weight (Bytes)|field_queue1_weight_eth2|hidden
text|queue1_weight_eth2|$FORM_queue1_weight_eth2

field||spacer1>
string|<br />
submit|save_egress_shaper|@TR<<Save>>
formtag_end

end_form
EOF
}

footer ?>
<!--
##WEBIF:name:QoS:200:EGRESS
-->
