#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "nat"

if empty "$FORM_general"; then
	FORM_nat_enable=${nat_enable:-$(uci get nat.general.enable)}
else
	SAVED=1
validate <<EOF
string|FORM_nat_enable|@TR<<Enable NAT>>||$FORM_nat_enable
EOF
	equal "$?" 0 && {
	case "$FORM_nat_enable" in
	yes) uci_set nat general enable "yes" ;;
	*) uci_set nat general enable "no" ;;
	esac
}
fi

! empty "$FORM_new_rule" && {
	SAVED=1
validate <<EOF
int|FORM_pub_port|@TR<<Public Port>>|required|$FORM_pub_port
ip|FORM_local_ipaddr|@TR<<Local IP Address>>|required|$FORM_local_ipaddr
int|FORM_local_port|@TR<<Local Port>>|required|$FORM_local_port
EOF
	equal "$?" 0 && {
	ruleid=`uci get nat.general.number`
	ruleid=`expr $ruleid + 1`
	uci_add nat nat rule$ruleid
	uci_set nat rule$ruleid pubport $FORM_pub_port
	uci_set nat rule$ruleid localipaddr $FORM_local_ipaddr
	uci_set nat rule$ruleid localport $FORM_local_port
	uci_set nat general number $ruleid
	}
}

! empty "$FORM_display_edit_rule" && {
	ruleid=$FORM_display_edit_rule
	FORM_pub_port=${pub_port:-$(uci get nat.rule$ruleid.pubport)}
	FORM_local_ipaddr=${local_ipaddr:-$(uci get nat.rule$ruleid.localipaddr)}
	FORM_local_port=${local_port:-$(uci get nat.rule$ruleid.localport)}
}

! empty "$FORM_save_edit_rule" && {
	SAVED=1
validate <<EOF
int|FORM_pub_port|@TR<<Public Port>>|required|$FORM_pub_port
ip|FORM_local_ipaddr|@TR<<Local IP Address>>|required|$FORM_local_ipaddr
int|FORM_local_port|@TR<<Local Port>>|required|$FORM_local_port
EOF
	equal "$?" 0 && {
	uci_set nat rule$FORM_ruleid pubport $FORM_pub_port
	uci_set nat rule$FORM_ruleid localipaddr $FORM_local_ipaddr
	uci_set nat rule$FORM_ruleid localport $FORM_local_port
        }
}

! empty "$FORM_delete" && {
	number=`uci get nat.general.number`
	ruleid=$FORM_delete
	uci_remove nat rule$ruleid
	while [ $ruleid -lt $number ]
	do
	uci_rename nat rule`expr $ruleid + 1` rule$ruleid
	ruleid=`expr $ruleid + 1`
	done
	uci_set nat general number `expr $number - 1`
}

if empty "$FORM_new_dmz"; then
	FORM_dmz_enable=${dmz_enable:-$(uci get nat.general.dmzenable)}
	FORM_dmz_ipaddr=${dmz_ipaddr:-$(uci get nat.general.dmzip)}
else
	SAVED=1
validate <<EOF
string|FORM_dmz_enable|@TR<<DMZ Enable>>||$FORM_dmz_enable
ip|FORM_dmz_ipaddr|@TR<<DMZ IP Address>>||$FORM_dmz_ipaddr
EOF
	equal "$?" 0 && {
	case "$FORM_dmz_enable" in
	yes) uci_set nat general dmzenable "yes" ;;
	*) uci_set nat general dmzenable "no" ;;
	esac
	uci_set nat general dmzip "$FORM_dmz_ipaddr"
}
fi

header "NAT" "General" "@TR<<NAT Configuration>>" 

#cat <<EOF
#<script type="text/javascript" src="/webif.js "></script>
#<script type="text/javascript">
#<!--
#function modechange()
#{
#        var v;
#        v = isset('dmz_enable', 'yes');
#        set_visible('field_dmz_ipaddr', v);
#
#        hide('save');
#        show('save');
#}
#-->
#</script>
#EOF

display_form <<EOF
formtag_begin|general|$SCRIPT_NAME
start_form|@TR<<Enable NAT>>
checkbox|nat_enable|$FORM_nat_enable|yes|@TR<<Enable NAT>>
helpitem|Enable NAT
helptext|To Enable and disable NAT.
field||spacer1
submit|general|@TR<<Save>>
formtag_end
end_form

start_form|@TR<<List of Existing Rules>>
end_form
EOF

count=`uci get nat.general.number`
echo "<table style=\"width: 70%; text-align: left;\" border=\"1\" cellpadding=\"2\" cellspacing=\"2\" align=\"center\"><tr><th>Rule ID</th><th>Public Port</th><th>Local IP</th><th>Local Port</th><th>Actions</th></tr>"
#echo "<tr><td>&nbsp</td><td>&nbsp</td><td>&nbsp</td><td>&nbsp</td><td>&nbsp</td></tr>"
i=1
while [ $i -le $count ]
do
pub_port=`uci get nat.rule$i.pubport`
local_ipaddr=`uci get nat.rule$i.localipaddr`
local_port=`uci get nat.rule$i.localport`
echo "<tr><td>$i</td>"
echo "<td>$pub_port</td>"
echo "<td>$local_ipaddr</td>"
echo "<td>$local_port</td>"

echo "<td><a href=\"$SCRIPT_NAME?display_edit_rule=$i\">@TR<<edit>></a>"
echo "/"
echo "<a href=\"$SCRIPT_NAME?delete=$i\" >@TR<<delete>></a>"
echo "</td></tr>"
i=`expr $i + 1`
done
echo "</table><br>"

display_form <<EOF
start_form
field||spacer1
string|<br />
formtag_begin|new_nat_rule|$SCRIPT_NAME
submit|new_nat_rule|@TR<< New Rule >>
formtag_end
end_form
EOF

! empty "$FORM_new_nat_rule" && {

display_form <<EOF
start_form|@TR<<New Rule>>
formtag_begin|new_rule|$SCRIPT_NAME
field|@TR<<Public Port>>|field_pub_port
text|pub_port|$FORM_pub_port
field|@TR<<Local IP Addres>>|field_local_ipaddr
text|local_ipaddr|$FORM_local_ipaddr
field|@TR<<Local Port>>|field_local_port
text|local_port|$FORM_local_port
field||spacer1
string|<br />
submit|new_rule|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_edit_rule" && {

display_form <<EOF
onchange|modechange
start_form|@TR<<Edit Rule $FORM_display_edit_rule>>
formtag_begin|save_edit_rule|$SCRIPT_NAME
field|@TR<<Rule ID>>
text|ruleid|$FORM_display_edit_rule|||readonly
field|@TR<<Public Port>>|field_pub_port
text|pub_port|$FORM_pub_port
field|@TR<<Local IP Addres>>|field_local_ipaddr
text|local_ipaddr|$FORM_local_ipaddr
field|@TR<<Local Port>>|field_local_port
text|local_port|$FORM_local_port
field||spacer1
string|<br />
submit|save_edit_rule|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

display_form <<EOF
#onclick|modechange
start_form|@TR<<DMZ>>
formtag_begin|new_dmz|$SCRIPT_NAME
checkbox|dmz_enable|$FORM_dmz_enable|yes|@TR<<Enable DMZ>>
#field|@TR<<IP Address>>|field_dmz_ipaddr|hidden
field|@TR<<IP Address>>|field_dmz_ipaddr
text|dmz_ipaddr|$FORM_dmz_ipaddr
field||spacer1
submit|new_dmz|@TR<<Save>>
formtag_end
end_form
EOF

footer ?>

<!--
##WEBIF:name:NAT:100:General
-->
