#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "firewall"
uci_load "firewall_new"

if empty "$FORM_submit"; then
	FORM_security_level_value=${security_level_value:-$(uci get firewall.general.security_level)}
else
        SAVED=1
	equal "$?" 0 && {
	uci_set firewall general security_level "$FORM_security_level_value"
	uci_set firewall_new general_new flag "1"
	}
fi

#####################################################################
header "Firewall" "General" "@TR<<Firewall General Configuration>>" '' "$SCRIPT_NAME"
#####################################################################

wan=`uci get bridge.general.wan`
equal $wan 1 && {
display_form <<EOF
string|<h3>WAN is part of bridge.</h3>
EOF
}

! equal $wan 1 && {
display_form <<EOF

start_form|@TR<<Security Level>>

radio|security_level_value|$FORM_security_level_value|no|@TR<<No Security>>
helpitem|No Security
helptext|INBOUND traffic (WAN to LAN) is allowed.
helptext|OUTBOUND traffic (LAN to WAN) is allowed.
field||spacer1
string|<br /><br /><br />

radio|security_level_value|$FORM_security_level_value|low|@TR<<Low Security>>
helpitem|Low Security
helptext|INBOUND traffic (WAN to LAN) is blocked.
helptext|OUTBOUND traffic (LAN to WAN) is allowed.
field||spacer1
string|<br /><br /><br />

radio|security_level_value|$FORM_security_level_value|high|@TR<<High Security>>
helpitem|High Security
helptext|INBOUND traffic (WAN to LAN) is blocked.
helptext|OUTBOUND traffic (LAN to WAN) is blocked.
field||spacer1
string|<br /><br /><br />

helpitem|NOTE
helptext|The General Security settings are applicable for both IPv4 and IPv6 traffic. However, the Firewall-Rules are applicable only for IPv4 traffic.
end_form
submit|save|@TR<<Save>>
EOF
}

footer ?>
<!--
##WEBIF:name:Firewall:100:General
-->
