#!/bin/ash
#
#
# Handler for config application of all types.
#
#   Types supported:
#	uci-*		UCI config files
#	file-*		Undefined format for whatever
#	edited-files-*  raw edited files
#
#
. /usr/lib/webif/functions.sh
. /lib/config/uci.sh

config_cb() {
	config_get TYPE "$CONFIG_SECTION" TYPE
	case "$TYPE" in
		timezone)
			timezone_cfg="$CONFIG_SECTION"
		;;
	esac
}

HANDLERS_file='
	hosts) rm -f /etc/hosts; mv $config /etc/hosts; killall -HUP dnsmasq ;;
	ethers) rm -f /etc/ethers; mv $config /etc/ethers; killall -HUP dnsmasq ;;
'

# for some reason a for loop with "." doesn't work
eval "$(cat /usr/lib/webif/apply-*.sh 2>&-)"

mkdir -p "/tmp/.webif"
_pushed_dir=$(pwd)
cd "/tmp/.webif"

# edited-files/*		user edited files - stored with directory tree in-tact
for edited_file in $(find "/tmp/.webif/edited-files/" -type f 2>&-); do
	target_file=$(echo "$edited_file" | sed s/'\/tmp\/.webif\/edited-files'//g)
	echo "@TR<<Processing>> $target_file"
	fix_symlink_hack "$target_file"
	if tr -d '\r' <"$edited_file" >"$target_file"; then
		rm "$edited_file" 2>&-
	else
		echo "@TR<<Critical Error>> : @TR<<Could not replace>> $target_file. @TR<<Media full>>?"
	fi
done
# leave if some files not applied
rm -r "/tmp/.webif/edited-files" 2>&-

# file-*		other config files
for config in $(ls file-* 2>&-); do
	name=${config#file-}
	echo "@TR<<Processing>> @TR<<config file>>: $name"
	eval 'case "$name" in
		'"$HANDLERS_file"'
	esac'
done


# config-conntrack	  Conntrack Config file
for config in $(ls config-conntrack 2>&-); do
	echo '@TR<<Applying>> @TR<<conntrack settings>> ...'
	fix_symlink_hack "/etc/sysctl.conf"
	# set any and all net.ipv4.netfilter settings.
	for conntrack in $(grep ip_ /tmp/.webif/config-conntrack); do
		variable_name=$(echo "$conntrack" | cut -d '=' -f1)
		variable_value=$(echo "$conntrack" | cut -d '"' -f2)
		echo "&nbsp;@TR<<Setting>> $variable_name to $variable_value"
		remove_lines_from_file "/etc/sysctl.conf" "net.ipv4.netfilter.$variable_name"
		echo "net.ipv4.netfilter.$variable_name=$variable_value" >> /etc/sysctl.conf
	done
	sysctl -p 2>&- 1>&- # reload sysctl.conf
	rm -f /tmp/.webif/config-conntrack
	echo '@TR<<Done>>'
done

# init_theme - initialize a new theme
init_theme() {
	echo '@TR<<Initializing theme ...>>'	
	uci_load "webif"
	newtheme="$CONFIG_theme_id"	
	# if theme isn't present, then install it		
	! exists "/www/themes/$newtheme/webif.css" && {
		install_package "webif-theme-$newtheme"	
	}
	if ! exists "/www/themes/$newtheme/webif.css"; then
		# if theme still not installed, there was an error
		echo "@TR<<Error>>: @TR<<installing theme package>>."
	else
		# create symlink to new active theme if its not already set right
		current_theme=$(ls /www/themes/active -l | cut -d '>' -f 2 | sed s/'\/www\/themes\/'//g)
		! equal "$current_theme" "$newtheme" && {
			rm /www/themes/active
			ln -s /www/themes/$newtheme /www/themes/active
		}
	fi		
	echo '@TR<<Done>>'
}

# switch_language (old_lang)  - switches language if changed
switch_language() {
	oldlang="$1"
	uci_load "webif"
	newlang="$CONFIG_general_lang"
	! equal "$newlang" "$oldlang" && {
		echo '@TR<<Applying>> @TR<<Installing language pack>> ...'
		# if not English then we install language pack
		! equal "$newlang" "en" && {
			# build URL for package
			#  since the original webif may be installed to, have to make sure we get latest ver
			webif_version=$(ipkg status webif | awk '/Version:/ { print $2 }')
			xwrt_repo_url=$(cat /etc/ipkg.conf | grep X-Wrt | cut -d' ' -f3)
			# always install language pack, since it may have been updated without package version change
			ipkg install "${xwrt_repo_url}/webif-lang-${newlang}_${webif_version}_all.ipk" -force-reinstall -force-overwrite | uniq
			# switch to it if installed, even old one, otherwise return to previous
			if equal "$(ipkg status "webif-lang-${newlang}" |grep "Status:" |grep " installed" )" ""; then
				echo '@TR<<Error installing language pack>>!'
			fi
		}
		echo '@TR<<Done>>'
	}
}

uci_load_originals() {
	local cfsection
	config_load "$1"
	for cfsection in $CONFIG_SECTIONS; do
		config_rename "$cfsection" "orig_$cfsection"
	done
	CONFIG_orig_SECTION="$CONFIG_SECTIONS"
}

uci_unset_originals() {
	local cfsection
	local oldvar
	for cfsection in $CONFIG_orig_SECTION; do
		for oldvar in $(set | grep "^CONFIG_${cfsection}_" | sed -e 's/\(.*\)=.*$/\1/'); do
			unset "$oldvar"
		done
	done
	unset CONFIG_orig_SECTION
}

#
# now apply any UCI config changes
#
restart_webif=0
for package in $(ls /tmp/.uci/* 2>&-); do
	# do not process lock files
	[ "${package%.lock}" != "${package}" ] && continue
	# store original language before committing new one so we know if changed
	equal "$package" "/tmp/.uci/webif" && {
		uci_load_originals "webif"
		oldlang="$CONFIG_orig_general_lang"
		uci_unset_originals "webif"
		uci_load "webif"
	}
	equal "$package" "/tmp/.uci/network" && {
	cat /tmp/.uci/network | awk '/clear/ { print "ifdown " $2 }' |sh
	cat /tmp/.uci/network | awk '/interface/ { print "uci set network." $3 ".flag=1" }' |sh
#	ifdown -a
	}
	equal "$package" "/tmp/.uci/wireless" && {
		uci set wireless.general.flag=1
	}
	echo "@TR<<Committing>> ${package#/tmp/.uci/} ..."
	uci_commit "$package"
	case "$package" in
		"/tmp/.uci/qos") /etc/init.d/qos-fpp start;;
		"/tmp/.uci/webif") 
			switch_language "$oldlang"
			init_theme
#			/etc/init.d/webif start
			restart_webif=1
			;;
		"/tmp/.uci/upnpd")
			status=`uci get upnpd.config.enabled`
				case "$status" in
				1) /etc/init.d/miniupnpd start ;;
				0) /etc/init.d/miniupnpd stop ;;
				esac
			;;
		"/tmp/.uci/network")
			echo '@TR<<Reloading>> @TR<<network>> ...'
			flag=`uci get wireless.general.flag`
			if [ "$flag" = "1" ] ; then
			/sbin/wifi up 
			uci set wireless.general.flag=0
			uci commit wireless
			fi
#			ifup -a

			ifaces=""
			append ifaces "lan wan"
			count=`uci get bridge.general.count`
			i=1
			while [ $i -le "$count" ]
			do
			brname=`uci get bridge.general.brname$i`
			append ifaces "$brname"
			i=`expr $i + 1`
			done
			for iface in $ifaces ; do
			flag=`uci get network.$iface.flag`
			if [ "$flag" = "1" ] ; then
			ifup $iface
			uci set network.$iface.flag=0
			fi
			done
			fw_restart="n"
			fw_restart=`uci get network.wan.firewall_restart`
			uci set network.wan.firewall_restart="n"
			uci commit network

			wifi=`uci get wireless.general.type`
			case "$wifi" in
			ra0) 
			ssid=`uci get wireless.ra0.ssid`
			iwpriv ra0 set SSID="$ssid" >/dev/null 2>/dev/null ;;
			esac
			[ "$fw_restart" = "y" ] && {
			  echo '@TR<<Reloading>> @TR<<Firewall>> ...'
			  /etc/init.d/firewall start
			}
			;;
		"/tmp/.uci/network6")
			for i in lan wan loopback; do
			ifname=`uci get network6.$i.ifname`
			status=`uci get network6.$i.status6`
			ipaddr=`uci get network6.$i.ipaddr6`
			netmask=`uci get network6.$i.netmask6`
			ipaddr_new=`uci get network6.$i.ipaddr6_new`
			netmask_new=`uci get network6.$i.netmask6_new`
#			ip -6 addr flush dev $ifname
			ip -6 addr del $ipaddr/$netmask dev $ifname >&- 2>&- <&-
			if [ "$status" = "1" ] ; then
			ip -6 addr add $ipaddr_new/$netmask_new dev $ifname >&- 2>&- <&-
			fi
			uci set network6.$i.ipaddr6=$ipaddr_new
			uci set network6.$i.netmask6=$netmask_new
			done
			uci commit network6
			;;
		"/tmp/.uci/vlan")
			echo '@TR<<Reloading>> @TR<<Vlans>> ...'
			/etc/init.d/vlan start
			;;
		"/tmp/.uci/route")
			echo '@TR<<Reloading>> @TR<<Routes>> ...'
			/etc/init.d/route start
			;;
		"/tmp/.uci/bridge")
			echo '@TR<<Reloading>> @TR<<bridge>> ...'
			;;
		"/tmp/.uci/samba")
                        /etc/init.d/samba stop
			echo '@TR<<Reloading>> @TR<<Samba>> ...'
			samba_enable=`uci get samba.general.enable`
			if [ "$samba_enable" = "1" ] ; then
			  count=`uci get samba.general.usercount`
			  i=1
			  while [ "$i" -le "$count" ]
			  do
			    username=`uci get samba.smbusr$i.name`
			    password=`uci get samba.smbusr$i.password`
			    echo "username=$username password=$password" >>/testsamba
			    smbpasswd $username $password
			    i=`expr $i + 1`
			  done
                          /etc/init.d/samba start
			fi
                        ;;
		"/tmp/.uci/dhcp")
			echo '@TR<<Reloading>> @TR<<Dnsmasq>> ...'
			killall dnsmasq >&- 2>&- <&-
			[ -z "$(ps | grep "[d]nsmasq ")" ] && /etc/init.d/dnsmasq start
			;;
		"/tmp/.uci/firewall_new")
			echo '@TR<<Reloading>> @TR<<Firewall>> ...'
			/etc/init.d/firewall apply
			;;
		"/tmp/.uci/nat_new")
			echo '@TR<<Reloading>> @TR<<Nat>> ...'
			/etc/init.d/nat apply
			;;
                "/tmp/.uci/ipsec_new")
                        echo '@TR<<Reloading>> @TR<<IPsec>> ...'
                        /etc/init.d/ipsec apply
                        ;;
		"/tmp/.uci/asterisk")
			echo '@TR<<Reloading>> @TR<<Asterisk>> ...'
#			/etc/init.d/asterisk stop
#			/etc/init.d/asterisk start
			/lib/asterisk/configure_asterisk
			asterisk -rx "sip reload"  >&- 2>&- <&-
			asterisk -rx "mspd reload conf"  >&- 2>&- <&-
			asterisk -rx "extensions reload"  >&- 2>&- <&-
			asterisk -rx "reload app_voicemail.so"  >&- 2>&- <&-
			;;
		"/tmp/.uci/wireless")
			echo '@TR<<Reloading>> @TR<<wireless>> ...'
			wifi 
			uci set wireless.general.flag=0
			uci commit wireless
			;;
		"/tmp/.uci/syslogd")
			# for kamikaze
			echo '@TR<<Reloading>> @TR<<syslogd>> ...'
			killall syslogd >&- 2>&- <&-
			/etc/init.d/syslog start >&- 2>&- <&- ;;
		"/tmp/.uci/openvpn")
			echo '@TR<<Reloading>> @TR<<OpenVPN>> ...'
			killall openvpn >&- 2>&- <&-
			/etc/init.d/openvpn start ;;
		"/tmp/.uci/system")
			/etc/init.d/boot start ;;
		"/tmp/.uci/snmp")
			echo '@TR<<Exporting>> @TR<<snmp settings>> ...'
			[ -e "/sbin/save_snmp" ] && {
				/sbin/save_snmp >&- 2>&-
			}
			
			echo '@TR<<Reloading>> @TR<<snmp settings>> ...'
			[ ! -e "/etc/init.d/snmpd" ] && {
				ln -s "/etc/init.d/snmpd" "/etc/init.d/S92snmpd" 2>/dev/null
			}
			/etc/init.d/S??snmpd restart >&- 2>&-
			;;
		"/tmp/.uci/updatedd")
			uci_load "updatedd"
			if [ "$CONFIG_ddns_update" = "1" ]; then
				/etc/init.d/ddns enable >&- 2>&- <&-
				/etc/init.d/ddns stop >&- 2>&- <&-
				/etc/init.d/ddns start >&- 2>&- <&-
			else
				/etc/init.d/ddns disable >&- 2>&- <&-
				/etc/init.d/ddns stop >&- 2>&- <&-
			fi
		 	;;
		"/tmp/.uci/timezone")
			echo '@TR<<Exporting>> @TR<<TZ setting>> ...'
			uci_load "timezone"
			eval CONFIG_timezone_posixtz="\$CONFIG_${timezone_cfg}_posixtz"
			# create symlink to /tmp/TZ if /etc/TZ doesn't exist
			# todo: -e | -f | -d didn't seem to work here, so I used find
			if [ -z $(find "/etc/TZ" 2>/dev/null) ]; then
				ln -s /tmp/TZ /etc/TZ
			fi
			# eJunky: set timezone
			[ "$CONFIG_timezone_posixtz" ] && echo $CONFIG_timezone_posixtz > /etc/TZ
			;;
	esac
done
if [ "$restart_webif" = "1" ] ; then
  passwdchng=`uci get webif.password.passwdchng`
  if [ "$passwdchng" = "y" ] ; then
    echo "<strong>Password changed. Please wait few seconds, the pop-up will ask you to enter the new login details to login again.</strong>"
  fi
  uci set webif.password.passwdchng="n"
  uci commit webif
  echo "</pre>${FORM_prev:+<meta http-equiv=\"refresh\" content=\"4; URL=$FORM_prev\" />}<pre>"
  /etc/init.d/webif start
fi

#
# commit tarfs if exists
#
[ -f "/rom/local.tar" ] && config save

#
# cleanup
#
cd "$pushed_dir"
rm /tmp/.webif/* >&- 2>&-
rm /tmp/.uci/* >&- 2>&-

