#!/bin/sh /etc/rc.common
### HA function is only deployed on Vigor3900
#This script is used to polling one special event:
#G40237: If all WAN switch ports are down, stop send CARP
#Mechanism for multi-HA LAN environment(Active-Standby method)

last_all_wans=""
NO_WAN_IS_ENABLED=0
FIRST_LAUNCH=1
HEALTHY_MASTER=1

HA_profile=$2
[ -f "/var/run/ucarp/${HA_profile}_ASmaster.pid" ] && echo $$ >/var/run/ucarp/${HA_profile}_ASmaster.pid
vip=`uci get ucarp_as.$HA_profile.vip`
lan=`uci get ucarp_as.$HA_profile.lan`
wan_port_detect=`uci get ucarp_mode.general.wan_port_detect`

restore_CARP_ad()
{
	[ -f /var/run/ucarp/$1.pid ] && {
		ucarp_PID=`cat /var/run/ucarp/$1.pid`
		[ -z "$ucarp_PID" ] || kill -SIGUSR2 $ucarp_PID 2>/dev/null
	}
}
attach_vip()
{
	#Attach VIP to LAN
	ifname=lan-$lan
	lan_mask=`uci get network.$lan.static_netmask`
	macaddr=`uci get network.$lan.macaddr`
	/usr/sbin/ip addr add $vip/$lan_mask dev $ifname brd + 2> /dev/null > /dev/null
	[ "$?" = 0 ] && logger -p 152.5 "[High Availability] master-polling_AS($HA_profile): Attach VIP($vip) to $ifname"
	#Add VIP into ipset:ip_lanX for user management dst bypassing
	ipset -A ip_$lan $vip
	#send garp of VIP
	arping -b -c 1 -i $ifname -S $macaddr $vip > /dev/null
}
stop_CARP_ad() {
	[ -f /var/run/ucarp/$1.pid ] && {
		ucarp_PID=`cat /var/run/ucarp/$1.pid`
		[ -z "$ucarp_PID" ] || kill -SIGUSR1 $ucarp_PID 2>/dev/null	
	}
}
remove_vip()
{
	#Remove VIP from LAN
	ifname=lan-$lan
	lan_mask=`uci get network.$lan.static_netmask`
	/usr/sbin/ip addr del $vip/$lan_mask dev $ifname 2> /dev/null >/dev/null
	[ "$?" = 0 ] && logger -p 152.5 "[High Availability] master-polling_AS($HA_profile): Remove VIP($vip) from $ifname"
	#remove VIP from ipset:ip_lanX for user management dst bypassing
	ipset -D ip_$lan $vip
}

set_status_to_master() {
	uci set ucarp_as.$HA_profile.ha_profile_status=Master
}
set_to_mal_master_WAN(){
	uci set ucarp_as.$HA_profile.ha_profile_status=WAN_Failed
}

check_rebind_flag()
{
	local ucarp_pid
	ucarp_pid=`cat var/run/ucarp/$HA_profile.pid`
	[ -e "/tmp/HA_rebind_$ucarp_pid" ] && {
		rebind_flag=`cat /tmp/HA_rebind_$ucarp_pid`
		if [ "$rebind_flag" = "1" ] ;then
			logger -p 152.5 "[High Availability] master-polling_AS($HA_profile): rebind flag is set! do re-attaching. (AS profile:$HA_profile)"
			attach_vip
		fi
		rm -f "/tmp/HA_rebind_$ucarp_pid"
	}
}
send_garp_vip()
{
	ifname=lan-$lan
	macaddr=`uci get network.$lan.macaddr`
	arping -b -c 1 -i $ifname -S $macaddr $vip >/dev/null 2>&1
}

while true; do
	################ G40237: If all WAN profile online status are down, stop ucarp sending CARP ad
	if [ "$wan_port_detect" = "enable" ] ;then
		enabled_WANs=`json -f /var/cd_status get global.interfaces`
		if [ -n "$enabled_WANs" ] ;then
			NO_WAN_IS_ENABLED=0
			all_wan_status=`json get ucarp.general.all_wan_status`
			if [ "$all_wan_status" = "up" ] ;then
				if [ -z "$last_all_wans" -o "$last_all_wans" = "down" ] ;then
					logger -p 152.5 "[High Availability] master-polling_AS($HA_profile): one of enabled WAN/USB's switch port is up, start to send AD"
					HEALTHY_MASTER=1
					last_all_wans=up
					restore_CARP_ad $HA_profile
					attach_vip
					##### Enable LAN DHCP Service
					json set ucarp.$lan dhcp_state=up
					logger -p 152.5 "[High Availability] master-polling_AS($HA_profile): enable $lan dhcp service"
					set_status_to_master
					/etc/init.d/dhcpd apply
					##### G49223: LAN pppoe server
					/etc/init.d/pppoe_server restart
					##### Send signal of "DevChange" to ubf_polling_d
					web_portal_status=`uci get general_conf.base.status`
					[ "$web_portal_status" == "enable" ] && kill -SIGUSR1 `pidof ubf_polling_d` >/dev/null 2>&1
					##### G49368: restart vlan
					/etc/init.d/rtk8366_vlan restart &
				fi
			elif [ "$all_wan_status" = "down" ] ;then
				if [ -z "$last_all_wans" -o "$last_all_wans" = "up" ] ;then
					logger -p 152.5 "[High Availability] master-polling_AS($HA_profile): all enabled WAN/USB switch ports are down, stop sending AD"
					HEALTHY_MASTER=0
					last_all_wans=down
					stop_CARP_ad $HA_profile
					remove_vip
					json set ucarp.$lan dhcp_state=down
					logger -p 152.5 "[High Availability] master-polling_AS($HA_profile): disable $lan dhcp service"
					set_to_mal_master_WAN
					/etc/init.d/dhcpd apply
					##### G49223: LAN pppoe server
					/etc/init.d/pppoe_server stop
					##### Send signal of "DevChange" to ubf_polling_d
					web_portal_status=`uci get general_conf.base.status`
					[ "$web_portal_status" == "enable" ] && kill -SIGUSR1 `pidof ubf_polling_d` >/dev/null 2>&1
					##### G49368: restart vlan
					/etc/init.d/rtk8366_vlan restart &
				fi
			fi
		else
			if [ "$NO_WAN_IS_ENABLED" = "0" ] ;then
				NO_WAN_IS_ENABLED=1
				HEALTHY_MASTER=1
				logger -p 152.5 "[High Availability] master-polling_AS($HA_profile):Event: No WAN is enabled, start up master procedure one time"
				restore_CARP_ad $HA_profile
				attach_vip
				##### Enable LAN DHCP Service
				json set ucarp.$lan dhcp_state=up
				logger -p 152.5 "[High Availability] master-polling_AS($HA_profile): enable $lan dhcp service"
				/etc/init.d/dhcpd apply
				##### G49223: LAN pppoe server
				/etc/init.d/pppoe_server restart
				##### Send signal of "DevChange" to ubf_polling_d
				web_portal_status=`uci get general_conf.base.status`
				[ "$web_portal_status" == "enable" ] && kill -SIGUSR1 `pidof ubf_polling_d` >/dev/null 2>&1
				##### G49368: restart vlan
				/etc/init.d/rtk8366_vlan restart &
			fi
		fi
	else
		if [ "$FIRST_LAUNCH" = "1" ] ;then
			FIRST_LAUNCH=0;
			HEALTHY_MASTER=1
			logger -p 152.5 "[High Availability] master-polling_AS($HA_profile):Event: WAN status detection is disabled, start master procedure"
			restore_CARP_ad $HA_profile
			attach_vip
			##### Enable LAN DHCP Service
			json set ucarp.$lan dhcp_state=up
			logger -p 152.5 "[High Availability] master-polling_AS($HA_profile): enable $lan dhcp service"
			set_status_to_master
			/etc/init.d/dhcpd apply
			##### G49223: LAN pppoe server
			/etc/init.d/pppoe_server restart
			##### Send signal of "DevChange" to ubf_polling_d
			web_portal_status=`uci get general_conf.base.status`
			[ "$web_portal_status" == "enable" ] && kill -SIGUSR1 `pidof ubf_polling_d` >/dev/null 2>&1
			##### G49368: restart vlan
			/etc/init.d/rtk8366_vlan restart &
		fi
	fi
	[ "$HEALTHY_MASTER" = "1" ] && {
		#When ucarp detects and executes "iface-rebinding" event, the flag:/tmp/HA_rebind_$ucarp_pid will be created.
		#We need to re-attach the vip to iface again
		check_rebind_flag
		#Periodically announce that VIP is belong to me if I am a healthy master.
		#This action helps to speed up asserting VIP owner to LAN CPE
		send_garp_vip
	}
	sleep 10
done
